/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.selection;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.watergis.broker.AppBroker;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SelectAllAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SelectAllAction.class);

    public SelectAllAction() {
        String tooltip = NbBundle.getMessage(SelectAllAction.class, (String)"SelectAllAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SelectAllAction.class, (String)"SelectAllAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(SelectAllAction.class, (String)"SelectAllAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-newwindow.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActiveLayerModel model = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap map = model.getMapServices();
        ArrayList<Feature> toBeSelected = new ArrayList<Feature>();
        for (MapService mapService : map.values()) {
            AbstractFeatureService service;
            if (!(mapService instanceof AbstractFeatureService) || !(service = (AbstractFeatureService)mapService).getPNode().getVisible()) continue;
            for (Object featureObject : service.getPNode().getChildrenReference()) {
                PFeature feature = (PFeature)featureObject;
                if (feature.isSelected()) continue;
                feature.setSelected(true);
                SelectionListener sl = (SelectionListener)CismapBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
                sl.addSelectedFeature(feature);
                toBeSelected.add(feature.getFeature());
            }
        }
        ((DefaultFeatureCollection)CismapBroker.getInstance().getMappingComponent().getFeatureCollection()).addToSelection(toBeSelected);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

