/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.selection;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.watergis.broker.AppBroker;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SelectAllDrawingsAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SelectAllDrawingsAction.class);

    public SelectAllDrawingsAction() {
        String tooltip = NbBundle.getMessage(SelectAllDrawingsAction.class, (String)"SelectAllDrawingsAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SelectAllDrawingsAction.class, (String)"SelectAllDrawingsAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selection-rectangleselection.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MappingComponent mc = AppBroker.getInstance().getMappingComponent();
        FeatureCollection fc = mc.getFeatureCollection();
        ArrayList<Feature> toBeSelected = new ArrayList<Feature>();
        for (Feature feature : fc.getAllFeatures()) {
            PFeature pFeature;
            if (!(feature instanceof DrawingSLDStyledFeature) || (pFeature = (PFeature)mc.getPFeatureHM().get(feature)).isSelected()) continue;
            pFeature.setSelected(true);
            SelectionListener sl = (SelectionListener)CismapBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
            sl.addSelectedFeature(pFeature);
            toBeSelected.add(feature);
        }
        ((DefaultFeatureCollection)CismapBroker.getInstance().getMappingComponent().getFeatureCollection()).addToSelection(toBeSelected);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

