/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.selection;

import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToFeaturesWorker;
import de.cismet.cismap.commons.util.SelectionManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ZoomSelectedDrawingsAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ZoomSelectedDrawingsAction.class);

    public ZoomSelectedDrawingsAction() {
        String tooltip = NbBundle.getMessage(ZoomSelectedDrawingsAction.class, (String)"ZoomSelectedDrawingsAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ZoomSelectedDrawingsAction.class, (String)"ZoomSelectedDrawingsAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ZoomSelectedDrawingsAction.class, (String)"ZoomSelectedDrawingsAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selectionadd.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List sel = SelectionManager.getInstance().getSelectedFeatures(null);
        ArrayList<DrawingSLDStyledFeature> drawingFeatures = new ArrayList<DrawingSLDStyledFeature>();
        for (Feature f : sel) {
            if (!(f instanceof DrawingSLDStyledFeature)) continue;
            drawingFeatures.add((DrawingSLDStyledFeature)f);
        }
        ZoomToFeaturesWorker worker = new ZoomToFeaturesWorker(drawingFeatures.toArray(new Feature[drawingFeatures.size()]), 10);
        worker.execute();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

