/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.split;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.watergis.gui.actions.split.FeatureSplitter;
import de.cismet.watergis.utils.GeometryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SimpleFeatureSplitter
implements FeatureSplitter {
    @Override
    public Feature[] split(Feature masterFeature, LineString splitLine) {
        if (masterFeature instanceof DefaultFeatureServiceFeature) {
            DefaultFeatureServiceFeature dfsf = (DefaultFeatureServiceFeature)masterFeature;
            boolean isMulti = masterFeature.getGeometry().getGeometryType().toLowerCase().startsWith("multi");
            Geometry geom = dfsf.getGeometry();
            Geometry[] splittedGeom = GeometryUtils.splitGeom(geom, splitLine);
            if (isMulti) {
                for (int i = 0; i < splittedGeom.length; ++i) {
                    splittedGeom[i] = StaticGeometryFunctions.toMultiGeometry((Geometry)splittedGeom[i]);
                    splittedGeom[i].setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                }
            } else if (splittedGeom[0] instanceof LineString) {
                Arrays.sort(splittedGeom, new Comparator<Geometry>(){

                    @Override
                    public int compare(Geometry o1, Geometry o2) {
                        return (int)Math.signum(o2.getLength() - o1.getLength());
                    }
                });
            }
            ArrayList<DefaultFeatureServiceFeature> newFeatures = new ArrayList<DefaultFeatureServiceFeature>();
            if (splittedGeom.length > 1) {
                masterFeature.setGeometry(splittedGeom[0]);
                for (int i = 1; i < splittedGeom.length; ++i) {
                    DefaultFeatureServiceFeature newFeature;
                    if (masterFeature instanceof DefaultFeatureServiceFeature && ((DefaultFeatureServiceFeature)masterFeature).getLayerProperties() != null && ((DefaultFeatureServiceFeature)masterFeature).getLayerProperties().getAttributeTableRuleSet() != null) {
                        AttributeTableRuleSet ruleSet = ((DefaultFeatureServiceFeature)masterFeature).getLayerProperties().getAttributeTableRuleSet();
                        newFeature = ruleSet.cloneFeature((FeatureServiceFeature)dfsf);
                        newFeatures.add(newFeature);
                        newFeature.setGeometry(splittedGeom[1]);
                        continue;
                    }
                    newFeature = (DefaultFeatureServiceFeature)dfsf.getLayerProperties().getFeatureService().getFeatureFactory().createNewFeature();
                    newFeatures.add(newFeature);
                    newFeature.setGeometry(splittedGeom[1]);
                    HashMap properties = dfsf.getProperties();
                    for (String propertyKey : properties.keySet()) {
                        if (propertyKey.equalsIgnoreCase("id") || propertyKey.equals(dfsf.getIdExpression()) || properties.get(propertyKey) instanceof Geometry) continue;
                        newFeature.setProperty(propertyKey, properties.get(propertyKey));
                    }
                }
                return newFeatures.toArray(new Feature[newFeatures.size()]);
            }
        }
        return null;
    }

    @Override
    public List<FeatureServiceFeature> getAdditionalFeaturesToSave() {
        return new ArrayList<FeatureServiceFeature>();
    }

    @Override
    public void undo() {
    }

    @Override
    public void unlockObjects() {
    }
}

