/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.JPopupMenuButton;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.jdom.Element;

public class MeasureButton
extends JPopupMenuButton
implements PropertyChangeListener,
Configurable {
    private static final int POLYGON_MODE = 1;
    private static final int LINE_MODE = 2;
    private static final String CONFIGURATION = "MeasureButton";
    private static final String MODE_ATTRIBUTE = "mode";
    private JPopupMenu popup = new JPopupMenu();
    private JRadioButtonMenuItem polygonMenu = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
    private JRadioButtonMenuItem lineMenu = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
    private int mode = 1;
    private ButtonGroup buttonGroup;

    public MeasureButton() {
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.lineMenu.setAction(new AbstractAction("Linie"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasureButton.this.setMode(2, false);
                AppBroker.getInstance().getMeasureListener().setMode("LINESTRING");
            }
        });
        this.polygonMenu.setAction(new AbstractAction("Polygon"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasureButton.this.setMode(1, false);
                AppBroker.getInstance().getMeasureListener().setMode("POLYGON");
            }
        });
        this.lineMenu.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-ruler.png")));
        this.polygonMenu.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-canvasrulers.png")));
        this.polygonMenu.setSelected(true);
        this.popup.add(this.lineMenu);
        this.popup.add(this.polygonMenu);
        this.setPopupMenu(this.popup);
        this.setUI(new JToggleButton().getUI());
    }

    private void setMode(int mode, boolean internal) {
        this.mode = mode;
        this.lineMenu.setSelected(mode == 2);
        this.polygonMenu.setSelected(mode == 1);
        if (mode == 2) {
            this.setIcon(this.lineMenu.getIcon());
        } else if (mode == 1) {
            this.setIcon(this.polygonMenu.getIcon());
        }
        this.repaint();
        if (!internal) {
            AppBroker.getInstance().getMappingComponent().setInteractionMode("MEASURE_MODE");
            AppBroker.getInstance().getMappingComponent().setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((AbstractButton)((Object)this));
    }

    public void setSelected(boolean b) {
        super.setSelected(b);
    }

    public void setAction(Action a) {
        super.setAction(a);
        a.addPropertyChangeListener(this);
        Boolean selected = (Boolean)a.getValue("SwingSelectedKey");
        if (selected != null && selected.booleanValue()) {
            this.setSelected(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SwingSelectedKey") && evt.getNewValue() != null && ((Boolean)evt.getNewValue()).booleanValue()) {
            this.setSelected(true);
        }
    }

    public void configure(Element parent) {
        Element conf;
        if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
            String modeAttr = conf.getAttributeValue(MODE_ATTRIBUTE);
            try {
                int mode = Integer.parseInt(modeAttr);
                this.setMode(mode, true);
                switch (mode) {
                    case 1: {
                        AppBroker.getInstance().getMeasureListener().setMode("POLYGON");
                        break;
                    }
                    case 2: {
                        AppBroker.getInstance().getMeasureListener().setMode("LINESTRING");
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void masterConfigure(Element parent) {
        this.configure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        conf.setAttribute(MODE_ATTRIBUTE, String.valueOf(this.mode));
        return conf;
    }
}

