/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.plugin.interfaces.PluginMethod;
import Sirius.navigator.plugin.ui.PluginMenuItem;
import Sirius.navigator.types.treenode.PureTreeNode;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import de.cismet.watergis.broker.AppBroker;
import java.awt.EventQueue;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class RefreshMenuItem
extends PluginMenuItem
implements PluginMethod {
    Logger LOG = Logger.getLogger(RefreshMenuItem.class);

    public RefreshMenuItem() {
        super(0L);
        this.pluginMethod = this;
        this.setText(NbBundle.getMessage(RefreshMenuItem.class, (String)"RefreshMenuItem.RefreshMenuItem.text"));
        this.setAccelerator(KeyStroke.getKeyStroke("F5"));
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void invoke() throws Exception {
        final MetaCatalogueTree currentTree = ComponentRegistry.getRegistry().getActiveCatalogue();
        final TreePath selectionPath = currentTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getPath().length > 0) {
            final RootTreeNode rootTreeNode = new RootTreeNode(SessionManager.getProxy().getRoots());
            try {
                PureTreeNode treeNode = (PureTreeNode)rootTreeNode.getChildAt(0);
                String childStat = treeNode.getMetaNode().getDynamicChildrenStatement();
                String user = "null";
                if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("administratoren")) {
                    user = "'" + AppBroker.getInstance().getOwner() + "'";
                }
                childStat = childStat.replace("$user", user);
                treeNode.getMetaNode().setDynamicChildrenStatement(childStat);
                rootTreeNode.remove(0);
                rootTreeNode.add((MutableTreeNode)treeNode);
            }
            catch (Exception e) {
                this.LOG.error((Object)"The problem tree cannot be created", (Throwable)e);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ((DefaultTreeModel)currentTree.getModel()).setRoot((TreeNode)rootTreeNode);
                    ((DefaultTreeModel)currentTree.getModel()).reload();
                    currentTree.exploreSubtree(selectionPath);
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }
    }
}

