/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.watergis.gui.components.SnappingMode;
import de.cismet.watergis.utils.JPopupMenuButton;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.jdom.Element;
import org.openide.util.Lookup;

public class SnappingButton
extends JPopupMenuButton
implements PropertyChangeListener,
Configurable {
    private static final String CONFIGURATION = "SnappingButton";
    private static final String MODE_ATTRIBUTE = "mode";
    private final JPopupMenu popup = new JPopupMenu();
    private final JRadioButtonMenuItem[] menuItems;
    private ButtonGroup menuItemButtonGroup = new ButtonGroup();
    private ButtonGroup buttonGroup;

    public SnappingButton() {
        this.setModel(new JToggleButton.ToggleButtonModel());
        Collection modes = Lookup.getDefault().lookupAll(SnappingMode.class);
        this.menuItems = new HighlightingRadioButtonMenuItem[modes.size()];
        int i = 0;
        for (SnappingMode snappingMode : modes) {
            this.menuItems[i] = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
            this.menuItems[i].setName(snappingMode.getClass().getName());
            this.menuItems[i].setAction((AbstractAction)((Object)snappingMode));
            this.menuItemButtonGroup.add(this.menuItems[i]);
            this.popup.add(this.menuItems[i++]);
            snappingMode.setParentButton((JButton)((Object)this));
        }
        this.menuItems[0].setSelected(true);
        this.setPopupMenu(this.popup);
        this.setUI(new JToggleButton().getUI());
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((AbstractButton)((Object)this));
    }

    public void setSelected(boolean b) {
        super.setSelected(b);
    }

    public void setAction(Action a) {
        super.setAction(a);
        a.addPropertyChangeListener(this);
        Boolean selected = (Boolean)a.getValue("SwingSelectedKey");
        if (selected != null && selected.booleanValue()) {
            this.setSelected(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SwingSelectedKey") && evt.getNewValue() != null && ((Boolean)evt.getNewValue()).booleanValue()) {
            this.setSelected(true);
        }
    }

    public void configure(Element parent) {
        Element conf;
        if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
            String modeAttr;
            String mode = modeAttr = conf.getAttributeValue(MODE_ATTRIBUTE);
            for (JRadioButtonMenuItem item : this.menuItems) {
                if (!item.getName().equals(mode)) continue;
                item.setSelected(true);
                item.doClick();
                break;
            }
        }
    }

    public void masterConfigure(Element parent) {
        this.configure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        for (JRadioButtonMenuItem item : this.menuItems) {
            if (!item.isSelected()) continue;
            conf.setAttribute(MODE_ATTRIBUTE, item.getName());
            break;
        }
        return conf;
    }
}

