/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components.location;

import Sirius.navigator.search.dynamic.SearchControlPanel;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.gui.layerwidget.ReadOnlyThemeLayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionChangedEvent;
import de.cismet.cismap.commons.util.SelectionChangedListener;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.components.location.SelectionMethodInterface;
import de.cismet.watergis.gui.components.location.SpatialSelectionMethodInterface;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LocationDialog
extends JDialog {
    private static final Class[] SUPPORTED_CLASSES = new Class[]{AbstractFeatureService.class, LayerCollection.class};
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(LocationDialog.class);
    private int lastSelectedFeatureCount = 0;
    private boolean inProgress = false;
    private ImageIcon iconSearch;
    private ImageIcon iconCancel;
    private SelectionCalculator selectionCalculator;
    private JButton btnSearchCancel;
    private JComboBox cboSelectionMethod;
    private JComboBox cboSource;
    private JComboBox cboSpatSelectionMethod;
    private JCheckBox chUseSelectedFeatures;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JLabel labDist;
    private JLabel labMeasureUnit;
    private JLabel labSelectedFeatures;
    private JLabel labSelectionMethod;
    private JLabel labSource;
    private JLabel labSpatSelectionMethod;
    private JLabel labTarget;
    private JXBusyLabel lblBusyIcon;
    private Box.Filler strGap;
    private JPanel tltTarget;
    private JTextField txtDistance;

    public LocationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Collection selectionMethod = Lookup.getDefault().lookupAll(SelectionMethodInterface.class);
        Collection spatialSelectionMethod = Lookup.getDefault().lookupAll(SpatialSelectionMethodInterface.class);
        SpatialSelectionMethodInterface[] ssmArray = spatialSelectionMethod.toArray(new SpatialSelectionMethodInterface[spatialSelectionMethod.size()]);
        SelectionMethodInterface[] smArray = selectionMethod.toArray(new SelectionMethodInterface[selectionMethod.size()]);
        Arrays.sort(ssmArray, new Comparator<SpatialSelectionMethodInterface>(){

            @Override
            public int compare(SpatialSelectionMethodInterface o1, SpatialSelectionMethodInterface o2) {
                return o1.getOrderId().compareTo(o2.getOrderId());
            }
        });
        Arrays.sort(smArray, new Comparator<SelectionMethodInterface>(){

            @Override
            public int compare(SelectionMethodInterface o1, SelectionMethodInterface o2) {
                return o1.getOrderId().compareTo(o2.getOrderId());
            }
        });
        URL iconSearchUrl = this.getClass().getResource("/Sirius/navigator/search/dynamic/SearchControlPanel_btnSearchCancel.png");
        this.iconSearch = iconSearchUrl != null ? new ImageIcon(iconSearchUrl) : new ImageIcon();
        URL iconCancelUrl = this.getClass().getResource("/Sirius/navigator/search/dynamic/SearchControlPanel_btnSearchCancel_cancel.png");
        this.iconCancel = iconCancelUrl != null ? new ImageIcon(iconCancelUrl) : new ImageIcon();
        this.cboSpatSelectionMethod.setModel(new DefaultComboBoxModel<SpatialSelectionMethodInterface>(ssmArray));
        this.cboSelectionMethod.setModel(new DefaultComboBoxModel<SelectionMethodInterface>(smArray));
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                LocationDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                LocationDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                LocationDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                LocationDialog.this.setLayerModel();
            }
        });
        this.txtDistance.setEnabled(false);
        this.setLayerModel();
        SelectionManager.getInstance().addSelectionChangedListener(new SelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LocationDialog.this.refreshSelectedFeatureCount(false);
                    }
                });
            }
        });
    }

    private void setLayerModel() {
        List<AbstractFeatureService> sourceLayer = FeatureServiceHelper.getServices(null);
        Object selectedItem = this.cboSource.getSelectedItem();
        this.cboSource.setModel(new DefaultComboBoxModel<AbstractFeatureService>(sourceLayer.toArray(new AbstractFeatureService[sourceLayer.size()])));
        this.cboSource.setSelectedItem(selectedItem);
        this.refreshSelectedFeatureCount(false);
    }

    private void initComponents() {
        this.labSelectionMethod = new JLabel();
        this.cboSelectionMethod = new JComboBox();
        this.labSource = new JLabel();
        this.cboSource = new JComboBox();
        this.labTarget = new JLabel();
        this.tltTarget = new ReadOnlyThemeLayerWidget();
        ((ReadOnlyThemeLayerWidget)this.tltTarget).setMappingModel((ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel(), SUPPORTED_CLASSES);
        this.chUseSelectedFeatures = new JCheckBox();
        this.labSpatSelectionMethod = new JLabel();
        this.cboSpatSelectionMethod = new JComboBox();
        this.labSelectedFeatures = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblBusyIcon = new JXBusyLabel(new Dimension(20, 20));
        this.strGap = new Box.Filler(new Dimension(5, 0), new Dimension(5, 25), new Dimension(5, Short.MAX_VALUE));
        this.btnSearchCancel = new JButton();
        this.jPanel6 = new JPanel();
        this.txtDistance = new JTextField();
        this.labMeasureUnit = new JLabel();
        this.labDist = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.labSelectionMethod.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.labSelectionMethod.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.labSelectionMethod, gridBagConstraints);
        this.cboSelectionMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cboSelectionMethod, gridBagConstraints);
        this.labSource.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.labSource.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.labSource, gridBagConstraints);
        this.cboSource.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboSource.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationDialog.this.cboSourceItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cboSource, gridBagConstraints);
        this.labTarget.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.labTarget.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.labTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.tltTarget, gridBagConstraints);
        this.chUseSelectedFeatures.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.chUseSelectedFeatures.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.chUseSelectedFeatures, gridBagConstraints);
        this.labSpatSelectionMethod.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.labSpatSelectionMethod.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.labSpatSelectionMethod, gridBagConstraints);
        this.cboSpatSelectionMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboSpatSelectionMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationDialog.this.cboSpatSelectionMethodItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cboSpatSelectionMethod, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.labSelectedFeatures, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2, 10, 10));
        this.jPanel2.setMinimumSize(new Dimension(125, 25));
        this.jPanel2.setPreferredSize(new Dimension(185, 25));
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblBusyIcon.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.lblBusyIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.strGap, gridBagConstraints);
        this.btnSearchCancel.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.btnSearchCancel.text"));
        this.btnSearchCancel.setToolTipText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.btnSearchCancel.toolTipText"));
        this.btnSearchCancel.setMaximumSize(new Dimension(100, 25));
        this.btnSearchCancel.setMinimumSize(new Dimension(100, 25));
        this.btnSearchCancel.setPreferredSize(new Dimension(100, 25));
        this.btnSearchCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationDialog.this.btnSearchCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.btnSearchCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel1.add(this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.txtDistance.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtDistance, gridBagConstraints);
        this.labMeasureUnit.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.labMeasureUnit.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.labMeasureUnit, gridBagConstraints);
        this.labDist.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.labDist.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.labDist, gridBagConstraints);
        this.pack();
    }

    private void cboSourceItemStateChanged(ItemEvent evt) {
        this.refreshSelectedFeatureCount(true);
    }

    private void cboSpatSelectionMethodItemStateChanged(ItemEvent evt) {
        SpatialSelectionMethodInterface spat = (SpatialSelectionMethodInterface)this.cboSpatSelectionMethod.getSelectedItem();
        this.txtDistance.setEnabled(spat.isDistanceRequired());
        if (this.txtDistance.isEnabled() && this.txtDistance.getText().equals("")) {
            this.txtDistance.setText("0");
        }
    }

    private void btnSearchCancelActionPerformed(ActionEvent evt) {
        if (!this.inProgress) {
            this.executeMethod();
        } else if (this.selectionCalculator != null && !this.selectionCalculator.isDone()) {
            this.selectionCalculator.cancel(true);
        }
    }

    public void refreshSelectedFeatureCount(boolean forceGuiRefresh) {
        AbstractFeatureService featureService = (AbstractFeatureService)this.cboSource.getSelectedItem();
        if (featureService != null) {
            int count = this.getSelectedFeatures(featureService).size();
            this.labSelectedFeatures.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.labSelectedFeatures.text", (Object)count));
            if (forceGuiRefresh || count != this.lastSelectedFeatureCount) {
                this.chUseSelectedFeatures.setSelected(count > 0);
            }
            this.lastSelectedFeatureCount = count;
        }
    }

    private void executeMethod() {
        AbstractFeatureService sourceService = (AbstractFeatureService)this.cboSource.getSelectedItem();
        ArrayList<AbstractFeatureService> targetServices = new ArrayList<AbstractFeatureService>();
        SpatialSelectionMethodInterface spat = (SpatialSelectionMethodInterface)this.cboSpatSelectionMethod.getSelectedItem();
        SelectionMethodInterface meth = (SelectionMethodInterface)this.cboSelectionMethod.getSelectedItem();
        List servicesFromTree = ((ReadOnlyThemeLayerWidget)this.tltTarget).getSelectedServices();
        double distance = 0.0;
        try {
            if (spat.isDistanceRequired()) {
                String doubleAsString = this.txtDistance.getText();
                doubleAsString = doubleAsString.replace('.', 'a');
                doubleAsString = doubleAsString.replace(',', '.');
                doubleAsString = doubleAsString.replace('a', ',');
                distance = Double.parseDouble(doubleAsString);
            }
        }
        catch (NumberFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Wrong number format.", (Throwable)e);
            }
            this.txtDistance.setText("0");
        }
        for (Object o : servicesFromTree) {
            if (!(o instanceof AbstractFeatureService)) continue;
            targetServices.add((AbstractFeatureService)o);
        }
        this.selectionCalculator = new SelectionCalculator(sourceService, targetServices, spat, meth, distance, this.chUseSelectedFeatures.isSelected());
        this.inProgress = true;
        this.setControlsAccordingToState(this.inProgress);
        CismetExecutors.newSingleThreadExecutor().execute(this.selectionCalculator);
    }

    public void setControlsAccordingToState(boolean inProgress) {
        if (inProgress) {
            this.btnSearchCancel.setText(NbBundle.getMessage(SearchControlPanel.class, (String)"SearchControlPanel.btnSearchCancel_cancel.text"));
            this.btnSearchCancel.setToolTipText(NbBundle.getMessage(SearchControlPanel.class, (String)"SearchControlPanel.btnSearchCancel_cancel.toolTipText"));
            this.btnSearchCancel.setIcon(this.iconCancel);
            this.lblBusyIcon.setEnabled(true);
            this.lblBusyIcon.setBusy(true);
        } else {
            this.btnSearchCancel.setText(NbBundle.getMessage(LocationDialog.class, (String)"LocationDialog.btnSearchCancel_select.text"));
            this.btnSearchCancel.setToolTipText(NbBundle.getMessage(SearchControlPanel.class, (String)"SearchControlPanel.btnSearchCancel.toolTipText"));
            this.btnSearchCancel.setIcon(this.iconSearch);
            this.lblBusyIcon.setEnabled(false);
            this.lblBusyIcon.setBusy(false);
        }
    }

    private List<FeatureServiceFeature> getSelectedFeatures(AbstractFeatureService service) {
        ArrayList<FeatureServiceFeature> result = new ArrayList<FeatureServiceFeature>();
        List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(service);
        if (selectedFeatures != null) {
            ArrayList selectedFeaturesCopy = new ArrayList(selectedFeatures);
            for (Feature feature : selectedFeaturesCopy) {
                if (!(feature instanceof FeatureServiceFeature)) continue;
                result.add((FeatureServiceFeature)feature);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LocationDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LocationDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(LocationDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LocationDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocationDialog dialog = new LocationDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private class SelectionCalculator
    extends SwingWorker<List<FeatureServiceFeature>, Void> {
        final AbstractFeatureService sourceService;
        final List<AbstractFeatureService> targetServices;
        final SpatialSelectionMethodInterface spat;
        final SelectionMethodInterface meth;
        double distance;
        boolean useSelectedFeatures;
        boolean abort = false;

        public SelectionCalculator(AbstractFeatureService sourceService, List<AbstractFeatureService> targetServices, SpatialSelectionMethodInterface spat, SelectionMethodInterface meth, double distance, boolean useSelectedFeatures) {
            this.sourceService = sourceService;
            this.targetServices = targetServices;
            this.spat = spat;
            this.meth = meth;
            this.distance = distance;
            this.useSelectedFeatures = useSelectedFeatures;
        }

        @Override
        protected List<FeatureServiceFeature> doInBackground() throws Exception {
            List sourceFeatures;
            ArrayList<Geometry> geomList = new ArrayList<Geometry>();
            Geometry geom = null;
            if (this.useSelectedFeatures) {
                sourceFeatures = LocationDialog.this.getSelectedFeatures(this.sourceService);
            } else {
                Geometry g = ZoomToLayerWorker.getServiceBounds((RetrievalServiceLayer)this.sourceService);
                XBoundingBox bounds = null;
                if (g != null) {
                    bounds = new XBoundingBox(g);
                    String crs = CismapBroker.getInstance().getSrs().getCode();
                    CrsTransformer trans = new CrsTransformer(crs);
                    bounds = trans.transformBoundingBox(bounds);
                }
                sourceFeatures = this.sourceService.getFeatureFactory().createFeatures(this.sourceService.getQuery(), (BoundingBox)bounds, null, 0, 0, null);
            }
            for (FeatureServiceFeature fsf : sourceFeatures) {
                if (Thread.interrupted()) {
                    this.abort = true;
                    return null;
                }
                Geometry newGeom = fsf.getGeometry();
                if (newGeom == null || !fsf.getGeometry().isValid()) continue;
                geomList.add(fsf.getGeometry());
            }
            if (geomList.size() > 0) {
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), ((Geometry)geomList.get(0)).getSRID());
                if (Thread.interrupted()) {
                    this.abort = true;
                    return null;
                }
                geom = factory.buildGeometry(geomList);
                if (geom instanceof GeometryCollection) {
                    try {
                        geom = ((GeometryCollection)geom).union();
                    }
                    catch (TopologyException e) {
                        LOG.error((Object)"Topology exception occured during an union operation", (Throwable)e);
                        geom = null;
                        for (Geometry g : geomList) {
                            if (geom == null && g.isValid()) {
                                geom = g;
                                continue;
                            }
                            if (g == null || !g.isValid()) continue;
                            geom = geom.union(g);
                        }
                    }
                }
            }
            return this.calculateCorrespondingFeatures(geom, this.targetServices, this.distance, this.spat);
        }

        @Override
        protected void done() {
            try {
                List correspondingFeatures = (List)this.get();
                if (!this.abort) {
                    this.meth.executeMethod(correspondingFeatures, this.sourceService, this.targetServices);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while calculating new selection", (Throwable)e);
            }
            finally {
                LocationDialog.this.inProgress = false;
                LocationDialog.this.setControlsAccordingToState(LocationDialog.this.inProgress);
            }
        }

        private List<FeatureServiceFeature> calculateCorrespondingFeatures(Geometry source, List<AbstractFeatureService> targetLayer, double distance, SpatialSelectionMethodInterface spatMethod) {
            ArrayList<FeatureServiceFeature> resultFeatureList = new ArrayList<FeatureServiceFeature>();
            if (source != null) {
                Geometry bufferedGeometry = source.getEnvelope();
                if (distance > 0.0) {
                    bufferedGeometry = bufferedGeometry.buffer(distance);
                }
                for (AbstractFeatureService service : targetLayer) {
                    List<FeatureServiceFeature> featureList = this.getAllFeatures(service, bufferedGeometry);
                    if (featureList == null) continue;
                    for (FeatureServiceFeature featureObject : featureList) {
                        if (Thread.interrupted()) {
                            this.abort = true;
                            return null;
                        }
                        FeatureServiceFeature feature = featureObject;
                        if (!spatMethod.featureGeometryFulfilsRequirements(source, feature.getGeometry(), distance)) continue;
                        resultFeatureList.add(feature);
                    }
                }
            }
            return resultFeatureList;
        }

        private List<FeatureServiceFeature> getAllFeatures(AbstractFeatureService service, Geometry geom) {
            try {
                Geometry g = geom;
                service.initAndWait();
                if (geom == null) {
                    g = ZoomToLayerWorker.getServiceBounds((RetrievalServiceLayer)service);
                }
                XBoundingBox bounds = null;
                if (g != null) {
                    bounds = new XBoundingBox(g);
                    String crs = CismapBroker.getInstance().getSrs().getCode();
                    CrsTransformer trans = new CrsTransformer(crs);
                    bounds = trans.transformBoundingBox(bounds);
                }
                return service.getFeatureFactory().createFeatures(service.getQuery(), (BoundingBox)bounds, null, 0, 0, null);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while retrieving features.", (Throwable)e);
                return null;
            }
        }
    }
}

