/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BufferDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(BufferDialog.class);
    private int selectedThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JComboBox cbField;
    private JComboBox cbTheme;
    private JCheckBox ckbIndividual;
    private JCheckBox ckbMergeBuffer;
    private JCheckBox ckbSelected;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JLabel labSelected;
    private JLabel labTableName;
    private JLabel labTheme;
    private JRadioButton rbFieldBuffer;
    private JRadioButton rbFixBuffer;
    private JTextField txtBuffer;
    private JTextField txtTable;

    public BufferDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(null).toArray(new AbstractFeatureService[0])));
        this.cbTheme.setSelectedItem(null);
        this.cbTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.txtTable.setText("Puffer");
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFeatureService service = (AbstractFeatureService)BufferDialog.this.cbTheme.getSelectedItem();
                        BufferDialog.this.selectedThemeFeatureCount = BufferDialog.this.refreshSelectedFeatureCount(false, BufferDialog.this.ckbSelected, service, BufferDialog.this.selectedThemeFeatureCount, BufferDialog.this.labSelected);
                    }
                });
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                BufferDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                BufferDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                BufferDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                BufferDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
        this.cbField.setEnabled(this.rbFieldBuffer.isSelected());
        this.txtBuffer.setEnabled(this.rbFixBuffer.isSelected());
        this.enabledOrNot();
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbTheme = new JComboBox();
        this.labTableName = new JLabel();
        this.txtTable = new JTextField();
        this.ckbIndividual = new JCheckBox();
        this.rbFixBuffer = new JRadioButton();
        this.rbFieldBuffer = new JRadioButton();
        this.txtBuffer = new JTextField();
        this.cbField = new JComboBox();
        this.ckbMergeBuffer = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.ckbSelected = new JCheckBox();
        this.labSelected = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferDialog.this.cbThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.cbTheme, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtTable.setMinimumSize(new Dimension(200, 27));
        this.txtTable.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtTable, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbIndividual, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.ckbIndividual.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbIndividual, gridBagConstraints);
        this.bgBuffer.add(this.rbFixBuffer);
        this.rbFixBuffer.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbFixBuffer, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.rbFixBuffer.text", (Object[])new Object[0]));
        this.rbFixBuffer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferDialog.this.rbFixBufferActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.rbFixBuffer, gridBagConstraints);
        this.bgBuffer.add(this.rbFieldBuffer);
        Mnemonics.setLocalizedText((AbstractButton)this.rbFieldBuffer, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.rbFieldBuffer.text", (Object[])new Object[0]));
        this.rbFieldBuffer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferDialog.this.rbFieldBufferActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.rbFieldBuffer, gridBagConstraints);
        this.txtBuffer.setMinimumSize(new Dimension(200, 27));
        this.txtBuffer.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtBuffer, gridBagConstraints);
        this.cbField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbField.setMinimumSize(new Dimension(200, 27));
        this.cbField.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.cbField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbMergeBuffer, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.ckbMergeBuffer.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbMergeBuffer, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(80, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelected, (String)NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.ckbSelected.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.ckbSelected, gridBagConstraints);
        this.labSelected.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.labSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        final AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        final String tableName = this.txtTable.getText();
        WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Puffer                                            ", null, 100, true){

            protected H2FeatureService doInBackground() throws Exception {
                int progress = 10;
                this.wd.setText(NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.retrieving"));
                this.wd.setMax(100);
                this.wd.setProgress(5);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> featureList = FeatureServiceHelper.getFeatures(service, BufferDialog.this.ckbSelected.isSelected());
                this.wd.setProgress(10);
                if (Thread.interrupted()) {
                    return null;
                }
                double buffer = 0.0;
                ArrayList<FeatureServiceFeature> resultedFeatures = new ArrayList<FeatureServiceFeature>();
                if (featureList == null || featureList.size() == 0) {
                    JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Es wurden keine Objekte ausgew\u00e4hlt");
                    return null;
                }
                LayerProperties serviceLayerProperties = featureList.get(0).getLayerProperties();
                LayerProperties newLayerProperties = serviceLayerProperties.clone();
                int count = 0;
                int percentageToBuffer = !BufferDialog.this.ckbMergeBuffer.isSelected() ? 80 : 40;
                String distanceAttribute = "";
                newLayerProperties.setFeatureService((AbstractFeatureService)serviceLayerProperties.getFeatureService().clone());
                if (!BufferDialog.this.ckbMergeBuffer.isSelected()) {
                    newLayerProperties.getFeatureService().setFeatureServiceAttributes(FeatureServiceHelper.cloneFeatureServiceAttributes(serviceLayerProperties.getFeatureService().getFeatureServiceAttributes()));
                } else {
                    newLayerProperties.getFeatureService().setFeatureServiceAttributes(FeatureServiceHelper.createGeometryOnlyFeatureServiceAttributes(serviceLayerProperties.getFeatureService().getFeatureServiceAttributes()));
                }
                if (BufferDialog.this.rbFixBuffer.isSelected()) {
                    if (BufferDialog.this.txtBuffer.isEnabled() && !BufferDialog.this.txtBuffer.getText().equals("")) {
                        try {
                            buffer = Double.parseDouble(BufferDialog.this.txtBuffer.getText());
                        }
                        catch (NumberFormatException e) {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.noBuffer.message"), NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.noBuffer.title"), 0);
                            LOG.error((Object)"Invalid buffer entered. Buffer 1 is used", (Throwable)e);
                            buffer = 1.0;
                        }
                    } else {
                        buffer = 1.0;
                    }
                } else {
                    distanceAttribute = BufferDialog.this.cbField.getSelectedItem().toString();
                }
                this.wd.setText(NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.createFeatures"));
                Boolean isFeatureMulti = null;
                for (FeatureServiceFeature f : featureList) {
                    Geometry geom = f.getGeometry();
                    ++count;
                    if (isFeatureMulti == null) {
                        isFeatureMulti = geom instanceof MultiPolygon || geom instanceof MultiPoint || geom instanceof MultiLineString;
                    }
                    if (geom != null) {
                        if (BufferDialog.this.rbFixBuffer.isSelected()) {
                            geom = geom.buffer(buffer);
                        } else {
                            double bufferValue = BufferDialog.this.toDouble(f.getProperty(distanceAttribute));
                            geom = geom.buffer(bufferValue);
                        }
                    }
                    if (geom == null) continue;
                    if (BufferDialog.this.ckbIndividual.isSelected()) {
                        for (int geomIndex = 0; geomIndex < geom.getNumGeometries(); ++geomIndex) {
                            FeatureServiceFeature newFeature = (FeatureServiceFeature)f.clone();
                            newFeature.setLayerProperties(newLayerProperties);
                            newFeature.setGeometry(geom.getGeometryN(geomIndex));
                            resultedFeatures.add(newFeature);
                        }
                    } else if (!geom.isEmpty()) {
                        FeatureServiceFeature newFeature = (FeatureServiceFeature)f.clone();
                        if (isFeatureMulti.booleanValue()) {
                            newFeature.setGeometry(StaticGeometryFunctions.toMultiGeometry((Geometry)geom));
                        } else {
                            newFeature.setGeometry(geom);
                        }
                        resultedFeatures.add(newFeature);
                    }
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= 10 + count * percentageToBuffer / featureList.size()) continue;
                    progress = 10 + count * percentageToBuffer / featureList.size();
                    this.wd.setProgress(progress);
                }
                if (BufferDialog.this.ckbMergeBuffer.isSelected()) {
                    ArrayList<FeatureServiceFeature> bufferedFeatures = new ArrayList<FeatureServiceFeature>(resultedFeatures);
                    resultedFeatures.clear();
                    TreeSet<FeatureServiceFeature> usedFeatureMap = new TreeSet<FeatureServiceFeature>();
                    count = 0;
                    STRtree tree = FeatureServiceHelper.getFeatureTree(bufferedFeatures);
                    for (FeatureServiceFeature f : bufferedFeatures) {
                        ++count;
                        if (Thread.interrupted()) {
                            return null;
                        }
                        if (progress < 10 + percentageToBuffer + count * (80 - percentageToBuffer) / featureList.size()) {
                            progress = 10 + percentageToBuffer + count * (80 - percentageToBuffer) / featureList.size();
                            this.wd.setProgress(progress);
                        }
                        if (usedFeatureMap.contains(f)) continue;
                        usedFeatureMap.add(f);
                        if (f.getGeometry() != null) {
                            boolean geometryIncreased;
                            do {
                                geometryIncreased = false;
                                List suitableFeatures = tree.query(f.getGeometry().getEnvelopeInternal());
                                for (FeatureServiceFeature intersectionCandidate : suitableFeatures) {
                                    if (f.equals(intersectionCandidate) || !f.getGeometry().intersects(intersectionCandidate.getGeometry()) || usedFeatureMap.contains(intersectionCandidate)) continue;
                                    f.setGeometry(f.getGeometry().union(intersectionCandidate.getGeometry()));
                                    usedFeatureMap.add(intersectionCandidate);
                                    geometryIncreased = true;
                                    if (progress >= 10 + percentageToBuffer + ++count * (80 - percentageToBuffer) / featureList.size()) continue;
                                    progress = 10 + percentageToBuffer + count * (80 - percentageToBuffer) / featureList.size();
                                    this.wd.setProgress(progress);
                                }
                            } while (geometryIncreased);
                        }
                        f.setLayerProperties(newLayerProperties);
                        resultedFeatures.add(f);
                    }
                }
                ArrayList<String> orderedAttributeNames = new ArrayList<String>();
                orderedAttributeNames.addAll(service.getOrderedFeatureServiceAttributes());
                if (Thread.interrupted()) {
                    return null;
                }
                this.wd.setText(NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, tableName, orderedAttributeNames);
            }

            protected void done() {
                try {
                    H2FeatureService service2 = (H2FeatureService)this.get();
                    if (service2 != null) {
                        FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)service2);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while execute the buffer operation.", (Throwable)ex);
                }
            }
        };
        if (H2FeatureService.tableAlreadyExists((String)tableName)) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOkActionPerformed.tableAlreadyExists", (Object)tableName), NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.butOkActionPerformed.tableAlreadyExists.title"), 0);
        } else {
            this.setVisible(false);
            wdt.start();
        }
    }

    private double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        String doubleAsString = o.toString();
        try {
            return Double.parseDouble(doubleAsString);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)(o.toString() + " is not a number."), (Throwable)e);
            return 0.0;
        }
    }

    private void cbThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelected, service, this.selectedThemeFeatureCount, this.labSelected);
        this.refreshFieldModel();
        this.enabledOrNot();
    }

    private void rbFieldBufferActionPerformed(ActionEvent evt) {
        this.cbField.setEnabled(this.rbFieldBuffer.isSelected());
        this.txtBuffer.setEnabled(this.rbFixBuffer.isSelected());
    }

    private void rbFixBufferActionPerformed(ActionEvent evt) {
        this.cbField.setEnabled(this.rbFieldBuffer.isSelected());
        this.txtBuffer.setEnabled(this.rbFixBuffer.isSelected());
    }

    private void refreshFieldModel() {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        if (service != null) {
            List<String> fields = FeatureServiceHelper.getAllFieldNames(service, Number.class);
            this.cbField.setModel(new DefaultComboBoxModel<String>(fields.toArray(new String[fields.size()])));
        } else {
            this.cbField.setModel(new DefaultComboBoxModel());
        }
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh, JCheckBox box, AbstractFeatureService featureService, int lastSelectedFeatureCount, JLabel selectionCountlab) {
        int count = featureService == null ? 0 : FeatureServiceHelper.getSelectedFeatures(featureService).size();
        selectionCountlab.setText(NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.refreshSelectedFeatureCount.text", (Object)count));
        if (forceGuiRefresh || count != lastSelectedFeatureCount) {
            box.setSelected(count > 0);
        }
        return count;
    }

    private void setLayerModel() {
        final Object selectedObject = this.cbTheme.getSelectedItem();
        this.cbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(BufferDialog.class, (String)"BufferDialog.setlayerModel.searchServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferDialog.this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(null).toArray(new AbstractFeatureService[0])));
                if (selectedObject != null) {
                    BufferDialog.this.cbTheme.setSelectedItem(selectedObject);
                } else if (BufferDialog.this.cbTheme.getModel().getSize() > 0) {
                    BufferDialog.this.cbTheme.setSelectedIndex(0);
                } else {
                    BufferDialog.this.cbTheme.setSelectedItem(null);
                }
            }
        });
        t.start();
    }

    private void enabledOrNot() {
        boolean isServiceSelected = this.cbTheme.getSelectedItem() instanceof AbstractFeatureService;
        this.butOk.setEnabled(isServiceSelected);
    }
}

