/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.tools.WorldFileDownload;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.download.ImageDownload;
import de.cismet.watergis.gui.components.ValidationJTextField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.concurrent.Future;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ExportMapToFileDialog
extends JDialog
implements ComponentListener {
    private static final Logger LOG = Logger.getLogger(ExportMapToFileDialog.class);
    private HeightChangedDocumentListener heightChangedDocumentListener = new HeightChangedDocumentListener();
    private WidthChangedDocumentListener widthChangedDocumentListener = new WidthChangedDocumentListener();
    private PixelDPICalculator pixelDPICalculator;
    private DpiChangedDocumentListener dpiChangedDocumentListener = new DpiChangedDocumentListener();
    private String lastPath = null;
    private int lastDpi = -1;
    private JButton btnCancel;
    private JButton btnSave;
    private JButton butFile;
    private JCheckBox chbWorldFile;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblName;
    private JSpinner spnDPI;
    private JTextField txtFile;
    private JTextField txtHeight;
    private JTextField txtWidth;

    public ExportMapToFileDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.addComponentListener(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblName = new JLabel();
        this.spnDPI = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtWidth = new ValidationJTextField();
        this.txtHeight = new ValidationJTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.chbWorldFile = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.btnSave = new JButton();
        this.btnCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.setTitle(NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.title"));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.lblName.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        this.jPanel1.add((Component)this.lblName, gridBagConstraints);
        this.spnDPI.setModel(new SpinnerNumberModel((Number)300, null, null, (Number)1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 6, 0);
        this.jPanel1.add((Component)this.spnDPI, gridBagConstraints);
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spnDPI.getEditor()).getTextField();
        tf.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.txtWidth.setText(NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.txtWidth.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 4, 0);
        this.jPanel1.add((Component)this.txtWidth, gridBagConstraints);
        ((ValidationJTextField)this.txtWidth).setPattern("\\d{1,9}");
        this.txtHeight.setText(NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.txtHeight.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 4, 0);
        this.jPanel1.add((Component)this.txtHeight, gridBagConstraints);
        ((ValidationJTextField)this.txtHeight).setPattern("\\d{1,9}");
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chbWorldFile, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.chbWorldFile.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        this.jPanel1.add((Component)this.chbWorldFile, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.btnSave.text"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMapToFileDialog.this.btnSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 4, 0, 0);
        this.jPanel2.add((Component)this.btnSave, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMapToFileDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 0, 0, 3);
        this.jPanel2.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 22;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.txtFile.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 5);
        this.jPanel3.add((Component)this.txtFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butFile, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.butFile.text", (Object[])new Object[0]));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMapToFileDialog.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        this.jPanel3.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        int width = Integer.parseInt(this.txtWidth.getText());
        int height = Integer.parseInt(this.txtHeight.getText());
        MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
        HeadlessMapProvider headlessMapProvider = HeadlessMapProvider.createHeadlessMapProviderAndAddLayers((MappingComponent)mappingComponent);
        headlessMapProvider.setDominatingDimension(HeadlessMapProvider.DominatingDimension.SIZE);
        headlessMapProvider.setBoundingBox((XBoundingBox)mappingComponent.getCurrentBoundingBoxFromCamera());
        Future futureImage = headlessMapProvider.getImage(width, height);
        String fileString = this.txtFile.getText();
        if (fileString != null && !fileString.isEmpty()) {
            int ans;
            File file = new File(fileString);
            if (file.exists() && (ans = JOptionPane.showConfirmDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.btnSaveActionPerformed().fileExists.text", (Object)file.getAbsolutePath()), NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.btnSaveActionPerformed().fileExists.title"), 0)) != 0) {
                return;
            }
            String imageFilePath = fileString;
            ImageDownload imageDownload = new ImageDownload(FilenameUtils.getBaseName((String)imageFilePath), FilenameUtils.getExtension((String)imageFilePath), file, futureImage);
            DownloadManager.instance().add((Download)imageDownload);
            if (this.chbWorldFile.isSelected()) {
                String worldFileName = FilenameUtils.getFullPath((String)imageFilePath) + FilenameUtils.getBaseName((String)imageFilePath) + ".jgw";
                WorldFileDownload worldFileDownload = new WorldFileDownload(NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.btnSaveActionPerformed.title"), futureImage, headlessMapProvider.getCurrentBoundingBoxFromMap(), worldFileName);
                DownloadManager.instance().add((Download)worldFileDownload);
            }
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.btnSaveActionPerformed.noFile.message"), NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.btnSaveActionPerformed.noFile.title"), 0);
        }
    }

    private void butFileActionPerformed(ActionEvent evt) {
        File file = StaticSwingTools.chooseFile((String)(this.lastPath == null ? DownloadManager.instance().getDestinationDirectory().toString() : this.lastPath), (boolean)true, (String[])new String[]{"jpg", "jpeg"}, (String)NbBundle.getMessage(ExportMapToFileDialog.class, (String)"ExportMapToFileDialog.save.FileFilter.getDescription.return"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            this.txtFile.setText(file.getAbsolutePath());
            this.lastPath = file.getParent();
        }
    }

    private void addListener() {
        this.txtHeight.getDocument().addDocumentListener(this.heightChangedDocumentListener);
        this.txtWidth.getDocument().addDocumentListener(this.widthChangedDocumentListener);
        this.spnDPI.addChangeListener(this.dpiChangedDocumentListener);
    }

    private void removeListener() {
        this.txtHeight.getDocument().removeDocumentListener(this.heightChangedDocumentListener);
        this.txtWidth.getDocument().removeDocumentListener(this.widthChangedDocumentListener);
        this.spnDPI.removeChangeListener(this.dpiChangedDocumentListener);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.removeListener();
        MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
        int width = mappingComponent.getWidth();
        int height = mappingComponent.getHeight();
        int dpi = this.lastDpi == -1 ? 300 : this.lastDpi;
        this.pixelDPICalculator = new PixelDPICalculator(width, height, dpi);
        this.txtHeight.setText(Integer.toString(height));
        this.txtWidth.setText(Integer.toString(width));
        this.spnDPI.setValue(dpi);
        this.lastDpi = dpi;
        this.addListener();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    class DpiChangedDocumentListener
    implements ChangeListener {
        DpiChangedDocumentListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.dpiChanged();
        }

        private void dpiChanged() {
            ExportMapToFileDialog.this.removeListener();
            int newDpi = (Integer)ExportMapToFileDialog.this.spnDPI.getValue();
            ExportMapToFileDialog.this.pixelDPICalculator.setDPI(newDpi);
            ExportMapToFileDialog.this.lastDpi = newDpi;
            ExportMapToFileDialog.this.txtHeight.setText(Integer.toString(ExportMapToFileDialog.this.pixelDPICalculator.getHeightPixel()));
            ExportMapToFileDialog.this.txtWidth.setText(Integer.toString(ExportMapToFileDialog.this.pixelDPICalculator.getWidthPixel()));
            ExportMapToFileDialog.this.addListener();
        }
    }

    class WidthChangedDocumentListener
    implements DocumentListener {
        WidthChangedDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.widthChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.widthChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.widthChanged();
        }

        private void widthChanged() {
            if (((ValidationJTextField)ExportMapToFileDialog.this.txtWidth).isContentValid()) {
                ExportMapToFileDialog.this.removeListener();
                int newWidth = Integer.parseInt(ExportMapToFileDialog.this.txtWidth.getText());
                ExportMapToFileDialog.this.pixelDPICalculator.setWidthPixel(newWidth);
                ExportMapToFileDialog.this.txtHeight.setText(Integer.toString(ExportMapToFileDialog.this.pixelDPICalculator.getHeightPixel()));
                ExportMapToFileDialog.this.spnDPI.setValue(ExportMapToFileDialog.this.pixelDPICalculator.getDPI());
                ExportMapToFileDialog.this.addListener();
            }
        }
    }

    class HeightChangedDocumentListener
    implements DocumentListener {
        HeightChangedDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.heightChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.heightChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.heightChanged();
        }

        private void heightChanged() {
            if (((ValidationJTextField)ExportMapToFileDialog.this.txtHeight).isContentValid()) {
                ExportMapToFileDialog.this.removeListener();
                int newHeigth = Integer.parseInt(ExportMapToFileDialog.this.txtHeight.getText());
                ExportMapToFileDialog.this.pixelDPICalculator.setHeightPixel(newHeigth);
                ExportMapToFileDialog.this.txtWidth.setText(Integer.toString(ExportMapToFileDialog.this.pixelDPICalculator.getWidthPixel()));
                ExportMapToFileDialog.this.spnDPI.setValue(ExportMapToFileDialog.this.pixelDPICalculator.getDPI());
                ExportMapToFileDialog.this.lastDpi = ExportMapToFileDialog.this.pixelDPICalculator.getDPI();
                ExportMapToFileDialog.this.addListener();
            }
        }
    }

    class PixelDPICalculator {
        private int widthPixel;
        private int heightPixel;
        private int dpi;
        private final double aspectRatio;
        private final double widthInches;

        public PixelDPICalculator(int widthPixel, int heightPixel, int dpi) {
            this.widthPixel = widthPixel;
            this.heightPixel = heightPixel;
            this.dpi = dpi;
            this.aspectRatio = (double)widthPixel * 1.0 / (double)heightPixel;
            this.widthInches = (double)widthPixel * 1.0 / (double)dpi;
        }

        public int getHeightPixel() {
            return this.heightPixel;
        }

        public void setHeightPixel(int newHeightPixel) {
            this.widthPixel = (int)Math.round((double)newHeightPixel * this.aspectRatio);
            double newDpi = (double)this.widthPixel / this.widthInches;
            this.dpi = (int)Math.round(newDpi);
            this.heightPixel = newHeightPixel;
        }

        public int getDPI() {
            return this.dpi;
        }

        public void setDPI(int newDpi) {
            double newWidthPixel = (double)this.widthPixel * 1.0 / (double)this.dpi * (double)newDpi;
            this.widthPixel = (int)Math.round(newWidthPixel);
            this.heightPixel = (int)Math.round((double)this.widthPixel * 1.0 / this.aspectRatio);
            this.dpi = newDpi;
        }

        public int getWidthPixel() {
            return this.widthPixel;
        }

        public void setWidthPixel(int newWidthPixel) {
            this.heightPixel = (int)Math.round((double)newWidthPixel * 1.0 / this.aspectRatio);
            this.widthPixel = newWidthPixel;
            double newDpi = (double)this.widthPixel / this.widthInches;
            this.dpi = (int)Math.round(newDpi);
        }
    }
}

