/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.dialog.BufferDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GafExportDialog
extends JDialog {
    private boolean cancelled = false;
    private String lastPath = DownloadManager.instance().getDestinationDirectory().toString();
    private JButton butCancel;
    private JButton butFile;
    private JButton butOk;
    private JCheckBox ckBasis;
    private JCheckBox ckGaf;
    private JCheckBox ckLawa;
    private JCheckBox ckReport;
    private JCheckBox ckShape;
    private JCheckBox ckWithout;
    private JCheckBox ckbGafSelection;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JLabel labAusgabe;
    private JLabel labBezug;
    private JTextField txtFile;

    private GafExportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (!modal) {
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

                public void featuresAdded(FeatureCollectionEvent fce) {
                }

                public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresChanged(FeatureCollectionEvent fce) {
                }

                public void featureSelectionChanged(FeatureCollectionEvent fce) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GafExportDialog.this.refreshSelectedFeatureCount(false);
                        }
                    });
                }

                public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
                }

                public void featureCollectionChanged() {
                }
            });
        }
    }

    public static GafExportDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshSelectedFeatureCount(true);
            this.cancelled = true;
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.ckbGafSelection = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.labBezug = new JLabel();
        this.ckBasis = new JCheckBox();
        this.ckLawa = new JCheckBox();
        this.ckWithout = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.labAusgabe = new JLabel();
        this.ckGaf = new JCheckBox();
        this.ckReport = new JCheckBox();
        this.ckShape = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.title_1", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.butOk.text_1", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(120, 29));
        this.butOk.setPreferredSize(new Dimension(150, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.butOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.butCancel.text_1", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(120, 29));
        this.butCancel.setPreferredSize(new Dimension(150, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.txtFile.text_1", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.txtFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butFile, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.butFile.text_1", (Object[])new Object[0]));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        this.ckbGafSelection.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbGafSelection, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckbGafSelection.text", (Object[])new Object[0]));
        this.ckbGafSelection.setEnabled(false);
        this.ckbGafSelection.setMinimumSize(new Dimension(458, 24));
        this.ckbGafSelection.setPreferredSize(new Dimension(458, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbGafSelection, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labBezug, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.labBezug.text", (Object[])new Object[0]));
        this.labBezug.setPreferredSize(new Dimension(75, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel4.add((Component)this.labBezug, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckBasis, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckBasis.text", (Object[])new Object[0]));
        this.ckBasis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.ckBasisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel4.add((Component)this.ckBasis, gridBagConstraints);
        this.ckLawa.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckLawa, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckLawa.text", (Object[])new Object[0]));
        this.ckLawa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.ckLawaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel4.add((Component)this.ckLawa, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckWithout, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckWithout.text", (Object[])new Object[0]));
        this.ckWithout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.ckWithoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel4.add((Component)this.ckWithout, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labAusgabe, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.labAusgabe.text", (Object[])new Object[0]));
        this.labAusgabe.setPreferredSize(new Dimension(75, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel5.add((Component)this.labAusgabe, gridBagConstraints);
        this.ckGaf.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckGaf, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckGaf.text", (Object[])new Object[0]));
        this.ckGaf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.ckGafActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel5.add((Component)this.ckGaf, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckReport, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckReport.text", (Object[])new Object[0]));
        this.ckReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.ckReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel5.add((Component)this.ckReport, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckShape, (String)NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckShape.text", (Object[])new Object[0]));
        this.ckShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafExportDialog.this.ckShapeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel5.add((Component)this.ckShape, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        if (!this.txtFile.getText().equals("")) {
            this.cancelled = false;
            this.setVisible(false);
        } else {
            this.butFileActionPerformed(null);
        }
    }

    private void butFileActionPerformed(ActionEvent evt) {
        File file = StaticSwingTools.chooseFile((String)this.lastPath, (boolean)true, (String[])new String[]{"zip"}, (String)NbBundle.getMessage(GafExportDialog.class, (String)"PhotoExportReportDialog.butFileActionPerformed().getDescription()"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            this.lastPath = file.getParent();
            this.txtFile.setText(file.getAbsolutePath());
        }
    }

    private void ckBasisActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void ckLawaActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void ckWithoutActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void ckReportActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void ckShapeActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void ckGafActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void checkContentSelection() {
        this.butOk.setEnabled(!(!this.ckBasis.isSelected() && !this.ckLawa.isSelected() && !this.ckWithout.isSelected() || !this.ckReport.isSelected() && !this.ckShape.isSelected() && !this.ckGaf.isSelected()));
    }

    public void refreshSelectedFeatureCount(boolean forceGuiRefresh) {
        List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
        int count = features.size();
        this.ckbGafSelection.setText(NbBundle.getMessage(GafExportDialog.class, (String)"GafExportDialog.ckbGafSelection.text") + NbBundle.getMessage(BufferDialog.class, (String)"GafProfReportDialog.refreshSelectedFeatureCount.text", (Object)count));
    }

    public String getZipFile() {
        return this.txtFile.getText();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isGafSelected() {
        return this.ckGaf.isSelected();
    }

    public boolean isBasisSelected() {
        return this.ckBasis.isSelected();
    }

    public boolean isLawaSelected() {
        return this.ckLawa.isSelected();
    }

    public boolean isWithoutSelected() {
        return this.ckWithout.isSelected();
    }

    public boolean isReportSelected() {
        return this.ckReport.isSelected();
    }

    public boolean isShapeSelected() {
        return this.ckShape.isSelected();
    }

    private static final class LazyInitializer {
        private static final transient GafExportDialog INSTANCE = new GafExportDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }
}

