/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.GafInfoListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GafOptionsDialog
extends JDialog {
    private static final Dimension[] dimensions = new Dimension[4];
    private Order order = Order.XY;
    private Size size = Size.SMALL;
    private ButtonGroup bgOrder;
    private ButtonGroup bgSize;
    private JButton butCancel;
    private JButton butOk;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JLabel labOrder;
    private JLabel labSize;
    private JRadioButton rbExtraLarge;
    private JRadioButton rbGewaesser;
    private JRadioButton rbLarge;
    private JRadioButton rbLawaCode;
    private JRadioButton rbMedium;
    private JRadioButton rbSmall;
    private JRadioButton rbXy;

    private GafOptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jPanel2.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GafOptionsDialog.this.butCancelActionPerformed(null);
            }
        });
    }

    public Order getOrder() {
        return this.order;
    }

    public Comparator<FeatureServiceFeature> getSorter() {
        if (this.order == Order.XY) {
            return new Comparator<FeatureServiceFeature>(){

                @Override
                public int compare(FeatureServiceFeature o1, FeatureServiceFeature o2) {
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o2 == null && o1 != null) {
                        return -1;
                    }
                    if (o2 == null && o1 == null) {
                        return 0;
                    }
                    Geometry g1 = o1.getGeometry();
                    Geometry g2 = o2.getGeometry();
                    if (g1 == null && g2 != null) {
                        return 1;
                    }
                    if (g2 == null && g1 != null) {
                        return -1;
                    }
                    if (g2 == null && g1 == null) {
                        return 0;
                    }
                    if (g1.getCoordinate().x < g2.getCoordinate().x) {
                        return -1;
                    }
                    if (g1.getCoordinate().x == g2.getCoordinate().x) {
                        return (int)Math.signum(g1.getCoordinate().y - g2.getCoordinate().y);
                    }
                    return 1;
                }
            };
        }
        if (this.order == Order.RIVER) {
            return new Comparator<FeatureServiceFeature>(){

                @Override
                public int compare(FeatureServiceFeature o1, FeatureServiceFeature o2) {
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o2 == null && o1 != null) {
                        return -1;
                    }
                    if (o2 == null && o1 == null) {
                        return 0;
                    }
                    String baCd1 = GafOptionsDialog.this.getBaCd(o1);
                    String baCd2 = GafOptionsDialog.this.getBaCd(o2);
                    if (baCd1 == null && baCd2 != null) {
                        return 1;
                    }
                    if (baCd2 == null && baCd1 != null) {
                        return -1;
                    }
                    if (baCd2 == null && baCd1 == null) {
                        return 0;
                    }
                    if (baCd1.compareTo(baCd2) == 0) {
                        return (int)Math.signum(GafOptionsDialog.this.getStatValue(o1) - GafOptionsDialog.this.getStatValue(o2));
                    }
                    return baCd1.compareTo(baCd2);
                }
            };
        }
        if (this.order == Order.LAWA) {
            return new Comparator<FeatureServiceFeature>(){

                @Override
                public int compare(FeatureServiceFeature o1, FeatureServiceFeature o2) {
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o2 == null && o1 != null) {
                        return -1;
                    }
                    if (o2 == null && o1 == null) {
                        return 0;
                    }
                    String laCd1 = GafOptionsDialog.this.getLaCd(o1);
                    String laCd2 = GafOptionsDialog.this.getLaCd(o2);
                    if (laCd1 == null && laCd2 != null) {
                        return 1;
                    }
                    if (laCd2 == null && laCd1 != null) {
                        return -1;
                    }
                    if (laCd2 == null && laCd1 == null) {
                        return 0;
                    }
                    if (laCd1.compareTo(laCd2) == 0) {
                        return (int)Math.signum(GafOptionsDialog.this.getLaStatValue(o1) - GafOptionsDialog.this.getLaStatValue(o2));
                    }
                    return laCd1.compareTo(laCd2);
                }
            };
        }
        return null;
    }

    private String getBaCd(FeatureServiceFeature f) {
        Object baCd = f.getProperty("ba_cd");
        if (baCd == null) {
            baCd = f.getProperty("ba_st");
            if (baCd instanceof CidsBean) {
                return (String)((CidsBean)baCd).getProperty("route.ba_cd");
            }
            return null;
        }
        return (String)baCd;
    }

    private Double getStatValue(FeatureServiceFeature f) {
        Object stat = f.getProperty("ba_st");
        if (stat instanceof CidsBean) {
            return (Double)((CidsBean)stat).getProperty("wert");
        }
        if (stat == null) {
            return 0.0;
        }
        return (Double)stat;
    }

    private String getLaCd(FeatureServiceFeature f) {
        return (String)f.getProperty("la_cd");
    }

    private Double getLaStatValue(FeatureServiceFeature f) {
        Object stat = f.getProperty("la_st");
        if (stat == null) {
            return 0.0;
        }
        return (Double)stat;
    }

    public Dimension getImageSize() {
        return dimensions[this.size.ordinal()];
    }

    public static GafOptionsDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    private void initComponents() {
        this.bgOrder = new ButtonGroup();
        this.bgSize = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.jPanel2 = new JPanel();
        this.labOrder = new JLabel();
        this.rbXy = new JRadioButton();
        this.rbGewaesser = new JRadioButton();
        this.rbLawaCode = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.labSize = new JLabel();
        this.rbSmall = new JRadioButton();
        this.rbMedium = new JRadioButton();
        this.rbLarge = new JRadioButton();
        this.rbExtraLarge = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.title_1", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.butOk.text_1", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(120, 29));
        this.butOk.setPreferredSize(new Dimension(150, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafOptionsDialog.this.butOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.butCancel.text_1", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(120, 29));
        this.butCancel.setPreferredSize(new Dimension(150, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafOptionsDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labOrder, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.labOrder.text", (Object[])new Object[0]));
        this.labOrder.setPreferredSize(new Dimension(150, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.labOrder, gridBagConstraints);
        this.bgOrder.add(this.rbXy);
        this.rbXy.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbXy, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.rbXy.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.rbXy, gridBagConstraints);
        this.bgOrder.add(this.rbGewaesser);
        Mnemonics.setLocalizedText((AbstractButton)this.rbGewaesser, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.rbGewaesser.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.jPanel2.add((Component)this.rbGewaesser, gridBagConstraints);
        this.bgOrder.add(this.rbLawaCode);
        Mnemonics.setLocalizedText((AbstractButton)this.rbLawaCode, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.rbLawaCode.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.jPanel2.add((Component)this.rbLawaCode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labSize, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.labSize.text", (Object[])new Object[0]));
        this.labSize.setPreferredSize(new Dimension(150, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.jPanel4.add((Component)this.labSize, gridBagConstraints);
        this.bgSize.add(this.rbSmall);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSmall, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.rbSmall.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.jPanel4.add((Component)this.rbSmall, gridBagConstraints);
        this.bgSize.add(this.rbMedium);
        this.rbMedium.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbMedium, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.rbMedium.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.jPanel4.add((Component)this.rbMedium, gridBagConstraints);
        this.bgSize.add(this.rbLarge);
        Mnemonics.setLocalizedText((AbstractButton)this.rbLarge, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.rbLarge.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.jPanel4.add((Component)this.rbLarge, gridBagConstraints);
        this.bgSize.add(this.rbExtraLarge);
        Mnemonics.setLocalizedText((AbstractButton)this.rbExtraLarge, (String)NbBundle.getMessage(GafOptionsDialog.class, (String)"GafOptionsDialog.rbExtraLarge.text", (Object[])new Object[0]));
        this.rbExtraLarge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafOptionsDialog.this.rbExtraLargeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.jPanel4.add((Component)this.rbExtraLarge, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        if (this.order == Order.XY) {
            this.rbXy.setSelected(true);
        } else if (this.order == Order.RIVER) {
            this.rbGewaesser.setSelected(true);
        } else if (this.order == Order.LAWA) {
            this.rbLawaCode.setSelected(true);
        }
        if (this.size == Size.SMALL) {
            this.rbSmall.setSelected(true);
        } else if (this.size == Size.MEDIUM) {
            this.rbMedium.setSelected(true);
        } else if (this.size == Size.LARGE) {
            this.rbLarge.setSelected(true);
        } else if (this.size == Size.EXTRA_LARGE) {
            this.rbExtraLarge.setSelected(true);
        }
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        if (this.bgOrder.isSelected(this.rbXy.getModel())) {
            this.order = Order.XY;
        } else if (this.bgOrder.isSelected(this.rbGewaesser.getModel())) {
            this.order = Order.RIVER;
        } else if (this.bgOrder.isSelected(this.rbLawaCode.getModel())) {
            this.order = Order.LAWA;
        }
        if (this.bgSize.isSelected(this.rbSmall.getModel())) {
            this.size = Size.SMALL;
        } else if (this.bgSize.isSelected(this.rbMedium.getModel())) {
            this.size = Size.MEDIUM;
        } else if (this.bgSize.isSelected(this.rbLarge.getModel())) {
            this.size = Size.LARGE;
        } else if (this.bgSize.isSelected(this.rbExtraLarge.getModel())) {
            this.size = Size.EXTRA_LARGE;
        }
        GafInfoListener infoListener = (GafInfoListener)((Object)AppBroker.getInstance().getMappingComponent().getInputEventListener().get("GAF_INFO_LISTENER"));
        if (infoListener != null) {
            infoListener.setImageSize();
        }
        this.setVisible(false);
    }

    private void rbExtraLargeActionPerformed(ActionEvent evt) {
    }

    static {
        GafOptionsDialog.dimensions[0] = new Dimension(250, 175);
        GafOptionsDialog.dimensions[1] = new Dimension(300, 200);
        GafOptionsDialog.dimensions[2] = new Dimension(400, 250);
        GafOptionsDialog.dimensions[3] = new Dimension(500, 300);
    }

    private static final class LazyInitializer {
        private static final transient GafOptionsDialog INSTANCE = new GafOptionsDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE,
        EXTRA_LARGE;

    }

    public static enum Order {
        XY,
        RIVER,
        LAWA;

    }
}

