/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.dialog.BufferDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PhotoExportDialog
extends JDialog {
    private boolean cancelled = false;
    private String lastPath = null;
    private JButton butCancel;
    private JButton butFile;
    private JButton butOk;
    private JCheckBox ckPhoto;
    private JCheckBox ckReport;
    private JCheckBox ckShape;
    private JCheckBox ckbPhotoSelection;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel labContent;
    private JTextField txtFile;

    private PhotoExportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (!modal) {
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

                public void featuresAdded(FeatureCollectionEvent fce) {
                }

                public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresChanged(FeatureCollectionEvent fce) {
                }

                public void featureSelectionChanged(FeatureCollectionEvent fce) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PhotoExportDialog.this.refreshSelectedFeatureCount(false);
                        }
                    });
                }

                public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
                }

                public void featureCollectionChanged() {
                }
            });
        }
    }

    public static PhotoExportDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshSelectedFeatureCount(true);
            this.cancelled = true;
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.ckbPhotoSelection = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.labContent = new JLabel();
        this.ckPhoto = new JCheckBox();
        this.ckReport = new JCheckBox();
        this.ckShape = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.title_1", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.butOk.text_1", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(120, 29));
        this.butOk.setPreferredSize(new Dimension(150, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoExportDialog.this.butOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.butCancel.text_1", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(120, 29));
        this.butCancel.setPreferredSize(new Dimension(150, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoExportDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.txtFile.text_1", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.txtFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butFile, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.butFile.text_1", (Object[])new Object[0]));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoExportDialog.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        this.ckbPhotoSelection.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbPhotoSelection, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.ckbPhotoSelection.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbPhotoSelection, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labContent, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.labContent.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.labContent, gridBagConstraints);
        this.ckPhoto.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckPhoto, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.ckPhoto.text", (Object[])new Object[0]));
        this.ckPhoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoExportDialog.this.ckPhotoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel2.add((Component)this.ckPhoto, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckReport, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.ckReport.text", (Object[])new Object[0]));
        this.ckReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoExportDialog.this.ckReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel2.add((Component)this.ckReport, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckShape, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportDialog.ckShape.text", (Object[])new Object[0]));
        this.ckShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoExportDialog.this.ckShapeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.jPanel2.add((Component)this.ckShape, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        if (!this.txtFile.getText().equals("")) {
            this.cancelled = false;
            this.setVisible(false);
        } else {
            this.butFileActionPerformed(null);
        }
    }

    private void butFileActionPerformed(ActionEvent evt) {
        File file = StaticSwingTools.chooseFile((String)(this.lastPath == null ? DownloadManager.instance().getDestinationDirectory().toString() : this.lastPath), (boolean)true, (String[])new String[]{"zip"}, (String)NbBundle.getMessage(PhotoExportDialog.class, (String)"PhotoExportReportDialog.butFileActionPerformed().getDescription()"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            this.lastPath = file.getParent();
            this.txtFile.setText(file.getAbsolutePath());
        }
    }

    private void ckPhotoActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void ckReportActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void ckShapeActionPerformed(ActionEvent evt) {
        this.checkContentSelection();
    }

    private void checkContentSelection() {
        this.butOk.setEnabled(this.ckPhoto.isSelected() || this.ckReport.isSelected() || this.ckShape.isSelected());
    }

    public void refreshSelectedFeatureCount(boolean forceGuiRefresh) {
        List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("foto");
        int count = features.size();
        this.ckbPhotoSelection.setText(NbBundle.getMessage(PhotoExportDialog.class, (String)"FotoReportDialog.ckbPhotoSelection.text") + NbBundle.getMessage(BufferDialog.class, (String)"FotoReportDialog.refreshSelectedFeatureCount.text", (Object)count));
    }

    public String getZipFile() {
        return this.txtFile.getText();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isPhotosSelected() {
        return this.ckPhoto.isSelected();
    }

    public boolean isReportSelected() {
        return this.ckReport.isSelected();
    }

    public boolean isShapeSelected() {
        return this.ckShape.isSelected();
    }

    private static final class LazyInitializer {
        private static final transient PhotoExportDialog INSTANCE = new PhotoExportDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }
}

