/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cids.search.QuerySearch;
import de.cismet.cids.search.QuerySearchMethod;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.components.location.SelectionMethodInterface;
import de.cismet.watergis.utils.AddToSelectionQuerySearchMethod;
import de.cismet.watergis.utils.RemoveFromSelectionQuerySearchMethod;
import de.cismet.watergis.utils.SelectFromSelectionQuerySearchMethod;
import de.cismet.watergis.utils.SelectQuerySearchMethod;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class QuerySearchDialog
extends JDialog {
    final SelectionMethodInterface[] smArray;
    private ActiveLayerModel model;
    private AbstractFeatureService[] choosenLayer;
    private QuerySearch querySearch1;

    public QuerySearchDialog(Frame parent, boolean modal, ActiveLayerModel model) {
        super(parent, modal);
        this.model = model;
        Collection selectionMethod = Lookup.getDefault().lookupAll(SelectionMethodInterface.class);
        this.smArray = selectionMethod.toArray(new SelectionMethodInterface[selectionMethod.size()]);
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        ArrayList<AbstractFeatureService> sourceLayer = new ArrayList<AbstractFeatureService>();
        TreeMap serviceMap = layerModel.getMapServices();
        ArrayList keyList = new ArrayList(serviceMap.keySet());
        Collections.sort(keyList, Collections.reverseOrder());
        Arrays.sort(this.smArray, new Comparator<SelectionMethodInterface>(){

            @Override
            public int compare(SelectionMethodInterface o1, SelectionMethodInterface o2) {
                return o1.getOrderId().compareTo(o2.getOrderId());
            }
        });
        for (Integer key : keyList) {
            MapService service = (MapService)serviceMap.get(key);
            if (!(service instanceof AbstractFeatureService)) continue;
            sourceLayer.add((AbstractFeatureService)service);
        }
        this.choosenLayer = sourceLayer.toArray(new AbstractFeatureService[sourceLayer.size()]);
        this.initComponents();
        this.querySearch1.initWithConnectionContext(ConnectionContext.createDummy());
        this.querySearch1.enableLineWrap(true);
    }

    private void initComponents() {
        this.querySearch1 = new QuerySearch((ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel(), new String[0], this.choosenLayer, new QuerySearchMethod[]{new SelectQuerySearchMethod(), new AddToSelectionQuerySearchMethod(), new RemoveFromSelectionQuerySearchMethod(), new SelectFromSelectionQuerySearchMethod()});
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(QuerySearchDialog.class, (String)"QuerySearchDialog.title"));
        this.setPreferredSize(new Dimension(430, 500));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.querySearch1, gridBagConstraints);
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(QuerySearchDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(QuerySearchDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(QuerySearchDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(QuerySearchDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QuerySearchDialog dialog = new QuerySearchDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

