/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.watergis.server.search.CalculateFgLa;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.tools.CismetThreadPool;
import de.cismet.watergis.gui.panels.GafProf;
import de.cismet.watergis.gui.panels.GafProfWrapper;
import de.cismet.watergis.profile.GafReader;
import de.cismet.watergis.utils.CidsBeanUtils;
import de.cismet.watergis.utils.ConversionUtils;
import de.cismet.watergis.utils.RendererTools;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.SoftReference;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GafProfEditor
extends JPanel
implements DisposableCidsBeanStore {
    private static CidsLayer ppLayer;
    private static final Logger LOG;
    private static final int CACHE_SIZE = 8;
    public static final Map<Object, SoftReference<List<DefaultFeatureServiceFeature>>> FEATURE_CACHE;
    private static final int IMAGE_HEIGHT = 400;
    private static final int IMAGE_WIDTH = 800;
    private static final SimpleDateFormat timeFormatter;
    private static final SimpleDateFormat dateFormatter;
    private MetaClass L_ST_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_l_st");
    private MetaClass FREIGABE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_freigabe");
    private CidsBean cidsBean;
    private CidsLayerFeature feature;
    private List<DefaultFeatureServiceFeature> gafFeatures;
    private Timer timer;
    private ImageResizeWorker currentResizeWorker;
    private Dimension lastDims;
    private boolean firstInit = true;
    private GafProfWrapper wrapper = new GafProfWrapper(null);
    private String lastTime = "";
    private Executor locationExecutor = CismetExecutors.newSingleThreadExecutor();
    private JComboBox<String> cbFreigabe;
    private JCheckBox cbHoehe;
    private JComboBox<String> cbStatus;
    private DefaultBindableDateChooser dateChooser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel labAufnDatum;
    private JLabel labAufnName;
    private JLabel labBaCd;
    private JLabel labBaCdVal;
    private JLabel labBaStVal;
    private JLabel labBemerkung;
    private JLabel labBeschreibung;
    private JLabel labEmpty;
    private JLabel labFoto;
    private JLabel labFreigabe;
    private JLabel labHoehe;
    private JLabel labId;
    private JLabel labIdVal;
    private JLabel labImage;
    private JLabel labLaCd;
    private JLabel labLaCdVal;
    private JLabel labLst;
    private JLabel labRe;
    private JLabel labStatBa;
    private JLabel labStatLa;
    private JLabel labStatLaVal;
    private JLabel labTitle;
    private JLabel labUplDatum;
    private JLabel labUplDatumVal;
    private JLabel labUplName;
    private JLabel labUplNameVal;
    private JXBusyLabel lblBusy;
    private JXBusyLabel lblBusyLoad;
    private JPanel panAufn;
    private JPanel panBesch;
    private JPanel panFreigabe;
    private JPanel panGewaesserBezug;
    private JPanel panImage;
    private JPanel panStatus;
    private JPanel panUpload;
    private JPanel panVerortung;
    private JTextArea taBemerkung;
    private JTextArea taBeschreibung;
    private JTextArea taTitle;
    private JTextField txtAufn;
    private JTextField txtAufn1;
    private JTextField txtHo;
    private JTextField txtRe;
    private BindingGroup bindingGroup;

    public GafProfEditor() {
        this.initComponents();
        this.setFilter();
        RendererTools.makeReadOnly(this.txtHo);
        RendererTools.makeReadOnly(this.txtRe);
        this.lblBusy.setBusy(false);
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GafProfEditor.this.currentResizeWorker != null) {
                    GafProfEditor.this.currentResizeWorker.cancel(true);
                }
                GafProfEditor.this.currentResizeWorker = new ImageResizeWorker();
                CismetThreadPool.execute((Runnable)GafProfEditor.this.currentResizeWorker);
            }
        });
        this.timer.setRepeats(false);
        this.panImage.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                double width = e.getComponent().getSize().getWidth();
                double height = e.getComponent().getSize().getHeight();
                if ((GafProfEditor.this.lastDims == null || Math.abs(GafProfEditor.this.lastDims.getHeight() - height) > 5.0 || Math.abs(GafProfEditor.this.lastDims.getWidth() - width) > 5.0) && GafProfEditor.this.gafFeatures != null && !GafProfEditor.this.lblBusy.isBusy()) {
                    GafProfEditor.this.lastDims = e.getComponent().getSize();
                    GafProfEditor.this.showWait(true);
                    GafProfEditor.this.timer.restart();
                }
            }
        });
    }

    private void setFilter() {
        CidsLayerFeatureFilter filter = new CidsLayerFeatureFilter(){

            public boolean accept(CidsLayerFeature bean) {
                if (bean == null) {
                    return true;
                }
                return bean.getProperty("qp") != null && (Boolean)bean.getProperty("qp") != false;
            }
        };
        ((DefaultCidsLayerBindableReferenceCombo)this.cbStatus).setBeanFilter(filter);
        ((DefaultCidsLayerBindableReferenceCombo)this.cbFreigabe).setBeanFilter(filter);
    }

    public GafProfWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(GafProfWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public static CidsLayer getPpLayer() {
        return ppLayer;
    }

    public static void setPpLayer(CidsLayer aPpLayer) {
        ppLayer = aPpLayer;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel2 = new JPanel();
        this.labEmpty = new JLabel();
        this.jPanel1 = new JPanel();
        this.labFoto = new JLabel();
        this.panUpload = new JPanel();
        this.jLabel1 = new JLabel();
        this.labUplName = new JLabel();
        this.labUplNameVal = new JLabel();
        this.labUplDatum = new JLabel();
        this.labUplDatumVal = new JLabel();
        this.labId = new JLabel();
        this.labIdVal = new JLabel();
        this.panVerortung = new JPanel();
        this.labRe = new JLabel();
        this.txtRe = new JTextField();
        this.txtHo = new JTextField();
        this.jLabel2 = new JLabel();
        this.panGewaesserBezug = new JPanel();
        this.labBaCd = new JLabel();
        this.labLaCd = new JLabel();
        this.labBaCdVal = new JLabel();
        this.labLaCdVal = new JLabel();
        this.labLst = new JLabel();
        this.labHoehe = new JLabel();
        this.labStatLa = new JLabel();
        this.labStatBa = new JLabel();
        this.labStatLaVal = new JLabel();
        this.jLabel3 = new JLabel();
        this.cbHoehe = new JCheckBox();
        this.labBaStVal = new JLabel();
        this.panStatus = new JPanel();
        this.cbStatus = new DefaultCidsLayerBindableReferenceCombo(this.L_ST_MC, true);
        this.panAufn = new JPanel();
        this.labAufnName = new JLabel();
        this.labAufnDatum = new JLabel();
        this.txtAufn = new JTextField();
        this.labFreigabe = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel4 = new JPanel();
        this.txtAufn1 = new JTextField();
        this.dateChooser = new DefaultBindableDateChooser();
        this.panFreigabe = new JPanel();
        this.cbFreigabe = new DefaultCidsLayerBindableReferenceCombo(this.FREIGABE_MC, true);
        this.panBesch = new JPanel();
        this.labTitle = new JLabel();
        this.labBemerkung = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.labBeschreibung = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.taBeschreibung = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.taTitle = new JTextArea();
        this.panImage = new JPanel();
        this.labImage = new JLabel();
        this.lblBusy = new JXBusyLabel(new Dimension(75, 75));
        this.jPanel3 = new JPanel();
        this.lblBusyLoad = new JXBusyLabel(new Dimension(75, 75));
        this.setLayout(new CardLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labEmpty, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labEmpty.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.labEmpty, gridBagConstraints);
        this.add((Component)this.jPanel2, "empty");
        this.jPanel1.setLayout(new GridBagLayout());
        this.labFoto.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labFoto, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labFoto.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 0);
        this.jPanel1.add((Component)this.labFoto, gridBagConstraints);
        this.panUpload.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.jLabel1.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.panUpload.add((Component)this.jLabel1, gridBagConstraints);
        this.labUplName.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labUplName, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labUplName.text", (Object[])new Object[0]));
        this.labUplName.setPreferredSize(new Dimension(103, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.panUpload.add((Component)this.labUplName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.upl_name}"), (Object)this.labUplNameVal, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.panUpload.add((Component)this.labUplNameVal, gridBagConstraints);
        this.labUplDatum.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labUplDatum, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labUplDatum.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panUpload.add((Component)this.labUplDatum, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panUpload.add((Component)this.labUplDatumVal, gridBagConstraints);
        this.labId.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labId, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labId.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panUpload.add((Component)this.labId, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.qp_nr}"), (Object)this.labIdVal, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panUpload.add((Component)this.labIdVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.jPanel1.add((Component)this.panUpload, gridBagConstraints);
        this.panVerortung.setLayout(new GridBagLayout());
        this.labRe.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labRe, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labRe.text", (Object[])new Object[0]));
        this.labRe.setPreferredSize(new Dimension(103, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.panVerortung.add((Component)this.labRe, gridBagConstraints);
        this.txtRe.setMinimumSize(new Dimension(250, 25));
        this.txtRe.setPreferredSize(new Dimension(100, 25));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geom.geo_field}"), (Object)this.txtRe, (Property)BeanProperty.create((String)"text"));
        binding.setConverter((Converter)new CoordinateConverter(true));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.panVerortung.add((Component)this.txtRe, gridBagConstraints);
        this.txtHo.setMinimumSize(new Dimension(250, 25));
        this.txtHo.setPreferredSize(new Dimension(100, 25));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geom.geo_field}"), (Object)this.txtHo, (Property)BeanProperty.create((String)"text"));
        binding.setConverter((Converter)new CoordinateConverter(false));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 10, 10);
        this.panVerortung.add((Component)this.txtHo, gridBagConstraints);
        this.jLabel2.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.jLabel2.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.panVerortung.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.jPanel1.add((Component)this.panVerortung, gridBagConstraints);
        this.panGewaesserBezug.setLayout(new GridBagLayout());
        this.labBaCd.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labBaCd, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labBaCd.text", (Object[])new Object[0]));
        this.labBaCd.setPreferredSize(new Dimension(103, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labBaCd, gridBagConstraints);
        this.labLaCd.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labLaCd, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labLaCd.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labLaCd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labBaCdVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labLaCdVal, gridBagConstraints);
        this.labLst.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labLst, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labLst.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labLst, gridBagConstraints);
        this.labHoehe.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labHoehe, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labHoehe.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labHoehe, gridBagConstraints);
        this.labStatLa.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labStatLa, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labStatLa.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labStatLa, gridBagConstraints);
        this.labStatBa.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labStatBa, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labStatBa.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labStatBa, gridBagConstraints);
        this.labStatLaVal.setFont(new Font("Ubuntu", 0, 15));
        this.labStatLaVal.setPreferredSize(new Dimension(150, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labStatLaVal, gridBagConstraints);
        this.jLabel3.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.jLabel3.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 7, 10, 0);
        this.panGewaesserBezug.add((Component)this.jLabel3, gridBagConstraints);
        this.cbHoehe.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbHoehe, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.cbHoehe.text", (Object[])new Object[0]));
        this.cbHoehe.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.cbHoehe, gridBagConstraints);
        this.labBaStVal.setPreferredSize(new Dimension(150, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.labBaStVal, gridBagConstraints);
        this.panStatus.setMinimumSize(new Dimension(120, 25));
        this.panStatus.setPreferredSize(new Dimension(120, 25));
        this.panStatus.setLayout(new GridLayout(1, 0));
        this.cbStatus.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.lSt}"), this.cbStatus, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panStatus.add(this.cbStatus);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panGewaesserBezug.add((Component)this.panStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.jPanel1.add((Component)this.panGewaesserBezug, gridBagConstraints);
        this.panAufn.setLayout(new GridBagLayout());
        this.labAufnName.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labAufnName, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labAufnName.text", (Object[])new Object[0]));
        this.labAufnName.setPreferredSize(new Dimension(103, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panAufn.add((Component)this.labAufnName, gridBagConstraints);
        this.labAufnDatum.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labAufnDatum, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labAufnDatum.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panAufn.add((Component)this.labAufnDatum, gridBagConstraints);
        this.txtAufn.setMinimumSize(new Dimension(250, 25));
        this.txtAufn.setPreferredSize(new Dimension(210, 25));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.aufnahmename}"), (Object)this.txtAufn, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtAufn.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GafProfEditor.this.txtAufnFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panAufn.add((Component)this.txtAufn, gridBagConstraints);
        this.labFreigabe.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labFreigabe, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labFreigabe.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panAufn.add((Component)this.labFreigabe, gridBagConstraints);
        this.jLabel4.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.jLabel4.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 7, 10, 0);
        this.panAufn.add((Component)this.jLabel4, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.txtAufn1.setMinimumSize(new Dimension(85, 25));
        this.txtAufn1.setPreferredSize(new Dimension(85, 25));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.aufnahmezeit}"), (Object)this.txtAufn1, (Property)BeanProperty.create((String)"text"));
        binding.setValidator((Validator)new TimeValidator());
        this.bindingGroup.addBinding((Binding)binding);
        this.txtAufn1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GafProfEditor.this.txtAufn1FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel4.add((Component)this.txtAufn1, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.aufndatum}"), (Object)this.dateChooser, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dateChooser.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        this.dateChooser.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GafProfEditor.this.dateChooserFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.dateChooser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panAufn.add((Component)this.jPanel4, gridBagConstraints);
        this.panFreigabe.setMinimumSize(new Dimension(120, 25));
        this.panFreigabe.setPreferredSize(new Dimension(120, 25));
        this.panFreigabe.setLayout(new GridLayout(1, 0));
        this.cbFreigabe.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.freigabe}"), this.cbFreigabe, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panFreigabe.add(this.cbFreigabe);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panAufn.add((Component)this.panFreigabe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.jPanel1.add((Component)this.panAufn, gridBagConstraints);
        this.panBesch.setLayout(new GridBagLayout());
        this.labTitle.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labTitle, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labTitle.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panBesch.add((Component)this.labTitle, gridBagConstraints);
        this.labBemerkung.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labBemerkung, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labBemerkung.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panBesch.add((Component)this.labBemerkung, gridBagConstraints);
        this.taBemerkung.setColumns(20);
        this.taBemerkung.setRows(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.bemerkung}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.taBemerkung.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GafProfEditor.this.taBemerkungFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.taBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panBesch.add((Component)this.jScrollPane1, gridBagConstraints);
        this.labBeschreibung.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.labBeschreibung, (String)NbBundle.getMessage(GafProfEditor.class, (String)"GafProfEditor.labBeschreibung.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panBesch.add((Component)this.labBeschreibung, gridBagConstraints);
        this.taBeschreibung.setColumns(20);
        this.taBeschreibung.setRows(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.beschreibung}"), (Object)this.taBeschreibung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.taBeschreibung.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GafProfEditor.this.taBeschreibungFocusLost(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.taBeschreibung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panBesch.add((Component)this.jScrollPane2, gridBagConstraints);
        this.taTitle.setColumns(20);
        this.taTitle.setRows(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wrapper.titel}"), (Object)this.taTitle, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.taTitle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GafProfEditor.this.taTitleFocusLost(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.taTitle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panBesch.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.jPanel1.add((Component)this.panBesch, gridBagConstraints);
        this.panImage.setMinimumSize(new Dimension(300, 300));
        this.panImage.setPreferredSize(new Dimension(300, 300));
        this.panImage.setLayout(new CardLayout());
        this.labImage.setHorizontalAlignment(0);
        this.panImage.add((Component)this.labImage, "image");
        this.lblBusy.setHorizontalAlignment(0);
        this.lblBusy.setMaximumSize(new Dimension(140, 40));
        this.lblBusy.setMinimumSize(new Dimension(140, 40));
        this.lblBusy.setPreferredSize(new Dimension(140, 40));
        this.panImage.add((Component)this.lblBusy, "busy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.jPanel1.add((Component)this.panImage, gridBagConstraints);
        this.add((Component)this.jPanel1, "editor");
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblBusyLoad.setHorizontalAlignment(0);
        this.lblBusyLoad.setMaximumSize(new Dimension(140, 40));
        this.lblBusyLoad.setMinimumSize(new Dimension(140, 40));
        this.lblBusyLoad.setPreferredSize(new Dimension(140, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.lblBusyLoad, gridBagConstraints);
        this.add((Component)this.jPanel3, "load");
        this.bindingGroup.bind();
    }

    private void taTitleFocusLost(FocusEvent evt) {
        this.feature.setProperty("titel", (Object)this.taTitle.getText());
    }

    private void taBeschreibungFocusLost(FocusEvent evt) {
        this.feature.setProperty("beschreib", (Object)this.taBeschreibung.getText());
    }

    private void taBemerkungFocusLost(FocusEvent evt) {
        this.feature.setProperty("bemerkung", (Object)this.taBemerkung.getText());
    }

    private void txtAufnFocusLost(FocusEvent evt) {
        this.feature.setProperty("aufn_name", (Object)this.txtAufn.getText());
    }

    private void txtAufn1FocusLost(FocusEvent evt) {
        String zeit = this.txtAufn1.getText();
        if (!ConversionUtils.isValidTimeString(zeit)) {
            this.txtAufn1.setText(this.lastTime == null ? "" : this.lastTime);
            return;
        }
        if (zeit.matches("\\d{1,2}?:\\d{1,2}?")) {
            this.txtAufn1.setText(zeit + ":00");
        }
        this.lastTime = this.txtAufn1.getText();
    }

    private void dateChooserFocusLost(FocusEvent evt) {
    }

    private Double getDouble(String text) throws NumberFormatException {
        return Double.parseDouble(text);
    }

    public void setCidsLayerFeature(CidsLayerFeature feature) {
        this.feature = feature;
        if (feature == null) {
            this.setCidsBean(null);
        } else {
            this.setCidsBean(feature.getBean());
        }
    }

    protected void refreshLaStation(final FeatureServiceFeature feature, final String baCd, final Double baSt, final String laCd, final String laSt) {
        Thread refreshLa = new Thread("refreshLa"){

            @Override
            public void run() {
                try {
                    if (baCd == null || baSt == null) {
                        feature.setProperty(laCd, null);
                        feature.setProperty(laSt, null);
                        GafProfEditor.this.labLaCdVal.setText("");
                        GafProfEditor.this.labStatLaVal.setText("");
                    } else {
                        CalculateFgLa search = new CalculateFgLa(baCd, baSt.doubleValue());
                        User user = SessionManager.getSession().getUser();
                        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                        if (attributes != null && attributes.size() > 0 && attributes.get(0) != null && ((ArrayList)attributes.get(0)).size() > 1) {
                            feature.setProperty(laCd, ((ArrayList)attributes.get(0)).get(0));
                            feature.setProperty(laSt, ((ArrayList)attributes.get(0)).get(1));
                            GafProfEditor.this.labLaCdVal.setText(String.valueOf(((ArrayList)attributes.get(0)).get(0)));
                            GafProfEditor.this.labStatLaVal.setText(String.valueOf(((ArrayList)attributes.get(0)).get(1)));
                        } else {
                            feature.setProperty(laCd, null);
                            feature.setProperty(laSt, null);
                            GafProfEditor.this.labLaCdVal.setText("");
                            GafProfEditor.this.labStatLaVal.setText("");
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot retrieve la_cd, la_st", (Throwable)e);
                }
            }
        };
        refreshLa.start();
    }

    public boolean hasWriteAccess() {
        if (this.feature != null) {
            return this.feature.hasWritePermissions();
        }
        return false;
    }

    public CidsLayerFeature getCidsLayerFeature() {
        return this.feature;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.wrapper.setFeature(null);
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            this.wrapper.setFeature(this.feature);
            try {
                GafProf.tryStationCreation(this.feature, cidsBean);
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot determine new station", (Throwable)ex);
            }
            this.bindingGroup.bind();
            this.lastTime = (String)cidsBean.getProperty("aufn_zeit");
            this.refreshGui();
            Date uplDate = (Date)cidsBean.getProperty("upl_datum");
            String uplTime = (String)cidsBean.getProperty("upl_zeit");
            if (uplTime != null && uplDate != null) {
                this.labUplDatumVal.setText(dateFormatter.format(uplDate) + " " + uplTime);
            }
            this.loadFoto();
            this.showEditor(true, false);
            this.setReadOnly(!this.hasWriteAccess());
        } else {
            this.showEditor(false, false);
        }
    }

    public void refreshGui() {
        this.labUplNameVal.setText(this.getPropString("upl_name"));
        this.taBemerkung.setText(this.object2String(this.feature.getProperty("bemerkung")));
        this.taTitle.setText(this.object2String(this.feature.getProperty("titel")));
        this.taBeschreibung.setText(this.object2String(this.feature.getProperty("beschreib")));
        this.locationExecutor.execute(new Thread("LocationThread"){

            @Override
            public void run() {
                GafProfEditor.this.refreshLaStation((FeatureServiceFeature)GafProfEditor.this.feature, (String)GafProfEditor.this.feature.getProperty("ba_cd"), (Double)GafProfEditor.this.feature.getProperty("ba_st"), "la_cd", "la_st");
            }
        });
        if (this.feature.getProperty("ba_cd") != null) {
            this.labBaCdVal.setText(String.valueOf(this.feature.getProperty("ba_cd")));
        } else {
            this.labBaCdVal.setText("");
        }
        if (this.feature.getProperty("ba_st") != null) {
            this.labBaStVal.setText(ConversionUtils.numberToString(this.feature.getProperty("ba_st")));
        } else {
            this.labBaStVal.setText("");
        }
    }

    private void setReadOnly(boolean readOnly) {
        if (readOnly) {
            RendererTools.makeReadOnly(this.txtAufn);
            this.dateChooser.setEnabled(false);
            this.txtAufn1.setEnabled(false);
            RendererTools.makeReadOnly(this.taBemerkung);
            RendererTools.makeReadOnly(this.taTitle);
            RendererTools.makeReadOnly(this.taBeschreibung);
            if (this.panFreigabe.getComponentCount() > 0) {
                RendererTools.makeReadOnly((JComboBox)((DefaultCidsLayerBindableReferenceCombo)this.panFreigabe.getComponent(0)));
            }
            if (this.panStatus.getComponentCount() > 0) {
                RendererTools.makeReadOnly((JComboBox)((DefaultCidsLayerBindableReferenceCombo)this.panStatus.getComponent(0)));
            }
        } else {
            RendererTools.makeWritable(this.txtAufn);
            this.dateChooser.setEnabled(true);
            this.txtAufn1.setEnabled(true);
            RendererTools.makeWritable(this.taBemerkung);
            RendererTools.makeWritable(this.taTitle);
            RendererTools.makeWritable(this.taBeschreibung);
            if (this.panFreigabe.getComponentCount() > 0) {
                RendererTools.makeWritable((JComboBox)((DefaultCidsLayerBindableReferenceCombo)this.panFreigabe.getComponent(0)));
            }
            if (this.panStatus.getComponentCount() > 0) {
                RendererTools.makeWritable((JComboBox)((DefaultCidsLayerBindableReferenceCombo)this.panStatus.getComponent(0)));
            }
        }
    }

    private String object2String(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Double) {
            return String.valueOf(o).replace('.', ',');
        }
        return String.valueOf(o);
    }

    private String getPropString(String propName) {
        Object value = this.cidsBean.getProperty(propName);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private void loadFoto() {
        Object qpNr = this.cidsBean.getProperty("qp_nr");
        boolean cacheHit = false;
        if (qpNr != null) {
            List<DefaultFeatureServiceFeature> features;
            SoftReference<List<DefaultFeatureServiceFeature>> cachedImageRef = FEATURE_CACHE.get(qpNr);
            if (cachedImageRef != null && (features = cachedImageRef.get()) != null) {
                cacheHit = true;
                this.gafFeatures = features;
                this.showWait(true);
                this.timer.restart();
            }
            if (!cacheHit) {
                CismetThreadPool.execute((Runnable)new LoadImageWorker(qpNr));
            }
        }
    }

    public void dispose() {
    }

    private void indicateError(String error) {
        this.labImage.setToolTipText(error);
    }

    private void showWait(boolean wait) {
        if (wait) {
            if (!this.lblBusy.isBusy()) {
                CardLayout cardLayout = (CardLayout)this.panImage.getLayout();
                cardLayout.show(this.panImage, "busy");
                this.labImage.setIcon(null);
                this.lblBusy.setBusy(true);
            }
        } else {
            CardLayout cardLayout = (CardLayout)this.panImage.getLayout();
            cardLayout.show(this.panImage, "image");
            this.lblBusy.setBusy(false);
        }
    }

    public void showEditor(boolean editor, boolean editorWait) {
        if (editor) {
            if (editorWait) {
                CardLayout cardLayout = (CardLayout)this.getLayout();
                cardLayout.show(this, "load");
                this.lblBusyLoad.setBusy(true);
            } else {
                CardLayout cardLayout = (CardLayout)this.getLayout();
                cardLayout.show(this, "editor");
                this.lblBusyLoad.setBusy(false);
            }
        } else {
            CardLayout cardLayout = (CardLayout)this.getLayout();
            cardLayout.show(this, "empty");
        }
    }

    static {
        LOG = Logger.getLogger(GafProfEditor.class);
        FEATURE_CACHE = new LinkedHashMap<Object, SoftReference<List<DefaultFeatureServiceFeature>>>(8){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, SoftReference<List<DefaultFeatureServiceFeature>>> eldest) {
                return this.size() >= 8;
            }
        };
        timeFormatter = new SimpleDateFormat("HH:mm:ss");
        dateFormatter = new SimpleDateFormat("dd.MM.yyyy");
    }

    private class SqlTimestampToUtilDateConverter
    extends Converter<Date, Date> {
        private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        private SqlTimestampToUtilDateConverter() {
        }

        public Date convertForward(Date value) {
            return value;
        }

        public Date convertReverse(Date value) {
            try {
                GafProfEditor.this.cidsBean.setProperty("aufn_zeit", (Object)new Time(value.getTime()));
                GafProfEditor.this.cidsBean.setProperty("aufn_datum", (Object)timeFormatter.format(value.getTime()));
            }
            catch (Exception e) {
                LOG.error((Object)"Error while filling time properties", (Throwable)e);
            }
            return value;
        }
    }

    class CoordinateConverter
    extends Converter<Geometry, String> {
        private boolean rw;

        public CoordinateConverter(boolean rw) {
            this.rw = rw;
        }

        public String convertForward(Geometry value) {
            Geometry geo = value;
            if (geo instanceof Point) {
                Point point = (Point)geo;
                if (this.rw) {
                    return ConversionUtils.numberToString(point.getX());
                }
                return ConversionUtils.numberToString(point.getY());
            }
            return "";
        }

        public Geometry convertReverse(String value) {
            try {
                double coord = Double.parseDouble(value.replace(',', '.'));
                CidsBean bean = (CidsBean)GafProfEditor.this.cidsBean.getProperty("geom");
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                if (bean != null) {
                    Geometry geom = (Geometry)bean.getProperty("geo_field");
                    if (this.rw) {
                        double y = geom.getCoordinate().y;
                        Point point = factory.createPoint(new Coordinate(coord, y));
                        try {
                            bean.setProperty("geo_field", (Object)point);
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)"Cannot create coordinate");
                        }
                        return point;
                    }
                    double x = geom.getCoordinate().x;
                    Point point = factory.createPoint(new Coordinate(x, coord));
                    try {
                        bean.setProperty("geo_field", (Object)point);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Cannot create coordinate");
                    }
                    return point;
                }
                if (this.rw) {
                    Double other = this.getDouble(GafProfEditor.this.txtHo.getText());
                    CidsBean geomBean = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
                    Point point = factory.createPoint(new Coordinate(coord, other.doubleValue()));
                    geomBean.setProperty("geo_field", (Object)point);
                    return point;
                }
                Double other = this.getDouble(GafProfEditor.this.txtRe.getText());
                CidsBean geomBean = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
                Point point = factory.createPoint(new Coordinate(other.doubleValue(), coord));
                geomBean.setProperty("geo_field", (Object)point);
                return point;
            }
            catch (NumberFormatException e) {
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)"Error in rh/ho converter", (Throwable)e);
                return null;
            }
        }

        private Double getDouble(String text) throws NumberFormatException {
            return Double.parseDouble(text);
        }
    }

    private class TimeValidator
    extends Validator<String> {
        private TimeValidator() {
        }

        public Validator.Result validate(String t) {
            if (t == null || t.isEmpty()) {
                return null;
            }
            if (!ConversionUtils.isValidTimeString(t)) {
                return new Validator.Result((Validator)this, (Object)"Error", "Dies ist kein g\u00fcltiges Datum", "ERROR");
            }
            return null;
        }
    }

    final class ImageResizeWorker
    extends SwingWorker<ImageIcon, Void> {
        @Override
        protected ImageIcon doInBackground() throws Exception {
            if (GafProfEditor.this.gafFeatures != null) {
                GafReader reader = new GafReader(GafProfEditor.this.gafFeatures);
                double scalex = (double)GafProfEditor.this.panImage.getWidth() / 800.0;
                double scaley = (double)GafProfEditor.this.panImage.getHeight() / 400.0;
                double scale = Math.min(scalex, scaley);
                int width = (int)(800.0 * scale) - 20;
                int height = (int)(400.0 * scale) - 20;
                if (width > 0 && height > 0) {
                    return new ImageIcon(reader.createImage(reader.getProfiles().toArray(new Double[1])[0], width, height));
                }
                return null;
            }
            return null;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    ImageIcon result = (ImageIcon)this.get();
                    if (result != null) {
                        GafProfEditor.this.labImage.setIcon(result);
                        GafProfEditor.this.labImage.setText("");
                        GafProfEditor.this.labImage.setToolTipText(null);
                    }
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    GafProfEditor.this.labImage.setText("Fehler beim Skalieren!");
                }
                finally {
                    GafProfEditor.this.showWait(false);
                    if (GafProfEditor.this.currentResizeWorker == this) {
                        GafProfEditor.this.currentResizeWorker = null;
                    }
                }
            }
        }
    }

    final class LoadImageWorker
    extends SwingWorker<List<DefaultFeatureServiceFeature>, Void> {
        private final Object qpNr;

        public LoadImageWorker(Object qpNr) {
            this.qpNr = qpNr;
        }

        @Override
        protected List<DefaultFeatureServiceFeature> doInBackground() throws Exception {
            ppLayer.initAndWait();
            List features = ppLayer.getFeatureFactory().createFeatures((Object)("qp_nr = " + this.qpNr.toString()), null, null, 0, 0, null);
            return features;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                GafProfEditor.this.gafFeatures = (List)this.get();
                if (GafProfEditor.this.gafFeatures != null) {
                    FEATURE_CACHE.put(this.qpNr, new SoftReference<List>(GafProfEditor.this.gafFeatures));
                    GafProfEditor.this.timer.restart();
                } else {
                    GafProfEditor.this.indicateError("Bild konnte nicht geladen werden: Unbekanntes Bildformat");
                }
            }
            catch (InterruptedException ex) {
                GafProfEditor.this.gafFeatures = null;
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                GafProfEditor.this.gafFeatures = null;
                LOG.error((Object)ex, (Throwable)ex);
                String causeMessage = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                }
                GafProfEditor.this.indicateError(causeMessage);
            }
            finally {
                if (GafProfEditor.this.gafFeatures == null) {
                    GafProfEditor.this.showWait(false);
                }
            }
        }
    }
}

