/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.tools.gui.ScrollableComboBox;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class ZoomPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(ZoomPanel.class);
    protected boolean routeModelInitialised = false;
    protected final MetaClass objectMc;
    protected String featureClass;
    protected final String nameAttr;
    protected JComboBox cbObjects;

    public ZoomPanel(MetaClass objectMc, String featureClass, String nameAttr) {
        this.initComponents();
        this.objectMc = objectMc;
        this.nameAttr = nameAttr;
        AutoCompleteDecorator.decorate((JComboBox)this.cbObjects);
        this.featureClass = featureClass;
        this.init();
    }

    public void init() {
        this.cbObjects.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Lade ..."}));
        SwingWorker<GeometryElement[], Void> sw = new SwingWorker<GeometryElement[], Void>(){

            @Override
            protected GeometryElement[] doInBackground() throws Exception {
                if (ZoomPanel.this.objectMc != null) {
                    FeatureServiceAttribute attr;
                    CidsLayer layer = new CidsLayer(ZoomPanel.this.objectMc);
                    layer.initAndWait();
                    Map attributes = layer.getFeatureServiceAttributes();
                    String userGroup = SessionManager.getSession().getUser().getUserGroup().getName();
                    if (userGroup.endsWith("_edit")) {
                        userGroup = userGroup.substring(0, userGroup.indexOf("_edit"));
                    }
                    String query = (attr = (FeatureServiceAttribute)attributes.get("gmd_" + userGroup)) == null ? layer.getQuery() : attr.getName() + "=" + 1;
                    List features = layer.getFeatureFactory().createFeatures((Object)query, null, null);
                    ArrayList<GeometryElement> beans = new ArrayList<GeometryElement>();
                    if (features != null && !features.isEmpty()) {
                        for (Object f : features) {
                            if (!(f instanceof CidsLayerFeature)) continue;
                            CidsLayerFeature feature = (CidsLayerFeature)f;
                            beans.add(new GeometryElement(feature.getId(), String.valueOf(feature.getProperty(ZoomPanel.this.nameAttr)), feature.getGeometry().getEnvelope(), feature.getProperty(ZoomPanel.this.nameAttr) instanceof Integer));
                        }
                    }
                    Collections.sort(beans);
                    return beans.toArray(new GeometryElement[beans.size()]);
                }
                return new GeometryElement[0];
            }

            @Override
            protected void done() {
                try {
                    GeometryElement[] tmp = (GeometryElement[])this.get();
                    ZoomPanel.this.cbObjects.setModel(new DefaultComboBoxModel<GeometryElement>(tmp));
                    ZoomPanel.this.routeModelInitialised = true;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while initializing the model of the route combobox", (Throwable)e);
                }
            }
        };
        CismetConcurrency.getInstance((String)"watergis").getDefaultExecutor().execute(sw);
    }

    private void initComponents() {
        this.cbObjects = new ScrollableComboBox();
        this.setLayout(new GridBagLayout());
        this.cbObjects.setEditable(true);
        this.cbObjects.setMaximumSize(new Dimension(240, 24));
        this.cbObjects.setMinimumSize(new Dimension(240, 24));
        this.cbObjects.setPreferredSize(new Dimension(240, 24));
        this.cbObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomPanel.this.cbObjectsActionPerformed(evt);
            }
        });
        this.add((Component)this.cbObjects, new GridBagConstraints());
    }

    private void cbObjectsActionPerformed(ActionEvent evt) {
        Object selectedObject = this.cbObjects.getSelectedItem();
        if (this.routeModelInitialised && selectedObject instanceof GeometryElement) {
            GeometryElement selectedRoute = (GeometryElement)this.cbObjects.getSelectedItem();
            XBoundingBox bbox = (XBoundingBox)selectedRoute.getEnvelope().clone();
            bbox.increase(10);
            final int id = selectedRoute.getId();
            CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory((BoundingBox)bbox);
            if (bbox.getX1() == bbox.getX2()) {
                CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory(CismapBroker.getInstance().getMappingComponent().getBoundingBoxFromScale(500.0));
            }
            Thread t = new Thread("selectAfterZoomOnRiver"){

                @Override
                public void run() {
                    List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree(ZoomPanel.this.featureClass);
                    for (AbstractFeatureService service : services) {
                        try {
                            service.initAndWait();
                            List features = service.getFeatureFactory().createFeatures((Object)("dlm25w." + ZoomPanel.this.featureClass + ".id = " + id), null, null, 0, 1, null);
                            if (features == null || features.isEmpty()) continue;
                            SelectionManager.getInstance().setSelectedFeaturesForService(service, features);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error while selecting " + ZoomPanel.this.featureClass + " object"), (Throwable)e);
                        }
                    }
                }
            };
            t.start();
        } else {
            Thread t = new Thread("selectAfterZoomOnRiver"){

                @Override
                public void run() {
                    List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree(ZoomPanel.this.featureClass);
                    for (AbstractFeatureService service : services) {
                        try {
                            SelectionManager.getInstance().setSelectedFeaturesForService(service, new ArrayList());
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error while selecting " + ZoomPanel.this.featureClass + " object"), (Throwable)e);
                        }
                    }
                }
            };
            t.start();
        }
    }

    protected static class GeometryElement
    implements Comparable<GeometryElement> {
        private XBoundingBox env;
        private final String name;
        private final int id;
        private boolean isInteger;

        public GeometryElement(int id, String name, Geometry g, boolean isInteger) {
            this.name = name;
            this.id = id;
            this.isInteger = isInteger;
            if (g != null) {
                this.env = new XBoundingBox(g);
            }
        }

        public XBoundingBox getEnvelope() {
            return this.env;
        }

        public String toString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public int compareTo(GeometryElement o) {
            if (this.isInteger) {
                try {
                    Integer i1 = Integer.parseInt(this.toString());
                    Integer i2 = Integer.parseInt(o.toString());
                    return i1.compareTo(i2);
                }
                catch (NumberFormatException e) {
                    return this.toString().compareTo(o.toString());
                }
            }
            return this.toString().compareTo(o.toString());
        }
    }
}

