/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.watergis.profile.ChartCreator;
import de.cismet.watergis.profile.ProfileLine;
import de.cismet.watergis.profile.ProfileReader;
import de.cismet.watergis.profile.QpCheckResult;
import de.cismet.watergis.utils.CustomGafCatalogueReader;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractProfileReader
implements ProfileReader {
    private static final Logger LOG = Logger.getLogger(AbstractProfileReader.class);
    private static Double artificialStationCounter = -1.0;
    protected List<ProfileLine> content = new ArrayList<ProfileLine>();
    protected Map<ProfileReader.GAF_FIELDS, Integer> fieldMap;
    protected CustomGafCatalogueReader customRkCatalogue;
    protected CustomGafCatalogueReader customBkCatalogue;
    protected final Map<Double, ArrayList<ProfileLine>> profiles = new HashMap<Double, ArrayList<ProfileLine>>();
    protected boolean catalogueInitialised = false;
    protected final List<CidsBean> rkList = new ArrayList<CidsBean>();
    protected final List<CidsBean> bkList = new ArrayList<CidsBean>();
    protected final List<CidsBean> kz = new ArrayList<CidsBean>();
    private boolean calc = false;

    @Override
    public boolean isCalc() {
        return this.calc;
    }

    public void setCalc(boolean calc) {
        this.calc = calc;
    }

    protected synchronized void initCatalogues() {
        if (!this.catalogueInitialised) {
            MetaClass rkMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_qp_gaf_rk");
            MetaClass kzMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_qp_gaf_kz");
            MetaClass bkMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_qp_gaf_bk");
            try {
                String queryRk = "select " + rkMc.getID() + ", " + rkMc.getPrimaryKey() + " from " + rkMc.getTableName();
                String queryKz = "select " + kzMc.getID() + ", " + kzMc.getPrimaryKey() + " from " + kzMc.getTableName();
                String queryBk = "select " + bkMc.getID() + ", " + bkMc.getPrimaryKey() + " from " + bkMc.getTableName();
                MetaObject[] moRk = MetaObjectCache.getInstance().getMetaObjectsByQuery(queryRk, "DLM25W");
                MetaObject[] moBk = MetaObjectCache.getInstance().getMetaObjectsByQuery(queryBk, "DLM25W");
                MetaObject[] moKz = MetaObjectCache.getInstance().getMetaObjectsByQuery(queryKz, "DLM25W");
                if (moRk != null) {
                    for (MetaObject mo : moRk) {
                        this.rkList.add(mo.getBean());
                    }
                }
                if (moBk != null) {
                    for (MetaObject mo : moBk) {
                        this.bkList.add(mo.getBean());
                    }
                }
                if (moKz != null) {
                    for (MetaObject mo : moKz) {
                        this.kz.add(mo.getBean());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot receive gaf catalogue meta objects.", (Throwable)e);
            }
            this.catalogueInitialised = true;
        }
    }

    public static Double getArtificialStation() {
        Double d = artificialStationCounter;
        Double d2 = artificialStationCounter = Double.valueOf(artificialStationCounter - 1.0);
        return d;
    }

    protected String objectToString(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Double) {
            DecimalFormat format = new DecimalFormat();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            format.setDecimalFormatSymbols(symbols);
            format.setGroupingUsed(false);
            return format.format(obj);
        }
        return String.valueOf(obj);
    }

    protected double getStationNumber(ProfileLine line) {
        try {
            return line.getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION);
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    @Override
    public CustomGafCatalogueReader.FILE_TYPE addCustomCatalogue(File catalogueFile) throws IllegalArgumentException {
        CustomGafCatalogueReader catFile = new CustomGafCatalogueReader(catalogueFile);
        if (catFile.getType().equals((Object)CustomGafCatalogueReader.FILE_TYPE.BK)) {
            this.customBkCatalogue = catFile;
            return CustomGafCatalogueReader.FILE_TYPE.BK;
        }
        if (catFile.getType().equals((Object)CustomGafCatalogueReader.FILE_TYPE.RK)) {
            this.customRkCatalogue = catFile;
            return CustomGafCatalogueReader.FILE_TYPE.RK;
        }
        return CustomGafCatalogueReader.FILE_TYPE.UNKNOWN;
    }

    @Override
    public QpCheckResult checkFileForHints() {
        return null;
    }

    @Override
    public Set<Double> getProfiles() {
        return this.profiles.keySet();
    }

    @Override
    public LineString getNpLine(Double profile) {
        LineString ls = this.getLineBetween(profile, "PA", "PE");
        if (ls == null) {
            ls = this.getLineBetween(profile, null, null);
        }
        return ls;
    }

    public Image createImage(Double profile, int width, int height) {
        ChartCreator chart = new ChartCreator();
        ArrayList<ProfileLine> gaf = this.profiles.get(profile);
        ArrayList<ChartCreator.Point> pointList = new ArrayList<ChartCreator.Point>();
        double water = Double.MIN_VALUE;
        ArrayList schlamm = new ArrayList();
        ArrayList baUk = new ArrayList();
        ArrayList baOk = new ArrayList();
        ArrayList eiprof = new ArrayList();
        ArrayList kprof = new ArrayList();
        ArrayList maprof = new ArrayList();
        double xStart = 0.0;
        double xEnd = 0.0;
        boolean started = false;
        for (int i = 0; i < gaf.size(); ++i) {
            try {
                ProfileLine line = gaf.get(i);
                String kzVal = line.getField(ProfileReader.GAF_FIELDS.KZ);
                if (kzVal == null) {
                    kzVal = i == 0 ? "PA" : (i == gaf.size() - 1 ? "PE" : "PP");
                }
                if (kzVal.equalsIgnoreCase("PA")) {
                    xStart = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                    started = true;
                }
                if (started) {
                    double x = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                    double y = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                    ChartCreator.Point point = new ChartCreator.Point(new Color(234, 156, 39), x, y, true, false);
                    pointList.add(point);
                    ChartCreator.Point pointWithLine = new ChartCreator.Point(Color.BLACK, x, y, true, false);
                    chart.addPoint(pointWithLine);
                }
                if (!kzVal.equalsIgnoreCase("PE")) continue;
                xEnd = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                started = false;
                continue;
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Invalid value found. Not a number.", (Throwable)e);
            }
        }
        chart.addPointLines(new ChartCreator.PointLine(pointList));
        return chart.createImage(width, height);
    }

    protected LineString getLineBetween(Double profile, String kzStart, String kzEnd) {
        ArrayList<ProfileLine> profContent = this.profiles.get(profile);
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>();
        boolean started = false;
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
        for (ProfileLine line : profContent) {
            try {
                if (line.getField(ProfileReader.GAF_FIELDS.KZ) == null || kzStart == null || line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(kzStart)) {
                    started = true;
                }
                if (started) {
                    double ho = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.HW);
                    double re = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.RW);
                    Coordinate coord = new Coordinate(re, ho);
                    coordinateList.add(coord);
                }
                if (kzEnd == null || line.getField(ProfileReader.GAF_FIELDS.KZ) == null || !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(kzEnd)) continue;
                started = false;
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Invalid value found. Not a number.", (Throwable)e);
            }
        }
        if (!coordinateList.isEmpty() && coordinateList.size() > 1) {
            return factory.createLineString(coordinateList.toArray(new Coordinate[coordinateList.size()]));
        }
        return null;
    }

    @Override
    public Point getProfilePoint(Double profile) {
        ArrayList<ProfileLine> profContent = this.profiles.get(profile);
        Double luY = null;
        Double ruY = null;
        Double lbukY = null;
        Double rbukY = null;
        Double lbokY = null;
        Double rbokY = null;
        Double paY = null;
        Double peY = null;
        for (ProfileLine line : profContent) {
            try {
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("LU")) {
                    luY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("RU")) {
                    ruY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("LBUK")) {
                    lbukY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("RBUK")) {
                    rbukY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("LBOK")) {
                    lbokY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("RBOK")) {
                    rbokY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PA")) {
                    paY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                }
                if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PE")) continue;
                peY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Invalid value found. Not a number.", (Throwable)e);
            }
        }
        if (peY == null) {
            return null;
        }
        if (luY != null && ruY != null) {
            double stat = Math.abs(luY - ruY) / 2.0 + Math.min(luY, ruY) - peY;
            return this.getCentralpoint(this.getNpLine(profile), stat);
        }
        if (lbukY != null && rbukY != null) {
            double stat = Math.abs(lbukY - rbukY) / 2.0 + Math.min(lbukY, rbukY) - peY;
            return this.getCentralpoint(this.getNpLine(profile), stat);
        }
        if (lbokY != null && rbokY != null) {
            double stat = Math.abs(lbokY - rbokY) / 2.0 + Math.min(lbokY, rbokY) - peY;
            return this.getCentralpoint(this.getNpLine(profile), stat);
        }
        if (paY != null && peY != null) {
            double stat = Math.abs(paY - peY) / 2.0 + Math.min(paY, peY) - peY;
            return this.getCentralpoint(this.getNpLine(profile), stat);
        }
        return null;
    }

    @Override
    public List<ProfileLine> getProfileContent(Double profile) {
        return this.profiles.get(profile);
    }

    @Override
    public Object getProfileContent(ProfileReader.GAF_FIELDS field, ProfileLine gafLine) {
        if (field == ProfileReader.GAF_FIELDS.Z || field == ProfileReader.GAF_FIELDS.Y || field == ProfileReader.GAF_FIELDS.STATION || field == ProfileReader.GAF_FIELDS.HW || field == ProfileReader.GAF_FIELDS.RW) {
            return this.toDouble(gafLine.getField(field).replace(",", ","));
        }
        if (field == ProfileReader.GAF_FIELDS.RK) {
            CustomGafCatalogueReader.RkObject obj;
            this.initCatalogues();
            if (this.customRkCatalogue != null && (obj = this.customRkCatalogue.getRkById(gafLine.getField(field))) != null) {
                CidsBean bean = this.getCentralRkBean(obj);
                if (bean != null) {
                    return bean;
                }
                return obj;
            }
            return this.toCatalogueElement(this.rkList, gafLine.getField(field), "rk");
        }
        if (field == ProfileReader.GAF_FIELDS.BK) {
            CustomGafCatalogueReader.BkObject obj;
            this.initCatalogues();
            if (this.customBkCatalogue != null && (obj = this.customBkCatalogue.getBkById(gafLine.getField(field))) != null) {
                CidsBean bean = this.getCentralBkBean(obj);
                if (bean != null) {
                    return bean;
                }
                return obj;
            }
            return this.toCatalogueElement(this.bkList, gafLine.getField(field), "bk");
        }
        if (field == ProfileReader.GAF_FIELDS.KZ) {
            this.initCatalogues();
            return this.toCatalogueElement(this.kz, gafLine.getField(field), "kz");
        }
        return gafLine.getField(field);
    }

    protected Double toDouble(String obj) {
        try {
            return Double.parseDouble(obj);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Not a number", (Throwable)e);
            return null;
        }
    }

    protected CidsBean getCentralRkBean(CustomGafCatalogueReader.RkObject rk) {
        for (CidsBean rkBean : this.rkList) {
            String name = (String)rkBean.getProperty("name");
            Double k = (Double)rkBean.getProperty("k");
            Double kst = (Double)rkBean.getProperty("kst");
            if (name == null || !name.equalsIgnoreCase(rk.getName()) || k != rk.getK() || kst != rk.getKst()) continue;
            return rkBean;
        }
        return null;
    }

    protected CidsBean getCentralBkBean(CustomGafCatalogueReader.BkObject bk) {
        for (CidsBean bkBean : this.bkList) {
            String name = (String)bkBean.getProperty("name");
            Double ax = (Double)bkBean.getProperty("ax");
            Double ay = (Double)bkBean.getProperty("ay");
            Double dp = (Double)bkBean.getProperty("dp");
            if (name == null || !name.equalsIgnoreCase(bk.getName()) || ax != bk.getAx() || ay != bk.getAy() || dp != bk.getDp()) continue;
            return bkBean;
        }
        return null;
    }

    protected CidsBean toCatalogueElement(List<CidsBean> catalogue, String name, String catPropName) {
        for (CidsBean tmpCat : catalogue) {
            if (!String.valueOf(tmpCat.getProperty(catPropName)).equalsIgnoreCase(name)) continue;
            return tmpCat;
        }
        return null;
    }

    protected Point getCentralpoint(LineString line, double position) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
        LengthIndexedLine lil = new LengthIndexedLine((Geometry)line);
        Coordinate coordinate = lil.extractPoint(position);
        return factory.createPoint(coordinate);
    }

    @Override
    public List<ProfileLine> getContent() {
        return this.content;
    }
}

