/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.commons.security.WebDavClient;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.watergis.gui.actions.gaf.ExportAction;
import de.cismet.watergis.utils.JumpShapeWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.util.List;

public abstract class AbstractQpDownload
extends AbstractCancellableDownload {
    private static final int MAX_BUFFER_SIZE = 1024;
    protected final WebDavClient client;
    protected final List<FeatureServiceFeature> features;

    public AbstractQpDownload(WebDavClient client, String directory, String title, List<FeatureServiceFeature> features) {
        this.client = client;
        this.directory = directory;
        this.title = title;
        this.features = features;
        if (!this.directory.endsWith("/")) {
            this.directory = this.directory + "/";
        }
        this.status = Download.State.WAITING;
    }

    protected void createDbfAndMetaDoc(List<FeatureServiceFeature> features, String outputFileStem, boolean createPrj) throws Exception {
        this.createShapeAndMetaDoc(features, outputFileStem, false);
        File file = new File(outputFileStem + ".shp");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(outputFileStem + ".shx")).exists()) {
            file.delete();
        }
        if ((file = new File(outputFileStem + ".prj")).exists()) {
            file.delete();
        }
    }

    protected void createShapeAndMetaDoc(List<FeatureServiceFeature> features, String outputFileStem, boolean createPrj) throws Exception {
        CidsLayer service = (CidsLayer)features.get(0).getLayerProperties().getFeatureService();
        JumpShapeWriter shapeWriter = new JumpShapeWriter();
        String charset = Charset.defaultCharset().name();
        shapeWriter.writeShpFile(features.toArray(new FeatureServiceFeature[features.size()]), new File(outputFileStem + ".shp"), null, charset);
        if (createPrj) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileStem + ".prj"));
            bw.write("PROJCS[\"ETRS_1989_UTM_Zone_33N_zE-N\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",5650]]");
            bw.close();
        }
        BufferedWriter bwCpg = new BufferedWriter(new FileWriter(outputFileStem + ".cpg"));
        bwCpg.write(charset);
        bwCpg.close();
        ExportAction.downloadMetaDocument(service, outputFileStem);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractQpDownload)) {
            return false;
        }
        AbstractQpDownload other = (AbstractQpDownload)((Object)obj);
        boolean result = true;
        if (!(this.features == other.features || this.features != null && this.features.equals(other.features))) {
            result &= false;
        }
        if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
            result &= false;
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.features != null ? this.features.hashCode() : 0);
        hash = 43 * hash + (this.fileToSaveTo != null ? this.fileToSaveTo.hashCode() : 0);
        return hash;
    }

    protected void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }
}

