/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ChartCreator {
    private final List<Point> points = new ArrayList<Point>();
    private final List<PointLine> pointLines = new ArrayList<PointLine>();
    private final List<HorizontalLine> horizontalLines = new ArrayList<HorizontalLine>();
    private final List<VerticalLine> verticalLines = new ArrayList<VerticalLine>();
    private final List<Circle> circles = new ArrayList<Circle>();
    private int leftBorder;
    private int buttomBorder;
    private int topBorder;
    private int rightBorder;
    private Rectangle2D dims;

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public void addPointLines(PointLine line) {
        this.pointLines.add(line);
    }

    public void addHorizontalLines(HorizontalLine line) {
        this.horizontalLines.add(line);
    }

    public void addVerticalLines(VerticalLine line) {
        this.verticalLines.add(line);
    }

    public void addCircle(Circle circle) {
        this.circles.add(circle);
    }

    public Image createImage(int width, int height) {
        BufferedImage im = new BufferedImage(width, height, 2);
        Graphics2D g = im.createGraphics();
        FontMetrics fmetrics = g.getFontMetrics();
        this.dims = this.getDimension();
        if (this.dims.getWidth() < 1.0 || this.dims.getHeight() < 1.0) {
            return im;
        }
        Rectangle2D yTextSize = fmetrics.getStringBounds(String.valueOf((double)((int)(this.dims.getMinY() + this.dims.getHeight())) + 0.8), g);
        this.leftBorder = (int)yTextSize.getBounds2D().getWidth() + 15;
        this.buttomBorder = (int)yTextSize.getBounds2D().getHeight() + 15;
        this.topBorder = 5;
        this.rightBorder = 5;
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, width, height);
        g.setStroke(new BasicStroke(2.0f));
        this.drawCoordinateSystem(g, width, height);
        this.drawAllPoints(g, width, height);
        this.drawAllHorizontalLines(g, width, height);
        this.drawAllVerticalLines(g, width, height);
        this.drawAllPointLines(g, width, height);
        this.drawAllCircles(g, width, height);
        return im;
    }

    private void drawAllPoints(Graphics2D g, int width, int height) {
        for (Point p : this.points) {
            this.drawPoint(p, g, width, height);
        }
    }

    private void drawAllCircles(Graphics2D g, int width, int height) {
        for (Circle c : this.circles) {
            this.drawCircle(c, g, width, height);
        }
    }

    private void drawAllPointLines(Graphics2D g, int width, int height) {
        for (PointLine pl : this.pointLines) {
            this.drawPointLine(pl, g, width, height);
        }
    }

    private void drawAllHorizontalLines(Graphics2D g, int width, int height) {
        for (HorizontalLine l : this.horizontalLines) {
            g.setColor(l.getColor());
            g.drawLine(this.transformToScreenX(l.getFrom().getX(), width), this.transformToScreenY(l.getFrom().getY(), height), this.transformToScreenX(l.getTo().getX(), width), this.transformToScreenY(l.getTo().getY(), height));
        }
    }

    private void drawAllVerticalLines(Graphics2D g, int width, int height) {
        for (VerticalLine l : this.verticalLines) {
            g.setColor(l.getColor());
            Point p = l.getPoint();
            g.drawLine(this.transformToScreenX(p.getX(), width), this.transformToScreenY(p.getY(), height), this.transformToScreenX(p.getX(), width), height - this.buttomBorder - 1);
        }
    }

    private void drawPointLine(PointLine pl, Graphics2D g, int width, int height) {
        Point lastPoint = null;
        for (Point p : pl.getPoints()) {
            this.drawPoint(p, g, width, height);
            if (lastPoint != null) {
                g.setColor(lastPoint.getColor());
                g.drawLine(this.transformToScreenX(lastPoint.getX(), width), this.transformToScreenY(lastPoint.getY(), height), this.transformToScreenX(p.getX(), width), this.transformToScreenY(p.getY(), height));
            }
            lastPoint = p;
        }
    }

    private void drawPoint(Point p, Graphics2D g, int width, int height) {
        g.setColor(p.getColor());
        if (p.pointSymbol) {
            g.fillOval(this.transformToScreenX(p.getX(), width) - 4, this.transformToScreenY(p.getY(), height) - 4, 9, 9);
        }
        if (p.lineToBottom) {
            Stroke oldStroke = g.getStroke();
            if (p.getStroke() != null) {
                g.setStroke(p.getStroke());
            }
            g.drawLine(this.transformToScreenX(p.getX(), width), this.transformToScreenY(p.getY(), height), this.transformToScreenX(p.getX(), width), height - this.buttomBorder - 1);
            g.setStroke(oldStroke);
        }
        if (p.getText() != null) {
            g.setColor(Color.BLACK);
            g.drawString(p.getText(), this.transformToScreenX(p.getX(), width) - 4, this.transformToScreenY(p.getY(), height) - 10);
        }
    }

    private void drawCircle(Circle c, Graphics2D g, int width, int height) {
        g.setColor(c.getColor());
        g.drawOval(this.transformToScreenX(c.getX(), width) - 4, this.transformToScreenY(c.getY(), height), (int)c.getWidth(), (int)c.getHeight());
    }

    private void drawCoordinateSystem(Graphics2D g, int width, int height) {
        g.setColor(Color.BLACK);
        g.drawLine(this.leftBorder, this.topBorder, this.leftBorder, height - this.buttomBorder);
        g.drawLine(width - this.rightBorder, this.topBorder, width - this.rightBorder, height - this.buttomBorder);
        g.drawLine(this.leftBorder, this.topBorder, width - this.rightBorder, this.topBorder);
        g.drawLine(this.leftBorder, height - this.buttomBorder, width - this.rightBorder, height - this.buttomBorder);
        FontMetrics fmetrics = g.getFontMetrics();
        Rectangle2D xTextSize = fmetrics.getStringBounds(String.valueOf((int)(10.0 * (this.dims.getMinX() + this.dims.getWidth())) / 10), g);
        int xValueCount = (int)((double)(width - this.leftBorder - this.rightBorder) / (xTextSize.getWidth() + 20.0));
        int yValueCount = (int)((double)(height - this.topBorder - this.buttomBorder) / (xTextSize.getHeight() + 20.0));
        double xPart = this.getPartDistance(xValueCount, this.dims.getBounds2D().getWidth());
        double yPart = this.getPartDistance(yValueCount, this.dims.getBounds2D().getHeight());
        int x = 1;
        int y = 1;
        while (this.transformToScreenX((double)x * xPart + this.dims.getX(), width) < width - (this.rightBorder + 15)) {
            double xVal = (double)x * xPart + this.dims.getX();
            g.drawLine(this.transformToScreenX(xVal, width), height - this.buttomBorder, this.transformToScreenX(xVal, width), height - this.buttomBorder + 4);
            double stringWidth = fmetrics.getStringBounds(String.valueOf(this.round(xVal)), g).getWidth();
            g.drawString(String.valueOf(this.round(xVal)), (int)((double)this.transformToScreenX(xVal, width) - stringWidth / 2.0), height - 5);
            ++x;
        }
        while (this.transformToScreenY((double)y * yPart + this.dims.getY(), height) > this.topBorder + 20) {
            double yVal = (double)y * yPart + this.dims.getY();
            g.drawLine(this.leftBorder, this.transformToScreenY(yVal, height), this.leftBorder - 4, this.transformToScreenY(yVal, height));
            double stringHeight = fmetrics.getStringBounds(String.valueOf(this.round(yVal)), g).getHeight();
            g.drawString(String.valueOf(this.round(yVal)), 5, (int)((double)this.transformToScreenY(yVal, height) + stringHeight / 2.0));
            ++y;
        }
    }

    private double round(double val) {
        return (double)((int)(val * 10.0)) / 10.0;
    }

    private double getPartDistance(int parts, double totalDist) {
        if (totalDist / (double)parts >= 1.0) {
            return (int)(totalDist / (double)parts);
        }
        return (double)((int)(totalDist / (double)parts * 10.0)) / 10.0;
    }

    private int transformToScreenX(double x, int width) {
        return (int)((x - this.dims.getX()) / this.dims.getWidth() * (double)(width - this.rightBorder - this.leftBorder)) + this.leftBorder;
    }

    private int transformToScreenY(double y, int height) {
        return (int)((this.dims.getHeight() - (y - this.dims.getY())) / this.dims.getHeight() * (double)(height - this.topBorder - this.buttomBorder)) + this.topBorder;
    }

    private Rectangle2D getDimension() {
        Dimension dim = new Dimension();
        for (Point point : this.points) {
            dim.addPoint(point);
        }
        for (PointLine pointLine : this.pointLines) {
            for (Point p : pointLine.points) {
                dim.addPoint(p);
            }
        }
        for (HorizontalLine horizontalLine : this.horizontalLines) {
            dim.addPoint(horizontalLine.from);
            dim.addPoint(horizontalLine.to);
        }
        for (VerticalLine verticalLine : this.verticalLines) {
            dim.addPoint(verticalLine.point);
        }
        return dim.getDimensions();
    }

    static class HorizontalLine {
        private final Color color;
        private final Point from;
        private final Point to;
        private final Color backgroundColor;

        public HorizontalLine(Color color, Point from, Point to, Color backgroundColor) {
            this.color = color;
            this.from = from;
            this.to = to;
            this.backgroundColor = backgroundColor;
        }

        public Color getColor() {
            return this.color;
        }

        public Point getFrom() {
            return this.from;
        }

        public Point getTo() {
            return this.to;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }
    }

    static class VerticalLine {
        private final Color color;
        private final Point point;

        public VerticalLine(Color color, Point point) {
            this.color = color;
            this.point = point;
        }

        public Color getColor() {
            return this.color;
        }

        public Point getPoint() {
            return this.point;
        }
    }

    static class PointLine {
        private final List<Point> points;

        public PointLine(List<Point> points) {
            this.points = points;
        }

        public List<Point> getPoints() {
            return this.points;
        }
    }

    static class Circle {
        private final Color color;
        private final double x;
        private final double y;
        private final double width;
        private final double height;

        public Circle(Color color, double x, double y, double width, double height) {
            this.color = color;
            this.x = x;
            this.y = y;
            this.width = width / 2.0;
            this.height = height / 2.0;
        }

        public Color getColor() {
            return this.color;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }
    }

    static class Point
    extends Point2D.Double {
        private final Color color;
        private final boolean pointSymbol;
        private final boolean lineToBottom;
        private final String text;
        private Stroke stroke = null;

        public Point(Color color, double x, double y, boolean pointSymbol, boolean lineToBottom) {
            this(color, x, y, pointSymbol, lineToBottom, null);
        }

        public Point(Color color, double x, double y, boolean pointSymbol, boolean lineToBottom, String text) {
            super(x, y);
            this.color = color;
            this.pointSymbol = pointSymbol;
            this.lineToBottom = lineToBottom;
            this.text = text;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isPointSymbol() {
            return this.pointSymbol;
        }

        public String getText() {
            return this.text;
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        public void setStroke(Stroke stroke) {
            this.stroke = stroke;
        }
    }

    class Dimension {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;

        Dimension() {
        }

        public void addPoint(Point p) {
            if (p.getX() < this.minX) {
                this.minX = p.getX();
            }
            if (p.getX() > this.maxX) {
                this.maxX = p.getX();
            }
            if (p.getY() > this.maxY) {
                this.maxY = p.getY();
            }
            if (p.getY() < this.minY) {
                this.minY = p.getY();
            }
        }

        public Rectangle2D getDimensions() {
            double width = this.maxX - this.minX;
            double height = this.maxY - this.minY;
            double additionalWidth = width * 0.05;
            double additionalHeight = (height == 0.0 ? 10.0 : height) * 0.05;
            this.minX -= additionalWidth;
            this.maxX += additionalWidth;
            this.minY -= additionalHeight;
            this.maxY += additionalHeight;
            return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
        }
    }
}

