/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.commons.security.WebDavClient;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.profile.AbstractQpDownload;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;

public class QpNplDownload
extends AbstractQpDownload {
    private static final int MAX_BUFFER_SIZE = 1024;

    public QpNplDownload(WebDavClient client, String directory, String title, List<FeatureServiceFeature> features) {
        super(client, directory, title, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        FileOutputStream out = null;
        InputStream resp = null;
        this.stateChanged();
        for (FeatureServiceFeature feature : this.features) {
            try {
                int read;
                String fileName = "qp-" + String.valueOf(feature.getProperty("upl_nr")) + ".zip";
                String filePrefix = "qp/";
                resp = this.client.getInputStream(Photo.WEB_DAV_DIRECTORY + "qp/" + fileName);
                out = new FileOutputStream(this.directory + fileName);
                byte[] buffer = new byte[1024];
                while ((read = resp.read(buffer)) != -1) {
                    if (Thread.interrupted()) {
                        log.info((Object)"Download was interuppted");
                        out.close();
                        resp.close();
                        this.deleteFile();
                        return;
                    }
                    out.write(buffer, 0, read);
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception occured while closing file.", (Throwable)e);
                    }
                }
                if (resp == null) continue;
                try {
                    resp.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception occured while closing response stream.", (Throwable)e);
                }
            }
        }
        try {
            File shapeFile = new File(this.directory, "qp_npl");
            this.createShapeAndMetaDoc(this.features, this.directory + "qp_npl", true);
        }
        catch (Exception ex) {
            this.error(ex);
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }
}

