/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewByGem;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.reports.types.GemeindenDataLightweight;
import de.cismet.watergis.reports.types.GmdPartObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class GerOffenGmdHelper {
    private final Map<Integer, List<GmdPartObj>> gemPartMap = new HashMap<Integer, List<GmdPartObj>>();
    private final Map<Integer, GemeindenDataLightweight> gemDataMap = new HashMap<Integer, GemeindenDataLightweight>();

    public GerOffenGmdHelper(int[] gemNr, int[] routeIds, int[] allowedWdmArray) throws Exception {
        this.init(gemNr, routeIds, allowedWdmArray);
    }

    private void init(int[] gemNr, int[] routeIds, int[] allowedWdmArray) throws Exception {
        for (int gem : gemNr) {
            this.gemPartMap.put(gem, this.getAllRoutes(gem, routeIds, allowedWdmArray));
            Integer[] idList = this.getGew(gem).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length == 0) {
                routes = null;
            }
            this.gemDataMap.put(gem, new GemeindenDataLightweight(gem, routes));
        }
    }

    public Map<Integer, List<GmdPartObj>> getGemPartMap() {
        return this.gemPartMap;
    }

    private List<GmdPartObj> getAllRoutes(int gemId, int[] routeIds, int[] allowedWdmArray) throws Exception {
        AllGewByGem search = new AllGewByGem(gemId, routeIds, allowedWdmArray);
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GmdPartObj> objList = new ArrayList<GmdPartObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GmdPartObj((Integer)f.get(0), (String)f.get(1), (String)f.get(7), (String)f.get(8), (String)f.get(9), (Integer)f.get(10), (String)f.get(2), (Double)f.get(3), (Double)f.get(4), (Integer)f.get(5), (Integer)f.get(6), (Double)f.get(11), (Double)f.get(12)));
            }
        }
        return objList;
    }

    public Collection<Integer> getGew(int gemNr) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    public int getCountGewAll(int gemNr) {
        return this.getCountGewAll(gemNr, -1);
    }

    public double getLengthGewAll(int gemNr) {
        return this.getLengthGewAll(gemNr, -1);
    }

    public int getCountGewAll(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    public double getLengthGewAll(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(int gemNr) {
        return this.getLengthOffeneAbschn(gemNr, -1);
    }

    public double getLengthOffeneAbschn(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(int gemNr, int gewId, double from, double till) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    public int getCountOffeneAbschn(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    public double getLengthOffeneAbschn(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(int gemNr, String owner, Integer wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm.intValue() || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public int getCountGewAll(int gemNr, String gu) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    public int getCountGewAll(int gemNr, String gu, Integer wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            ++count;
        }
        return count;
    }

    public double getLengthGewAll(int gemNr, String gu) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthGewAll(int gemNr, String gu, Integer wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            length += tmp.getLength();
        }
        return length;
    }
}

