/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewGeschlByGeom;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.GerinneGeschlFlaechenReportDialog;
import de.cismet.watergis.reports.KatasterFlaechenData;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.Flaeche;
import de.cismet.watergis.reports.types.GmdPartObjGeschl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.apache.log4j.Logger;

public class GerinneGFlReport {
    private static final Logger LOG = Logger.getLogger(GerinneGFlReport.class);
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "group", "gmdName", "code", "anzahlGu", "gu", "dimension", "dim"};
    protected List<String> sheetNames = new ArrayList<String>();
    protected HashMap<String, Object> parameters = new HashMap();
    private final Map<Object, List<GmdPartObjGeschl>> gemPartMap = new HashMap<Object, List<GmdPartObjGeschl>>();
    private final Map<Object, KatasterFlaechenData> gemDataMap = new HashMap<Object, KatasterFlaechenData>();

    public File createFlaechenReport(Flaeche[] fl, int[] gew) throws Exception {
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        this.parameters.put("klasse", GerinneGeschlFlaechenReportDialog.getInstance().getFlaechenService().getName());
        this.parameters.put("attr1", GerinneGeschlFlaechenReportDialog.getInstance().getAttr1());
        this.parameters.put("attr2", GerinneGeschlFlaechenReportDialog.getInstance().getAttr2());
        this.parameters.put("datum", df.format(new Date()));
        this.parameters.put("spalte1", false);
        this.parameters.put("spalte2", false);
        this.parameters.put("spalte3", false);
        this.parameters.put("spalte4", false);
        this.parameters.put("spalte5", false);
        this.parameters.put("spalte6", false);
        this.parameters.put("spalte7", false);
        this.parameters.put("spalte8", false);
        this.parameters.put("spalte9", false);
        this.parameters.put("spalte10", false);
        this.parameters.put("spalte11", false);
        this.parameters.put("ges", true);
        this.parameters.put("dimension", GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null);
        this.parameters.put("tiefenklasse", GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null);
        this.parameters.put("fachdata", GerinneGeschlFlaechenReportDialog.getInstance().isAllDataPerObject());
        this.parameters.put("perObject", GerinneGeschlFlaechenReportDialog.getInstance().isPerObject());
        this.parameters.put("sumGu", GerinneGeschlFlaechenReportDialog.getInstance().isSumGu());
        this.parameters.put("withWdm", GerinneGeschlFlaechenReportDialog.getInstance().isPerWdm());
        this.parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GerinneGFlReport.class.getResourceAsStream("/de/cismet/watergis/reports/GerinneGeschlFl.jasper"));
        this.init(fl, gew);
        if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses().size() > 1) {
            this.parameters.put("gemKomp", true);
            dataSources.put("gemeinden", this.getGemeinden2());
        } else if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses().size() == 1) {
            this.parameters.put("gemKomp", false);
            dataSources.put("gemeinden", this.getGemeinden1());
        } else {
            this.parameters.put("gemKomp", false);
            dataSources.put("gemeinden", this.getGemeinden());
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().isPerGew()) {
            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                dataSources.put("gewaesser", this.getGewaesser2());
            } else if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses().size() == 1) {
                dataSources.put("gewaesser", this.getGewaesser1());
            } else {
                dataSources.put("gewaesser", this.getGewaesser());
            }
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().isPerObject()) {
            dataSources.put("objects", this.getObjects());
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().isSumGu() && !GerinneGeschlFlaechenReportDialog.getInstance().isPerWdm()) {
            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                dataSources.put("gu", this.getGuDataSource2());
            } else if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses().size() == 1) {
                dataSources.put("gu", this.getGuDataSource1());
            } else {
                dataSources.put("gu", this.getGuDataSource());
            }
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().isSumGu() && GerinneGeschlFlaechenReportDialog.getInstance().isPerWdm()) {
            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                dataSources.put("gu", this.getGuWdmDataSource2());
            } else if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null || GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getClasses().size() == 1) {
                dataSources.put("gu", this.getGuWdmDataSource1());
            } else {
                dataSources.put("gu", this.getGuWdmDataSource());
            }
        }
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.parameters, (JRDataSource)dummyDataSource);
        File file = new File(GerinneGeschlFlaechenReportDialog.getInstance().getPath() + "/Fl\u00e4chen.xlsx");
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        GerinneGFlReport report = new GerinneGFlReport();
    }

    private void init(Flaeche[] fls, int[] routeIds) throws Exception {
        for (Flaeche fl : fls) {
            this.gemPartMap.put(fl.getAttr1(), this.getAllRoutes(fl, routeIds));
            Integer[] idList = this.getGew(fl.getAttr1()).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length == 0) {
                routes = null;
            }
            this.gemDataMap.put(fl.getAttr1(), new KatasterFlaechenData(fl.getAttr1(), fl.getAttr2(), routes));
        }
    }

    private List<GmdPartObjGeschl> getAllRoutes(Flaeche fl, int[] routeIds) throws Exception {
        AllGewGeschlByGeom search = new AllGewGeschlByGeom(routeIds, this.getAllowedWdms(), fl.getGeom());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GmdPartObjGeschl> objList = new ArrayList<GmdPartObjGeschl>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GmdPartObjGeschl((Integer)f.get(0), (String)f.get(7), (String)f.get(1), (String)f.get(4), (String)f.get(2), (Integer)f.get(3), (String)f.get(8), (Double)f.get(9), (Double)f.get(10), (Integer)f.get(11), (Integer)f.get(12), (Double)f.get(5), (Double)f.get(6), (String)f.get(13), (String)f.get(14), (String)f.get(15), (String)f.get(16), (String)f.get(17), (Integer)f.get(18), (String)f.get(19), (String)f.get(20), (String)f.get(21), (Double)f.get(22), (Double)f.get(23), (Double)f.get(24), (Double)f.get(25), (Double)f.get(26), (Double)f.get(27), (Double)f.get(28), (Double)f.get(29), (Double)f.get(30), (Double)f.get(31), (Double)f.get(32), (String)f.get(33), (String)f.get(34)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (GerinneGeschlFlaechenReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (GerinneGeschlFlaechenReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGemeinden() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            double colLength;
            double colCount;
            String lab;
            String anz;
            Integer till;
            Integer from;
            int i;
            List<Object> l;
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double count = 0.0;
            double length = 0.0;
            feature.put("anzahlGmd", this.gemDataMap.size());
            feature.put("group", "gemeinde");
            feature.put("gmdNr", gem);
            feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
            feature.put("art", art);
            if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + i;
                    String laenge = "laenge" + i;
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllTf(gem, from, till);
                    colLength = this.getLengthAllTf(gem, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null) {
                l = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllDim(gem, from, till);
                    colLength = this.getLengthAllDim(gem, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                for (i = 0; i < l.size(); ++i) {
                    String anz2 = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    String lab2 = "lab" + (i + 1);
                    double colCount2 = this.getCount(gem, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                    double colLength2 = this.getLength(gem, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                    count += colCount2;
                    length += colLength2;
                    feature.put(lab2, this.toColumnName((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))));
                    feature.put(anz2, colCount2);
                    feature.put(laenge, colLength2);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                        this.parameters.put("ges", false);
                    }
                    first = false;
                }
            }
            feature.put("anzGes", count);
            feature.put("laengeGes", length);
            features.add(feature);
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGemeinden1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        for (int di = 0; di < d.size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            for (Object gem : this.gemDataMap.keySet()) {
                int i;
                List<Object> l;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                feature.put("anzahlGmd", this.gemDataMap.size());
                feature.put("group", null);
                feature.put("gmdNr", gem);
                feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                feature.put("art", art);
                if (!isTiefeArt && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        Integer till = (Integer)l.get(i);
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        String lab = "lab" + (i + 1);
                        if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                            GerinneGeschlFlaechenReportDialog.Art arten = GerinneGeschlFlaechenReportDialog.getInstance().getArt().get(0);
                            colCount = this.getCountAllTfDim(gem, arten, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(gem, arten, from, till, dimFrom, dimTill);
                        } else {
                            colCount = this.getCountAllTfDim(gem, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(gem, from, till, dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        String anz = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        String lab = "lab" + (i + 1);
                        if (isTiefeArt) {
                            colCount = this.getCountTf(gem, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthTf(gem, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        } else {
                            colCount = this.getCountDim(gem, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthDim(gem, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, this.toColumnName((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                            this.parameters.put("ges", false);
                        }
                        first = false;
                    }
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        features.add(this.createKumFeature(featuresKum, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGemeinden2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        boolean first = true;
        String art = this.createArtString();
        for (int di = 0; di < GerinneGeschlFlaechenReportDialog.getInstance().getDimensions().size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            List<Integer> d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
            for (Object gem : this.gemDataMap.keySet()) {
                Integer till;
                Integer from;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("anzahlGmd", this.gemDataMap.size());
                feature.put("group", null);
                feature.put("gmdNr", gem);
                feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                feature.put("art", art);
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                    double countA = 0.0;
                    double lengthA = 0.0;
                    if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                        int i;
                        List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                            String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                            String lab = "lab" + (i + 1);
                            double colCount = this.getCountAllTfDim(gem, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(gem, a, from, till, dimFrom, dimTill);
                            count += colCount;
                            length += colLength;
                            countA += colCount;
                            lengthA += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    }
                    feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                    feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                    List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                    double countT = 0.0;
                    double lengthT = 0.0;
                    for (int i = 0; i < l.size(); ++i) {
                        for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            double colCount = this.getCountAllTfDim(gem, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(gem, a, from, till, dimFrom, dimTill);
                            countT += colCount;
                            lengthT += colLength;
                        }
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        feature.put(anz, countT);
                        feature.put(laenge, lengthT);
                    }
                }
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        features.add(this.createKumFeature(featuresKum, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("" + this.gemDataMap.get(gem).getAttr2());
            for (Integer gew : this.getGew(gem)) {
                double colLength;
                double colCount;
                String lab;
                String anz;
                Integer till;
                Integer from;
                int i;
                List<Object> l;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double count = 0.0;
                double length = 0.0;
                feature.put("anzGew", this.gemDataMap.size());
                feature.put("group", String.valueOf(gem));
                feature.put("gmdNr", gem);
                feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                feature.put("gewName", this.getGewName(gem, gew));
                feature.put("code", this.getBaCd(gem, gew));
                feature.put("arten", art);
                feature.put("laenge", this.getLengthGew(gem, (int)gew));
                if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                    for (i = 0; i < l.size(); ++i) {
                        from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        till = (Integer)l.get(i);
                        anz = "anz" + i;
                        String laenge = "laenge" + i;
                        lab = "lab" + (i + 1);
                        colCount = this.getCountAllTf(gem, gew, from, till);
                        colLength = this.getLengthAllTf(gem, gew, from, till);
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
                    for (i = 0; i < l.size(); ++i) {
                        from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        till = (Integer)l.get(i);
                        anz = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        lab = "lab" + (i + 1);
                        colCount = this.getCountAllDim(gem, gew, from, till);
                        colLength = this.getLengthAllDim(gem, gew, from, till);
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                    for (i = 0; i < l.size(); ++i) {
                        String anz2 = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        String lab2 = "lab" + (i + 1);
                        double colCount2 = this.getCount(gem, gew, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                        double colLength2 = this.getLength(gem, gew, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                        count += colCount2;
                        length += colLength2;
                        feature.put(lab2, this.toColumnName((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))));
                        feature.put(anz2, colCount2);
                        feature.put(laenge, colLength2);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                            this.parameters.put("ges", false);
                        }
                        first = false;
                    }
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                features.add(feature);
            }
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("" + this.gemDataMap.get(gem).getAttr2());
            for (int di = 0; di < d.size(); ++di) {
                ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
                for (Integer gew : this.getGew(gem)) {
                    int i;
                    List<Object> l;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                    Integer dimTill = d.get(di);
                    double count = 0.0;
                    double length = 0.0;
                    feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                    feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                    feature.put("anzGew", this.getGew(gem).size());
                    feature.put("group", String.valueOf(gem));
                    feature.put("gmdNr", gem);
                    feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                    feature.put("gewName", this.getGewName(gem, gew));
                    feature.put("code", this.getBaCd(gem, gew));
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gem, (int)gew));
                    if (!isTiefeArt && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                        l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            double colLength;
                            double colCount;
                            Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                            Integer till = (Integer)l.get(i);
                            String anz = "anz" + i;
                            String laenge = "laenge" + i;
                            String lab = "lab" + (i + 1);
                            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                                GerinneGeschlFlaechenReportDialog.Art arten = GerinneGeschlFlaechenReportDialog.getInstance().getArt().get(0);
                                colCount = this.getCountAllTfDim(gem, gew, arten, from, till, dimFrom, dimTill);
                                colLength = this.getLengthAllTfDim(gem, gew, arten, from, till, dimFrom, dimTill);
                            } else {
                                colCount = this.getCountAllTfDim(gem, gew, from, till, dimFrom, dimTill);
                                colLength = this.getLengthAllTfDim(gem, gew, from, till, dimFrom, dimTill);
                            }
                            count += colCount;
                            length += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                        l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                        for (i = 0; i < l.size(); ++i) {
                            double colLength;
                            double colCount;
                            String anz = "anz" + (i + 1);
                            String laenge = "laenge" + (i + 1);
                            String lab = "lab" + (i + 1);
                            if (isTiefeArt) {
                                colCount = this.getCountTf(gem, gew, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                colLength = this.getLengthTf(gem, gew, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            } else {
                                colCount = this.getCountDim(gem, gew, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                colLength = this.getLengthDim(gem, gew, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            }
                            count += colCount;
                            length += colLength;
                            feature.put(lab, this.toColumnName((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                                this.parameters.put("ges", false);
                            }
                            first = false;
                        }
                    }
                    feature.put("anzGes", count);
                    feature.put("laengeGes", length);
                    features.add(feature);
                    featuresKum.add(feature);
                    featuresKumDim.add(feature);
                }
                features.add(this.createKumFeature(featuresKumDim, true));
            }
            features.add(this.createKumFeature(featuresKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("" + this.gemDataMap.get(gem).getAttr2());
            for (int di = 0; di < GerinneGeschlFlaechenReportDialog.getInstance().getDimensions().size(); ++di) {
                ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
                List<Integer> d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
                for (Integer gew : this.getGew(gem)) {
                    Integer till;
                    Integer from;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                    Integer dimTill = d.get(di);
                    double count = 0.0;
                    double length = 0.0;
                    feature.put("anzGew", this.getGew(gem).size());
                    feature.put("group", String.valueOf(gem));
                    feature.put("gmdNr", gem);
                    feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                    feature.put("gewName", this.getGewName(gem, gew));
                    feature.put("code", this.getBaCd(gem, gew));
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gem, (int)gew));
                    feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                    for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                        double countA = 0.0;
                        double lengthA = 0.0;
                        if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                            int i;
                            List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                            for (i = 0; i < l.size(); ++i) {
                                from = i > 0 ? l.get(i - 1) : new Integer(0);
                                till = l.get(i);
                                String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                                String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                                String lab = "lab" + (i + 1);
                                double colCount = this.getCountAllTfDim(gem, gew, a, from, till, dimFrom, dimTill);
                                double colLength = this.getLengthAllTfDim(gem, gew, a, from, till, dimFrom, dimTill);
                                count += colCount;
                                length += colLength;
                                countA += colCount;
                                lengthA += colLength;
                                feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                                feature.put(anz, colCount);
                                feature.put(laenge, colLength);
                            }
                            if (first) {
                                for (i = 0; i < l.size(); ++i) {
                                    this.parameters.put("spalte" + (i + 1), true);
                                }
                                first = false;
                            }
                        }
                        feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                        feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                    }
                    feature.put("anzGes", count);
                    feature.put("laengeGes", length);
                    if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                        List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                        double countT = 0.0;
                        double lengthT = 0.0;
                        for (int i = 0; i < l.size(); ++i) {
                            for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                                from = i > 0 ? l.get(i - 1) : new Integer(0);
                                till = l.get(i);
                                double colCount = this.getCountAllTfDim(gem, gew, a, from, till, dimFrom, dimTill);
                                double colLength = this.getLengthAllTfDim(gem, gew, a, from, till, dimFrom, dimTill);
                                countT += colCount;
                                lengthT += colLength;
                            }
                            String anz = "anz" + i;
                            String laenge = "laenge" + i;
                            feature.put(anz, countT);
                            feature.put(laenge, lengthT);
                        }
                    }
                    features.add(feature);
                    featuresKum.add(feature);
                    featuresKumDim.add(feature);
                }
                features.add(this.createKumFeature(featuresKumDim, true));
            }
            features.add(this.createKumFeature(featuresKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuDataSource() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getAttr2());
            for (String gu : this.getGu(gem)) {
                double colLength;
                double colCount;
                String lab;
                String anz;
                Integer till;
                Integer from;
                int i;
                List<Object> l;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double count = 0.0;
                double length = 0.0;
                feature.put("anzGu", this.getGu(gem).size());
                feature.put("gu", gu);
                feature.put("guName", gu);
                feature.put("group", String.valueOf(gem));
                feature.put("gmdNr", gem);
                feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                feature.put("arten", art);
                feature.put("laenge", this.getLengthGew(gem, gu));
                if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                    for (i = 0; i < l.size(); ++i) {
                        from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        till = (Integer)l.get(i);
                        anz = "anz" + i;
                        String laenge = "laenge" + i;
                        lab = "lab" + (i + 1);
                        colCount = this.getCountAllTf(gem, gu, from, till);
                        colLength = this.getLengthAllTf(gem, gu, from, till);
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
                    for (i = 0; i < l.size(); ++i) {
                        from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        till = (Integer)l.get(i);
                        anz = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        lab = "lab" + (i + 1);
                        colCount = this.getCountAllDim(gem, gu, from, till);
                        colLength = this.getLengthAllDim(gem, gu, from, till);
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                    l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                    for (i = 0; i < l.size(); ++i) {
                        String anz2 = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        String lab2 = "lab" + (i + 1);
                        double colCount2 = this.getCount(gem, gu, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                        double colLength2 = this.getLength(gem, gu, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                        count += colCount2;
                        length += colLength2;
                        feature.put(lab2, ((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))).name().toUpperCase());
                        feature.put(anz2, colCount2);
                        feature.put(laenge, colLength2);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                            this.parameters.put("ges", false);
                        }
                        first = false;
                    }
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                features.add(feature);
            }
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuDataSource1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("Gu " + this.gemDataMap.get(gem).getAttr2());
            for (int di = 0; di < d.size(); ++di) {
                ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
                for (String gu : this.getGu(gem)) {
                    int i;
                    List<Object> l;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                    Integer dimTill = d.get(di);
                    double count = 0.0;
                    double length = 0.0;
                    feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                    feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                    feature.put("anzGu", this.getGu(gem).size());
                    feature.put("group", String.valueOf(gem));
                    feature.put("gmdNr", gem);
                    feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                    feature.put("guName", gu);
                    feature.put("gu", gu);
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gem, gu));
                    if (!isTiefeArt && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                        l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            double colLength;
                            double colCount;
                            Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                            Integer till = (Integer)l.get(i);
                            String anz = "anz" + i;
                            String laenge = "laenge" + i;
                            String lab = "lab" + (i + 1);
                            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                                GerinneGeschlFlaechenReportDialog.Art arten = GerinneGeschlFlaechenReportDialog.getInstance().getArt().get(0);
                                colCount = this.getCountAllTfDim(gem, gu, arten, from, till, dimFrom, dimTill);
                                colLength = this.getLengthAllTfDim(gem, gu, arten, from, till, dimFrom, dimTill);
                            } else {
                                colCount = this.getCountAllTfDim(gem, gu, from, till, dimFrom, dimTill);
                                colLength = this.getLengthAllTfDim(gem, gu, from, till, dimFrom, dimTill);
                            }
                            count += colCount;
                            length += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                        l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                        for (i = 0; i < l.size(); ++i) {
                            double colLength;
                            double colCount;
                            String anz = "anz" + (i + 1);
                            String laenge = "laenge" + (i + 1);
                            String lab = "lab" + (i + 1);
                            if (isTiefeArt) {
                                colCount = this.getCountTf(gem, gu, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                colLength = this.getLengthTf(gem, gu, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            } else {
                                colCount = this.getCountDim(gem, gu, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                colLength = this.getLengthDim(gem, gu, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            }
                            count += colCount;
                            length += colLength;
                            feature.put(lab, ((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))).name().toUpperCase());
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                                this.parameters.put("ges", false);
                            }
                            first = false;
                        }
                    }
                    feature.put("anzGes", count);
                    feature.put("laengeGes", length);
                    features.add(feature);
                    featuresKum.add(feature);
                    featuresKumDim.add(feature);
                }
                features.add(this.createKumFeature(featuresKumDim, true));
            }
            features.add(this.createKumFeature(featuresKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuDataSource2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getAttr2());
            for (int di = 0; di < GerinneGeschlFlaechenReportDialog.getInstance().getDimensions().size(); ++di) {
                ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
                List<Integer> d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
                for (String gu : this.getGu(gem)) {
                    Integer till;
                    Integer from;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                    Integer dimTill = d.get(di);
                    double count = 0.0;
                    double length = 0.0;
                    feature.put("anzGew", this.getGew(gem).size());
                    feature.put("group", String.valueOf(gem));
                    feature.put("gmdNr", gem);
                    feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                    feature.put("guName", gu);
                    feature.put("gu", gu);
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gem, gu));
                    feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                    for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                        double countA = 0.0;
                        double lengthA = 0.0;
                        if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                            int i;
                            List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                            for (i = 0; i < l.size(); ++i) {
                                from = i > 0 ? l.get(i - 1) : new Integer(0);
                                till = l.get(i);
                                String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                                String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                                String lab = "lab" + (i + 1);
                                double colCount = this.getCountAllTfDim(gem, gu, a, from, till, dimFrom, dimTill);
                                double colLength = this.getLengthAllTfDim(gem, gu, a, from, till, dimFrom, dimTill);
                                count += colCount;
                                length += colLength;
                                countA += colCount;
                                lengthA += colLength;
                                feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                                feature.put(anz, colCount);
                                feature.put(laenge, colLength);
                            }
                            if (first) {
                                for (i = 0; i < l.size(); ++i) {
                                    this.parameters.put("spalte" + (i + 1), true);
                                }
                                first = false;
                            }
                        }
                        feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                        feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                    }
                    feature.put("anzGes", count);
                    feature.put("laengeGes", length);
                    if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                        List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                        double countT = 0.0;
                        double lengthT = 0.0;
                        for (int i = 0; i < l.size(); ++i) {
                            for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                                from = i > 0 ? l.get(i - 1) : new Integer(0);
                                till = l.get(i);
                                double colCount = this.getCountAllTfDim(gem, gu, a, from, till, dimFrom, dimTill);
                                double colLength = this.getLengthAllTfDim(gem, gu, a, from, till, dimFrom, dimTill);
                                countT += colCount;
                                lengthT += colLength;
                            }
                            String anz = "anz" + i;
                            String laenge = "laenge" + i;
                            feature.put(anz, countT);
                            feature.put(laenge, lengthT);
                        }
                    }
                    features.add(feature);
                    featuresKum.add(feature);
                    featuresKumDim.add(feature);
                }
                features.add(this.createKumFeature(featuresKumDim, true));
            }
            features.add(this.createKumFeature(featuresKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWdmDataSource() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getAttr2());
            for (String gu : this.getGu(gem)) {
                ArrayList<Map<String, Object>> subGroupFeatures = new ArrayList<Map<String, Object>>();
                for (Integer wdm : this.getWdm(gem, gu)) {
                    double colLength;
                    double colCount;
                    String lab;
                    String anz;
                    Integer till;
                    Integer from;
                    int i;
                    List<Object> l;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    double count = 0.0;
                    double length = 0.0;
                    feature.put("wdm", wdm);
                    feature.put("anzGu", this.getGu(gem).size());
                    feature.put("gu", gu);
                    feature.put("guName", gu);
                    feature.put("group", String.valueOf(gem));
                    feature.put("gmdNr", gem);
                    feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gem, gu, wdm));
                    if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                        l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                            till = (Integer)l.get(i);
                            anz = "anz" + i;
                            String laenge = "laenge" + i;
                            lab = "lab" + (i + 1);
                            colCount = this.getCountAllTf(gem, gu, wdm, from, till);
                            colLength = this.getLengthAllTf(gem, gu, wdm, from, till);
                            count += colCount;
                            length += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    } else if (GerinneGeschlFlaechenReportDialog.getInstance().getDimensions() != null) {
                        l = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
                        for (i = 0; i < l.size(); ++i) {
                            from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                            till = (Integer)l.get(i);
                            anz = "anz" + (i + 1);
                            String laenge = "laenge" + (i + 1);
                            lab = "lab" + (i + 1);
                            colCount = this.getCountAllDim(gem, gu, wdm, from, till);
                            colLength = this.getLengthAllDim(gem, gu, wdm, from, till);
                            count += colCount;
                            length += colLength;
                            feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                        l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                        for (i = 0; i < l.size(); ++i) {
                            String anz2 = "anz" + (i + 1);
                            String laenge = "laenge" + (i + 1);
                            String lab2 = "lab" + (i + 1);
                            double colCount2 = this.getCount(gem, gu, wdm, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                            double colLength2 = this.getLength(gem, gu, wdm, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)));
                            count += colCount2;
                            length += colLength2;
                            feature.put(lab2, ((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))).name().toUpperCase());
                            feature.put(anz2, colCount2);
                            feature.put(laenge, colLength2);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                                this.parameters.put("ges", false);
                            }
                            first = false;
                        }
                    }
                    feature.put("anzGes", count);
                    feature.put("laengeGes", length);
                    subGroupFeatures.add(feature);
                    features.add(feature);
                }
                features.add(this.createKumFeature(subGroupFeatures, true));
            }
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWdmDataSource1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("Gu " + this.gemDataMap.get(gem).getAttr2());
            for (int di = 0; di < d.size(); ++di) {
                ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
                for (String gu : this.getGu(gem)) {
                    ArrayList<Map<String, Object>> subGroupFeatures = new ArrayList<Map<String, Object>>();
                    for (Integer wdm : this.getWdm(gem, gu)) {
                        int i;
                        List<Object> l;
                        HashMap<String, Object> feature = new HashMap<String, Object>();
                        Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                        Integer dimTill = d.get(di);
                        double count = 0.0;
                        double length = 0.0;
                        feature.put("wdm", wdm);
                        feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                        feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                        feature.put("anzGu", this.getGu(gem).size());
                        feature.put("group", String.valueOf(gem));
                        feature.put("gmdNr", gem);
                        feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                        feature.put("guName", gu);
                        feature.put("gu", gu);
                        feature.put("arten", art);
                        feature.put("laenge", this.getLengthGew(gem, gu, wdm));
                        if (!isTiefeArt && GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                            l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                            for (i = 0; i < l.size(); ++i) {
                                double colLength;
                                double colCount;
                                Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                                Integer till = (Integer)l.get(i);
                                String anz = "anz" + i;
                                String laenge = "laenge" + i;
                                String lab = "lab" + (i + 1);
                                if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null && GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                                    GerinneGeschlFlaechenReportDialog.Art arten = GerinneGeschlFlaechenReportDialog.getInstance().getArt().get(0);
                                    colCount = this.getCountAllTfDim(gem, gu, wdm, arten, from, till, dimFrom, dimTill);
                                    colLength = this.getLengthAllTfDim(gem, gu, wdm, arten, from, till, dimFrom, dimTill);
                                } else {
                                    colCount = this.getCountAllTfDim(gem, gu, wdm, from, till, dimFrom, dimTill);
                                    colLength = this.getLengthAllTfDim(gem, gu, wdm, from, till, dimFrom, dimTill);
                                }
                                count += colCount;
                                length += colLength;
                                feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                                feature.put(anz, colCount);
                                feature.put(laenge, colLength);
                            }
                            if (first) {
                                for (i = 0; i < l.size(); ++i) {
                                    this.parameters.put("spalte" + (i + 1), true);
                                }
                                first = false;
                            }
                        } else if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() != null) {
                            l = GerinneGeschlFlaechenReportDialog.getInstance().getArt();
                            for (i = 0; i < l.size(); ++i) {
                                double colLength;
                                double colCount;
                                String anz = "anz" + (i + 1);
                                String laenge = "laenge" + (i + 1);
                                String lab = "lab" + (i + 1);
                                if (isTiefeArt) {
                                    colCount = this.getCountTf(gem, gu, wdm, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                    colLength = this.getLengthTf(gem, gu, wdm, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                } else {
                                    colCount = this.getCountDim(gem, gu, wdm, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                    colLength = this.getLengthDim(gem, gu, wdm, (GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                }
                                count += colCount;
                                length += colLength;
                                feature.put(lab, ((GerinneGeschlFlaechenReportDialog.Art)((Object)l.get(i))).name().toUpperCase());
                                feature.put(anz, colCount);
                                feature.put(laenge, colLength);
                            }
                            if (first) {
                                for (i = 0; i < l.size(); ++i) {
                                    this.parameters.put("spalte" + (i + 1), true);
                                }
                                if (GerinneGeschlFlaechenReportDialog.getInstance().getArt().size() == 1) {
                                    this.parameters.put("ges", false);
                                }
                                first = false;
                            }
                        }
                        feature.put("anzGes", count);
                        feature.put("laengeGes", length);
                        features.add(feature);
                        subGroupFeatures.add(feature);
                        featuresKum.add(feature);
                        featuresKumDim.add(feature);
                    }
                    features.add(this.createKumFeature(subGroupFeatures, true));
                }
                features.add(this.createKumFeature(featuresKumDim, true));
            }
            features.add(this.createKumFeature(featuresKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWdmDataSource2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getAttr2());
            for (int di = 0; di < GerinneGeschlFlaechenReportDialog.getInstance().getDimensions().size(); ++di) {
                ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
                List<Integer> d = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
                for (String gu : this.getGu(gem)) {
                    ArrayList<Map<String, Object>> subGroupFeatures = new ArrayList<Map<String, Object>>();
                    for (Integer wdm : this.getWdm(gem, gu)) {
                        Integer till;
                        Integer from;
                        HashMap<String, Object> feature = new HashMap<String, Object>();
                        Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                        Integer dimTill = d.get(di);
                        double count = 0.0;
                        double length = 0.0;
                        feature.put("wdm", wdm);
                        feature.put("anzGew", this.getGew(gem).size());
                        feature.put("group", String.valueOf(gem));
                        feature.put("gmdNr", gem);
                        feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                        feature.put("guName", gu);
                        feature.put("gu", gu);
                        feature.put("arten", art);
                        feature.put("laenge", this.getLengthGew(gem, gu, wdm));
                        feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                        for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                            double countA = 0.0;
                            double lengthA = 0.0;
                            if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                                int i;
                                List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                                for (i = 0; i < l.size(); ++i) {
                                    from = i > 0 ? l.get(i - 1) : new Integer(0);
                                    till = l.get(i);
                                    String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                                    String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                                    String lab = "lab" + (i + 1);
                                    double colCount = this.getCountAllTfDim(gem, gu, wdm, a, from, till, dimFrom, dimTill);
                                    double colLength = this.getLengthAllTfDim(gem, gu, wdm, a, from, till, dimFrom, dimTill);
                                    count += colCount;
                                    length += colLength;
                                    countA += colCount;
                                    lengthA += colLength;
                                    feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                                    feature.put(anz, colCount);
                                    feature.put(laenge, colLength);
                                }
                                if (first) {
                                    for (i = 0; i < l.size(); ++i) {
                                        this.parameters.put("spalte" + (i + 1), true);
                                    }
                                    first = false;
                                }
                            }
                            feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                            feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                        }
                        feature.put("anzGes", count);
                        feature.put("laengeGes", length);
                        if (GerinneGeschlFlaechenReportDialog.getInstance().getClasses() != null) {
                            List<Integer> l = GerinneGeschlFlaechenReportDialog.getInstance().getClasses();
                            double countT = 0.0;
                            double lengthT = 0.0;
                            for (int i = 0; i < l.size(); ++i) {
                                for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                                    from = i > 0 ? l.get(i - 1) : new Integer(0);
                                    till = l.get(i);
                                    double colCount = this.getCountAllTfDim(gem, gu, wdm, a, from, till, dimFrom, dimTill);
                                    double colLength = this.getLengthAllTfDim(gem, gu, wdm, a, from, till, dimFrom, dimTill);
                                    countT += colCount;
                                    lengthT += colLength;
                                }
                                String anz = "anz" + i;
                                String laenge = "laenge" + i;
                                feature.put(anz, countT);
                                feature.put(laenge, lengthT);
                            }
                        }
                        features.add(feature);
                        subGroupFeatures.add(feature);
                        featuresKum.add(feature);
                        featuresKumDim.add(feature);
                    }
                    features.add(this.createKumFeature(subGroupFeatures, true));
                }
                features.add(this.createKumFeature(featuresKumDim, true));
            }
            features.add(this.createKumFeature(featuresKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getObjects() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (Object gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("Objekte " + this.gemDataMap.get(gem).getAttr2());
            for (Integer gew : this.getGew(gem)) {
                for (GmdPartObjGeschl obj : this.getObjects(gem, gew)) {
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    feature.put("group", String.valueOf(gem));
                    feature.put("gmdNr", gem);
                    feature.put("gmdName", this.gemDataMap.get(gem).getAttr2());
                    feature.put("gewName", this.getGewName(gem, gew));
                    feature.put("code", this.getBaCd(gem, gew));
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gem, (int)gew));
                    feature.put("von", this.convertStation(obj.getFrom()));
                    feature.put("bis", this.convertStation(obj.getTill()));
                    feature.put("anzahlObj", this.getObjects(gem, gew).size());
                    feature.put("tf", this.getTf(obj.getTf()));
                    feature.put("dim", this.getDim(obj.getDim()));
                    feature.put("ls", obj.getLs());
                    feature.put("prof", obj.getProf());
                    feature.put("ma", obj.getMa());
                    feature.put("objNr", obj.getObjNr());
                    feature.put("tr", obj.getTr());
                    feature.put("ausbaujahr", obj.getAusbaujahr());
                    feature.put("wbbl", obj.getWbbl());
                    feature.put("art", obj.getArt());
                    feature.put("laengeObj", obj.getLength());
                    feature.put("faktor", obj.getLs());
                    feature.put("zustKl", obj.getLs());
                    feature.put("br", obj.getLs());
                    feature.put("brOben", obj.getBrOben());
                    feature.put("hoehe", obj.getHoehe());
                    feature.put("hEin", obj.gethEin());
                    feature.put("hAus", obj.gethAus());
                    feature.put("gefaelle", obj.getGefaelle());
                    feature.put("dhAus", obj.getDhAus());
                    feature.put("dhEin", obj.getDhEin());
                    feature.put("hAb", obj.gethAb());
                    feature.put("hAuf", obj.gethAuf());
                    feature.put("aufstieg", obj.getAufstieg());
                    features.add(feature);
                }
            }
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    protected Integer getDim(Double d) {
        List<Integer> dims = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
        int lastDim = 0;
        if (dims == null || d == null) {
            return this.toInteger(d);
        }
        for (Integer tmp : dims) {
            if (tmp == null) continue;
            if (d > (double)tmp.intValue()) {
                return lastDim;
            }
            lastDim = tmp;
        }
        return this.toInteger(d);
    }

    protected Integer getTf(Double tf) {
        List<Integer> tfs = GerinneGeschlFlaechenReportDialog.getInstance().getDimensions();
        int lastTf = 0;
        if (tfs == null || tf == null) {
            return this.toInteger(tf);
        }
        for (int tmp : tfs) {
            if (tf > (double)tmp) {
                return lastTf;
            }
            lastTf = tmp;
        }
        return this.toInteger(tf);
    }

    protected Integer toInteger(Double d) {
        if (d == null) {
            return null;
        }
        return d.intValue();
    }

    protected Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        kumFeature.put("summe", Boolean.TRUE);
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : firstElement.keySet()) {
            Object value = firstElement.get(key);
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Double)f.get(key)).doubleValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            kumFeature.put(key, value);
        }
        return kumFeature;
    }

    protected String getArtPrefix(GerinneGeschlFlaechenReportDialog.Art art) {
        char firstCharacter = Character.toUpperCase(art.name().charAt(0));
        String prefix = art.name().length() > 1 ? firstCharacter + art.name().substring(1) : String.valueOf(firstCharacter);
        return prefix;
    }

    protected String createArtString() {
        String art;
        if (GerinneGeschlFlaechenReportDialog.getInstance().getArt() == null) {
            art = "RL / D / Due";
        } else {
            art = null;
            for (GerinneGeschlFlaechenReportDialog.Art a : GerinneGeschlFlaechenReportDialog.getInstance().getArt()) {
                if (art == null) {
                    art = a.name();
                    continue;
                }
                art = art + " / " + a.name();
            }
        }
        return art;
    }

    private Collection<Integer> getGew(Object gemNr) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjGeschl tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private Collection<GmdPartObjGeschl> getObjects(Object gemNr, int gew) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        TreeSet<GmdPartObjGeschl> ts = new TreeSet<GmdPartObjGeschl>();
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew) continue;
            ts.add(tmp);
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu(Object gemNr) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObjGeschl tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private Collection<Integer> getWdm(Object gemNr, String gu) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ts.add(tmp.getWidmung());
        }
        return ts.descendingSet();
    }

    protected boolean valueBetween(Double value, Integer from, Integer till) {
        if (value == null && till == null) {
            return true;
        }
        if (value == null || till == null) {
            return false;
        }
        Integer fromConvert = from == null ? 0 : from;
        return value > (double)fromConvert.intValue() && value <= (double)till.intValue();
    }

    private double getCountAllDim(Object gemNr, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(Object gemNr, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(Object gemNr, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(Object gemNr, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(Object gemNr, int gew, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(Object gemNr, int gew, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(Object gemNr, String gu, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(Object gemNr, String gu, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(Object gemNr, String gu, Integer wdm, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(Object gemNr, String gu, Integer wdm, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getWidmung().equals(wdm) || !tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getWidmung().equals(wdm) || !tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(Object gemNr, int gew, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(Object gemNr, int gew, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(Object gemNr, String gu, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(Object gemNr, String gu, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(Object gemNr, String gu, Integer wdm, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(Object gemNr, String gu, Integer wdm, Integer from, Integer till) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, int gew, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, int gew, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, String gu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, String gu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, String gu, Integer wdm, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, String gu, Integer wdm, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, int gew, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, String gu, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(Object gemNr, String gu, Integer wdm, GerinneGeschlFlaechenReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (Object gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObjGeschl tmp : gemList) {
                ts.add(tmp.getOwner());
            }
        }
        return ts.size();
    }

    private String getBaCd(Object gemNr, int gew) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(Object gemNr, int gew) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private int getCountGewAll(Object gemNr) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObjGeschl tmp : gemList) {
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    private double getLengthGewAll(Object gemNr) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(Object gemNr, int gewId) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(Object gemNr, String gu) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm) {
        double length = 0.0;
        for (Object gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObjGeschl tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGew(Object gemNr, String gu) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    private int getCountGew(String gu, int wdm) {
        int count = 0;
        for (Object gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObjGeschl tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGew(Object gemNr, String gu, int wdm) {
        List<GmdPartObjGeschl> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    protected String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    protected String toColumnName(GerinneGeschlFlaechenReportDialog.Art a) {
        if (a.equals((Object)GerinneGeschlFlaechenReportDialog.Art.d)) {
            return "D";
        }
        if (a.equals((Object)GerinneGeschlFlaechenReportDialog.Art.due)) {
            return "Due";
        }
        if (a.equals((Object)GerinneGeschlFlaechenReportDialog.Art.rl)) {
            return "RL";
        }
        return a.name();
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

