/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewOffenByGeom;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.GerinneOFlaechenReportDialog;
import de.cismet.watergis.reports.GerOffenFlHelper;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.Flaeche;
import de.cismet.watergis.reports.types.GewFlObj;
import de.cismet.watergis.reports.types.GmdPartObjOffen;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.apache.log4j.Logger;

public class GerinneOFlaecheReport {
    private static final Logger LOG = Logger.getLogger(GerinneOFlaecheReport.class);
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "group", "gmdName", "code", "anzahlGu", "gu"};
    private static final int PROFSTAT = 1;
    private final Map<Object, List<GmdPartObjOffen>> gemPartMap = new HashMap<Object, List<GmdPartObjOffen>>();
    private final Map<Object, Flaeche> gemDataMap = new HashMap<Object, Flaeche>();
    private final List<String> sheetNames = new ArrayList<String>();
    private GerOffenFlHelper helper;

    public File createFlaechenReport(Flaeche[] fl, int[] gew) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("klasse", GerinneOFlaechenReportDialog.getInstance().getFlaechenService().getName());
        parameters.put("attr1", GerinneOFlaechenReportDialog.getInstance().getAttr1());
        parameters.put("attr2", GerinneOFlaechenReportDialog.getInstance().getAttr2());
        parameters.put("datum", df.format(new Date()));
        parameters.put("perGew", GerinneOFlaechenReportDialog.getInstance().isPerGew());
        parameters.put("perAbschn", GerinneOFlaechenReportDialog.getInstance().isPerPart());
        parameters.put("sumGu", GerinneOFlaechenReportDialog.getInstance().isSumGu());
        parameters.put("wdm", GerinneOFlaechenReportDialog.getInstance().isPerWdm());
        parameters.put("perAbschnProf", GerinneOFlaechenReportDialog.getInstance().isPerPartProf());
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GerinneOFlaecheReport.class.getResourceAsStream("/de/cismet/watergis/reports/GerinneOffenGem.jasper"));
        this.init(fl, gew);
        this.helper = new GerOffenFlHelper(fl, gew, this.getAllowedWdms());
        dataSources.put("gemeinden", this.getGemeindenAll());
        if (GerinneOFlaechenReportDialog.getInstance().isPerGew() && !GerinneOFlaechenReportDialog.getInstance().isPerPart() && !GerinneOFlaechenReportDialog.getInstance().isPerPartProf()) {
            dataSources.put("gewaesser", this.getGewaesser());
        } else if (GerinneOFlaechenReportDialog.getInstance().isPerPartProf()) {
            dataSources.put("gewaesserAbschnittProf", this.getGewaesserAbschnittProfil());
        } else if (GerinneOFlaechenReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesserAbschnitt", this.getGewaesserAbschnitt());
        }
        if (GerinneOFlaechenReportDialog.getInstance().isSumGu()) {
            if (GerinneOFlaechenReportDialog.getInstance().isPerWdm()) {
                dataSources.put("gewaesserGuAbschnitt", this.getGewaesserGuWidmung());
            } else {
                dataSources.put("gewaesserGu", this.getGewaesserGu());
            }
        }
        File file = new File(GerinneOFlaechenReportDialog.getInstance().getPath() + "/Gerinne_offen_Fl\u00e4chen.xlsx");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        GerinneOFlaecheReport report = new GerinneOFlaecheReport();
    }

    private void init(Flaeche[] fls, int[] routeIds) throws Exception {
        for (Flaeche fl : fls) {
            this.gemPartMap.put(fl.getAttr1(), this.getAllRoutes(fl, routeIds));
            Integer[] idList = this.getGew(fl.getAttr1()).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length == 0) {
                routes = null;
            }
            this.gemDataMap.put(fl.getAttr1(), fl);
        }
    }

    private List<GmdPartObjOffen> getAllRoutes(Flaeche fl, int[] routeIds) throws Exception {
        AllGewOffenByGeom search = new AllGewOffenByGeom(routeIds, this.getAllowedWdms(), fl.getGeom());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GmdPartObjOffen> objList = new ArrayList<GmdPartObjOffen>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GmdPartObjOffen((Integer)f.get(0), (String)f.get(1), (String)f.get(2), (Integer)f.get(3), (String)f.get(4), (String)f.get(5), (Double)f.get(6), (Double)f.get(7), (Integer)f.get(8), (Integer)f.get(9), (String)f.get(10), (Double)f.get(11), (Double)f.get(12), (Double)f.get(13), (Double)f.get(14), (Double)f.get(15), (Double)f.get(16), (Double)f.get(17), (Double)f.get(18), (Double)f.get(19), (Double)f.get(20), (Double)f.get(21), (Double)f.get(22), (String)f.get(23), (Double)f.get(24), (Double)f.get(25), (String)f.get(26), (Double)f.get(27), (Double)f.get(28), (Double)f.get(29), (Double)f.get(30), (String)f.get(31), (Double)f.get(32), (Integer)f.get(33), (Double)f.get(34), (Double)f.get(35), (Double)f.get(36), (Double)f.get(37), (Double)f.get(38), (Double)f.get(39), (Double)f.get(40), (Double)f.get(41), (Double)f.get(42), (Double)f.get(43), (Double)f.get(44), (Double)f.get(45), (Double)f.get(46), (Double)f.get(47), (Double)f.get(48), (String)f.get(49)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (GerinneOFlaechenReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (GerinneOFlaechenReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (GerinneOFlaechenReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (GerinneOFlaechenReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (GerinneOFlaechenReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGemeindenAll() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        for (Object flAttr : this.gemDataMap.keySet()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double offenLength = this.helper.getLengthOffeneAbschn(flAttr);
            double prof = this.getLengthGew(flAttr);
            double mw = this.getLengthMw(flAttr);
            double gewAll = this.helper.getLengthGewAll(flAttr);
            feature.put("name", this.gemDataMap.get(flAttr).getAttr2());
            feature.put("nummer", flAttr);
            feature.put("gew_a", this.helper.getCountGewAll(flAttr));
            feature.put("gew_l", this.helper.getLengthGewAll(flAttr));
            feature.put("offene_l", offenLength);
            feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
            feature.put("prof_l", prof);
            feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
            feature.put("mw_l", mw);
            feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
            feature.put("profTrap_a", this.getCountProf("tr", flAttr));
            feature.put("profTrap_l", this.getLengthProf("tr", flAttr));
            feature.put("profRe_a", this.getCountProf("re", flAttr));
            feature.put("profRe_l", this.getLengthProf("re", flAttr));
            feature.put("brSohleMin", this.getMinMax("brSo", flAttr, true));
            feature.put("brSohleMit", this.getMit("brSo", flAttr));
            feature.put("brSohleMax", this.getMinMax("brSo", flAttr, false));
            feature.put("bvReMin", this.getMinMax("bvRe", flAttr, true));
            feature.put("bvReMit", this.getMit("bvRe", flAttr));
            feature.put("bvReMax", this.getMinMax("bvRe", flAttr, false));
            feature.put("bhReMin", this.getMinMax("bhRe", flAttr, true));
            feature.put("bhReMit", this.getMit("bhRe", flAttr));
            feature.put("bhReMax", this.getMinMax("bhRe", flAttr, false));
            feature.put("blReMin", this.getMinMax("blRe", flAttr, true));
            feature.put("blReMit", this.getMit("blRe", flAttr));
            feature.put("blReMax", this.getMinMax("blRe", flAttr, false));
            feature.put("bvLiMin", this.getMinMax("bvLi", flAttr, true));
            feature.put("bvLiMit", this.getMit("bvLi", flAttr));
            feature.put("bvLiMax", this.getMinMax("bvLi", flAttr, false));
            feature.put("bhLiMin", this.getMinMax("bhLi", flAttr, true));
            feature.put("bhLiMit", this.getMit("bhLi", flAttr));
            feature.put("bhLiMax", this.getMinMax("bhLi", flAttr, false));
            feature.put("blLiMin", this.getMinMax("blLi", flAttr, true));
            feature.put("blLiMit", this.getMit("blLi", flAttr));
            feature.put("blLiMax", this.getMinMax("blLi", flAttr, false));
            feature.put("flSohle", this.getSum("flSo", flAttr));
            feature.put("flBoeRe", this.getSum("flBRe", flAttr));
            feature.put("flBoeLi", this.getSum("flBLi", flAttr));
            feature.put("flBoe", this.getSum("flB", flAttr));
            feature.put("flGer", this.getSum("flGer", flAttr));
            feature.put("brGewMin", this.getMinMax("brGew", flAttr, true));
            feature.put("brGewMit", this.getMit("brGew", flAttr));
            feature.put("brGewMax", this.getMinMax("brGew", flAttr, false));
            feature.put("flGew", this.getSum("flGew", flAttr));
            feature.put("blNassReMin", this.getMinMax("blNRe", flAttr, true));
            feature.put("blNassReMit", this.getMit("blNRe", flAttr));
            feature.put("blNassReMax", this.getMinMax("blNRe", flAttr, false));
            feature.put("blTroReMin", this.getMinMax("blTRe", flAttr, true));
            feature.put("blTroReMit", this.getMit("blTRe", flAttr));
            feature.put("blTroReMax", this.getMinMax("blTRe", flAttr, false));
            feature.put("blNassLiMin", this.getMinMax("blNLi", flAttr, true));
            feature.put("blNassLiMit", this.getMit("blNLi", flAttr));
            feature.put("blNassLiMax", this.getMinMax("blNLi", flAttr, false));
            feature.put("blTroLiMin", this.getMinMax("blTLi", flAttr, true));
            feature.put("blTroLiMit", this.getMit("blTLi", flAttr));
            feature.put("blTroLiMax", this.getMinMax("blTLi", flAttr, false));
            feature.put("flBoeNassRe", this.getSum("flBnRe", flAttr));
            feature.put("flBoeTroRe", this.getSum("flBtRe", flAttr));
            feature.put("flBoeNassLi", this.getSum("flBnLi", flAttr));
            feature.put("flBoeTroLi", this.getSum("flBtLi", flAttr));
            feature.put("flBoeNass", this.getSum("flBn", flAttr));
            feature.put("flBoeTro", this.getSum("flBt", flAttr));
            feature.put("flNass", this.getSum("flN", flAttr));
            feature.put("summe", false);
            features.add(feature);
        }
        features.add(this.createKumFeature(features, false));
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object flAttr : this.gemDataMap.keySet()) {
            if (this.getGew(flAttr) == null || this.getGew(flAttr).isEmpty()) continue;
            this.sheetNames.add(String.valueOf(this.gemDataMap.get(flAttr).getAttr2()));
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (int gew : this.getGew(flAttr)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double offenLength = this.helper.getLengthOffeneAbschn(flAttr, gew);
                double prof = this.getLengthGew(flAttr, gew);
                double mw = this.getLengthMw(flAttr, gew);
                double gewAll = this.helper.getLengthGewAll(flAttr, gew);
                feature.put("name", this.getGewName(flAttr, gew));
                feature.put("code", this.getBaCd(flAttr, gew));
                feature.put("gew_l", this.helper.getLengthGewAll(flAttr, gew));
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", flAttr, gew));
                feature.put("profTrap_l", this.getLengthProf("tr", flAttr, gew));
                feature.put("profRe_a", this.getCountProf("re", flAttr, gew));
                feature.put("profRe_l", this.getLengthProf("re", flAttr, gew));
                feature.put("brSohleMin", this.getMinMax("brSo", flAttr, gew, true));
                feature.put("brSohleMit", this.getMit("brSo", flAttr, gew));
                feature.put("brSohleMax", this.getMinMax("brSo", flAttr, gew, false));
                feature.put("bvReMin", this.getMinMax("bvRe", flAttr, gew, true));
                feature.put("bvReMit", this.getMit("bvRe", flAttr, gew));
                feature.put("bvReMax", this.getMinMax("bvRe", flAttr, gew, false));
                feature.put("bhReMin", this.getMinMax("bhRe", flAttr, gew, true));
                feature.put("bhReMit", this.getMit("bhRe", flAttr, gew));
                feature.put("bhReMax", this.getMinMax("bhRe", flAttr, gew, false));
                feature.put("blReMin", this.getMinMax("blRe", flAttr, gew, true));
                feature.put("blReMit", this.getMit("blRe", flAttr, gew));
                feature.put("blReMax", this.getMinMax("blRe", flAttr, gew, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", flAttr, gew, true));
                feature.put("bvLiMit", this.getMit("bvLi", flAttr, gew));
                feature.put("bvLiMax", this.getMinMax("bvLi", flAttr, gew, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", flAttr, gew, true));
                feature.put("bhLiMit", this.getMit("bhLi", flAttr, gew));
                feature.put("bhLiMax", this.getMinMax("bhLi", flAttr, gew, false));
                feature.put("blLiMin", this.getMinMax("blLi", flAttr, gew, true));
                feature.put("blLiMit", this.getMit("blLi", flAttr, gew));
                feature.put("blLiMax", this.getMinMax("blLi", flAttr, gew, false));
                feature.put("flSohle", this.getSum("flSo", flAttr, gew));
                feature.put("flBoeRe", this.getSum("flBRe", flAttr, gew));
                feature.put("flBoeLi", this.getSum("flBLi", flAttr, gew));
                feature.put("flBoe", this.getSum("flB", flAttr, gew));
                feature.put("flGer", this.getSum("flGer", flAttr, gew));
                feature.put("brGewMin", this.getMinMax("brGew", flAttr, gew, true));
                feature.put("brGewMit", this.getMit("brGew", flAttr, gew));
                feature.put("brGewMax", this.getMinMax("brGew", flAttr, gew, false));
                feature.put("flGew", this.getSum("flGew", flAttr, gew));
                feature.put("blNassReMin", this.getMinMax("blNRe", flAttr, gew, true));
                feature.put("blNassReMit", this.getMit("blNRe", flAttr, gew));
                feature.put("blNassReMax", this.getMinMax("blNRe", flAttr, gew, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", flAttr, gew, true));
                feature.put("blTroReMit", this.getMit("blTRe", flAttr, gew));
                feature.put("blTroReMax", this.getMinMax("blTRe", flAttr, gew, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", flAttr, gew, true));
                feature.put("blNassLiMit", this.getMit("blNLi", flAttr, gew));
                feature.put("blNassLiMax", this.getMinMax("blNLi", flAttr, gew, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", flAttr, gew, true));
                feature.put("blTroLiMit", this.getMit("blTLi", flAttr, gew));
                feature.put("blTroLiMax", this.getMinMax("blTLi", flAttr, gew, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", flAttr, gew, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", flAttr, gew));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", flAttr, gew, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", flAttr, gew, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", flAttr, gew));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", flAttr, gew, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", flAttr, gew));
                feature.put("flBoeTroRe", this.getSum("flBtRe", flAttr, gew));
                feature.put("flBoeNassLi", this.getSum("flBnLi", flAttr, gew));
                feature.put("flBoeTroLi", this.getSum("flBtLi", flAttr, gew));
                feature.put("flBoeNass", this.getSum("flBn", flAttr, gew));
                feature.put("flBoeTro", this.getSum("flBt", flAttr, gew));
                feature.put("flNass", this.getSum("flN", flAttr, gew));
                feature.put("summe", false);
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnitt() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object flAttr : this.gemDataMap.keySet()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
            String code = null;
            if (this.helper.getGemPartMap().get(flAttr) == null || this.helper.getGemPartMap().get(flAttr).isEmpty()) continue;
            this.sheetNames.add(String.valueOf(this.gemDataMap.get(flAttr).getAttr2()));
            for (GewFlObj gew : this.helper.getGemPartMap().get(flAttr)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                int id = gew.getId();
                double from = gew.getFrom();
                double till = gew.getTill();
                double offenLength = this.helper.getLengthOffeneAbschn(flAttr, id, from, till);
                double prof = this.getLengthGew(flAttr, id, from, till);
                double mw = this.getLengthMw(flAttr, id, from, till);
                double gewAll = this.helper.getLengthGewAll(flAttr, id);
                feature.put("name", this.getGewName(flAttr, id));
                feature.put("code", this.getBaCd(flAttr, id));
                feature.put("gew_l", this.helper.getLengthGewAll(flAttr, id));
                feature.put("von", this.convertStation(from));
                feature.put("bis", this.convertStation(till));
                feature.put("laenge", gew.getLength());
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", flAttr, id, from, till));
                feature.put("profTrap_l", this.getLengthProf("tr", flAttr, id, from, till));
                feature.put("profRe_a", this.getCountProf("re", flAttr, id, from, till));
                feature.put("profRe_l", this.getLengthProf("re", flAttr, id, from, till));
                feature.put("brSohleMin", this.getMinMax("brSo", flAttr, id, from, till, true));
                feature.put("brSohleMit", this.getMit("brSo", flAttr, id, from, till));
                feature.put("brSohleMax", this.getMinMax("brSo", flAttr, id, from, till, false));
                feature.put("bvReMin", this.getMinMax("bvRe", flAttr, id, from, till, true));
                feature.put("bvReMit", this.getMit("bvRe", flAttr, id, from, till));
                feature.put("bvReMax", this.getMinMax("bvRe", flAttr, id, from, till, false));
                feature.put("bhReMin", this.getMinMax("bhRe", flAttr, id, from, till, true));
                feature.put("bhReMit", this.getMit("bhRe", flAttr, id, from, till));
                feature.put("bhReMax", this.getMinMax("bhRe", flAttr, id, from, till, false));
                feature.put("blReMin", this.getMinMax("blRe", flAttr, id, from, till, true));
                feature.put("blReMit", this.getMit("blRe", flAttr, id, from, till));
                feature.put("blReMax", this.getMinMax("blRe", flAttr, id, from, till, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", flAttr, id, from, till, true));
                feature.put("bvLiMit", this.getMit("bvLi", flAttr, id, from, till));
                feature.put("bvLiMax", this.getMinMax("bvLi", flAttr, id, from, till, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", flAttr, id, from, till, true));
                feature.put("bhLiMit", this.getMit("bhLi", flAttr, id, from, till));
                feature.put("bhLiMax", this.getMinMax("bhLi", flAttr, id, from, till, false));
                feature.put("blLiMin", this.getMinMax("blLi", flAttr, id, from, till, true));
                feature.put("blLiMit", this.getMit("blLi", flAttr, id, from, till));
                feature.put("blLiMax", this.getMinMax("blLi", flAttr, id, from, till, false));
                feature.put("flSohle", this.getSum("flSo", flAttr, id, from, till));
                feature.put("flBoeRe", this.getSum("flBRe", flAttr, id, from, till));
                feature.put("flBoeLi", this.getSum("flBLi", flAttr, id, from, till));
                feature.put("flBoe", this.getSum("flB", flAttr, id, from, till));
                feature.put("flGer", this.getSum("flGer", flAttr, id, from, till));
                feature.put("brGewMin", this.getMinMax("brGew", flAttr, id, from, till, true));
                feature.put("brGewMit", this.getMit("brGew", flAttr, id, from, till));
                feature.put("brGewMax", this.getMinMax("brGew", flAttr, id, from, till, false));
                feature.put("flGew", this.getSum("flGew", flAttr, id, from, till));
                feature.put("blNassReMin", this.getMinMax("blNRe", flAttr, id, from, till, true));
                feature.put("blNassReMit", this.getMit("blNRe", flAttr, id, from, till));
                feature.put("blNassReMax", this.getMinMax("blNRe", flAttr, id, from, till, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", flAttr, id, from, till, true));
                feature.put("blTroReMit", this.getMit("blTRe", flAttr, id, from, till));
                feature.put("blTroReMax", this.getMinMax("blTRe", flAttr, id, from, till, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", flAttr, id, from, till, true));
                feature.put("blNassLiMit", this.getMit("blNLi", flAttr, id, from, till));
                feature.put("blNassLiMax", this.getMinMax("blNLi", flAttr, id, from, till, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", flAttr, id, from, till, true));
                feature.put("blTroLiMit", this.getMit("blTLi", flAttr, id, from, till));
                feature.put("blTroLiMax", this.getMinMax("blTLi", flAttr, id, from, till, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", flAttr, id, from, till, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", flAttr, id, from, till));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", flAttr, id, from, till, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", flAttr, id, from, till, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", flAttr, id, from, till));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", flAttr, id, from, till, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", flAttr, id, from, till));
                feature.put("flBoeTroRe", this.getSum("flBtRe", flAttr, id, from, till));
                feature.put("flBoeNassLi", this.getSum("flBnLi", flAttr, id, from, till));
                feature.put("flBoeTroLi", this.getSum("flBtLi", flAttr, id, from, till));
                feature.put("flBoeNass", this.getSum("flBn", flAttr, id, from, till));
                feature.put("flBoeTro", this.getSum("flBt", flAttr, id, from, till));
                feature.put("flNass", this.getSum("flN", flAttr, id, from, till));
                feature.put("summe", false);
                String newCode = this.getBaCd(flAttr, gew.getId());
                if (code != null && !code.equals(newCode)) {
                    features.add(this.createKumFeature(featureListGewKum, true));
                    featureListGewKum.clear();
                }
                code = newCode;
                features.add(feature);
                featureListKum.add(feature);
                featureListGewKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnittProfil() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object flAttr : this.gemDataMap.keySet()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
            String code = null;
            if (this.gemPartMap.get(flAttr) == null || this.gemPartMap.get(flAttr).isEmpty()) continue;
            this.sheetNames.add(String.valueOf(this.gemDataMap.get(flAttr).getAttr2()));
            for (GmdPartObjOffen gew : this.gemPartMap.get(flAttr)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                int id = gew.getId();
                double from = gew.getBaStVon();
                double till = gew.getBaStBis();
                double offenLength = this.helper.getLengthOffeneAbschn(flAttr, id, from, till);
                double prof = this.getLengthGew(flAttr, id, from, till);
                double mw = this.getLengthMw(flAttr, id, from, till);
                double gewAll = this.helper.getLengthGewAll(flAttr, id);
                feature.put("group", String.valueOf(this.gemDataMap.get(flAttr).getAttr2()));
                feature.put("name", this.getGewName(flAttr, id));
                feature.put("code", this.getBaCd(flAttr, id));
                feature.put("gew_l", gewAll);
                feature.put("von", this.convertStation(from));
                feature.put("bis", this.convertStation(till));
                feature.put("laenge", gew.getLength());
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", flAttr, id, from, till));
                feature.put("profTrap_l", this.getLengthProf("tr", flAttr, id, from, till));
                feature.put("profRe_a", this.getCountProf("re", flAttr, id, from, till));
                feature.put("profRe_l", this.getLengthProf("re", flAttr, id, from, till));
                feature.put("brSohleMin", this.getMinMax("brSo", flAttr, id, from, till, true));
                feature.put("brSohleMit", this.getMit("brSo", flAttr, id, from, till));
                feature.put("brSohleMax", this.getMinMax("brSo", flAttr, id, from, till, false));
                feature.put("bvReMin", this.getMinMax("bvRe", flAttr, id, from, till, true));
                feature.put("bvReMit", this.getMit("bvRe", flAttr, id, from, till));
                feature.put("bvReMax", this.getMinMax("bvRe", flAttr, id, from, till, false));
                feature.put("bhReMin", this.getMinMax("bhRe", flAttr, id, from, till, true));
                feature.put("bhReMit", this.getMit("bhRe", flAttr, id, from, till));
                feature.put("bhReMax", this.getMinMax("bhRe", flAttr, id, from, till, false));
                feature.put("blReMin", this.getMinMax("blRe", flAttr, id, from, till, true));
                feature.put("blReMit", this.getMit("blRe", flAttr, id, from, till));
                feature.put("blReMax", this.getMinMax("blRe", flAttr, id, from, till, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", flAttr, id, from, till, true));
                feature.put("bvLiMit", this.getMit("bvLi", flAttr, id, from, till));
                feature.put("bvLiMax", this.getMinMax("bvLi", flAttr, id, from, till, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", flAttr, id, from, till, true));
                feature.put("bhLiMit", this.getMit("bhLi", flAttr, id, from, till));
                feature.put("bhLiMax", this.getMinMax("bhLi", flAttr, id, from, till, false));
                feature.put("blLiMin", this.getMinMax("blLi", flAttr, id, from, till, true));
                feature.put("blLiMit", this.getMit("blLi", flAttr, id, from, till));
                feature.put("blLiMax", this.getMinMax("blLi", flAttr, id, from, till, false));
                feature.put("flSohle", this.getSum("flSo", flAttr, id, from, till));
                feature.put("flBoeRe", this.getSum("flBRe", flAttr, id, from, till));
                feature.put("flBoeLi", this.getSum("flBLi", flAttr, id, from, till));
                feature.put("flBoe", this.getSum("flB", flAttr, id, from, till));
                feature.put("flGer", this.getSum("flGer", flAttr, id, from, till));
                feature.put("brGewMin", this.getMinMax("brGew", flAttr, id, from, till, true));
                feature.put("brGewMit", this.getMit("brGew", flAttr, id, from, till));
                feature.put("brGewMax", this.getMinMax("brGew", flAttr, id, from, till, false));
                feature.put("flGew", this.getSum("flGew", flAttr, id, from, till));
                feature.put("blNassReMin", this.getMinMax("blNRe", flAttr, id, from, till, true));
                feature.put("blNassReMit", this.getMit("blNRe", flAttr, id, from, till));
                feature.put("blNassReMax", this.getMinMax("blNRe", flAttr, id, from, till, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", flAttr, id, from, till, true));
                feature.put("blTroReMit", this.getMit("blTRe", flAttr, id, from, till));
                feature.put("blTroReMax", this.getMinMax("blTRe", flAttr, id, from, till, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", flAttr, id, from, till, true));
                feature.put("blNassLiMit", this.getMit("blNLi", flAttr, id, from, till));
                feature.put("blNassLiMax", this.getMinMax("blNLi", flAttr, id, from, till, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", flAttr, id, from, till, true));
                feature.put("blTroLiMit", this.getMit("blTLi", flAttr, id, from, till));
                feature.put("blTroLiMax", this.getMinMax("blTLi", flAttr, id, from, till, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", flAttr, id, from, till, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", flAttr, id, from, till));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", flAttr, id, from, till, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", flAttr, id, from, till, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", flAttr, id, from, till));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", flAttr, id, from, till, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", flAttr, id, from, till));
                feature.put("flBoeTroRe", this.getSum("flBtRe", flAttr, id, from, till));
                feature.put("flBoeNassLi", this.getSum("flBnLi", flAttr, id, from, till));
                feature.put("flBoeTroLi", this.getSum("flBtLi", flAttr, id, from, till));
                feature.put("flBoeNass", this.getSum("flBn", flAttr, id, from, till));
                feature.put("flBoeTro", this.getSum("flBt", flAttr, id, from, till));
                feature.put("flNass", this.getSum("flN", flAttr, id, from, till));
                feature.put("summe", false);
                String newCode = this.getBaCd(flAttr, gew.getId());
                if (code != null && !code.equals(newCode)) {
                    features.add(this.createKumFeature(featureListGewKum, true));
                    featureListGewKum.clear();
                }
                code = newCode;
                features.add(feature);
                featureListKum.add(feature);
                featureListGewKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false, 1));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGu() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object flAttr : this.gemDataMap.keySet()) {
            if (this.getGu(flAttr) == null || this.getGu(flAttr).isEmpty()) continue;
            this.sheetNames.add("GU " + String.valueOf(this.gemDataMap.get(flAttr).getAttr2()));
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(flAttr)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double offenLength = this.helper.getLengthOffeneAbschn(flAttr, guName);
                double prof = this.getLengthGew(flAttr, guName);
                double mw = this.getLengthMw(flAttr, guName);
                double gewAll = this.helper.getLengthGewAll(flAttr, guName);
                feature.put("group", String.valueOf(flAttr));
                feature.put("name", guName);
                feature.put("gu", this.getGuId(flAttr, guName));
                feature.put("gew_a", this.helper.getCountGewAll(flAttr, guName));
                feature.put("gew_l", this.helper.getLengthGewAll(flAttr, guName));
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", flAttr, guName));
                feature.put("profTrap_l", this.getLengthProf("tr", flAttr, guName));
                feature.put("profRe_a", this.getCountProf("re", flAttr, guName));
                feature.put("profRe_l", this.getLengthProf("re", flAttr, guName));
                feature.put("brSohleMin", this.getMinMax("brSo", flAttr, guName, true));
                feature.put("brSohleMit", this.getMit("brSo", flAttr, guName));
                feature.put("brSohleMax", this.getMinMax("brSo", flAttr, guName, false));
                feature.put("bvReMin", this.getMinMax("bvRe", flAttr, guName, true));
                feature.put("bvReMit", this.getMit("bvRe", flAttr, guName));
                feature.put("bvReMax", this.getMinMax("bvRe", flAttr, guName, false));
                feature.put("bhReMin", this.getMinMax("bhRe", flAttr, guName, true));
                feature.put("bhReMit", this.getMit("bhRe", flAttr, guName));
                feature.put("bhReMax", this.getMinMax("bhRe", flAttr, guName, false));
                feature.put("blReMin", this.getMinMax("blRe", flAttr, guName, true));
                feature.put("blReMit", this.getMit("blRe", flAttr, guName));
                feature.put("blReMax", this.getMinMax("blRe", flAttr, guName, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", flAttr, guName, true));
                feature.put("bvLiMit", this.getMit("bvLi", flAttr, guName));
                feature.put("bvLiMax", this.getMinMax("bvLi", flAttr, guName, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", flAttr, guName, true));
                feature.put("bhLiMit", this.getMit("bhLi", flAttr, guName));
                feature.put("bhLiMax", this.getMinMax("bhLi", flAttr, guName, false));
                feature.put("blLiMin", this.getMinMax("blLi", flAttr, guName, true));
                feature.put("blLiMit", this.getMit("blLi", flAttr, guName));
                feature.put("blLiMax", this.getMinMax("blLi", flAttr, guName, false));
                feature.put("flSohle", this.getSum("flSo", flAttr, guName));
                feature.put("flBoeRe", this.getSum("flBRe", flAttr, guName));
                feature.put("flBoeLi", this.getSum("flBLi", flAttr, guName));
                feature.put("flBoe", this.getSum("flB", flAttr, guName));
                feature.put("flGer", this.getSum("flGer", flAttr, guName));
                feature.put("brGewMin", this.getMinMax("brGew", flAttr, guName, true));
                feature.put("brGewMit", this.getMit("brGew", flAttr, guName));
                feature.put("brGewMax", this.getMinMax("brGew", flAttr, guName, false));
                feature.put("flGew", this.getSum("flGew", flAttr, guName));
                feature.put("blNassReMin", this.getMinMax("blNRe", flAttr, guName, true));
                feature.put("blNassReMit", this.getMit("blNRe", flAttr, guName));
                feature.put("blNassReMax", this.getMinMax("blNRe", flAttr, guName, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", flAttr, guName, true));
                feature.put("blTroReMit", this.getMit("blTRe", flAttr, guName));
                feature.put("blTroReMax", this.getMinMax("blTRe", flAttr, guName, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", flAttr, guName, true));
                feature.put("blNassLiMit", this.getMit("blNLi", flAttr, guName));
                feature.put("blNassLiMax", this.getMinMax("blNLi", flAttr, guName, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", flAttr, guName, true));
                feature.put("blTroLiMit", this.getMit("blTLi", flAttr, guName));
                feature.put("blTroLiMax", this.getMinMax("blTLi", flAttr, guName, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", flAttr, guName, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", flAttr, guName));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", flAttr, guName, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", flAttr, guName, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", flAttr, guName));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", flAttr, guName, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", flAttr, guName));
                feature.put("flBoeTroRe", this.getSum("flBtRe", flAttr, guName));
                feature.put("flBoeNassLi", this.getSum("flBnLi", flAttr, guName));
                feature.put("flBoeTroLi", this.getSum("flBtLi", flAttr, guName));
                feature.put("flBoeNass", this.getSum("flBn", flAttr, guName));
                feature.put("flBoeTro", this.getSum("flBt", flAttr, guName));
                feature.put("flNass", this.getSum("flN", flAttr, guName));
                feature.put("summe", false);
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object flAttr : this.gemDataMap.keySet()) {
            if (this.getGu(flAttr) == null || this.getGu(flAttr).isEmpty()) continue;
            this.sheetNames.add("GU " + String.valueOf(this.gemDataMap.get(flAttr).getAttr2()));
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(flAttr)) {
                ArrayList<Map<String, Object>> featureListGuKum = new ArrayList<Map<String, Object>>();
                for (Integer wdm : this.getWidmung(flAttr, guName)) {
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    double offenLength = this.helper.getLengthOffeneAbschn(flAttr, guName, wdm);
                    double prof = this.getLengthGew(flAttr, guName, wdm);
                    double mw = this.getLengthMw(flAttr, guName, wdm);
                    double gewAll = this.helper.getLengthGewAll(flAttr, guName, wdm);
                    feature.put("group", String.valueOf(flAttr));
                    feature.put("name", this.getGuId(flAttr, guName));
                    feature.put("gu", guName);
                    feature.put("wdm", wdm);
                    feature.put("gew_a", this.helper.getCountGewAll(flAttr, guName, wdm));
                    feature.put("gew_l", this.helper.getLengthGewAll(flAttr, guName, wdm));
                    feature.put("offene_l", offenLength);
                    feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                    feature.put("prof_l", prof);
                    feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : offenLength);
                    feature.put("mw_l", mw);
                    feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                    feature.put("profTrap_a", this.getCountProf("tr", flAttr, guName, wdm));
                    feature.put("profTrap_l", this.getLengthProf("tr", flAttr, guName, wdm));
                    feature.put("profRe_a", this.getCountProf("re", flAttr, guName, wdm));
                    feature.put("profRe_l", this.getLengthProf("re", flAttr, guName, wdm));
                    feature.put("brSohleMin", this.getMinMax("brSo", flAttr, guName, wdm, true));
                    feature.put("brSohleMit", this.getMit("brSo", flAttr, guName, wdm));
                    feature.put("brSohleMax", this.getMinMax("brSo", flAttr, guName, wdm, false));
                    feature.put("bvReMin", this.getMinMax("bvRe", flAttr, guName, wdm, true));
                    feature.put("bvReMit", this.getMit("bvRe", flAttr, guName, wdm));
                    feature.put("bvReMax", this.getMinMax("bvRe", flAttr, guName, wdm, false));
                    feature.put("bhReMin", this.getMinMax("bhRe", flAttr, guName, wdm, true));
                    feature.put("bhReMit", this.getMit("bhRe", flAttr, guName, wdm));
                    feature.put("bhReMax", this.getMinMax("bhRe", flAttr, guName, wdm, false));
                    feature.put("blReMin", this.getMinMax("blRe", flAttr, guName, wdm, true));
                    feature.put("blReMit", this.getMit("blRe", flAttr, guName, wdm));
                    feature.put("blReMax", this.getMinMax("blRe", flAttr, guName, wdm, false));
                    feature.put("bvLiMin", this.getMinMax("bvLi", flAttr, guName, wdm, true));
                    feature.put("bvLiMit", this.getMit("bvLi", flAttr, guName, wdm));
                    feature.put("bvLiMax", this.getMinMax("bvLi", flAttr, guName, wdm, false));
                    feature.put("bhLiMin", this.getMinMax("bhLi", flAttr, guName, wdm, true));
                    feature.put("bhLiMit", this.getMit("bhLi", flAttr, guName, wdm));
                    feature.put("bhLiMax", this.getMinMax("bhLi", flAttr, guName, wdm, false));
                    feature.put("blLiMin", this.getMinMax("blLi", flAttr, guName, wdm, true));
                    feature.put("blLiMit", this.getMit("blLi", flAttr, guName, wdm));
                    feature.put("blLiMax", this.getMinMax("blLi", flAttr, guName, wdm, false));
                    feature.put("flSohle", this.getSum("flSo", flAttr, guName, wdm));
                    feature.put("flBoeRe", this.getSum("flBRe", flAttr, guName, wdm));
                    feature.put("flBoeLi", this.getSum("flBLi", flAttr, guName, wdm));
                    feature.put("flBoe", this.getSum("flB", flAttr, guName, wdm));
                    feature.put("flGer", this.getSum("flGer", flAttr, guName, wdm));
                    feature.put("brGewMin", this.getMinMax("brGew", flAttr, guName, wdm, true));
                    feature.put("brGewMit", this.getMit("brGew", flAttr, guName, wdm));
                    feature.put("brGewMax", this.getMinMax("brGew", flAttr, guName, wdm, false));
                    feature.put("flGew", this.getSum("flGew", flAttr, guName, wdm));
                    feature.put("blNassReMin", this.getMinMax("blNRe", flAttr, guName, wdm, true));
                    feature.put("blNassReMit", this.getMit("blNRe", flAttr, guName, wdm));
                    feature.put("blNassReMax", this.getMinMax("blNRe", flAttr, guName, wdm, false));
                    feature.put("blTroReMin", this.getMinMax("blTRe", flAttr, guName, wdm, true));
                    feature.put("blTroReMit", this.getMit("blTRe", flAttr, guName, wdm));
                    feature.put("blTroReMax", this.getMinMax("blTRe", flAttr, guName, wdm, false));
                    feature.put("blNassLiMin", this.getMinMax("blNLi", flAttr, guName, wdm, true));
                    feature.put("blNassLiMit", this.getMit("blNLi", flAttr, guName, wdm));
                    feature.put("blNassLiMax", this.getMinMax("blNLi", flAttr, guName, wdm, false));
                    feature.put("blTroLiMin", this.getMinMax("blTLi", flAttr, guName, wdm, true));
                    feature.put("blTroLiMit", this.getMit("blTLi", flAttr, guName, wdm));
                    feature.put("blTroLiMax", this.getMinMax("blTLi", flAttr, guName, wdm, false));
                    feature.put("flQsGerMin", this.getMinMax("flQsGer", flAttr, guName, wdm, true));
                    feature.put("flQsGerMit", this.getMit("flQsGer", flAttr, guName, wdm));
                    feature.put("flQsGerMax", this.getMinMax("flQsGer", flAttr, guName, wdm, false));
                    feature.put("flQsGewMin", this.getMinMax("flQsGew", flAttr, guName, wdm, true));
                    feature.put("flQsGewMit", this.getMit("flQsGew", flAttr, guName, wdm));
                    feature.put("flQsGewMax", this.getMinMax("flQsGew", flAttr, guName, wdm, false));
                    feature.put("flBoeNassRe", this.getSum("flBnRe", flAttr, guName, wdm));
                    feature.put("flBoeTroRe", this.getSum("flBtRe", flAttr, guName, wdm));
                    feature.put("flBoeNassLi", this.getSum("flBnLi", flAttr, guName, wdm));
                    feature.put("flBoeTroLi", this.getSum("flBtLi", flAttr, guName, wdm));
                    feature.put("flBoeNass", this.getSum("flBn", flAttr, guName, wdm));
                    feature.put("flBoeTro", this.getSum("flBt", flAttr, guName, wdm));
                    feature.put("flNass", this.getSum("flN", flAttr, guName, wdm));
                    feature.put("summe", false);
                    features.add(feature);
                    featureListKum.add(feature);
                    featureListGuKum.add(feature);
                }
                features.add(this.createKumFeature(featureListGuKum, true));
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal) {
        return this.createKumFeature(featureListKum, subtotal, 0);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal, int stat) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        kumFeature.put("summe", Boolean.TRUE);
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : new ArrayList<String>(firstElement.keySet())) {
            double totalTmp;
            double specificTmp;
            Object value = firstElement.get(key);
            if (key.endsWith("offene_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = (Double)f.get("offene_l");
                    totalTmp = (Double)f.get("gew_l");
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("prof_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = (Double)f.get("prof_l");
                    totalTmp = (Double)f.get("offene_l");
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("group")) {
                kumFeature.put(key, value);
                continue;
            }
            if (key.endsWith("mw_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = (Double)f.get("mw_l");
                    totalTmp = (Double)f.get("prof_l");
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("Min") && value instanceof Double) {
                double min = (Double)value;
                for (Map<String, Object> f : featureListKum) {
                    double val = (Double)f.get(key);
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (!(val < min)) continue;
                    min = val;
                }
                kumFeature.put(key, min);
                continue;
            }
            if (key.endsWith("Max") && value instanceof Double) {
                double max = (Double)value;
                for (Map<String, Object> f : featureListKum) {
                    double val = (Double)f.get(key);
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
                kumFeature.put(key, max);
                continue;
            }
            if (key.endsWith("Mit") && value instanceof Double) {
                double mit = (Double)value;
                double length = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    double val = (Double)f.get(key);
                    double len = (Double)f.get("prof_l");
                    mit += val * len;
                    length += len;
                }
                kumFeature.put(key, mit / length);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Double)f.get(key)).doubleValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (value instanceof String || value instanceof Boolean || Arrays.binarySearch(exceptionalNumberFields, key) >= 0) continue;
            kumFeature.put(key, value);
        }
        return kumFeature;
    }

    private Collection<Integer> getGew(Object flNr) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjOffen tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu(Object flNr) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObjOffen tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private String getGuId(Object flNr, String owner) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        for (GmdPartObjOffen tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    private Collection<Integer> getWidmung(Object flNr, String guName) {
        List<GmdPartObjOffen> gmdList = this.gemPartMap.get(flNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjOffen gmdPart : gmdList) {
            if (!gmdPart.getOwner().equals(guName)) continue;
            ts.add(gmdPart.getWdm());
        }
        return ts.descendingSet();
    }

    private String getBaCd(Object flNr, int gew) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(Object flNr, int gew) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private double getLengthGew(Object flNr) {
        return this.getLengthGew(flNr, -1);
    }

    private double getLengthGew(Object flNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(Object flNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthMw(Object flNr) {
        return this.getLengthMw(flNr, -1);
    }

    private double getLengthMw(Object flNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(Object flNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(Object flNr, String gu, Integer wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(Object flNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, Object flNr) {
        return this.getLengthProf(prof, flNr, -1);
    }

    private double getLengthProf(String prof, Object flNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, Object flNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, Object flNr, String gu, Integer wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, Object flNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getMinMax(String field, Object flNr, boolean min) {
        return this.getMinMax(field, flNr, -1, min);
    }

    private double getMinMax(String field, Object flNr, int gewId, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (gewId != -1 && tmp.getId() != gewId || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, Object flNr, String gu, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, Object flNr, String gu, Integer wdm, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, Object flNr, int gewId, double from, double till, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMit(String field, Object flNr) {
        return this.getMit(field, flNr, -1);
    }

    private double getMit(String field, Object flNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (gewId != -1 && tmp.getId() != gewId || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, Object flNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, Object flNr, String gu, Integer wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, Object flNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLengthInGewPart(gewId, from, till);
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getSum(String field, Object flNr) {
        return this.getSum(field, flNr, -1);
    }

    private double getSum(String field, Object flNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, Object flNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, Object flNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, Object flNr, String gu, Integer wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    public int getCountProf(String prof, Object flNr) {
        return this.getCountProf(prof, flNr, -1);
    }

    public int getCountProf(String prof, Object flNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, Object flNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, Object flNr, String gu, Integer wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, Object flNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof) || !tmp.isInGewPart(gewId, from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGew(Object flNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(Object flNr, String gu, int wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWdm() != wdm) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

