/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewOffenByGem;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.GerinneOGewaesserReportDialog;
import de.cismet.watergis.reports.GerOffenHelper;
import de.cismet.watergis.reports.GerinneOGemeindeReport;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.GmdPartObjOffen;
import de.cismet.watergis.reports.types.KatasterGewObj;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.apache.log4j.Logger;

public class GerinneOGewaesserReport
extends GerinneOGemeindeReport {
    private static final Logger LOG = Logger.getLogger(GerinneOGewaesserReport.class);
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "gmdName", "code", "anzahlGu", "gu"};
    private static final int PROFSTAT = 1;
    private List<GmdPartObjOffen> objList;
    private final List<String> sheetNames = new ArrayList<String>();
    private GerOffenHelper helper;

    public File createGewaesserReport(int[] gew) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("datum", df.format(new Date()));
        parameters.put("sumGu", GerinneOGewaesserReportDialog.getInstance().isSumGu());
        parameters.put("wdm", GerinneOGewaesserReportDialog.getInstance().isPerWdm());
        parameters.put("perAbschn", GerinneOGewaesserReportDialog.getInstance().isPerPart());
        parameters.put("perAbschnProf", GerinneOGewaesserReportDialog.getInstance().isPerPartProf());
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GerinneOGewaesserReport.class.getResourceAsStream("/de/cismet/watergis/reports/GerinneOffenGew.jasper"));
        this.init(gew);
        this.helper = new GerOffenHelper(gew, this.getAllowedWdms());
        dataSources.put("gewaesser", this.getGewaesser());
        if (GerinneOGewaesserReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesserAbschnitt", this.getGewaesserAbschnitt());
        }
        if (GerinneOGewaesserReportDialog.getInstance().isPerPartProf()) {
            dataSources.put("gewaesserAbschnittProf", this.getGewaesserAbschnittProfil());
        }
        if (GerinneOGewaesserReportDialog.getInstance().isSumGu()) {
            if (GerinneOGewaesserReportDialog.getInstance().isPerWdm()) {
                dataSources.put("gewaesserGuAbschnitt", this.getGewaesserGuWidmung());
            } else {
                dataSources.put("gewaesserGu", this.getGewaesserGu());
            }
        }
        parameters.put("gewaesser", this.helper.getGew().size());
        parameters.put("offeneAbschnitte", this.helper.getAbschnitteOffen().size());
        parameters.put("profile", this.objList.size());
        File file = new File(GerinneOGewaesserReportDialog.getInstance().getPath() + "/Gerinne_offen_Gew\u00e4sser.xls");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsReportConfiguration config = new SimpleXlsReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        GerinneOGewaesserReport report = new GerinneOGewaesserReport();
        try {
            report.createGemeindeReport(new int[]{2}, new int[]{2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(int[] routeIds) throws Exception {
        this.objList = this.getAllRoutes(routeIds);
    }

    private List<GmdPartObjOffen> getAllRoutes(int[] routeIds) throws Exception {
        AllGewOffenByGem search = new AllGewOffenByGem(routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GmdPartObjOffen> objList = new ArrayList<GmdPartObjOffen>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GmdPartObjOffen((Integer)f.get(0), (String)f.get(1), (String)f.get(2), (Integer)f.get(3), (String)f.get(4), (String)f.get(5), (Double)f.get(6), (Double)f.get(7), (Integer)f.get(8), (Integer)f.get(9), (String)f.get(10), (Double)f.get(11), (Double)f.get(12), (Double)f.get(13), (Double)f.get(14), (Double)f.get(15), (Double)f.get(16), (Double)f.get(17), (Double)f.get(18), (Double)f.get(19), (Double)f.get(20), (Double)f.get(21), (Double)f.get(22), (String)f.get(23), (Double)f.get(24), (Double)f.get(25), (String)f.get(26), (Double)f.get(27), (Double)f.get(28), (Double)f.get(29), (Double)f.get(30), (String)f.get(31), (Double)f.get(32), (Integer)f.get(33), (Double)f.get(34), (Double)f.get(35), (Double)f.get(36), (Double)f.get(37), (Double)f.get(38), (Double)f.get(39), (Double)f.get(40), (Double)f.get(41), (Double)f.get(42), (Double)f.get(43), (Double)f.get(44), (Double)f.get(45), (Double)f.get(46), (Double)f.get(47), (Double)f.get(48), (String)f.get(49)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (GerinneOGewaesserReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (GerinneOGewaesserReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (GerinneOGewaesserReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (GerinneOGewaesserReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (GerinneOGewaesserReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gew\u00e4sser");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (int gew : this.helper.getGew()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double offenLength = this.helper.getLengthOffeneAbschn(gew);
            double prof = this.getLengthGew(gew);
            double mw = this.getLengthMw(gew);
            double gewAll = this.helper.getLengthGewAll(gew);
            feature.put("name", this.helper.getGewName(gew));
            feature.put("code", this.helper.getBaCd(gew));
            feature.put("gew_l", this.helper.getLengthGewAll(gew));
            feature.put("offene_l", offenLength);
            feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
            feature.put("prof_l", prof);
            feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
            feature.put("mw_l", mw);
            feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
            feature.put("profTrap_a", this.getCountProf("tr", gew));
            feature.put("profTrap_l", this.getLengthProf("tr", gew));
            feature.put("profRe_a", this.getCountProf("re", gew));
            feature.put("profRe_l", this.getLengthProf("re", gew));
            feature.put("brSohleMin", this.getMinMax("brSo", gew, true));
            feature.put("brSohleMit", this.getMit("brSo", gew));
            feature.put("brSohleMax", this.getMinMax("brSo", gew, false));
            feature.put("bvReMin", this.getMinMax("bvRe", gew, true));
            feature.put("bvReMit", this.getMit("bvRe", gew));
            feature.put("bvReMax", this.getMinMax("bvRe", gew, false));
            feature.put("bhReMin", this.getMinMax("bhRe", gew, true));
            feature.put("bhReMit", this.getMit("bhRe", gew));
            feature.put("bhReMax", this.getMinMax("bhRe", gew, false));
            feature.put("blReMin", this.getMinMax("blRe", gew, true));
            feature.put("blReMit", this.getMit("blRe", gew));
            feature.put("blReMax", this.getMinMax("blRe", gew, false));
            feature.put("bvLiMin", this.getMinMax("bvLi", gew, true));
            feature.put("bvLiMit", this.getMit("bvLi", gew));
            feature.put("bvLiMax", this.getMinMax("bvLi", gew, false));
            feature.put("bhLiMin", this.getMinMax("bhLi", gew, true));
            feature.put("bhLiMit", this.getMit("bhLi", gew));
            feature.put("bhLiMax", this.getMinMax("bhLi", gew, false));
            feature.put("blLiMin", this.getMinMax("blLi", gew, true));
            feature.put("blLiMit", this.getMit("blLi", gew));
            feature.put("blLiMax", this.getMinMax("blLi", gew, false));
            feature.put("mwMin", this.getMinMax("mw", gew, true));
            feature.put("mwMit", this.getMit("mw", gew));
            feature.put("mwMax", this.getMinMax("mw", gew, false));
            feature.put("flSohle", this.getSum("flSo", gew));
            feature.put("flBoeRe", this.getSum("flBRe", gew));
            feature.put("flBoeLi", this.getSum("flBLi", gew));
            feature.put("flBoe", this.getSum("flB", gew));
            feature.put("flGer", this.getSum("flGer", gew));
            feature.put("brGewMin", this.getMinMax("brGew", gew, true));
            feature.put("brGewMit", this.getMit("brGew", gew));
            feature.put("brGewMax", this.getMinMax("brGew", gew, false));
            feature.put("flGew", this.getSum("flGew", gew));
            feature.put("blNassReMin", this.getMinMax("blNRe", gew, true));
            feature.put("blNassReMit", this.getMit("blNRe", gew));
            feature.put("blNassReMax", this.getMinMax("blNRe", gew, false));
            feature.put("blTroReMin", this.getMinMax("blTRe", gew, true));
            feature.put("blTroReMit", this.getMit("blTRe", gew));
            feature.put("blTroReMax", this.getMinMax("blTRe", gew, false));
            feature.put("blNassLiMin", this.getMinMax("blNLi", gew, true));
            feature.put("blNassLiMit", this.getMit("blNLi", gew));
            feature.put("blNassLiMax", this.getMinMax("blNLi", gew, false));
            feature.put("blTroLiMin", this.getMinMax("blTLi", gew, true));
            feature.put("blTroLiMit", this.getMit("blTLi", gew));
            feature.put("blTroLiMax", this.getMinMax("blTLi", gew, false));
            feature.put("flQsGerMin", this.getMinMax("flQsGer", gew, true));
            feature.put("flQsGerMit", this.getMit("flQsGer", gew));
            feature.put("flQsGerMax", this.getMinMax("flQsGer", gew, false));
            feature.put("flQsGewMin", this.getMinMax("flQsGew", gew, true));
            feature.put("flQsGewMit", this.getMit("flQsGew", gew));
            feature.put("flQsGewMax", this.getMinMax("flQsGew", gew, false));
            feature.put("flBoeNassRe", this.getSum("flBnRe", gew));
            feature.put("flBoeTroRe", this.getSum("flBtRe", gew));
            feature.put("flBoeNassLi", this.getSum("flBnLi", gew));
            feature.put("flBoeTroLi", this.getSum("flBtLi", gew));
            feature.put("flBoeNass", this.getSum("flBn", gew));
            feature.put("flBoeTro", this.getSum("flBt", gew));
            feature.put("flNass", this.getSum("flN", gew));
            feature.put("summe", false);
            feature.put("zwischenSumme", false);
            features.add(feature);
            featureListKum.add(feature);
        }
        features.add(this.createKumFeature(featureListKum, false));
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnitt() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList simpleFeatures = new ArrayList();
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
        String code = null;
        this.sheetNames.add("Abschnitte");
        for (KatasterGewObj katasterGewObj : this.helper.getAbschnitteOffen()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int id = katasterGewObj.getId();
            double d = katasterGewObj.getFrom();
            double till = katasterGewObj.getTill();
            double prof = this.getLengthGew(id, d, till);
            double mw = this.getLengthMw(id, d, till);
            hashMap.put("group", "group");
            hashMap.put("name", this.helper.getGewName(id));
            hashMap.put("code", this.helper.getBaCd(id));
            hashMap.put("gew_l_ges", this.helper.getLengthGewAll(id));
            hashMap.put("von", this.convertStation(d));
            hashMap.put("bis", this.convertStation(till));
            hashMap.put("laenge", katasterGewObj.getLength());
            hashMap.put("offene_l", katasterGewObj.getLength());
            hashMap.put("offene_a", katasterGewObj.getLength() * 100.0 / this.helper.getLengthGewAll(id));
            hashMap.put("prof_l", prof);
            hashMap.put("prof_a", katasterGewObj.getLength() != 0.0 ? prof * 100.0 / katasterGewObj.getLength() : 100.0);
            hashMap.put("mw_l", mw);
            hashMap.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
            hashMap.put("profTrap_a", this.getCountProf("tr", id, d, till));
            hashMap.put("profTrap_l", this.getLengthProf("tr", id, d, till));
            hashMap.put("profRe_a", this.getCountProf("re", id, d, till));
            hashMap.put("profRe_l", this.getLengthProf("re", id, d, till));
            hashMap.put("brSohleMin", this.getMinMax("brSo", id, d, till, true));
            hashMap.put("brSohleMit", this.getMit("brSo", id, d, till));
            hashMap.put("brSohleMax", this.getMinMax("brSo", id, d, till, false));
            hashMap.put("bvReMin", this.getMinMax("bvRe", id, d, till, true));
            hashMap.put("bvReMit", this.getMit("bvRe", id, d, till));
            hashMap.put("bvReMax", this.getMinMax("bvRe", id, d, till, false));
            hashMap.put("bhReMin", this.getMinMax("bhRe", id, d, till, true));
            hashMap.put("bhReMit", this.getMit("bhRe", id, d, till));
            hashMap.put("bhReMax", this.getMinMax("bhRe", id, d, till, false));
            hashMap.put("blReMin", this.getMinMax("blRe", id, d, till, true));
            hashMap.put("blReMit", this.getMit("blRe", id, d, till));
            hashMap.put("blReMax", this.getMinMax("blRe", id, d, till, false));
            hashMap.put("bvLiMin", this.getMinMax("bvLi", id, d, till, true));
            hashMap.put("bvLiMit", this.getMit("bvLi", id, d, till));
            hashMap.put("bvLiMax", this.getMinMax("bvLi", id, d, till, false));
            hashMap.put("bhLiMin", this.getMinMax("bhLi", id, d, till, true));
            hashMap.put("bhLiMit", this.getMit("bhLi", id, d, till));
            hashMap.put("bhLiMax", this.getMinMax("bhLi", id, d, till, false));
            hashMap.put("blLiMin", this.getMinMax("blLi", id, d, till, true));
            hashMap.put("blLiMit", this.getMit("blLi", id, d, till));
            hashMap.put("blLiMax", this.getMinMax("blLi", id, d, till, false));
            hashMap.put("mwMin", this.getMinMax("mw", id, d, till, true));
            hashMap.put("mwMit", this.getMit("mw", id, d, till));
            hashMap.put("mwMax", this.getMinMax("mw", id, d, till, false));
            hashMap.put("flSohle", this.getSum("flSo", id, d, till));
            hashMap.put("flBoeRe", this.getSum("flBRe", id, d, till));
            hashMap.put("flBoeLi", this.getSum("flBLi", id, d, till));
            hashMap.put("flBoe", this.getSum("flB", id, d, till));
            hashMap.put("flGer", this.getSum("flGer", id, d, till));
            hashMap.put("brGewMin", this.getMinMax("brGew", id, d, till, true));
            hashMap.put("brGewMit", this.getMit("brGew", id, d, till));
            hashMap.put("brGewMax", this.getMinMax("brGew", id, d, till, false));
            hashMap.put("flGew", this.getSum("flGew", id, d, till));
            hashMap.put("blNassReMin", this.getMinMax("blNRe", id, d, till, true));
            hashMap.put("blNassReMit", this.getMit("blNRe", id, d, till));
            hashMap.put("blNassReMax", this.getMinMax("blNRe", id, d, till, false));
            hashMap.put("blTroReMin", this.getMinMax("blTRe", id, d, till, true));
            hashMap.put("blTroReMit", this.getMit("blTRe", id, d, till));
            hashMap.put("blTroReMax", this.getMinMax("blTRe", id, d, till, false));
            hashMap.put("blNassLiMin", this.getMinMax("blNLi", id, d, till, true));
            hashMap.put("blNassLiMit", this.getMit("blNLi", id, d, till));
            hashMap.put("blNassLiMax", this.getMinMax("blNLi", id, d, till, false));
            hashMap.put("blTroLiMin", this.getMinMax("blTLi", id, d, till, true));
            hashMap.put("blTroLiMit", this.getMit("blTLi", id, d, till));
            hashMap.put("blTroLiMax", this.getMinMax("blTLi", id, d, till, false));
            hashMap.put("flQsGerMin", this.getMinMax("flQsGer", id, d, till, true));
            hashMap.put("flQsGerMit", this.getMit("flQsGer", id, d, till));
            hashMap.put("flQsGerMax", this.getMinMax("flQsGer", id, d, till, false));
            hashMap.put("flQsGewMin", this.getMinMax("flQsGew", id, d, till, true));
            hashMap.put("flQsGewMit", this.getMit("flQsGew", id, d, till));
            hashMap.put("flQsGewMax", this.getMinMax("flQsGew", id, d, till, false));
            hashMap.put("flBoeNassRe", this.getSum("flBnRe", id, d, till));
            hashMap.put("flBoeTroRe", this.getSum("flBtRe", id, d, till));
            hashMap.put("flBoeNassLi", this.getSum("flBnLi", id, d, till));
            hashMap.put("flBoeTroLi", this.getSum("flBtLi", id, d, till));
            hashMap.put("flBoeNass", this.getSum("flBn", id, d, till));
            hashMap.put("flBoeTro", this.getSum("flBt", id, d, till));
            hashMap.put("flNass", this.getSum("flN", id, d, till));
            hashMap.put("summe", false);
            hashMap.put("zwischenSumme", false);
            String newCode = this.helper.getBaCd(katasterGewObj.getId());
            if (code != null && !code.equals(newCode)) {
                Map<String, Object> kumFeature = this.createKumFeature(featureListGewKum, true);
                kumFeature.put("laenge", ((Map)featureListGewKum.get(0)).get("laenge"));
                kumFeature.put("code", ((Map)featureListGewKum.get(0)).get("code"));
                kumFeature.put("name", ((Map)featureListGewKum.get(0)).get("name"));
                features.add(kumFeature);
                featureListGewKum.clear();
            }
            code = newCode;
            features.add(hashMap);
            simpleFeatures.add(hashMap);
            featureListKum.add(hashMap);
            featureListGewKum.add(hashMap);
        }
        Map<String, Object> kumFeature = this.createKumFeature(featureListKum, false, 1);
        for (Map map : simpleFeatures) {
            map.put("code", null);
            map.put("name", null);
            map.put("laenge", null);
        }
        double d = 0.0;
        for (Map map : features) {
            if (map.get("laenge") == null) continue;
            d += ((Double)map.get("laenge")).doubleValue();
        }
        kumFeature.put("laenge", d);
        features.add(kumFeature);
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnittProfil() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
        ArrayList simpleFeatures = new ArrayList();
        String code = null;
        this.sheetNames.add("Profile");
        for (KatasterGewObj katasterGewObj : this.helper.getAbschnitteOffen(this.objList)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int id = katasterGewObj.getId();
            double d = katasterGewObj.getFrom();
            double till = katasterGewObj.getTill();
            double prof = this.getLengthGew(id, d, till);
            double mw = this.getLengthMw(id, d, till);
            String profTyp = null;
            if (this.getCountProf("tr", id, d, till) > 0) {
                profTyp = "tr";
            } else if (this.getCountProf("re", id, d, till) > 0) {
                profTyp = "re";
            }
            hashMap.put("group", "group");
            hashMap.put("name", this.helper.getGewName(id));
            hashMap.put("code", this.helper.getBaCd(id));
            hashMap.put("laenge", katasterGewObj.getLength());
            hashMap.put("gew_l", this.helper.getLengthGewAll(id));
            hashMap.put("von", this.convertStation(d));
            hashMap.put("bis", this.convertStation(till));
            hashMap.put("laenge", katasterGewObj.getLength());
            hashMap.put("offene_a", katasterGewObj.getLength() * 100.0 / this.helper.getLengthGewAll(id));
            hashMap.put("prof", prof > 0.0 ? "x" : null);
            hashMap.put("mw", mw > 0.0 ? "x" : null);
            hashMap.put("profTyp", profTyp);
            hashMap.put("brSohleMit", this.getMit("brSo", id, d, till));
            hashMap.put("bvReMit", this.getMit("bvRe", id, d, till));
            hashMap.put("bhReMit", this.getMit("bhRe", id, d, till));
            hashMap.put("blReMit", this.getMit("blRe", id, d, till));
            hashMap.put("bvLiMit", this.getMit("bvLi", id, d, till));
            hashMap.put("bhLiMit", this.getMit("bhLi", id, d, till));
            hashMap.put("blLiMit", this.getMit("blLi", id, d, till));
            hashMap.put("mwMit", this.getMit("mw", id, d, till));
            hashMap.put("flSohle", this.getSum("flSo", id, d, till));
            hashMap.put("flBoeRe", this.getSum("flBRe", id, d, till));
            hashMap.put("flBoeLi", this.getSum("flBLi", id, d, till));
            hashMap.put("flBoe", this.getSum("flB", id, d, till));
            hashMap.put("flGer", this.getSum("flGer", id, d, till));
            hashMap.put("brGewMit", this.getMit("brGew", id, d, till));
            hashMap.put("flGew", this.getSum("flGew", id, d, till));
            hashMap.put("blNassReMit", this.getMit("blNRe", id, d, till));
            hashMap.put("blTroReMit", this.getMit("blTRe", id, d, till));
            hashMap.put("blNassLiMit", this.getMit("blNLi", id, d, till));
            hashMap.put("blTroLiMit", this.getMit("blTLi", id, d, till));
            hashMap.put("flQsGerMit", this.getMit("flQsGer", id, d, till));
            hashMap.put("flQsGewMit", this.getMit("flQsGew", id, d, till));
            hashMap.put("flBoeNassRe", this.getSum("flBnRe", id, d, till));
            hashMap.put("flBoeTroRe", this.getSum("flBtRe", id, d, till));
            hashMap.put("flBoeNassLi", this.getSum("flBnLi", id, d, till));
            hashMap.put("flBoeTroLi", this.getSum("flBtLi", id, d, till));
            hashMap.put("flBoeNass", this.getSum("flBn", id, d, till));
            hashMap.put("flBoeTro", this.getSum("flBt", id, d, till));
            hashMap.put("flNass", this.getSum("flN", id, d, till));
            hashMap.put("summe", false);
            hashMap.put("zwischenSumme", false);
            String newCode = this.helper.getBaCd(katasterGewObj.getId());
            if (code != null && !code.equals(newCode)) {
                Map<String, Object> kumFeature = this.createKumFeature(featureListGewKum, true);
                kumFeature.put("gew_l", ((Map)featureListGewKum.get(0)).get("gew_l"));
                kumFeature.put("code", ((Map)featureListGewKum.get(0)).get("code"));
                kumFeature.put("name", ((Map)featureListGewKum.get(0)).get("name"));
                features.add(kumFeature);
                featureListGewKum.clear();
            }
            code = newCode;
            features.add(hashMap);
            simpleFeatures.add(hashMap);
            featureListKum.add(hashMap);
            featureListGewKum.add(hashMap);
        }
        Map<String, Object> kumFeature = this.createKumFeature(featureListKum, false, 1);
        for (Map map : simpleFeatures) {
            map.put("code", null);
            map.put("name", null);
            map.put("gew_l", null);
        }
        double d = 0.0;
        for (Map map : features) {
            if (map.get("gew_l") == null) continue;
            d += ((Double)map.get("gew_l")).doubleValue();
        }
        kumFeature.put("gew_l", d);
        features.add(kumFeature);
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGu() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU ");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.helper.getGu()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double offenLength = this.helper.getLengthOffeneAbschn(guName);
            double prof = this.getLengthGew(guName);
            double mw = this.getLengthMw(guName);
            double gewAll = this.helper.getLengthGewAll(guName);
            feature.put("group", "group");
            feature.put("name", guName);
            feature.put("gu", this.helper.getGuId(guName));
            feature.put("gew_a", this.helper.getCountGewAll(guName));
            feature.put("gew_l", this.helper.getLengthGewAll(guName));
            feature.put("offene_l", offenLength);
            feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
            feature.put("prof_l", prof);
            feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
            feature.put("mw_l", mw);
            feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
            feature.put("profTrap_a", this.getCountProf("tr", guName));
            feature.put("profTrap_l", this.getLengthProf("tr", guName));
            feature.put("profRe_a", this.getCountProf("re", guName));
            feature.put("profRe_l", this.getLengthProf("re", guName));
            feature.put("brSohleMin", this.getMinMax("brSo", guName, true));
            feature.put("brSohleMit", this.getMit("brSo", guName));
            feature.put("brSohleMax", this.getMinMax("brSo", guName, false));
            feature.put("bvReMin", this.getMinMax("bvRe", guName, true));
            feature.put("bvReMit", this.getMit("bvRe", guName));
            feature.put("bvReMax", this.getMinMax("bvRe", guName, false));
            feature.put("bhReMin", this.getMinMax("bhRe", guName, true));
            feature.put("bhReMit", this.getMit("bhRe", guName));
            feature.put("bhReMax", this.getMinMax("bhRe", guName, false));
            feature.put("blReMin", this.getMinMax("blRe", guName, true));
            feature.put("blReMit", this.getMit("blRe", guName));
            feature.put("blReMax", this.getMinMax("blRe", guName, false));
            feature.put("bvLiMin", this.getMinMax("bvLi", guName, true));
            feature.put("bvLiMit", this.getMit("bvLi", guName));
            feature.put("bvLiMax", this.getMinMax("bvLi", guName, false));
            feature.put("bhLiMin", this.getMinMax("bhLi", guName, true));
            feature.put("bhLiMit", this.getMit("bhLi", guName));
            feature.put("bhLiMax", this.getMinMax("bhLi", guName, false));
            feature.put("blLiMin", this.getMinMax("blLi", guName, true));
            feature.put("blLiMit", this.getMit("blLi", guName));
            feature.put("blLiMax", this.getMinMax("blLi", guName, false));
            feature.put("mwMin", this.getMinMax("mw", guName, true));
            feature.put("mwMit", this.getMit("mw", guName));
            feature.put("mwMax", this.getMinMax("mw", guName, false));
            feature.put("flSohle", this.getSum("flSo", guName));
            feature.put("flBoeRe", this.getSum("flBRe", guName));
            feature.put("flBoeLi", this.getSum("flBLi", guName));
            feature.put("flBoe", this.getSum("flB", guName));
            feature.put("flGer", this.getSum("flGer", guName));
            feature.put("brGewMin", this.getMinMax("brGew", guName, true));
            feature.put("brGewMit", this.getMit("brGew", guName));
            feature.put("brGewMax", this.getMinMax("brGew", guName, false));
            feature.put("flGew", this.getSum("flGew", guName));
            feature.put("blNassReMin", this.getMinMax("blNRe", guName, true));
            feature.put("blNassReMit", this.getMit("blNRe", guName));
            feature.put("blNassReMax", this.getMinMax("blNRe", guName, false));
            feature.put("blTroReMin", this.getMinMax("blTRe", guName, true));
            feature.put("blTroReMit", this.getMit("blTRe", guName));
            feature.put("blTroReMax", this.getMinMax("blTRe", guName, false));
            feature.put("blNassLiMin", this.getMinMax("blNLi", guName, true));
            feature.put("blNassLiMit", this.getMit("blNLi", guName));
            feature.put("blNassLiMax", this.getMinMax("blNLi", guName, false));
            feature.put("blTroLiMin", this.getMinMax("blTLi", guName, true));
            feature.put("blTroLiMit", this.getMit("blTLi", guName));
            feature.put("blTroLiMax", this.getMinMax("blTLi", guName, false));
            feature.put("flQsGerMin", this.getMinMax("flQsGer", guName, true));
            feature.put("flQsGerMit", this.getMit("flQsGer", guName));
            feature.put("flQsGerMax", this.getMinMax("flQsGer", guName, false));
            feature.put("flQsGewMin", this.getMinMax("flQsGew", guName, true));
            feature.put("flQsGewMit", this.getMit("flQsGew", guName));
            feature.put("flQsGewMax", this.getMinMax("flQsGew", guName, false));
            feature.put("flBoeNassRe", this.getSum("flBnRe", guName));
            feature.put("flBoeTroRe", this.getSum("flBtRe", guName));
            feature.put("flBoeNassLi", this.getSum("flBnLi", guName));
            feature.put("flBoeTroLi", this.getSum("flBtLi", guName));
            feature.put("flBoeNass", this.getSum("flBn", guName));
            feature.put("flBoeTro", this.getSum("flBt", guName));
            feature.put("flNass", this.getSum("flN", guName));
            feature.put("summe", false);
            feature.put("zwischenSumme", false);
            features.add(feature);
            featureListKum.add(feature);
        }
        if (!featureListKum.isEmpty()) {
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList simpleFeatures = new ArrayList();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.helper.getGu()) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            for (Integer wdm : this.helper.getWidmung(guName)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double offenLength = this.helper.getLengthOffeneAbschn(guName, wdm);
                double prof = this.getLengthGew(guName, wdm);
                double mw = this.getLengthMw(guName, wdm);
                double gewAll = this.helper.getLengthGewAll(guName, wdm);
                feature.put("group", "group");
                feature.put("name", this.helper.getGuId(guName));
                feature.put("gu", guName);
                feature.put("wdm", wdm);
                feature.put("gew_a", this.helper.getCountGewAll(guName, wdm));
                feature.put("gew_l", this.helper.getLengthGewAll(guName, wdm));
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : offenLength);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", guName, (int)wdm));
                feature.put("profTrap_l", this.getLengthProf("tr", guName, wdm));
                feature.put("profRe_a", this.getCountProf("re", guName, (int)wdm));
                feature.put("profRe_l", this.getLengthProf("re", guName, wdm));
                feature.put("brSohleMin", this.getMinMax("brSo", guName, wdm, true));
                feature.put("brSohleMit", this.getMit("brSo", guName, wdm));
                feature.put("brSohleMax", this.getMinMax("brSo", guName, wdm, false));
                feature.put("bvReMin", this.getMinMax("bvRe", guName, wdm, true));
                feature.put("bvReMit", this.getMit("bvRe", guName, wdm));
                feature.put("bvReMax", this.getMinMax("bvRe", guName, wdm, false));
                feature.put("bhReMin", this.getMinMax("bhRe", guName, wdm, true));
                feature.put("bhReMit", this.getMit("bhRe", guName, wdm));
                feature.put("bhReMax", this.getMinMax("bhRe", guName, wdm, false));
                feature.put("blReMin", this.getMinMax("blRe", guName, wdm, true));
                feature.put("blReMit", this.getMit("blRe", guName, wdm));
                feature.put("blReMax", this.getMinMax("blRe", guName, wdm, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", guName, wdm, true));
                feature.put("bvLiMit", this.getMit("bvLi", guName, wdm));
                feature.put("bvLiMax", this.getMinMax("bvLi", guName, wdm, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", guName, wdm, true));
                feature.put("bhLiMit", this.getMit("bhLi", guName, wdm));
                feature.put("bhLiMax", this.getMinMax("bhLi", guName, wdm, false));
                feature.put("blLiMin", this.getMinMax("blLi", guName, wdm, true));
                feature.put("blLiMit", this.getMit("blLi", guName, wdm));
                feature.put("blLiMax", this.getMinMax("blLi", guName, wdm, false));
                feature.put("mwMin", this.getMinMax("mw", guName, wdm, true));
                feature.put("mwMit", this.getMit("mw", guName, wdm));
                feature.put("mwMax", this.getMinMax("mw", guName, wdm, false));
                feature.put("flSohle", this.getSum("flSo", guName, wdm));
                feature.put("flBoeRe", this.getSum("flBRe", guName, wdm));
                feature.put("flBoeLi", this.getSum("flBLi", guName, wdm));
                feature.put("flBoe", this.getSum("flB", guName, wdm));
                feature.put("flGer", this.getSum("flGer", guName, wdm));
                feature.put("brGewMin", this.getMinMax("brGew", guName, wdm, true));
                feature.put("brGewMit", this.getMit("brGew", guName, wdm));
                feature.put("brGewMax", this.getMinMax("brGew", guName, wdm, false));
                feature.put("flGew", this.getSum("flGew", guName, wdm));
                feature.put("blNassReMin", this.getMinMax("blNRe", guName, wdm, true));
                feature.put("blNassReMit", this.getMit("blNRe", guName, wdm));
                feature.put("blNassReMax", this.getMinMax("blNRe", guName, wdm, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", guName, wdm, true));
                feature.put("blTroReMit", this.getMit("blTRe", guName, wdm));
                feature.put("blTroReMax", this.getMinMax("blTRe", guName, wdm, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", guName, wdm, true));
                feature.put("blNassLiMit", this.getMit("blNLi", guName, wdm));
                feature.put("blNassLiMax", this.getMinMax("blNLi", guName, wdm, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", guName, wdm, true));
                feature.put("blTroLiMit", this.getMit("blTLi", guName, wdm));
                feature.put("blTroLiMax", this.getMinMax("blTLi", guName, wdm, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", guName, wdm, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", guName, wdm));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", guName, wdm, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", guName, wdm, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", guName, wdm));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", guName, wdm, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", guName, wdm));
                feature.put("flBoeTroRe", this.getSum("flBtRe", guName, wdm));
                feature.put("flBoeNassLi", this.getSum("flBnLi", guName, wdm));
                feature.put("flBoeTroLi", this.getSum("flBtLi", guName, wdm));
                feature.put("flBoeNass", this.getSum("flBn", guName, wdm));
                feature.put("flBoeTro", this.getSum("flBt", guName, wdm));
                feature.put("flNass", this.getSum("flN", guName, wdm));
                feature.put("summe", false);
                feature.put("zwischenSumme", false);
                simpleFeatures.add(feature);
                features.add(feature);
                featureListKum.add(feature);
                arrayList.add(feature);
            }
            Map<String, Object> kumFeature = this.createKumFeature(arrayList, true);
            kumFeature.put("wdm", null);
            kumFeature.put("name", this.helper.getGuId(guName));
            kumFeature.put("gu", guName);
            features.add(kumFeature);
        }
        Map<String, Object> kumFeature = this.createKumFeature(featureListKum, false);
        for (Map map : simpleFeatures) {
            map.put("name", null);
            map.put("gu", null);
        }
        kumFeature.put("wdm", null);
        features.add(kumFeature);
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal) {
        return this.createKumFeature(featureListKum, subtotal, 0);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal, int stat) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        if (!subtotal) {
            kumFeature.put("summe", Boolean.TRUE);
        }
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : new ArrayList<String>(firstElement.keySet())) {
            double totalTmp;
            double specificTmp;
            Object value = firstElement.get(key);
            if (key.endsWith("offene_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = this.toDouble(f.get("offene_l"));
                    totalTmp = this.toDouble(f.get("gew_l"));
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("prof_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = this.toDouble(f.get("prof_l"));
                    totalTmp = this.toDouble(f.get("offene_l"));
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("mw_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = this.toDouble(f.get("mw_l"));
                    totalTmp = this.toDouble(f.get("prof_l"));
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("Min") && value instanceof Double) {
                double min = this.toDouble(value);
                for (Map<String, Object> f : featureListKum) {
                    double val = this.toDouble(f.get(key));
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (val == 0.0 || !(val < min)) continue;
                    min = val;
                }
                if (min == 0.0) continue;
                kumFeature.put(key, min);
                continue;
            }
            if (key.endsWith("Max") && value instanceof Double) {
                double max = this.toDouble(value);
                for (Map<String, Object> f : featureListKum) {
                    double val = this.toDouble(f.get(key));
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
                if (max == 0.0) continue;
                kumFeature.put(key, max);
                continue;
            }
            if (key.endsWith("Mit") && value instanceof Double) {
                double mit = 0.0;
                double length = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    double val = this.toDouble(f.get(key));
                    double len = this.toDouble(f.get("prof_l"));
                    mit += val * len;
                    length += len;
                }
                if (length == 0.0) continue;
                kumFeature.put(key, mit / length);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    sum += this.toDouble(f.get(key));
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (value instanceof String && !key.equals("group") || value instanceof Boolean || Arrays.binarySearch(exceptionalNumberFields, key) >= 0) continue;
            kumFeature.put(key, value);
        }
        return kumFeature;
    }

    private double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        return (Double)o;
    }

    private double getLengthGew(int gewId) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(int gewId, double from, double till) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gewId) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(String gu) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(String gu, int wdm) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gewId, double from, double till) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gewId) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, String gu) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, String gu, int wdm) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gewId, double from, double till) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getMinMax(String field, int gewId, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (gewId != -1 && tmp.getId() != gewId || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, String gu, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, String gu, int wdm, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, int gewId, double from, double till, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMit(String field, int gewId) {
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (gewId != -1 && tmp.getId() != gewId || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, String gu) {
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, String gu, int wdm) {
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, int gewId, double from, double till) {
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLengthInGewPart(gewId, from, till);
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getSum(String field, int gewId) {
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, int gewId, double from, double till) {
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, String gu) {
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, String gu, int wdm) {
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    @Override
    public int getCountProf(String prof, int gewId) {
        int count = 0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, String gu) {
        int count = 0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, String gu, int wdm) {
        int count = 0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, int gewId, double from, double till) {
        int count = 0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof) || !tmp.isInGewPart(gewId, from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGew(String gu) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm) {
        double length = 0.0;
        for (GmdPartObjOffen tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWdm() != wdm) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

