/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewWithParts;
import de.cismet.cids.custom.watergis.server.search.AllLineObjects;
import de.cismet.cids.custom.watergis.server.search.AllPunktObjects;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.watergis.gui.dialog.KatasterGewaesserReportDialog;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.GewaesserData;
import de.cismet.watergis.reports.types.KatasterGewObj;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.apache.log4j.Logger;

public class KatasterGewaesserReport {
    private static final Logger LOG = Logger.getLogger(KatasterGewaesserReport.class);
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "group", "gmdName", "code", "anzahlGu", "gu", "gewName"};
    GewaesserData gd;
    private List<KatasterGewObj> parts;
    private List<String> sheetNames = new ArrayList<String>();
    private HashSet<Integer> ts = new HashSet();

    public File createGewaesserReport(int[] gew, WaitDialog wd) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("datum", df.format(new Date()));
        parameters.put("gemeinden", 0);
        parameters.put("gmd", KatasterGewaesserReportDialog.getInstance().isGmd());
        parameters.put("wasserschutz", KatasterGewaesserReportDialog.getInstance().isWsg());
        parameters.put("ueber", KatasterGewaesserReportDialog.getInstance().isSchutzgebiete());
        parameters.put("ben", KatasterGewaesserReportDialog.getInstance().isBen());
        parameters.put("aus", KatasterGewaesserReportDialog.getInstance().isAus());
        parameters.put("pegel", KatasterGewaesserReportDialog.getInstance().isPegel());
        parameters.put("gb", KatasterGewaesserReportDialog.getInstance().isGb());
        parameters.put("sb", KatasterGewaesserReportDialog.getInstance().isSb());
        parameters.put("prof", KatasterGewaesserReportDialog.getInstance().isProf());
        parameters.put("sbef", KatasterGewaesserReportDialog.getInstance().isSbef());
        parameters.put("ubef", KatasterGewaesserReportDialog.getInstance().isUbef());
        parameters.put("bbef", KatasterGewaesserReportDialog.getInstance().isBbef());
        parameters.put("rl", KatasterGewaesserReportDialog.getInstance().isRl());
        parameters.put("d", KatasterGewaesserReportDialog.getInstance().isD());
        parameters.put("due", KatasterGewaesserReportDialog.getInstance().isDue());
        parameters.put("scha", KatasterGewaesserReportDialog.getInstance().isScha());
        parameters.put("wehr", KatasterGewaesserReportDialog.getInstance().isWehr());
        parameters.put("schw", KatasterGewaesserReportDialog.getInstance().isSchw());
        parameters.put("anlp", KatasterGewaesserReportDialog.getInstance().isAnlp());
        parameters.put("anll", KatasterGewaesserReportDialog.getInstance().isAnll());
        parameters.put("kr", KatasterGewaesserReportDialog.getInstance().isKr());
        parameters.put("ea", KatasterGewaesserReportDialog.getInstance().isEa());
        parameters.put("deich", KatasterGewaesserReportDialog.getInstance().isDeich());
        parameters.put("ughz", KatasterGewaesserReportDialog.getInstance().isUghz());
        parameters.put("leis", KatasterGewaesserReportDialog.getInstance().isLeis());
        parameters.put("tech", KatasterGewaesserReportDialog.getInstance().isTech());
        parameters.put("dok", KatasterGewaesserReportDialog.getInstance().isDok());
        parameters.put("proj", KatasterGewaesserReportDialog.getInstance().isProj());
        parameters.put("foto", KatasterGewaesserReportDialog.getInstance().isFoto());
        parameters.put("perGew", false);
        parameters.put("perAbschn", KatasterGewaesserReportDialog.getInstance().isPerPart());
        parameters.put("sumGu", KatasterGewaesserReportDialog.getInstance().isSumGu());
        parameters.put("wdm", KatasterGewaesserReportDialog.getInstance().isPerWdm());
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)KatasterGewaesserReport.class.getResourceAsStream("/de/cismet/watergis/reports/stat_gewaesser.jasper"));
        this.init(gew, wd);
        if (KatasterGewaesserReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesserAbschn", this.getGewaesserAbschnitt());
        } else {
            dataSources.put("gewaesser", this.getGewaesser());
        }
        if (KatasterGewaesserReportDialog.getInstance().isSumGu()) {
            if (KatasterGewaesserReportDialog.getInstance().isPerWdm()) {
                dataSources.put("guWidmung", this.getGuWidmung());
            } else {
                dataSources.put("gu", this.getGuTable());
            }
        }
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        File file = new File(KatasterGewaesserReportDialog.getInstance().getPath() + "/Kataster_Gew\u00e4sser.xlsx");
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        KatasterGewaesserReport report = new KatasterGewaesserReport();
    }

    private void init(int[] routeIds, WaitDialog wd) throws Exception {
        this.parts = this.getAllRoutes(routeIds);
        int[] routes = routeIds;
        if (routes != null && routes.length == 0) {
            routes = null;
        }
        this.gd = new GewaesserData(routes);
    }

    private List<KatasterGewObj> getAllRoutes(int[] routeIds) throws Exception {
        AllGewWithParts search = new AllGewWithParts(routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<KatasterGewObj> objList = new ArrayList<KatasterGewObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new KatasterGewObj((Integer)f.get(0), (String)f.get(1), (String)f.get(7), (String)f.get(8), (String)f.get(9), (Integer)f.get(10), (String)f.get(2), (Double)f.get(3), (Double)f.get(4)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (KatasterGewaesserReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (KatasterGewaesserReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (KatasterGewaesserReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (KatasterGewaesserReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (KatasterGewaesserReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gew\u00e4sser");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        int gewCount = this.getCountGewAll();
        for (int gew : this.getGewSortedByBaCd()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("anzahlGew", gewCount);
            feature.put("code", this.getBaCd(gew));
            feature.put("gewName", this.getGewName(gew));
            feature.put("gewLaenge", this.toNullIfZero(this.getLengthGew(gew)));
            double lengthSee = this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, gew);
            feature.put("offene_a", this.toNullIfZero((this.getLengthGew(gew) - this.getLengthGeschlAbschn(gew) - lengthSee) * 100.0 / (this.getLengthOffeneAbschn(gew) + this.getLengthGeschlAbschn(gew))));
            feature.put("offene_l", this.toNullIfZero(this.getLengthGew(gew) - this.getLengthGeschlAbschn(gew) - lengthSee));
            feature.put("see_a", this.toNullIfZero(lengthSee * 100.0 / (this.getLengthOffeneAbschn(gew) + this.getLengthGeschlAbschn(gew))));
            feature.put("see_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, gew)));
            feature.put("geschl_a", this.toNullIfZero(this.getLengthGeschlAbschn(gew) * 100.0 / (this.getLengthOffeneAbschn(gew) + this.getLengthGeschlAbschn(gew))));
            feature.put("geschl_l", this.toNullIfZero(this.getLengthGeschlAbschn(gew)));
            feature.put("wschutz_a", this.toNullIfZero(this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, gew)));
            feature.put("wschutz_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, gew)));
            feature.put("ueber_a", this.toNullIfZero(this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, gew)));
            feature.put("ueber_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, gew)));
            feature.put("ben_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, gew)));
            feature.put("aus_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, gew)));
            feature.put("pegel_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, gew)));
            feature.put("gb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, gew)));
            feature.put("gb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, gew)));
            feature.put("gmd_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gmd, gew)));
            feature.put("gmd_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gmd, gew)));
            feature.put("sb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, gew)));
            feature.put("sb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, gew)));
            feature.put("prof_a", this.toNullIfZero(this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gew), this.getLengthOffeneAbschn(gew))));
            feature.put("prof_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gew)));
            feature.put("sbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, gew)));
            feature.put("sbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, gew)));
            feature.put("ubef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, gew)));
            feature.put("ubef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, gew)));
            feature.put("bbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, gew)));
            feature.put("bbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, gew)));
            feature.put("rl_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, gew)));
            feature.put("rl_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, gew)));
            feature.put("d_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, gew)));
            feature.put("d_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, gew)));
            feature.put("due_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, gew)));
            feature.put("due_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, gew)));
            feature.put("scha_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, gew)));
            feature.put("wehr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, gew)));
            feature.put("schw_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, gew)));
            feature.put("anlp_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, gew)));
            feature.put("anll_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, gew)));
            feature.put("anll_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, gew)));
            feature.put("kr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, gew)));
            feature.put("ea_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, gew)));
            feature.put("foto_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.foto, gew)));
            feature.put("deich_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.deich_ft, gew)));
            feature.put("deich_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.deich_ft, gew)));
            feature.put("ughz_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, gew)));
            feature.put("ughz_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, gew)));
            feature.put("leis_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, gew)));
            feature.put("leis_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, gew)));
            feature.put("tech_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, gew)));
            feature.put("tech_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, gew)));
            feature.put("dok_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, gew)));
            feature.put("dok_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, gew)));
            feature.put("proj_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, gew)));
            feature.put("proj_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, gew)));
            features.add(feature);
            featureListKum.add(feature);
        }
        Map<String, Object> kumObj = this.createKumFeature(featureListKum, false, true);
        kumObj.put("code", null);
        kumObj.put("gewName", null);
        features.add(kumObj);
        return new FeatureDataSource(features);
    }

    private double percentage(double part, double total) {
        if (part == 0.0) {
            return 0.0;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return part * 100.0 / total;
    }

    private Object toNullIfZero(Object o) {
        if (o instanceof Number && ((Number)o).doubleValue() == 0.0) {
            return null;
        }
        return o;
    }

    private FeatureDataSource getGewaesserAbschnitt() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
        String code = null;
        this.sheetNames.add("Gew\u00e4sser");
        int gewCount = this.getCountGewAll();
        for (KatasterGewObj gew : this.parts) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("anzahlGew", gewCount);
            hashMap.put("anzahlAbschn", this.parts.size());
            hashMap.put("code", this.getBaCd(gew.getId()));
            hashMap.put("gewName", gew.getGewName());
            hashMap.put("von", this.convertStation(gew.getFrom()));
            hashMap.put("bis", this.convertStation(gew.getTill()));
            hashMap.put("gewLaenge", gew.getLength());
            hashMap.put("offene_a", this.getCountOffeneAbschn(gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("offene_l", this.getLengthOffeneAbschn(gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("see_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.sg_see, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("see_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("geschl_a", this.getCountGeschlAbschn(gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("geschl_l", this.getLengthGeschlAbschn(gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("wschutz_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("wschutz_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ueber_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ueber_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("gmd_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gmd, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("gmd_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gmd, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("prof_a", this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gew.getId(), gew.getFrom(), gew.getTill()), this.getLengthOffeneAbschn(gew.getId(), gew.getFrom(), gew.getTill())));
            hashMap.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("foto_a", this.getCountPointObjects(AllPunktObjects.Table.foto, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("dok_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("dok_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("proj_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, gew.getId(), gew.getFrom(), gew.getTill()));
            hashMap.put("proj_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, gew.getId(), gew.getFrom(), gew.getTill()));
            String newCode = this.getBaCd(gew.getId());
            if (code != null && !code.equals(newCode)) {
                Map<String, Object> kumObj = this.createKumFeature(featureListGewKum, true, false);
                kumObj.remove("von");
                kumObj.remove("bis");
                kumObj.remove("gewLaenge");
                features.add(kumObj);
                featureListGewKum.clear();
            }
            code = newCode;
            features.add(hashMap);
            featureListKum.add(hashMap);
            featureListGewKum.add(hashMap);
        }
        Map<String, Object> kumObj = this.createKumFeature(featureListGewKum, true, false);
        kumObj.remove("von");
        kumObj.remove("bis");
        kumObj.remove("gewLaenge");
        features.add(kumObj);
        featureListGewKum.clear();
        kumObj = this.createKumFeature(featureListKum, false, false);
        kumObj.remove("code");
        kumObj.remove("gewName");
        kumObj.remove("von");
        kumObj.remove("bis");
        kumObj.remove("gewLaenge");
        features.add(kumObj);
        for (Map map : features) {
            if (map.get("summe") != null) continue;
            map.remove("code");
            map.remove("gewName");
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuTable() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("anzahlGu", this.getCountGu());
            feature.put("group", 1);
            feature.put("gu", this.getGuId(guName));
            feature.put("guName", guName);
            feature.put("gewAnzahl", this.getCountGew(guName));
            feature.put("gewLaenge", this.getLengthGew(guName));
            double lengthSee = this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, guName);
            feature.put("offene_a", this.toNullIfZero(this.getLengthGew(guName) - lengthSee - this.getLengthGeschlAbschn(guName) * 100.0 / (this.getLengthOffeneAbschn(guName) + this.getLengthGeschlAbschn(guName))));
            feature.put("offene_l", this.toNullIfZero(this.getLengthGew(guName) - lengthSee - this.getLengthGeschlAbschn(guName)));
            feature.put("see_a", this.toNullIfZero(lengthSee * 100.0 / (this.getLengthOffeneAbschn(guName) + this.getLengthGeschlAbschn(guName))));
            feature.put("see_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, guName)));
            feature.put("geschl_a", this.toNullIfZero(this.getLengthGeschlAbschn(guName) * 100.0 / (this.getLengthOffeneAbschn(guName) + this.getLengthGeschlAbschn(guName))));
            feature.put("geschl_l", this.toNullIfZero(this.getLengthGeschlAbschn(guName)));
            feature.put("wschutz_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, guName)));
            feature.put("ueber_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, guName)));
            feature.put("ben_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName)));
            feature.put("aus_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName)));
            feature.put("pegel_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName)));
            feature.put("gb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName)));
            feature.put("gb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName)));
            feature.put("gmd_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gmd, guName)));
            feature.put("gmd_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gmd, guName)));
            feature.put("sb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName)));
            feature.put("sb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName)));
            feature.put("prof_a", this.toNullIfZero(this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName), this.getLengthOffeneAbschn(guName))));
            feature.put("prof_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName)));
            feature.put("sbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName)));
            feature.put("sbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName)));
            feature.put("ubef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName)));
            feature.put("ubef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName)));
            feature.put("bbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName)));
            feature.put("bbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName)));
            feature.put("rl_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName)));
            feature.put("rl_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName)));
            feature.put("d_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName)));
            feature.put("d_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName)));
            feature.put("due_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName)));
            feature.put("due_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName)));
            feature.put("scha_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName)));
            feature.put("wehr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName)));
            feature.put("schw_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName)));
            feature.put("anlp_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName)));
            feature.put("anll_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName)));
            feature.put("anll_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName)));
            feature.put("kr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName)));
            feature.put("ea_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName)));
            feature.put("foto_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.foto, guName)));
            feature.put("deich_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName)));
            feature.put("deich_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName)));
            feature.put("ughz_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName)));
            feature.put("ughz_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName)));
            feature.put("leis_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName)));
            feature.put("leis_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName)));
            feature.put("tech_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName)));
            feature.put("tech_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName)));
            feature.put("dok_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, guName)));
            feature.put("dok_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, guName)));
            feature.put("proj_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, guName)));
            feature.put("proj_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, guName)));
            features.add(feature);
            featureListKum.add(feature);
        }
        Map<String, Object> kumObj = this.createKumFeature(featureListKum, false, true);
        kumObj.remove("gu");
        kumObj.remove("guName");
        features.add(kumObj);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            for (Integer wdm : this.getWidmung(guName)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("anzahlGu", this.getCountGu());
                feature.put("gu", this.getGuId(guName));
                feature.put("guName", guName);
                feature.put("widmung", wdm);
                double lengthSee = this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, guName, (int)wdm);
                feature.put("gew_a", this.getCountGew(guName, wdm));
                feature.put("gew_l", this.getLengthGew(guName, wdm));
                feature.put("offene_a", this.toNullIfZero(this.getLengthGew(guName, wdm) - lengthSee - this.getLengthGeschlAbschn(guName, wdm) * 100.0 / (this.getLengthOffeneAbschn(guName, wdm) + this.getLengthGeschlAbschn(guName, wdm))));
                feature.put("offene_l", this.toNullIfZero(this.getLengthGew(guName, wdm) - lengthSee - this.getLengthGeschlAbschn(guName, wdm)));
                feature.put("see_a", this.toNullIfZero(lengthSee * 100.0 / (this.getLengthOffeneAbschn(guName, wdm) + this.getLengthGeschlAbschn(guName, wdm))));
                feature.put("see_l", lengthSee);
                feature.put("geschl_a", this.toNullIfZero(this.getLengthGeschlAbschn(guName, wdm) * 100.0 / (this.getLengthOffeneAbschn(guName, wdm) + this.getLengthGeschlAbschn(guName, wdm))));
                feature.put("geschl_l", this.toNullIfZero(this.getLengthGeschlAbschn(guName, wdm)));
                feature.put("wschutz_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, guName, (int)wdm)));
                feature.put("ueber_l", this.toNullIfZero(this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, guName, (int)wdm)));
                feature.put("ben_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName, wdm)));
                feature.put("aus_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName, wdm)));
                feature.put("pegel_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName, wdm)));
                feature.put("gb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm)));
                feature.put("gb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm)));
                feature.put("gmd_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gmd, guName, (int)wdm)));
                feature.put("gmd_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gmd, guName, (int)wdm)));
                feature.put("sb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm)));
                feature.put("sb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm)));
                feature.put("prof_a", this.toNullIfZero(this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm), this.getLengthOffeneAbschn(guName, wdm))));
                feature.put("prof_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm)));
                feature.put("sbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm)));
                feature.put("sbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm)));
                feature.put("ubef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm)));
                feature.put("ubef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm)));
                feature.put("bbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm)));
                feature.put("bbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm)));
                feature.put("rl_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm)));
                feature.put("rl_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm)));
                feature.put("d_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm)));
                feature.put("d_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm)));
                feature.put("due_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm)));
                feature.put("due_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm)));
                feature.put("scha_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName, wdm)));
                feature.put("wehr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName, wdm)));
                feature.put("schw_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName, wdm)));
                feature.put("anlp_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName, wdm)));
                feature.put("anll_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm)));
                feature.put("anll_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm)));
                feature.put("kr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName, wdm)));
                feature.put("ea_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName, wdm)));
                feature.put("foto_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.foto, guName, wdm)));
                feature.put("deich_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm)));
                feature.put("deich_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm)));
                feature.put("ughz_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm)));
                feature.put("ughz_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm)));
                feature.put("leis_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm)));
                feature.put("leis_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm)));
                feature.put("tech_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm)));
                feature.put("tech_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm)));
                feature.put("dok_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, guName, (int)wdm)));
                feature.put("dok_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, guName, (int)wdm)));
                feature.put("proj_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, guName, (int)wdm)));
                feature.put("proj_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, guName, (int)wdm)));
                features.add(feature);
                featureListKum.add(feature);
                arrayList.add(feature);
            }
            Map<String, Object> kumObj = this.createKumFeature(arrayList, true, true);
            kumObj.remove("widmung");
            features.add(kumObj);
        }
        Map<String, Object> kumObj = this.createKumFeature(featureListKum, false, true);
        kumObj.remove("gu");
        kumObj.remove("guName");
        kumObj.remove("widmung");
        features.add(kumObj);
        for (Map map : features) {
            if (map.get("summe") == null) continue;
            kumObj.remove("gu");
            kumObj.remove("guName");
        }
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal, boolean isGeschDouble) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        kumFeature.put("summe", Boolean.TRUE);
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : firstElement.keySet()) {
            Object value = firstElement.get(key);
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0) {
                if (isGeschDouble && (key.equals("geschl_a") || key.equals("offene_a") || key.equals("prof_a") || key.equals("see_a"))) continue;
                double sum = 0.0;
                boolean isInt = false;
                for (Map<String, Object> f : featureListKum) {
                    Number n;
                    if (!(f.get(key) instanceof Number) || (n = (Number)f.get(key)) == null) continue;
                    if (f.get(key) instanceof Integer) {
                        isInt = true;
                    }
                    sum += ((Number)f.get(key)).doubleValue();
                }
                if (sum == 0.0) {
                    kumFeature.put(key, null);
                    continue;
                }
                if (isInt) {
                    kumFeature.put(key, (int)Math.round(sum));
                    continue;
                }
                kumFeature.put(key, sum);
                continue;
            }
            kumFeature.put(key, value);
        }
        if (isGeschDouble) {
            Double offene = (Double)kumFeature.get("offene_l");
            Double geschl = (Double)kumFeature.get("geschl_l");
            Double prof = (Double)kumFeature.get("prof_l");
            Double see = (Double)kumFeature.get("see_l");
            if (offene == null) {
                offene = 0.0;
            }
            if (see == null) {
                see = 0.0;
            }
            if (geschl == null) {
                geschl = 0.0;
            }
            if (prof == null) {
                prof = 0.0;
            }
            kumFeature.put("offene_a", this.toNullIfZero(offene * 100.0 / (offene + geschl + see)));
            kumFeature.put("geschl_a", this.toNullIfZero(geschl * 100.0 / (offene + geschl + see)));
            kumFeature.put("see_a", this.toNullIfZero(see * 100.0 / (offene + geschl + see)));
            if (offene == 0.0) {
                kumFeature.put("prof_a", 0.0);
            } else {
                kumFeature.put("prof_a", this.toNullIfZero(prof * 100.0 / (offene + see)));
            }
        }
        kumFeature.put("gmd_a", null);
        kumFeature.put("gb_a", null);
        kumFeature.put("sb_a", null);
        kumFeature.put("wschutz_a", null);
        kumFeature.put("ueber_a", null);
        kumFeature.put("gmd_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gmd, -1)));
        kumFeature.put("gb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, -1)));
        kumFeature.put("sb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, -1)));
        return kumFeature;
    }

    private Collection<Integer> getGewSortedByBaCd() {
        TreeSet<KatasterGewObj> ts = new TreeSet<KatasterGewObj>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (KatasterGewObj tmp : this.parts) {
            ts.add(tmp);
        }
        for (KatasterGewObj tmp : ts) {
            list.add(tmp.getId());
        }
        return list;
    }

    private Collection<String> getGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (KatasterGewObj tmp : this.parts) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private String getGuId(String owner) {
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    private Integer getWdm(int gew) {
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gew) continue;
            return tmp.getWidmung();
        }
        return null;
    }

    private Collection<Integer> getWidmung(String guName) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (KatasterGewObj gmdPart : this.parts) {
            if (!gmdPart.getOwner().equals(guName)) continue;
            ts.add(gmdPart.getWidmung());
        }
        return ts.descendingSet();
    }

    private int getCountGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (KatasterGewObj tmp : this.parts) {
            ts.add(tmp.getOwner());
        }
        return ts.size();
    }

    private String getBaCd(int gew) {
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(int gew) {
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private int getCountGewAll() {
        TreeSet<String> ts = new TreeSet<String>();
        for (KatasterGewObj tmp : this.parts) {
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    private double getLengthGewAll() {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(int gewId) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGew(String gu) {
        boolean count = false;
        TreeSet<String> gew = new TreeSet<String>();
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(gu)) continue;
            gew.add(tmp.getBaCd());
        }
        return gew.size();
    }

    private int getCountGew(String gu, int wdm) {
        boolean count = false;
        TreeSet<String> gew = new TreeSet<String>();
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            gew.add(tmp.getBaCd());
        }
        return gew.size();
    }

    private int getCountOffeneAbschn() {
        return this.getCountOffeneAbschn(-1);
    }

    private double getLengthOffeneAbschn() {
        return this.getLengthOffeneAbschn(-1);
    }

    private int getCountGeschlAbschn() {
        return this.getCountGeschlAbschn(-1);
    }

    private double getLengthGeschlAbschn() {
        return this.getLengthGeschlAbschn(-1);
    }

    private int getCountOffeneAbschn(int gewId) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gewId) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(int gewId) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gewId) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(int gewId, double from, double till) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gewId, double from, double till) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountGeschlAbschn(int gewId, double from, double till) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gewId, double from, double till) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner, int wdm) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner, int wdm) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner, int wdm) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner, int wdm) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gewId) {
        this.ts.clear();
        for (KatasterGewObj tmp : this.parts) {
            if (gewId != tmp.getId() && gewId >= 0) continue;
            this.ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return this.ts.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gewId) {
        double length = 0.0;
        return length += this.gd.getLength(table, gewId);
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, int gewId) {
        this.ts.clear();
        for (KatasterGewObj tmp : this.parts) {
            if (gewId != tmp.getId() && gewId >= 0) continue;
            this.ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return this.ts.size();
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, int gewId) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (gewId != tmp.getId() && gewId >= 0) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gewId) {
        this.ts.clear();
        for (KatasterGewObj tmp : this.parts) {
            if (gewId != tmp.getId() && gewId >= 0) continue;
            this.ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return this.ts.size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gewId, double from, double till) {
        return this.gd.getIds(table, gewId, from, till).size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gewId, double from, double till) {
        return this.gd.getLength(table, gewId, from, till);
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, int gewId, double from, double till) {
        return this.gd.getCount(table, gewId, from, till);
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, int gewId, double from, double till) {
        return this.gd.getLength(table, gewId, from, till);
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gewId, double from, double till) {
        return this.gd.getIds(table, gewId, from, till).size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner) {
        this.ts.clear();
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner)) continue;
            this.ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return this.ts.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, String owner) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner)) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, int gemNr, String owner) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        this.ts.clear();
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            this.ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return this.ts.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, String owner, int wdm) {
        int count = 0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, String owner, int wdm) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner, int wdm) {
        this.ts.clear();
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            this.ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return this.ts.size();
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, String owner) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner) {
        this.ts.clear();
        for (KatasterGewObj tmp : this.parts) {
            if (!tmp.getOwner().equals(owner)) continue;
            this.ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return this.ts.size();
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

