/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewByArea;
import de.cismet.cids.custom.watergis.server.search.AllLineObjects;
import de.cismet.cids.custom.watergis.server.search.AllPunktObjects;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.KatasterFlaechenReportDialog;
import de.cismet.watergis.reports.KatasterFlaechenData;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.Flaeche;
import de.cismet.watergis.reports.types.GewFlObj;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.apache.log4j.Logger;

public class KatasterflaechenReport {
    private static final Logger LOG = Logger.getLogger(KatasterflaechenReport.class);
    private static ImageIcon annotationIco = new ImageIcon(KatasterflaechenReport.class.getResource("/de/cismet/watergis/reports/Station.png"));
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "group", "gmdName", "code", "anzahlGu", "gu"};
    private final Map<Object, List<GewFlObj>> flPartMap = new HashMap<Object, List<GewFlObj>>();
    private final Map<Object, KatasterFlaechenData> flDataMap = new HashMap<Object, KatasterFlaechenData>();
    private final List<String> sheetNames = new ArrayList<String>();

    public File createFlaechenReport(Flaeche[] fl, int[] gew) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("datum", df.format(new Date()));
        parameters.put("gemeinden", fl.length);
        parameters.put("wasserschutz", KatasterFlaechenReportDialog.getInstance().isWsg());
        parameters.put("ueber", KatasterFlaechenReportDialog.getInstance().isSchutzgebiete());
        parameters.put("ben", KatasterFlaechenReportDialog.getInstance().isBen());
        parameters.put("aus", KatasterFlaechenReportDialog.getInstance().isAus());
        parameters.put("pegel", KatasterFlaechenReportDialog.getInstance().isPegel());
        parameters.put("gb", KatasterFlaechenReportDialog.getInstance().isGb());
        parameters.put("sb", KatasterFlaechenReportDialog.getInstance().isSb());
        parameters.put("prof", KatasterFlaechenReportDialog.getInstance().isProf());
        parameters.put("sbef", KatasterFlaechenReportDialog.getInstance().isSbef());
        parameters.put("ubef", KatasterFlaechenReportDialog.getInstance().isUbef());
        parameters.put("bbef", KatasterFlaechenReportDialog.getInstance().isBbef());
        parameters.put("rl", KatasterFlaechenReportDialog.getInstance().isRl());
        parameters.put("d", KatasterFlaechenReportDialog.getInstance().isD());
        parameters.put("due", KatasterFlaechenReportDialog.getInstance().isDue());
        parameters.put("scha", KatasterFlaechenReportDialog.getInstance().isScha());
        parameters.put("wehr", KatasterFlaechenReportDialog.getInstance().isWehr());
        parameters.put("schw", KatasterFlaechenReportDialog.getInstance().isSchw());
        parameters.put("anlp", KatasterFlaechenReportDialog.getInstance().isAnlp());
        parameters.put("anll", KatasterFlaechenReportDialog.getInstance().isAnll());
        parameters.put("kr", KatasterFlaechenReportDialog.getInstance().isKr());
        parameters.put("ea", KatasterFlaechenReportDialog.getInstance().isEa());
        parameters.put("deich", KatasterFlaechenReportDialog.getInstance().isDeich());
        parameters.put("ughz", KatasterFlaechenReportDialog.getInstance().isUghz());
        parameters.put("leis", KatasterFlaechenReportDialog.getInstance().isLeis());
        parameters.put("tech", KatasterFlaechenReportDialog.getInstance().isTech());
        parameters.put("perGew", KatasterFlaechenReportDialog.getInstance().isPerGew());
        parameters.put("perAbschn", KatasterFlaechenReportDialog.getInstance().isPerPart());
        parameters.put("sumGu", KatasterFlaechenReportDialog.getInstance().isSumGu());
        parameters.put("wdm", KatasterFlaechenReportDialog.getInstance().isPerWdm());
        parameters.put("thema", KatasterFlaechenReportDialog.getInstance().getFlaechenService().getName());
        parameters.put("attrName1", KatasterFlaechenReportDialog.getInstance().getAttr1());
        parameters.put("attrName2", KatasterFlaechenReportDialog.getInstance().getAttr2());
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)KatasterflaechenReport.class.getResourceAsStream("/de/cismet/watergis/reports/flaechen.jasper"));
        this.init(fl, gew);
        dataSources.put("gemeinden", this.getGemeindenAll());
        if (KatasterFlaechenReportDialog.getInstance().isSumGu()) {
            if (KatasterFlaechenReportDialog.getInstance().isPerWdm()) {
                dataSources.put("guWidmung", this.getGuWidmung());
            } else {
                dataSources.put("gu", this.getGuTable());
            }
        }
        if (KatasterFlaechenReportDialog.getInstance().isPerGew() && !KatasterFlaechenReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesser", this.getGewaesser());
        } else if (KatasterFlaechenReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesserAbschnitt", this.getGewaesserAbschnitt());
        }
        if (KatasterFlaechenReportDialog.getInstance().isSumGu()) {
            if (KatasterFlaechenReportDialog.getInstance().isPerWdm()) {
                dataSources.put("gewaesserGuAbschnitt", this.getGewaesserGuWidmung());
            } else {
                dataSources.put("gewaesserGu", this.getGewaesserGu());
            }
        }
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        File file = new File(KatasterFlaechenReportDialog.getInstance().getPath() + "/Kataster_Fl\u00e4chen.xlsx");
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
    }

    private void init(Flaeche[] fl, int[] routeIds) throws Exception {
        for (Flaeche f : fl) {
            this.flPartMap.put(f.getAttr1(), this.getAllRoutes(f, routeIds));
            Integer[] idList = this.getGew(f.getAttr1()).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length == 0) {
                routes = null;
            }
            this.flDataMap.put(f.getAttr1(), new KatasterFlaechenData(f.getAttr1(), f.getAttr2(), routes));
        }
    }

    private List<GewFlObj> getAllRoutes(Flaeche fl, int[] routeIds) throws Exception {
        AllGewByArea search = new AllGewByArea(routeIds, this.getAllowedWdms(), fl.getGeom());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GewFlObj> objList = new ArrayList<GewFlObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GewFlObj((Integer)f.get(0), (String)f.get(1), (String)f.get(5), (String)f.get(6), (String)f.get(7), (Integer)f.get(8), (String)f.get(2), (Double)f.get(3), (Double)f.get(4), fl.getAttr1()));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (KatasterFlaechenReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (KatasterFlaechenReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (KatasterFlaechenReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (KatasterFlaechenReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (KatasterFlaechenReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGemeindenAll() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add(KatasterFlaechenReportDialog.getInstance().getFlaechenService().getName());
        for (Object gem : this.flDataMap.keySet()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("name", String.valueOf(this.flDataMap.get(gem).getAttr2()));
            feature.put("nummer", gem);
            feature.put("gew_a", this.getCountGewAll(gem));
            feature.put("gew_l", this.getLengthGewAll(gem));
            feature.put("offene_a", this.getCountOffeneAbschn(gem));
            feature.put("offene_l", this.getLengthOffeneAbschn(gem));
            feature.put("see_a", this.getCountLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem));
            feature.put("see_l", this.getLengthLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem));
            feature.put("geschl_a", this.getCountGeschlAbschn(gem));
            feature.put("geschl_l", this.getLengthGeschlAbschn(gem));
            feature.put("wschutz_a", this.getCountLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem));
            feature.put("wschutz_l", this.getLengthLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem));
            feature.put("ueber_a", this.getCountLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem));
            feature.put("ueber_l", this.getLengthLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem));
            feature.put("ben_a", this.getCountPointObjectsAll(AllPunktObjects.Table.wr_wbu_ben, gem));
            feature.put("aus_a", this.getCountPointObjectsAll(AllPunktObjects.Table.wr_wbu_aus, gem));
            feature.put("pegel_a", this.getCountPointObjectsAll(AllPunktObjects.Table.mn_ow_pegel, gem));
            feature.put("gb_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_gb, gem));
            feature.put("gb_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_gb, gem));
            feature.put("sb_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_sb, gem));
            feature.put("sb_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_sb, gem));
            feature.put("prof_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_prof, gem));
            feature.put("prof_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_prof, gem));
            feature.put("sbef_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_sbef, gem));
            feature.put("sbef_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_sbef, gem));
            feature.put("ubef_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_ubef, gem));
            feature.put("ubef_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_ubef, gem));
            feature.put("bbef_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_bbef, gem));
            feature.put("bbef_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_bbef, gem));
            feature.put("rl_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_rl, gem));
            feature.put("rl_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_rl, gem));
            feature.put("d_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_d, gem));
            feature.put("d_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_d, gem));
            feature.put("due_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_due, gem));
            feature.put("due_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_due, gem));
            feature.put("scha_a", this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_scha, gem));
            feature.put("wehr_a", this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_wehr, gem));
            feature.put("schw_a", this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_schw, gem));
            feature.put("anlp_a", this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_anlp, gem));
            feature.put("anll_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_anll, gem));
            feature.put("anll_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_anll, gem));
            feature.put("kr_a", this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_kr, gem));
            feature.put("ea_a", this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_ea, gem));
            feature.put("deich_a", this.getCountLineObjectsAll(AllLineObjects.Table.deich_ft, gem));
            feature.put("deich_l", this.getLengthLineObjectsAll(AllLineObjects.Table.deich_ft, gem));
            feature.put("ughz_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_ughz, gem));
            feature.put("ughz_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_ughz, gem));
            feature.put("leis_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_leis, gem));
            feature.put("leis_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_leis, gem));
            feature.put("tech_a", this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_tech, gem));
            feature.put("tech_l", this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_tech, gem));
            features.add(feature);
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object gem : this.flDataMap.keySet()) {
            this.sheetNames.add(String.valueOf(this.flDataMap.get(gem).getAttr2()));
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (int gew : this.getGew(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("gmdName", String.valueOf(this.flDataMap.get(gem).getAttr2()));
                feature.put("gmdNummer", String.valueOf(gem));
                feature.put("anzahlGew", this.getCountGewAll(gem));
                feature.put("group", String.valueOf(gem));
                feature.put("code", this.getBaCd(gem, gew));
                feature.put("gewName", this.getGewName(gem, gew));
                feature.put("gewLaenge", this.getLengthGew(gem, gew));
                feature.put("offene_a", this.getCountOffeneAbschn(gem, gew));
                feature.put("offene_l", this.getLengthOffeneAbschn(gem, gew));
                feature.put("see_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, gew));
                feature.put("see_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, gew));
                feature.put("geschl_a", this.getCountGeschlAbschn(gem, gew));
                feature.put("geschl_l", this.getLengthGeschlAbschn(gem, gew));
                feature.put("wschutz_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, gew));
                feature.put("wschutz_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, gew));
                feature.put("ueber_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, gew));
                feature.put("ueber_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, gew));
                feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, gem, gew));
                feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, gem, gew));
                feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, gem, gew));
                feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, gem, gew));
                feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, gem, gew));
                feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, gem, gew));
                feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, gem, gew));
                feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, gem, gew));
                feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gem, gew));
                feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, gew));
                feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, gew));
                feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, gew));
                feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, gew));
                feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, gew));
                feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, gew));
                feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, gem, gew));
                feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, gem, gew));
                feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, gem, gew));
                feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, gem, gew));
                feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, gem, gew));
                feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, gem, gew));
                feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, gem, gew));
                feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, gem, gew));
                feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, gem, gew));
                feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, gem, gew));
                feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, gem, gew));
                feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, gem, gew));
                feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, gem, gew));
                feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, gem, gew));
                feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, gem, gew));
                feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, gem, gew));
                feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, gew));
                feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, gew));
                feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, gem, gew));
                feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, gem, gew));
                feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, gem, gew));
                feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, gem, gew));
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnitt() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object gem : this.flDataMap.keySet()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
            String code = null;
            this.sheetNames.add(String.valueOf(this.flDataMap.get(gem).getAttr2()));
            for (GewFlObj gew : this.flPartMap.get(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("gmdName", String.valueOf(this.flDataMap.get(gem).getAttr2()));
                feature.put("gmdNummer", String.valueOf(gem));
                feature.put("anzahlGew", this.getCountGewAll(gem));
                feature.put("anzahlAbschn", this.flPartMap.get(gem).size());
                feature.put("group", String.valueOf(gem));
                feature.put("code", this.getBaCd(gem, gew.getId()));
                feature.put("gewName", gew.getGewName());
                feature.put("von", this.convertStation(gew.getFrom()));
                feature.put("bis", this.convertStation(gew.getTill()));
                feature.put("gewLaenge", gew.getLength());
                feature.put("offene_a", this.getCountOffeneAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("offene_l", this.getLengthOffeneAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("see_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("see_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("geschl_a", this.getCountGeschlAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("geschl_l", this.getLengthGeschlAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("wschutz_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("wschutz_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ueber_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ueber_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                String newCode = this.getBaCd(gem, gew.getId());
                if (code != null && !code.equals(newCode)) {
                    features.add(this.createKumFeature(featureListGewKum, true));
                    featureListGewKum.clear();
                }
                code = newCode;
                features.add(feature);
                featureListKum.add(feature);
                featureListGewKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGu() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object gem : this.flDataMap.keySet()) {
            this.sheetNames.add("GU " + String.valueOf(this.flDataMap.get(gem).getAttr2()));
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("gmdName", String.valueOf(this.flDataMap.get(gem).getAttr2()));
                feature.put("gmdNummer", String.valueOf(gem));
                feature.put("anzahlGu", this.getCountGu(gem));
                feature.put("group", String.valueOf(gem));
                feature.put("gu", this.getGuId(gem, guName));
                feature.put("guName", guName);
                feature.put("gewAnzahl", this.getCountGew(gem, guName));
                feature.put("gewLaenge", this.getLengthGew(gem, guName));
                feature.put("offene_a", this.getCountOffeneAbschn(gem, guName));
                feature.put("offene_l", this.getLengthOffeneAbschn(gem, guName));
                feature.put("see_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, guName));
                feature.put("see_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, guName));
                feature.put("geschl_a", this.getCountGeschlAbschn(gem, guName));
                feature.put("geschl_l", this.getLengthGeschlAbschn(gem, guName));
                feature.put("wschutz_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, guName));
                feature.put("wschutz_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, guName));
                feature.put("ueber_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, guName));
                feature.put("ueber_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, guName));
                feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, gem, guName));
                feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, gem, guName));
                feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, gem, guName));
                feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, gem, guName));
                feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, gem, guName));
                feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, gem, guName));
                feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, gem, guName));
                feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, gem, guName));
                feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gem, guName));
                feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, guName));
                feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, guName));
                feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, guName));
                feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, guName));
                feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, guName));
                feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, guName));
                feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, gem, guName));
                feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, gem, guName));
                feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, gem, guName));
                feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, gem, guName));
                feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, gem, guName));
                feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, gem, guName));
                feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, gem, guName));
                feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, gem, guName));
                feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, gem, guName));
                feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, gem, guName));
                feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, gem, guName));
                feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, gem, guName));
                feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, gem, guName));
                feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, gem, guName));
                feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, gem, guName));
                feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, gem, guName));
                feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, guName));
                feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, guName));
                feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, gem, guName));
                feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, gem, guName));
                feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, gem, guName));
                feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, gem, guName));
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Object gem : this.flDataMap.keySet()) {
            this.sheetNames.add("GU " + String.valueOf(this.flDataMap.get(gem).getAttr2()));
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(gem)) {
                ArrayList<Map<String, Object>> featureListGuKum = new ArrayList<Map<String, Object>>();
                for (Integer wdm : this.getWidmung(gem, guName)) {
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    feature.put("gmdName", String.valueOf(this.flDataMap.get(gem).getAttr2()));
                    feature.put("gmdNummer", String.valueOf(gem));
                    feature.put("anzahlGu", this.getCountGu(gem));
                    feature.put("group", String.valueOf(gem));
                    feature.put("gu", this.getGuId(gem, guName));
                    feature.put("guName", guName);
                    feature.put("widmung", wdm);
                    feature.put("gew_a", this.getCountGew(gem, guName, wdm));
                    feature.put("gew_l", this.getLengthGew(gem, guName, wdm));
                    feature.put("offene_a", this.getCountOffeneAbschn(gem, guName, wdm));
                    feature.put("offene_l", this.getLengthOffeneAbschn(gem, guName, wdm));
                    feature.put("see_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, (int)wdm));
                    feature.put("see_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, gem, (int)wdm));
                    feature.put("geschl_a", this.getCountGeschlAbschn(gem, guName, wdm));
                    feature.put("geschl_l", this.getLengthGeschlAbschn(gem, guName, wdm));
                    feature.put("wschutz_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, (int)wdm));
                    feature.put("wschutz_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, gem, (int)wdm));
                    feature.put("ueber_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, (int)wdm));
                    feature.put("ueber_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, gem, (int)wdm));
                    feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, gem, (int)wdm));
                    feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, gem, (int)wdm));
                    feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, gem, (int)wdm));
                    feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, gem, (int)wdm));
                    feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, gem, (int)wdm));
                    feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, gem, (int)wdm));
                    feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, gem, (int)wdm));
                    feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, gem, (int)wdm));
                    feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, gem, (int)wdm));
                    feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, (int)wdm));
                    feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, gem, (int)wdm));
                    feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, (int)wdm));
                    feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, gem, (int)wdm));
                    feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, (int)wdm));
                    feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, gem, (int)wdm));
                    feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, gem, (int)wdm));
                    feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, gem, (int)wdm));
                    feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, gem, (int)wdm));
                    feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, gem, (int)wdm));
                    feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, gem, (int)wdm));
                    feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, gem, (int)wdm));
                    feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, gem, (int)wdm));
                    feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, gem, (int)wdm));
                    feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, gem, (int)wdm));
                    feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, gem, (int)wdm));
                    feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, gem, (int)wdm));
                    feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, gem, (int)wdm));
                    feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, gem, (int)wdm));
                    feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, gem, (int)wdm));
                    feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, gem, (int)wdm));
                    feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, gem, (int)wdm));
                    feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, (int)wdm));
                    feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, gem, (int)wdm));
                    feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, gem, (int)wdm));
                    feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, gem, (int)wdm));
                    feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, gem, (int)wdm));
                    feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, gem, (int)wdm));
                    features.add(feature);
                    featureListKum.add(feature);
                    featureListGuKum.add(feature);
                }
                features.add(this.createKumFeature(featureListGuKum, true));
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuTable() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("anzahlGu", this.getCountGu());
            feature.put("group", 1);
            feature.put("gu", this.getGuId(guName));
            feature.put("guName", guName);
            feature.put("gewAnzahl", this.getCountGew(guName));
            feature.put("gewLaenge", this.getLengthGew(guName));
            feature.put("offene_a", this.getCountOffeneAbschn(guName));
            feature.put("offene_l", this.getLengthOffeneAbschn(guName));
            feature.put("see_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, guName));
            feature.put("see_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, guName));
            feature.put("geschl_a", this.getCountGeschlAbschn(guName));
            feature.put("geschl_l", this.getLengthGeschlAbschn(guName));
            feature.put("wschutz_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, guName));
            feature.put("wschutz_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, guName));
            feature.put("ueber_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, guName));
            feature.put("ueber_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, guName));
            feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName));
            feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName));
            feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName));
            feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName));
            feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName));
            feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName));
            feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName));
            feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, guName));
            feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName));
            feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName));
            feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName));
            feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName));
            feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName));
            feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName));
            feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName));
            feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName));
            feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName));
            feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName));
            feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName));
            feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName));
            feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName));
            feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName));
            feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName));
            feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName));
            feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName));
            feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName));
            feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName));
            feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName));
            feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName));
            feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName));
            feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName));
            feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName));
            feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName));
            feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName));
            feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName));
            feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName));
            feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName));
            features.add(feature);
            featureListKum.add(feature);
        }
        features.add(this.createKumFeature(featureListKum, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            ArrayList<Map<String, Object>> featureListGuKum = new ArrayList<Map<String, Object>>();
            for (Integer wdm : this.getWidmung(guName)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("anzahlGu", this.getCountGu());
                feature.put("gu", this.getGuId(guName));
                feature.put("guName", guName);
                feature.put("widmung", wdm);
                feature.put("gew_a", this.getCountGew(guName, wdm));
                feature.put("gew_l", this.getLengthGew(guName, (int)wdm));
                feature.put("offene_a", this.getCountOffeneAbschn(guName, (int)wdm));
                feature.put("offene_l", this.getLengthOffeneAbschn(guName, (int)wdm));
                feature.put("see_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, guName, (int)wdm));
                feature.put("see_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.sg_see, guName, (int)wdm));
                feature.put("geschl_a", this.getCountGeschlAbschn(guName, (int)wdm));
                feature.put("geschl_l", this.getLengthGeschlAbschn(guName, (int)wdm));
                feature.put("wschutz_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, guName, (int)wdm));
                feature.put("wschutz_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_wsg, guName, (int)wdm));
                feature.put("ueber_a", this.getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, guName, (int)wdm));
                feature.put("ueber_l", this.getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable.wr_sg_uesg, guName, (int)wdm));
                feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName, (int)wdm));
                feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName, (int)wdm));
                feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName, (int)wdm));
                feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm));
                feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm));
                feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm));
                feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm));
                feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm));
                feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm));
                feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm));
                feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm));
                feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm));
                feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm));
                feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm));
                feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm));
                feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm));
                feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm));
                feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm));
                feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm));
                feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm));
                feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm));
                feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName, (int)wdm));
                feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName, (int)wdm));
                feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName, (int)wdm));
                feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName, (int)wdm));
                feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm));
                feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm));
                feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName, (int)wdm));
                feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName, (int)wdm));
                feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm));
                feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm));
                feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm));
                feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm));
                feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm));
                feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm));
                feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm));
                feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm));
                features.add(feature);
                featureListKum.add(feature);
                featureListGuKum.add(feature);
            }
            features.add(this.createKumFeature(featureListGuKum, true));
        }
        features.add(this.createKumFeature(featureListKum, false));
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        kumFeature.put("summe", Boolean.TRUE);
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : firstElement.keySet()) {
            Object value = firstElement.get(key);
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Double)f.get(key)).doubleValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            kumFeature.put(key, value);
        }
        return kumFeature;
    }

    private Collection<Integer> getGew(Object attr1) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GewFlObj tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private List<GewFlObj> getGew(Object attr1, String owner) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        ArrayList<GewFlObj> list = new ArrayList<GewFlObj>();
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            list.add(tmp);
        }
        return list;
    }

    private Collection<String> getGu(Object attr1) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        TreeSet<String> ts = new TreeSet<String>();
        for (GewFlObj tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                ts.add(tmp.getOwner());
            }
        }
        return ts.descendingSet();
    }

    private String getGuId(Object attr1, String owner) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    private String getGuId(String owner) {
        for (Object attr1 : this.flPartMap.keySet()) {
            String tmp = this.getGuId(attr1, owner);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    private Integer getWdm(Object attr1, int gew) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getWidmung();
        }
        return null;
    }

    private Collection<Integer> getWidmung(Object attr1, String guName) {
        List<GewFlObj> gmdList = this.flPartMap.get(attr1);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GewFlObj gmdPart : gmdList) {
            if (!gmdPart.getOwner().equals(guName)) continue;
            ts.add(gmdPart.getWidmung());
        }
        return ts.descendingSet();
    }

    private Collection<Integer> getWidmung(String guName) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gmdList = this.flPartMap.get(attr1);
            for (GewFlObj gmdPart : gmdList) {
                if (!gmdPart.getOwner().equals(guName)) continue;
                ts.add(gmdPart.getWidmung());
            }
        }
        return ts.descendingSet();
    }

    private int getCountGu(Object attr1) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        TreeSet<String> ts = new TreeSet<String>();
        for (GewFlObj tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.size();
    }

    private int getCountGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                ts.add(tmp.getOwner());
            }
        }
        return ts.size();
    }

    private String getBaCd(Object attr1, int gew) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(Object attr1, int gew) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private int getCountGewAll(Object attr1) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        TreeSet<String> ts = new TreeSet<String>();
        for (GewFlObj tmp : gemList) {
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    private double getLengthGewAll(Object attr1) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(Object attr1, int gewId) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(Object attr1, String gu) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm) {
        double length = 0.0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGew(Object attr1, String gu) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    private int getCountGew(String gu, int wdm) {
        int count = 0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGew(Object attr1, String gu, int wdm) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGew(Object attr1, String gu, int wdm) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGew(String gu) {
        double length = 0.0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu)) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGew(String gu) {
        int count = 0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu)) continue;
                ++count;
            }
        }
        return count;
    }

    private int getCountOffeneAbschn(Object attr1) {
        return this.getCountOffeneAbschn(attr1, -1);
    }

    private double getLengthOffeneAbschn(Object attr1) {
        return this.getLengthOffeneAbschn(attr1, -1);
    }

    private int getCountGeschlAbschn(Object attr1) {
        return this.getCountGeschlAbschn(attr1, -1);
    }

    private double getLengthGeschlAbschn(Object attr1) {
        return this.getLengthGeschlAbschn(attr1, -1);
    }

    private int getCountOffeneAbschn(Object attr1, int gewId) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(Object attr1, int gewId) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(Object attr1, int gewId) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(Object attr1, int gewId) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(Object attr1, int gewId, double from, double till) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(Object attr1, int gewId, double from, double till) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountGeschlAbschn(Object attr1, int gewId, double from, double till) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(Object attr1, int gewId, double from, double till) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountOffeneAbschn(Object attr1, String owner) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(Object attr1, String owner) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(Object attr1, String owner) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(Object attr1, String owner) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner, int wdm) {
        int count = 0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner, int wdm) {
        double length = 0.0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner, int wdm) {
        int count = 0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner, int wdm) {
        double length = 0.0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountOffeneAbschn(Object attr1, String owner, int wdm) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(Object attr1, String owner, int wdm) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(Object attr1, String owner, int wdm) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(Object attr1, String owner, int wdm) {
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner) {
        int count = 0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner) {
        double length = 0.0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner) {
        int count = 0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner) {
        double length = 0.0;
        for (Object attr1 : this.flPartMap.keySet()) {
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountLineObjectsAll(AllLineObjects.Table table, Object attr1) {
        return this.getCountLineObjects(table, attr1, -1);
    }

    private double getLengthLineObjectsAll(AllLineObjects.Table table, Object attr1) {
        return this.getLengthLineObjects(table, attr1, -1);
    }

    private int getCountLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable table, Object attr1) {
        return this.getCountLineObjects(table, attr1, -1);
    }

    private double getLengthLineObjectsAll(KatasterFlaechenData.LineFromPolygonTable table, Object attr1) {
        return this.getLengthLineObjects(table, attr1, -1);
    }

    private int getCountPointObjectsAll(AllPunktObjects.Table table, Object attr1) {
        return this.getCountPointObjects(table, attr1, -1);
    }

    private int getCountLineObjects(AllLineObjects.Table table, Object attr1, int gewId) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(AllLineObjects.Table table, Object attr1, int gewId) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, int gewId) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, int gewId) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, Object attr1, int gewId) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private int getCountLineObjects(AllLineObjects.Table table, Object attr1, int gewId, double from, double till) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        return gemData.getCount(table, gewId, from, till);
    }

    private double getLengthLineObjects(AllLineObjects.Table table, Object attr1, int gewId, double from, double till) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        return gemData.getLength(table, gewId, from, till);
    }

    private int getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, int gewId, double from, double till) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        return gemData.getCount(table, gewId, from, till);
    }

    private double getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, int gewId, double from, double till) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        return gemData.getLength(table, gewId, from, till);
    }

    private int getCountPointObjects(AllPunktObjects.Table table, Object attr1, int gewId, double from, double till) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        return gemData.getCount(table, gewId, from, till);
    }

    private int getCountLineObjects(AllLineObjects.Table table, Object attr1, String owner) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(AllLineObjects.Table table, Object attr1, String owner) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, String owner) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, String owner) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, Object attr1, String owner) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private int getCountLineObjects(AllLineObjects.Table table, Object attr1, String owner, int wdm) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(AllLineObjects.Table table, Object attr1, String owner, int wdm) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, String owner, int wdm) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable table, Object attr1, String owner, int wdm) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, Object attr1, String owner, int wdm) {
        KatasterFlaechenData gemData = this.flDataMap.get(attr1);
        List<GewFlObj> gemList = this.flPartMap.get(attr1);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        int count = 0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return count;
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        double length = 0.0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable table, String owner, int wdm) {
        int count = 0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return count;
    }

    private double getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable table, String owner, int wdm) {
        double length = 0.0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner, int wdm) {
        int count = 0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return count;
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner) {
        int count = 0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return count;
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner) {
        double length = 0.0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountLineObjects(KatasterFlaechenData.LineFromPolygonTable table, String owner) {
        int count = 0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return count;
    }

    private double getLengthLineObjects(KatasterFlaechenData.LineFromPolygonTable table, String owner) {
        double length = 0.0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                length += (double)gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner) {
        int count = 0;
        for (Object attr1 : this.flDataMap.keySet()) {
            KatasterFlaechenData gemData = this.flDataMap.get(attr1);
            List<GewFlObj> gemList = this.flPartMap.get(attr1);
            for (GewFlObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                count += gemData.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return count;
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

