/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewBySb;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.reports.types.SbObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class SbHelper {
    private List<SbObj> objList;

    public SbHelper(int[] routeIds, int[] allowedWdmArray) throws Exception {
        this.init(routeIds, allowedWdmArray);
    }

    private void init(int[] routeIds, int[] allowedWdmArray) throws Exception {
        this.objList = this.getAllRoutes(routeIds, allowedWdmArray);
    }

    private List<SbObj> getAllRoutes(int[] routeIds, int[] allowedWdmArray) throws Exception {
        AllGewBySb search = new AllGewBySb(routeIds, allowedWdmArray);
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<SbObj> objList = new ArrayList<SbObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new SbObj((Integer)f.get(0), (String)f.get(1), (String)f.get(7), (String)f.get(8), (String)f.get(9), (Integer)f.get(10), (String)f.get(2), (Double)f.get(3), (Double)f.get(4), (String)f.get(5), (String)f.get(6), (Double)f.get(11), (String)f.get(12)));
            }
        }
        return objList;
    }

    public String getBaCd(int gew) {
        for (SbObj tmp : this.objList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    public String getGewName(int gew) {
        for (SbObj tmp : this.objList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    public String getSbName(String sb) {
        for (SbObj tmp : this.objList) {
            if (tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            return tmp.getSbName();
        }
        return null;
    }

    public Collection<Integer> getGew() {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.objList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    public Collection<Integer> getGew(String gu, Integer wdm, String sb) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue() || tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    public Collection<String> getGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj tmp : this.objList) {
            ts.add(tmp.getGuName());
        }
        return ts.descendingSet();
    }

    public Collection<Integer> getWidmung(String gu) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.objList) {
            if (tmp.getGuName() == null || !tmp.getGuName().equals(gu)) continue;
            ts.add(tmp.getWidmung());
        }
        return ts.descendingSet();
    }

    public Collection<String> getSb(String gu, Integer wdm) {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj tmp : this.objList) {
            if (tmp.getGuName() == null || !tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            ts.add(tmp.getSb());
        }
        return ts.descendingSet();
    }

    public Integer getSbCount(String gu) {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj tmp : this.objList) {
            if (tmp.getGuName() == null || !tmp.getGuName().equals(gu)) continue;
            ts.add(tmp.getSb());
        }
        return ts.size();
    }

    public Collection<SbObj> getSbPart(String gu, Integer wdm, String sb) {
        ArrayList<SbObj> ts = new ArrayList<SbObj>();
        for (SbObj tmp : this.objList) {
            if (tmp.getGuName() == null || !tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue() || tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            ts.add(tmp);
        }
        return ts;
    }

    public Collection<SbObj> getSbPart(String gu, Integer wdm, String sb, Integer gewId) {
        ArrayList<SbObj> ts = new ArrayList<SbObj>();
        for (SbObj tmp : this.objList) {
            if (tmp.getId() != gewId.intValue() || tmp.getGuName() == null || !tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue() || tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            ts.add(tmp);
        }
        return ts;
    }

    public String getGuId(String owner) {
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    public Collection<SbObj> getAbschnitte() {
        return this.objList;
    }

    public Collection<SbObj> getAbschnitteOffen() {
        ArrayList<SbObj> abschnList = new ArrayList<SbObj>();
        for (SbObj tmp : this.objList) {
            if (!tmp.getArt().equals("p")) continue;
            abschnList.add(tmp);
        }
        return abschnList;
    }

    public int getCountGewAll() {
        return this.getCountGewAll(-1);
    }

    public double getLengthGewAll() {
        return this.getLengthGewAll(-1);
    }

    public int getCountGewAll(int gewId) {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    public double getLengthGewAll(int gewId) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn() {
        return this.getLengthOffeneAbschn(-1);
    }

    public double getLengthOffeneAbschn(int gewId) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(int gewId, double from, double till) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    public double getLengthOffeneAbschn(String gu, int wdm, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (tmp.getGuName() == null || !tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm || tmp.getSb() == null || !tmp.getSb().equals(sb) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(String gu, int wdm, String sb, Integer gew) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (tmp.getId() != gew.intValue() || tmp.getGuName() == null || !tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm || tmp.getSb() == null || !tmp.getSb().equals(sb) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public int getCountOffeneAbschn(String owner) {
        int count = 0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(owner) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    public double getLengthOffeneAbschn(String owner) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(owner) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(String owner, Integer wdm) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm.intValue() || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public int getCountGewAll(String gu) {
        int count = 0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    public int getCountGewAll(String gu, Integer wdm) {
        int count = 0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            ++count;
        }
        return count;
    }

    public int getCountGewAll(String gu, Integer wdm, String sb) {
        int count = 0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue() || tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            ++count;
        }
        return count;
    }

    public int getCountGewAll(String gu, Integer wdm, String sb, Integer gewId) {
        int count = 0;
        for (SbObj tmp : this.objList) {
            if (tmp.getId() != gewId.intValue() || !tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue() || tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            ++count;
        }
        return count;
    }

    public double getLengthGewAll(String gu) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthGewAll(String gu, Integer wdm) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthGewAll(String gu, Integer wdm, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue() || tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthGewAll(String gu, Integer wdm, String sb, Integer gewId) {
        double length = 0.0;
        for (SbObj tmp : this.objList) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm.intValue() || tmp.getSb() == null || !tmp.getSb().equals(sb)) continue;
            length += tmp.getLength();
        }
        return length;
    }
}

