/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports.types;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class FeatureDataSource
implements JRDataSource {
    private int index = -1;
    private final List<Map<String, Object>> features;

    public FeatureDataSource(FeatureDataSource copy) {
        this.features = copy.features;
    }

    public FeatureDataSource(List<Map<String, Object>> features) {
        this.features = features;
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.features.isEmpty() && this.index == 0) {
            return true;
        }
        return this.index < this.features.size();
    }

    public Object getFieldValue(JRField jrf) throws JRException {
        if (this.features.isEmpty()) {
            return null;
        }
        Object o = this.features.get(this.index).get(jrf.getName());
        if (o instanceof Double) {
            return this.round((Double)o);
        }
        return o;
    }

    private double round(double value) {
        return (double)((int)(value * 100.0 + 0.5)) / 100.0;
    }
}

