/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.search.QuerySearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureWithId;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.watergis.utils.TooManyResultsException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public abstract class AbstractSearchAndSelectThread
extends SwingWorker<List<Feature>, Void> {
    protected static final Logger LOG = Logger.getLogger(AbstractSearchAndSelectThread.class);
    protected final Object layer;
    protected final String query;
    protected final QuerySearch querySearch;

    public AbstractSearchAndSelectThread(Object layer, String query, QuerySearch querySearch) {
        this.layer = layer;
        this.query = query;
        this.querySearch = querySearch;
    }

    @Override
    protected List<Feature> doInBackground() throws Exception {
        List features = null;
        if (this.layer instanceof WebFeatureService) {
            WebFeatureService wfs = (WebFeatureService)this.layer;
            try {
                Element e = (Element)wfs.getQueryElement().clone();
                Element queryElement = e.getChild("Query", Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs"));
                queryElement.removeChild("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                Element filterElement = new Element("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                SAXBuilder builder = new SAXBuilder();
                Document d = builder.build((Reader)new StringReader(this.query));
                filterElement.addContent((Content)((Element)d.getRootElement().clone()));
                queryElement.addContent(0, (Content)filterElement);
                features = wfs.getFeatureFactory().createFeatures((Object)FeatureServiceUtilities.elementToString((Element)e), (BoundingBox)this.getServiceBounds(), null, 0, 0, null);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while retrieving features", (Throwable)ex);
            }
        } else if (this.layer instanceof AbstractFeatureService) {
            int maxPageSize;
            AbstractFeatureService fs = (AbstractFeatureService)this.layer;
            int limit = 0;
            if (this.layer instanceof CidsLayer && (maxPageSize = ((CidsLayer)this.layer).getMaxFeaturesPerPage()) > 0) {
                limit = maxPageSize + 1;
            }
            features = fs.getFeatureFactory().createFeatures((Object)this.query, (BoundingBox)this.getServiceBounds(), null, 0, limit, null);
            if (limit > 0 && features.size() == limit) {
                throw new TooManyResultsException();
            }
        }
        return features;
    }

    @Override
    protected abstract void done();

    private boolean isFeatureInList(FeatureWithId f, List<FeatureWithId> list) {
        for (FeatureWithId tmp : list) {
            if (tmp.getId() != f.getId()) continue;
            return true;
        }
        return false;
    }

    private XBoundingBox getServiceBounds() {
        Geometry g = ZoomToLayerWorker.getServiceBounds((RetrievalServiceLayer)((RetrievalServiceLayer)this.layer));
        XBoundingBox bounds = null;
        if (g != null) {
            bounds = new XBoundingBox(g);
            String crs = CismapBroker.getInstance().getSrs().getCode();
            try {
                CrsTransformer trans = new CrsTransformer(crs);
                bounds = trans.transformBoundingBox(bounds);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while transforming the bounding box of the service bounds.", (Throwable)e);
            }
        }
        return bounds;
    }
}

