/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class ExifReader {
    Metadata metadata;

    public ExifReader(File file) throws ImageProcessingException, IOException {
        this.metadata = ImageMetadataReader.readMetadata((File)file);
    }

    public Point getGpsCoords() {
        Point p = null;
        GpsDirectory gpsDirectory = (GpsDirectory)this.metadata.getFirstDirectoryOfType(GpsDirectory.class);
        if (gpsDirectory != null && gpsDirectory.getGeoLocation() != null && !gpsDirectory.getGeoLocation().isZero()) {
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
            p = factory.createPoint(new Coordinate(gpsDirectory.getGeoLocation().getLongitude(), gpsDirectory.getGeoLocation().getLatitude()));
        }
        return p;
    }

    public Double getGpsDirection() throws MetadataException {
        GpsDirectory gpsDirectory = (GpsDirectory)this.metadata.getFirstDirectoryOfType(GpsDirectory.class);
        if (gpsDirectory != null) {
            return gpsDirectory.getDouble(17);
        }
        return null;
    }

    public Date getTime() {
        ExifIFD0Directory dir = (ExifIFD0Directory)this.metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        if (dir != null) {
            return dir.getDate(306);
        }
        return null;
    }

    public void printAllAttributes() {
        for (Directory directory : this.metadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                System.out.println(tag);
            }
        }
    }

    public static void main(String[] args) {
        try {
            long time = System.currentTimeMillis();
            File file = new File("/home/therter/archive/RIMG0012.JPG");
            ExifReader reader = new ExifReader(file);
            Point po = reader.getGpsCoords();
            double direction = reader.getGpsDirection();
            System.out.println(po.toText());
            System.out.println(direction);
            System.out.println("Zeit " + (System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

