/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FeatureServiceHelper {
    private static final Logger LOG = Logger.getLogger(FeatureServiceHelper.class);

    public static FeatureServiceFeature mergeFeatures(FeatureServiceFeature primaryFeature, FeatureServiceFeature secondaryFeature, LayerProperties newLayerProperties, List<String> secondaryFeatureProperties, String distanceField) {
        DefaultFeatureServiceFeature feature = new DefaultFeatureServiceFeature(primaryFeature);
        Map newFeatureServiceAttributes = newLayerProperties.getFeatureService().getFeatureServiceAttributes();
        feature.setLayerProperties(newLayerProperties);
        if (secondaryFeature != null) {
            for (String key : secondaryFeatureProperties) {
                FeatureServiceAttribute attr = (FeatureServiceAttribute)newFeatureServiceAttributes.get(key);
                feature.addProperty(attr.getName(), secondaryFeature.getProperty(attr.getAlias()));
            }
            if (!distanceField.equals("")) {
                double distance = primaryFeature.getGeometry().distance(secondaryFeature.getGeometry());
                if (distance < 0.01) {
                    distance = 0.0;
                }
                feature.addProperty(distanceField, (Object)distance);
            }
        }
        return feature;
    }

    public static STRtree getFeatureTree(List<FeatureServiceFeature> features) {
        STRtree tree = new STRtree(features.size() > 3 ? features.size() : 3);
        for (FeatureServiceFeature feature : features) {
            if (feature.getGeometry() == null) continue;
            tree.insert(feature.getGeometry().getEnvelopeInternal(), (Object)feature);
        }
        tree.build();
        return tree;
    }

    public static Map<String, FeatureServiceAttribute> getSuitableFeatureServiceAttribute(Map<String, FeatureServiceAttribute> serviceAttr, Map<String, FeatureServiceAttribute> targetServiceAttr, List<String> targetAttributeOrder, List<String> newKeys) {
        HashMap<String, FeatureServiceAttribute> newAttrMap = new HashMap<String, FeatureServiceAttribute>(serviceAttr);
        HashMap<String, FeatureServiceAttribute> remainingTargetMap = new HashMap<String, FeatureServiceAttribute>(targetServiceAttr);
        for (String key : targetAttributeOrder) {
            FeatureServiceAttribute originalFeature = targetServiceAttr.get(key);
            if (originalFeature.isGeometry()) continue;
            FeatureServiceAttribute newAttr = new FeatureServiceAttribute(originalFeature.getName(), originalFeature.getType(), originalFeature.isSelected());
            newAttr.setAlias(key);
            remainingTargetMap.remove(key);
            String name = "_" + key.replace('.', '_');
            int attemption = 1;
            if (name.length() > 10) {
                name = name.substring(0, 10);
            }
            while (remainingTargetMap.containsKey(name) || serviceAttr.containsKey(name) || newAttrMap.containsKey(name)) {
                if (name.length() > 10 - (int)Math.ceil(Math.log10(attemption + 1))) {
                    name = name.substring(0, 10 - (int)Math.ceil(Math.log10(attemption + 1)));
                }
                name = name + attemption++;
            }
            newAttr.setAlias(newAttr.getName());
            newAttr.setName(name);
            newKeys.add(name);
            newAttrMap.put(name, newAttr);
        }
        return newAttrMap;
    }

    public static Map<String, FeatureServiceAttribute> getSuitableMergeFeatureServiceAttribute(Map<String, FeatureServiceAttribute> serviceAttr, Map<String, FeatureServiceAttribute> targetServiceAttr) {
        HashMap<String, FeatureServiceAttribute> newAttrMap = new HashMap<String, FeatureServiceAttribute>();
        for (String key : serviceAttr.keySet()) {
            FeatureServiceAttribute attr = serviceAttr.get(key).clone();
            if ((targetServiceAttr.containsKey(key) || targetServiceAttr.containsKey(key)) && !attr.isGeometry()) {
                newAttrMap.put(key, attr);
                continue;
            }
            if (!attr.isGeometry()) continue;
            newAttrMap.put(key, attr);
        }
        return newAttrMap;
    }

    public static Map<String, FeatureServiceAttribute> createGeometryOnlyFeatureServiceAttributes(Map<String, FeatureServiceAttribute> attributes) {
        HashMap<String, FeatureServiceAttribute> result = new HashMap<String, FeatureServiceAttribute>();
        for (String key : attributes.keySet()) {
            FeatureServiceAttribute attr = attributes.get(key);
            if (!attr.isGeometry()) continue;
            result.put(key, attr.clone());
        }
        return result;
    }

    public static Map<String, FeatureServiceAttribute> cloneFeatureServiceAttributes(Map<String, FeatureServiceAttribute> attributes) {
        HashMap<String, FeatureServiceAttribute> result = new HashMap<String, FeatureServiceAttribute>();
        for (String key : attributes.keySet()) {
            FeatureServiceAttribute attr = attributes.get(key);
            result.put(key, attr.clone());
        }
        return result;
    }

    public static List<String> getAllFieldNames(AbstractFeatureService service, Class<?> cl) {
        Map attributeMap = service.getFeatureServiceAttributes();
        ArrayList<String> resultList = new ArrayList<String>();
        if (attributeMap == null) {
            try {
                service.initAndWait();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initializing the feature service.", (Throwable)e);
            }
            attributeMap = service.getFeatureServiceAttributes();
        }
        for (String name : service.getOrderedFeatureServiceAttributes()) {
            FeatureServiceAttribute attr = (FeatureServiceAttribute)attributeMap.get(name);
            if (attr == null || cl != null && !cl.isAssignableFrom(FeatureTools.getClass((FeatureServiceAttribute)attr))) continue;
            resultList.add(name);
        }
        return resultList;
    }

    public static List<FeatureServiceFeature> getFeatures(AbstractFeatureService service, boolean onlySelected) throws Exception {
        if (onlySelected) {
            return FeatureServiceHelper.getSelectedFeatures(service);
        }
        if (!service.isInitialized()) {
            service.initAndWait();
        }
        Geometry g = ZoomToLayerWorker.getServiceBounds((RetrievalServiceLayer)service);
        XBoundingBox bb = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"retrieve all features from the service");
        }
        if (g != null) {
            bb = new XBoundingBox(g);
            try {
                CrsTransformer transformer = new CrsTransformer(CismapBroker.getInstance().getSrs().getCode());
                bb = transformer.transformBoundingBox(bb);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot transform CRS.", (Throwable)e);
            }
        }
        return service.getFeatureFactory().createFeatures(service.getQuery(), (BoundingBox)bb, null, 0, 0, null);
    }

    public static List<FeatureServiceFeature> getSelectedFeatures(AbstractFeatureService featureService) {
        ArrayList<FeatureServiceFeature> result = new ArrayList<FeatureServiceFeature>();
        List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(featureService);
        if (selectedFeatures != null) {
            for (Feature feature : selectedFeatures) {
                if (!(feature instanceof FeatureServiceFeature)) continue;
                result.add((FeatureServiceFeature)feature);
            }
        }
        return result;
    }

    public static boolean isAllOrNoneFeaturesSelected(AbstractFeatureService featureService) {
        ArrayList result = new ArrayList();
        List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(featureService);
        if (selectedFeatures == null || selectedFeatures.isEmpty()) {
            return true;
        }
        try {
            int featureCount;
            if (!featureService.isInitialized()) {
                featureService.initAndWait();
            }
            Geometry g = ZoomToLayerWorker.getServiceBounds((RetrievalServiceLayer)featureService);
            XBoundingBox bb = null;
            if (g != null) {
                bb = new XBoundingBox(g);
                try {
                    CrsTransformer transformer = new CrsTransformer(CismapBroker.getInstance().getSrs().getCode());
                    bb = transformer.transformBoundingBox(bb);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot transform CRS.", (Throwable)e);
                }
            }
            return (featureCount = featureService.getFeatureFactory().getFeatureCount(featureService.getQuery(), (BoundingBox)bb)) == selectedFeatures.size();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while determine total feature count", (Throwable)e);
            return false;
        }
    }

    public static List<FeatureServiceFeature> getSelectedCidsLayerFeatures(String metaClass) {
        ArrayList<FeatureServiceFeature> result = new ArrayList<FeatureServiceFeature>();
        List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
        if (selectedFeatures != null) {
            for (Feature feature : selectedFeatures) {
                CidsLayerFeature f;
                CidsLayer layer;
                if (!(feature instanceof CidsLayerFeature) || !(layer = (CidsLayer)(f = (CidsLayerFeature)feature).getLayerProperties().getFeatureService()).getMetaClass().getName().equalsIgnoreCase(metaClass)) continue;
                result.add((FeatureServiceFeature)feature);
            }
        }
        return result;
    }

    public static List<AbstractFeatureService> getServices(String[] geometryType) {
        ArrayList<AbstractFeatureService> serviceList = new ArrayList<AbstractFeatureService>();
        ActiveLayerModel mappingModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap treeMap = mappingModel.getMapServices();
        ArrayList keyList = new ArrayList(treeMap.keySet());
        Collections.sort(keyList, Collections.reverseOrder());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            Object service = treeMap.get(it.next());
            if (!(service instanceof AbstractFeatureService)) continue;
            AbstractFeatureService featureService = (AbstractFeatureService)service;
            if (geometryType == null) {
                serviceList.add(featureService);
                continue;
            }
            try {
                if (!featureService.isInitialized()) {
                    ((AbstractFeatureService)service).initAndWait();
                }
                if (!FeatureServiceHelper.containsIgnoreCase(geometryType, featureService.getGeometryType())) continue;
                serviceList.add(featureService);
            }
            catch (Exception e) {
                LOG.error((Object)("Error while initialising service " + ((AbstractFeatureService)service).getName()), (Throwable)e);
            }
        }
        return serviceList;
    }

    public static List<AbstractFeatureService> getCidsLayerServicesFromTree(String metaClass) {
        ArrayList<AbstractFeatureService> serviceList = new ArrayList<AbstractFeatureService>();
        ActiveLayerModel mappingModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap treeMap = mappingModel.getMapServices();
        ArrayList keyList = new ArrayList(treeMap.keySet());
        Collections.sort(keyList, Collections.reverseOrder());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            Object service = treeMap.get(it.next());
            if (!(service instanceof CidsLayer)) continue;
            CidsLayer featureService = (CidsLayer)service;
            if (metaClass == null) {
                serviceList.add((AbstractFeatureService)featureService);
                continue;
            }
            if (!featureService.getMetaClass().getName().equalsIgnoreCase(metaClass)) continue;
            serviceList.add((AbstractFeatureService)featureService);
        }
        return serviceList;
    }

    public static void addServiceLayerToTheTree(AbstractFeatureService service) {
        AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)service);
        Component capComponent = AppBroker.getInstance().getComponent(ComponentName.CAPABILITIES);
        if (capComponent instanceof CapabilityWidget) {
            CapabilityWidget cap = (CapabilityWidget)capComponent;
            cap.refreshJdbcTrees();
        }
    }

    public static H2FeatureService createNewService(Component c, List<FeatureServiceFeature> features, String tableName, List<String> attributeOrder) throws Exception {
        if (features == null || features.isEmpty()) {
            if (c != null) {
                JOptionPane.showMessageDialog(c, NbBundle.getMessage(FeatureServiceHelper.class, (String)"FeatureServiceHelper.createNewService.noFeatures.message", (Object)tableName), NbBundle.getMessage(FeatureServiceHelper.class, (String)"FeatureServiceHelper.createNewService.noFeatures.title"), 1);
            }
            return null;
        }
        H2FeatureService internalService = new H2FeatureService(tableName, "~/cismap/internalH2", tableName, null, null, features, attributeOrder);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"create the new data source");
        }
        internalService.initAndWait();
        return internalService;
    }

    public static H2FeatureService createNewService(Component c, List<FeatureServiceFeature> features, String tableName, List<FeatureServiceAttribute> newFeatureServiceAttributes, List<String> attributeOrder) throws Exception {
        if (features == null || features.isEmpty()) {
            if (c != null) {
                JOptionPane.showMessageDialog(c, NbBundle.getMessage(FeatureServiceHelper.class, (String)"FeatureServiceHelper.createNewService.noFeatures.message", (Object)tableName), NbBundle.getMessage(FeatureServiceHelper.class, (String)"FeatureServiceHelper.createNewService.noFeatures.title"), 1);
            }
            return null;
        }
        H2FeatureService internalService = new H2FeatureService(tableName, "~/cismap/internalH2", tableName, newFeatureServiceAttributes, null, features, attributeOrder, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"create the new data source");
        }
        internalService.initAndWait();
        return internalService;
    }

    public static H2FeatureService createNewService(ArrayList<ArrayList> attributes, String tableName, List<FeatureServiceAttribute> featureServiceAttributes) throws Exception {
        if (attributes.size() > 0) {
            ArrayList<DefaultFeatureServiceFeature> featureList = new ArrayList<DefaultFeatureServiceFeature>();
            int id = 0;
            DefaultLayerProperties layerProperties = new DefaultLayerProperties();
            boolean hasIdField = false;
            layerProperties.setFeatureService((AbstractFeatureService)new H2FeatureService("dummy", "dummy", null, featureServiceAttributes));
            for (int i = 0; i < attributes.size(); ++i) {
                Geometry g = null;
                HashMap<String, Object> properties = new HashMap<String, Object>(featureServiceAttributes.size());
                for (int j = attributes.get(i).size() - 1; j >= 0; --j) {
                    if (featureServiceAttributes.get(j).getName().equalsIgnoreCase("id")) {
                        hasIdField = true;
                    }
                    properties.put(featureServiceAttributes.get(j).getName(), attributes.get(i).get(j));
                }
                if (!hasIdField) {
                    properties.put("id", ++id);
                }
                DefaultFeatureServiceFeature lastFeature = new DefaultFeatureServiceFeature(id, g, (LayerProperties)layerProperties);
                lastFeature.setProperties(properties);
                featureList.add(lastFeature);
            }
            H2FeatureService.removeTableIfExists((String)tableName);
            H2FeatureService internalService = new H2FeatureService(tableName, "~/cismap/internalH2", tableName, featureServiceAttributes, featureList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"create the new data source");
            }
            internalService.initAndWait();
            return internalService;
        }
        return null;
    }

    private static boolean containsIgnoreCase(String[] array, String string) {
        for (String tmp : array) {
            if (!tmp.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

