/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jts.precision.GeometryPrecisionReducer;
import de.cismet.cids.custom.watergis.server.search.MakeValid;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.math.geometry.StaticGeometryFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class GeometryUtils {
    private static final Logger LOG = Logger.getLogger(GeometryUtils.class);

    public static Geometry makeValid(Geometry g) throws Exception {
        Geometry validGeometry = null;
        MakeValid search = new MakeValid(g);
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        if (attributes != null && !attributes.isEmpty() && !((ArrayList)attributes.get(0)).isEmpty() && ((ArrayList)attributes.get(0)).get(0) instanceof byte[]) {
            GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
            WKBReader wkbReader = new WKBReader(geomFactory);
            validGeometry = wkbReader.read((byte[])((ArrayList)attributes.get(0)).get(0));
        }
        return validGeometry;
    }

    public static Geometry[] splitGeom(Geometry geom, LineString splitLine) {
        if (geom.getGeometryType().equalsIgnoreCase("LINESTRING")) {
            Geometry[] result = new Geometry[2];
            Geometry intersectionPoint = geom.intersection((Geometry)splitLine);
            LengthIndexedLine lil = new LengthIndexedLine(geom);
            double value = lil.indexOf(intersectionPoint.getCoordinate());
            result[0] = lil.extractLine(0.0, value);
            result[1] = lil.extractLine(value, geom.getLength());
            return result;
        }
        if (geom.getGeometryType().equalsIgnoreCase("POLYGON") || geom.getGeometryType().equalsIgnoreCase("MULTIPOLYGON")) {
            return GeometryUtils.splitPolygon(geom, splitLine);
        }
        return null;
    }

    public static Geometry[] splitPolygon(Geometry sourceGeom, LineString splitter) {
        Geometry geom = sourceGeom.getBoundary();
        GeometryFactory geomFactory = sourceGeom.getFactory();
        ArrayList<Object> lines = new ArrayList<Object>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            lines.add(geom.getGeometryN(i));
        }
        lines.add(splitter);
        MultiLineString mls = geomFactory.createMultiLineString(lines.toArray(new LineString[0]));
        Point mlsPt = geomFactory.createPoint(mls.getCoordinate());
        Geometry nodedLines = mls.union((Geometry)mlsPt);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(nodedLines);
        Collection polygons = polygonizer.getPolygons();
        ArrayList<Object> polys = new ArrayList<Object>();
        for (Polygon pg : polygons) {
            if (!sourceGeom.contains((Geometry)pg.getInteriorPoint())) continue;
            polys.add(pg.clone());
        }
        return polys.toArray(new Geometry[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static Geometry unionFeatureEnvelopes(List<FeatureServiceFeature> sourceFeatures) {
        void var5_8;
        boolean first = true;
        int srid = -1;
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        for (Feature feature : sourceFeatures) {
            Geometry g = feature.getGeometry();
            if (g == null) continue;
            g = g.getEnvelope();
            if (first) {
                srid = g.getSRID();
                first = false;
            } else if (g.getSRID() != srid) {
                g = CrsTransformer.transformToGivenCrs((Geometry)g, (String)CrsTransformer.createCrsFromSrid((int)srid));
            }
            geomList.add(g);
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        Geometry geometry = factory.buildGeometry(geomList);
        if (geometry instanceof GeometryCollection) {
            Geometry geometry2 = ((GeometryCollection)geometry).union();
        }
        return var5_8;
    }

    public static Geometry unionFeatureGeometries(List<FeatureServiceFeature> sourceFeatures) {
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FIXED);
        for (FeatureServiceFeature fsf : sourceFeatures) {
            Geometry geom = fsf.getGeometry();
            if (geom == null) continue;
            geomList.add(GeometryPrecisionReducer.reduce((Geometry)geom, (PrecisionModel)pm));
        }
        if (geomList.size() == 1) {
            return (Geometry)geomList.get(0);
        }
        if (geomList.isEmpty()) {
            return null;
        }
        Geometry g = GeometryUtils.unionGeometries2(geomList);
        return g;
    }

    public static Geometry unionGeometries(List<Geometry> geom, int from, int to) {
        if (to == from) {
            return geom.get(from);
        }
        Geometry g1 = GeometryUtils.unionGeometries(geom, from, from + (to - from) / 2);
        Geometry g2 = GeometryUtils.unionGeometries(geom, from + (to - from) / 2 + 1, to);
        System.out.print("valid: " + g1.isValid());
        System.out.print("valid: " + g2.isValid());
        return g1.union(g2);
    }

    public static Geometry unionGeometries2(List<Geometry> geomList) {
        if (geomList.isEmpty()) {
            return null;
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), geomList.get(0).getSRID());
        Geometry geom = factory.buildGeometry(geomList);
        if (geom instanceof GeometryCollection) {
            geom = ((GeometryCollection)geom).union();
        }
        return geom;
    }

    public static boolean isLineOrPoint(Geometry geom) {
        return geom instanceof LineString || geom instanceof Point || geom instanceof MultiLineString || geom instanceof MultiPoint;
    }

    public static Geometry unionPolygons(List<Geometry> geomList) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), geomList.get(0).getSRID());
        ArrayList<Polygon> pList = new ArrayList<Polygon>();
        for (Geometry g : geomList) {
            if (g instanceof Polygon) {
                if (g.isValid()) {
                    pList.add((Polygon)g);
                    continue;
                }
                LOG.error((Object)("is not valid: " + g));
                continue;
            }
            if (g instanceof MultiPolygon) {
                for (int i = 0; i < g.getNumGeometries(); ++i) {
                    if (g.getGeometryN(i).isValid()) {
                        pList.add((Polygon)g.getGeometryN(i));
                        continue;
                    }
                    LOG.error((Object)("is not valid: " + g.getGeometryN(i)));
                }
                continue;
            }
            LOG.error((Object)("Not a Polygon: " + g));
        }
        GeometryCollection polygonCollection = factory.createGeometryCollection((Geometry[])pList.toArray(new Polygon[pList.size()]));
        return polygonCollection.buffer(0.0);
    }

    public static Geometry setEndpointOfLine(Geometry line, Coordinate newEndpoint) throws IllegalArgumentException {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), line.getSRID());
        boolean isMulti = line.getGeometryType().toUpperCase().contains("MULTI");
        if (!line.getGeometryType().toUpperCase().contains("LINE")) {
            throw new IllegalArgumentException("geometry is not a line");
        }
        if (isMulti && line.getNumGeometries() > 1) {
            Geometry lastLine = line.getGeometryN(line.getNumGeometries() - 1);
            Coordinate[] c = new Coordinate[lastLine.getCoordinates().length];
            System.arraycopy(lastLine.getCoordinates(), 0, c, 0, lastLine.getCoordinates().length - 1);
            c[c.length - 1] = newEndpoint;
            LineString newLastLine = factory.createLineString(c);
            LineString[] lines = new LineString[line.getNumGeometries()];
            for (int i = 0; i < line.getNumGeometries() - 1; ++i) {
                lines[i] = (LineString)line.getGeometryN(i);
            }
            lines[line.getNumGeometries() - 1] = newLastLine;
            return factory.createMultiLineString(lines);
        }
        Coordinate[] c = new Coordinate[line.getCoordinates().length];
        System.arraycopy(line.getCoordinates(), 0, c, 0, line.getCoordinates().length - 1);
        c[c.length - 1] = newEndpoint;
        if (isMulti) {
            return StaticGeometryFunctions.toMultiGeometry((Geometry)factory.createLineString(c));
        }
        return factory.createLineString(c);
    }

    public static Geometry createDummyGeometry(String geometryType) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), -1);
        if (geometryType.equalsIgnoreCase("Point")) {
            return factory.createPoint(new Coordinate(1.0, 2.0));
        }
        if (geometryType.equalsIgnoreCase("MultiPoint")) {
            return factory.createMultiPoint(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0)});
        }
        if (geometryType.equalsIgnoreCase("LineString")) {
            return factory.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0)});
        }
        if (geometryType.equalsIgnoreCase("MultiLineString")) {
            LineString ls1 = factory.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0)});
            LineString ls2 = factory.createLineString(new Coordinate[]{new Coordinate(3.0, 3.0), new Coordinate(4.0, 3.0)});
            return factory.createMultiLineString(new LineString[]{ls1, ls2});
        }
        if (geometryType.equalsIgnoreCase("Polygon")) {
            return factory.createPolygon(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0), new Coordinate(2.0, 3.0), new Coordinate(1.0, 3.0), new Coordinate(1.0, 2.0)});
        }
        if (geometryType.equalsIgnoreCase("MultiPolygon")) {
            Polygon p = factory.createPolygon(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0), new Coordinate(2.0, 3.0), new Coordinate(1.0, 3.0), new Coordinate(1.0, 2.0)});
            return factory.createMultiPolygon(new Polygon[]{p});
        }
        return null;
    }

    public static byte getShpGeometryType(String geometryType) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), -1);
        if (geometryType.equalsIgnoreCase("Point")) {
            return 1;
        }
        if (geometryType.equalsIgnoreCase("MultiPoint")) {
            return 8;
        }
        if (geometryType.equalsIgnoreCase("LineString")) {
            return 3;
        }
        if (geometryType.equalsIgnoreCase("MultiLineString")) {
            return 3;
        }
        if (geometryType.equalsIgnoreCase("Polygon")) {
            return 5;
        }
        if (geometryType.equalsIgnoreCase("MultiPolygon")) {
            return 5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearShpOrShxFile(String fileName, int shpGeoType) throws IOException {
        File origFile = new File(fileName);
        if (origFile.exists()) {
            InputStream is = null;
            OutputStream os = null;
            origFile.delete();
            try {
                int b;
                is = GeometryUtils.class.getResourceAsStream("/de/cismet/watergis/gui/actions/emptyShapeTemplate.shp");
                os = new FileOutputStream(new File(fileName));
                int index = 0;
                while ((b = is.read()) != -1) {
                    if (index == 32) {
                        os.write(shpGeoType);
                    } else {
                        os.write(b);
                    }
                    ++index;
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + origFile.getAbsolutePath()), (Throwable)e);
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + fileName), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDbfFile(String fileName) throws IOException {
        File origFile = new File(fileName);
        if (origFile.exists()) {
            FileInputStream is = null;
            OutputStream os = null;
            origFile.renameTo(new File(fileName + ".backup"));
            origFile = new File(fileName + ".backup");
            try {
                int content;
                is = new FileInputStream(origFile);
                os = new FileOutputStream(new File(fileName));
                int byteCounter = 0;
                int tmpLength = 0;
                int length = 1000;
                while ((content = ((InputStream)is).read()) != -1) {
                    if (++byteCounter == 5) {
                        os.write(0);
                        continue;
                    }
                    if (byteCounter == 9) {
                        tmpLength = content;
                    }
                    if (byteCounter == 10) {
                        length = tmpLength += content << 8;
                    }
                    os.write(content);
                    if (byteCounter < length - 1 || content != 13) continue;
                    break;
                }
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + origFile.getAbsolutePath()), (Throwable)e);
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + fileName), (Throwable)e);
                }
                origFile.delete();
            }
        }
    }

    private static class UnionHelper {
        private static final int CORES = Runtime.getRuntime().availableProcessors();
        private static final ExecutorService executor = CismetExecutors.newFixedThreadPool((int)CORES);

        private UnionHelper() {
        }

        public static Geometry union(List<Geometry> geomList) throws InterruptedException {
            final LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
            int countPerCore = geomList.size() / CORES;
            int i = 0;
            int n = 0;
            if (countPerCore < 1) {
                countPerCore = 1;
            }
            while (i < geomList.size() - 1) {
                final ArrayList<Geometry> gl = new ArrayList<Geometry>();
                ++n;
                while (i < n * countPerCore && i < geomList.size()) {
                    gl.add(geomList.get(i));
                    ++i;
                }
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Geometry g = UnionHelper.unionGeometries(gl, 0, gl.size() - 1);
                            resultQueue.put(g);
                        }
                        catch (InterruptedException g) {
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while union geometries", (Throwable)e);
                        }
                    }
                });
            }
            if (geomList.isEmpty()) {
                return null;
            }
            int resultCount = 0;
            Object lastResult = null;
            Geometry resultGeom = null;
            ArrayList<Geometry> gList = new ArrayList<Geometry>();
            do {
                resultGeom = (Geometry)resultQueue.take();
                gList.add(resultGeom);
            } while (++resultCount != n);
            return UnionHelper.unionGeometries(gList, 0, geomList.size() - 1);
        }

        public static Geometry unionGeometries(List<Geometry> geomList, int from, int to) {
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), geomList.get(0).getSRID());
            Geometry geom = factory.buildGeometry(geomList);
            if (geom instanceof GeometryCollection) {
                geom = ((GeometryCollection)geom).union();
            }
            return geom;
        }
    }
}

