/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class JTSCutPolygonByLineAction {
    public Geometry getResult(Geometry sourceGeom, Geometry splitter) {
        int i;
        Geometry geom = sourceGeom.getBoundary();
        MultiPolygon result = null;
        if (!geom.intersects(splitter)) {
            return geom;
        }
        GeometryFactory geomFactory = new GeometryFactory();
        Vector<Geometry> lines = new Vector<Geometry>();
        for (i = 0; i < geom.getNumGeometries(); ++i) {
            lines.add(geom.getGeometryN(i));
        }
        for (i = 0; i < splitter.getNumGeometries(); ++i) {
            lines.add(splitter.getGeometryN(i));
        }
        MultiLineString mls = geomFactory.createMultiLineString(lines.toArray(new LineString[0]));
        Point mlsPt = geomFactory.createPoint(mls.getCoordinate());
        Geometry nodedLines = mls.union((Geometry)mlsPt);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(nodedLines);
        Collection polygons = polygonizer.getPolygons();
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        boolean i2 = false;
        for (Polygon pg : polygons) {
            if (!sourceGeom.contains((Geometry)pg.getInteriorPoint())) continue;
            polys.add(pg);
        }
        result = geomFactory.createMultiPolygon(polys.toArray(new Polygon[0]));
        return result;
    }
}

