/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import de.cismet.cids.search.QuerySearch;
import de.cismet.cids.search.QuerySearchMethod;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.AbstractSearchAndSelectThread;
import de.cismet.watergis.utils.TooManyResultsException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SelectFromSelectionQuerySearchMethod
implements QuerySearchMethod {
    private static final Logger LOG = Logger.getLogger(SelectFromSelectionQuerySearchMethod.class);
    private QuerySearch querySearch;
    private boolean searching = false;
    private SearchAndSelectThread searchThread;
    private Object lastLayer;

    public void setQuerySearch(QuerySearch querySearch) {
        this.querySearch = querySearch;
    }

    public void actionPerformed(Object layer, String query) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)((this.searching ? "Cancel" : "Search") + " button was clicked."));
        }
        if (this.searching) {
            if (this.searchThread != null) {
                FeatureFactory ff;
                if (this.lastLayer instanceof AbstractFeatureService && (ff = ((AbstractFeatureService)this.lastLayer).getFeatureFactory()) instanceof AbstractFeatureFactory) {
                    ((AbstractFeatureFactory)ff).waitUntilInterruptedIsAllowed();
                }
                this.searchThread.cancel(true);
            }
        } else {
            this.lastLayer = layer;
            this.searchThread = new SearchAndSelectThread(layer, query, this.querySearch);
            CismetExecutors.newSingleThreadExecutor().submit(this.searchThread);
            this.searching = true;
            this.querySearch.setControlsAccordingToState(this.searching);
        }
    }

    public String toString() {
        return NbBundle.getMessage(SelectFromSelectionQuerySearchMethod.class, (String)"SelectFromSelectionQuerySearchMethod.toString");
    }

    private class SearchAndSelectThread
    extends AbstractSearchAndSelectThread {
        public SearchAndSelectThread(Object layer, String query, QuerySearch querySearch) {
            super(layer, query, querySearch);
        }

        @Override
        protected void done() {
            try {
                List features = (List)this.get();
                if (this.isCancelled()) {
                    return;
                }
                if (features != null && this.layer instanceof AbstractFeatureService) {
                    ArrayList<Feature> featureToSelect = new ArrayList<Feature>();
                    List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
                    for (Feature feature : features) {
                        if (!selectedFeatures.contains(feature)) continue;
                        featureToSelect.add(feature);
                    }
                    SelectionManager.getInstance().setSelectedFeatures(featureToSelect);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TooManyResultsException) {
                    JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), e.getCause().getMessage(), "Hinweis", 2);
                }
                LOG.error((Object)"Error while selecting features", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while selecting features", (Throwable)e);
            }
            SelectFromSelectionQuerySearchMethod.this.searching = false;
            this.querySearch.setControlsAccordingToState(SelectFromSelectionQuerySearchMethod.this.searching);
        }
    }
}

