/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.watergis.gui;

import Sirius.server.middleware.types.MetaClass;

import org.apache.log4j.Logger;

import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;

import java.lang.ref.SoftReference;

import java.text.SimpleDateFormat;

import java.util.List;
import java.util.concurrent.ExecutionException;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.Timer;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;

import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;

import de.cismet.commons.concurrency.CismetConcurrency;

import de.cismet.tools.CismetThreadPool;

import de.cismet.watergis.broker.AppBroker;

import de.cismet.watergis.gui.dialog.GafOptionsDialog;
import de.cismet.watergis.gui.panels.GafProfEditor;
import de.cismet.watergis.gui.panels.PhotoEditor;

import de.cismet.watergis.profile.GafReader;
import de.cismet.watergis.profile.WPROFReader;

import de.cismet.watergis.utils.RendererTools;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class GafInfoPanel extends javax.swing.JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(GafInfoPanel.class);
    private static CidsLayer ppLayer = null;
    private static final int IMAGE_HEIGHT = 200;
    private static final int IMAGE_WIDTH = 400;

    static {
        final MetaClass mc = ClassCacheMultiple.getMetaClass(
                AppBroker.DOMAIN_NAME,
                "dlm25w.qp_pkte");

        if (mc != null) {
            ppLayer = new CidsLayer(mc);
        }
    }

    //~ Instance fields --------------------------------------------------------

    private CidsLayerFeature feature;
    private List<DefaultFeatureServiceFeature> gafFeatures;
    private Timer timer;
    private ImageResizeWorker currentResizeWorker;
    private Dimension lastDims;
    private GafInfoPHandle handle;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel labImage;
    private javax.swing.JLabel labTime;
    private org.jdesktop.swingx.JXBusyLabel lblBusy;
    private javax.swing.JPanel panData;
    private javax.swing.JPanel panImage;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form FotoInfoPanel.
     *
     * @param  handle  DOCUMENT ME!
     */
    public GafInfoPanel(final GafInfoPHandle handle) {
        this.handle = handle;
        initComponents();
        panImage.setSize(GafOptionsDialog.getInstance().getImageSize());

        timer = new javax.swing.Timer(300, new ActionListener() {

                    @Override
                    public void actionPerformed(final ActionEvent e) {
                        if (currentResizeWorker != null) {
                            currentResizeWorker.cancel(true);
                        }
                        currentResizeWorker = new ImageResizeWorker();
                        CismetConcurrency.getInstance("qp").getDefaultExecutor().execute(currentResizeWorker);
                    }
                });
        timer.setRepeats(false);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panImage = new javax.swing.JPanel();
        labImage = new javax.swing.JLabel();
        lblBusy = new org.jdesktop.swingx.JXBusyLabel(new Dimension(75, 75));
        panData = new javax.swing.JPanel();
        labTime = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        panImage.setMinimumSize(new java.awt.Dimension(300, 300));
        panImage.setPreferredSize(new java.awt.Dimension(300, 300));
        panImage.setLayout(new java.awt.CardLayout());

        labImage.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        panImage.add(labImage, "image");

        lblBusy.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblBusy.setMaximumSize(new java.awt.Dimension(140, 40));
        lblBusy.setMinimumSize(new java.awt.Dimension(140, 40));
        lblBusy.setPreferredSize(new java.awt.Dimension(140, 40));
        panImage.add(lblBusy, "busy");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(panImage, gridBagConstraints);

        panData.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            labTime,
            org.openide.util.NbBundle.getMessage(GafInfoPanel.class, "GafInfoPanel.labTime.text", new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panData.add(labTime, gridBagConstraints);

        jPanel1.setMaximumSize(new java.awt.Dimension(250, 32));
        jPanel1.setPreferredSize(new java.awt.Dimension(250, 32));
        jPanel1.setLayout(new java.awt.BorderLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(GafInfoPanel.class, "GafInfoPanel.jLabel1.text", new Object[] {})); // NOI18N
        jPanel1.add(jLabel1, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panData.add(jPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(panData, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @return  the feature
     */
    public CidsLayerFeature getFeature() {
        return feature;
    }

    /**
     * DOCUMENT ME!
     */
    public void setImageSize() {
        this.setSize(GafOptionsDialog.getInstance().getImageSize());
        setFeature(null);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  feature  the feature to set
     */
    public void setFeature(final CidsLayerFeature feature) {
        if ((feature != null) && (this.feature != feature)) {
            this.feature = feature;
            jLabel1.setText("<html>" + obj2String(feature.getProperty("titel")) + "</html>");
            labTime.setText(dateTime2String(
                    feature.getProperty("aufn_datum"),
                    (String)feature.getProperty("aufn_zeit")));
//            labTime.setText(obj2Time(feature.getProperty("aufn_zeit")));
            loadFoto();
        } else {
            this.feature = feature;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   o  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String obj2String(final Object o) {
        if (o == null) {
            return "";
        } else {
            return String.valueOf(o);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   o  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String obj2Time(final Object o) {
        if (o == null) {
            return "";
        } else {
            try {
                final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                return format.format(o);
            } catch (IllegalArgumentException e) {
                LOG.error("Not a date", e);
                return "";
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   date  o DOCUMENT ME!
     * @param   time  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private static String dateTime2String(final Object date, final String time) {
        if ((date == null) && (time == null)) {
            return "";
        } else if (date == null) {
            return time;
        } else if (time == null) {
            try {
                final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                return format.format(date);
            } catch (IllegalArgumentException e) {
                LOG.error("Not a date", e);
                return "";
            }
        } else {
            try {
                final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                return format.format(date) + " " + time;
            } catch (IllegalArgumentException e) {
                LOG.error("Not a date", e);
                return "";
            }
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void loadFoto() {
        final Object qpNr = feature.getProperty("qp_nr");
        boolean cacheHit = false;

        if ((qpNr != null)) {
            final SoftReference<List<DefaultFeatureServiceFeature>> cachedImageRef = GafProfEditor.FEATURE_CACHE.get(
                    qpNr);
            if (cachedImageRef != null) {
                final List<DefaultFeatureServiceFeature> features = cachedImageRef.get();
                if (features != null) {
                    cacheHit = true;
                    gafFeatures = features;
                    showWait(true);
                    timer.restart();
                }
            }
            if (!cacheHit) {
                CismetConcurrency.getInstance("qp").getDefaultExecutor().execute(new LoadImageWorker(qpNr));
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  error  DOCUMENT ME!
     */
    private void indicateError(final String error) {
        labImage.setToolTipText(error);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  wait  DOCUMENT ME!
     */
    private void showWait(final boolean wait) {
        if (wait) {
            if (!lblBusy.isBusy()) {
                final CardLayout cardLayout = (CardLayout)panImage.getLayout();
                cardLayout.show(panImage, "busy");
                labImage.setIcon(null);
                lblBusy.setBusy(true);
            }
        } else {
            final CardLayout cardLayout = (CardLayout)panImage.getLayout();
            cardLayout.show(panImage, "image");
            lblBusy.setBusy(false);
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    final class LoadImageWorker extends SwingWorker<List<DefaultFeatureServiceFeature>, Void> {

        //~ Instance fields ----------------------------------------------------

        private final Object qpNr;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new LoadSelectedImageWorker object.
         *
         * @param  qpNr  path toLoad DOCUMENT ME!
         */
        public LoadImageWorker(final Object qpNr) {
            this.qpNr = qpNr;
        }

        //~ Methods ------------------------------------------------------------

        @Override
        protected List<DefaultFeatureServiceFeature> doInBackground() throws Exception {
            ppLayer.initAndWait();
            final List<DefaultFeatureServiceFeature> features = ppLayer.getFeatureFactory()
                        .createFeatures("qp_nr = " + qpNr.toString(),
                            null,
                            null,
                            0,
                            0,
                            null);

            return features;
        }

        @Override
        protected void done() {
            try {
                gafFeatures = get();
                if (gafFeatures != null) {
                    GafProfEditor.FEATURE_CACHE.put(
                        qpNr,
                        new SoftReference<List<DefaultFeatureServiceFeature>>(gafFeatures));
                    timer.restart();
                } else {
                    indicateError("Bild konnte nicht geladen werden: Unbekanntes Bildformat");
                }
            } catch (InterruptedException ex) {
                gafFeatures = null;
                LOG.warn(ex, ex);
            } catch (ExecutionException ex) {
                gafFeatures = null;
                LOG.error(ex, ex);
                String causeMessage = "";
                final Throwable cause = ex.getCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                }
                indicateError(causeMessage);
            } finally {
                if (gafFeatures == null) {
                    showWait(false);
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    final class ImageResizeWorker extends SwingWorker<ImageIcon, Void> {

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new ImageResizeWorker object.
         */
        public ImageResizeWorker() {
        }

        //~ Methods ------------------------------------------------------------

        @Override
        protected ImageIcon doInBackground() throws Exception {
            if ((gafFeatures != null) && (gafFeatures.size() > 0)) {
                final WPROFReader reader = new WPROFReader(gafFeatures);

                final BufferedImage image = (BufferedImage)reader.createImage(
                        reader.getProfiles().toArray(new Double[1])[0],
                        (int)(IMAGE_WIDTH),
                        (int)(IMAGE_HEIGHT));
                final ImageIcon result = new ImageIcon(adjustScale(image, panImage, 20, 20));
                return result;
            } else {
                return null;
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param   bi         DOCUMENT ME!
         * @param   component  DOCUMENT ME!
         * @param   insetX     DOCUMENT ME!
         * @param   insetY     DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private Image adjustScale(final BufferedImage bi,
                final JComponent component,
                final int insetX,
                final int insetY) {
            final double scalex = (double)component.getWidth() / bi.getWidth();
            final double scaley = (double)component.getHeight() / bi.getHeight();
            final double scale = Math.min(scalex, scaley);
            if (scale <= 1d) {
                return bi.getScaledInstance((int)(bi.getWidth() * scale) - insetX,
                        (int)(bi.getHeight() * scale)
                                - insetY,
                        Image.SCALE_SMOOTH);
            } else {
                return bi;
            }
        }

        @Override
        protected void done() {
            if (!isCancelled()) {
                try {
                    final ImageIcon result = get();
                    labImage.setIcon(result);
                    labImage.setText("");
                    labImage.setToolTipText(null);
                } catch (InterruptedException ex) {
                    LOG.warn(ex, ex);
                } catch (ExecutionException ex) {
                    LOG.error(ex, ex);
                    labImage.setText("Fehler beim Skalieren!");
                } finally {
                    showWait(false);
                    if (currentResizeWorker == this) {
                        currentResizeWorker = null;
                    }
                    handle.repaint();
                }
            }
        }
    }
}
