/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.watergis.gui.dialog;

import java.math.RoundingMode;

import java.text.DecimalFormat;

import javax.swing.JTextField;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class WsgRechtDialog extends javax.swing.JDialog {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton butOk;
    private javax.swing.JLabel labAnteil;
    private javax.swing.JLabel labAnz;
    private javax.swing.JLabel labBrd;
    private javax.swing.JTextField labBrdA;
    private javax.swing.JTextField labBrdAn;
    private javax.swing.JTextField labBrdFl;
    private javax.swing.JLabel labDdr;
    private javax.swing.JTextField labDdrA;
    private javax.swing.JTextField labDdrAn;
    private javax.swing.JTextField labDdrFl;
    private javax.swing.JLabel labFl;
    private javax.swing.JLabel labFlNuWsg;
    private javax.swing.JLabel labFoot;
    private javax.swing.JLabel labFoot1;
    private javax.swing.JLabel labWsg;
    private javax.swing.JTextField labWsgA;
    private javax.swing.JLabel labWsgAnzVal;
    private javax.swing.JTextField labWsgFl;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WsgDialog.
     *
     * @param  parent    DOCUMENT ME!
     * @param  modal     DOCUMENT ME!
     * @param  wsgCount  DOCUMENT ME!
     * @param  wsgTotal  DOCUMENT ME!
     * @param  brdCount  DOCUMENT ME!
     * @param  ddrCount  DOCUMENT ME!
     * @param  brdTotal  DOCUMENT ME!
     * @param  ddrTotal  DOCUMENT ME!
     */
    public WsgRechtDialog(final java.awt.Frame parent,
            final boolean modal,
            final int wsgCount,
            final double wsgTotal,
            final int brdCount,
            final int ddrCount,
            final double brdTotal,
            final double ddrTotal) {
        super(parent, modal);
        initComponents();

        makeReadOnly(labWsgA);
        makeReadOnly(labWsgFl);
        makeReadOnly(labDdrA);
        makeReadOnly(labDdrFl);
        makeReadOnly(labDdrAn);
        makeReadOnly(labBrdA);
        makeReadOnly(labBrdFl);
        makeReadOnly(labBrdAn);

        final DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(2);
        formatter.setMinimumFractionDigits(2);
        formatter.setGroupingSize(3);
        formatter.setRoundingMode(RoundingMode.HALF_UP);

        labWsgA.setText(String.valueOf(wsgCount));
        labWsgFl.setText(formatter.format(wsgTotal / 10000) + "*");
        labDdrA.setText(String.valueOf(ddrCount));
        labDdrFl.setText(formatter.format(ddrTotal / 10000) + "**");
        labDdrAn.setText(formatter.format(ddrTotal / (ddrTotal + brdTotal) * 100));
        labBrdA.setText(String.valueOf(brdCount));
        labBrdFl.setText(formatter.format(brdTotal / 10000));
        labBrdAn.setText(formatter.format(brdTotal / (ddrTotal + brdTotal) * 100));
        setSize(660, 350);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  tf  DOCUMENT ME!
     */
    public static void makeReadOnly(final JTextField tf) {
        tf.setBorder(null);
        tf.setOpaque(false);
        tf.setEditable(false);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        labFlNuWsg = new javax.swing.JLabel();
        labWsgAnzVal = new javax.swing.JLabel();
        labAnz = new javax.swing.JLabel();
        labFl = new javax.swing.JLabel();
        labAnteil = new javax.swing.JLabel();
        labWsg = new javax.swing.JLabel();
        labDdr = new javax.swing.JLabel();
        labBrd = new javax.swing.JLabel();
        labFoot = new javax.swing.JLabel();
        labFoot1 = new javax.swing.JLabel();
        butOk = new javax.swing.JButton();
        labWsgA = new javax.swing.JTextField();
        labDdrA = new javax.swing.JTextField();
        labBrdA = new javax.swing.JTextField();
        labWsgFl = new javax.swing.JTextField();
        labDdrFl = new javax.swing.JTextField();
        labBrdFl = new javax.swing.JTextField();
        labDdrAn = new javax.swing.JTextField();
        labBrdAn = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(WsgRechtDialog.class, "WsgRechtDialog.title", new Object[] {})); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            labFlNuWsg,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labFlNuWsg.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        getContentPane().add(labFlNuWsg, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labWsgAnzVal, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labAnz,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labAnz.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labAnz, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labFl,
            org.openide.util.NbBundle.getMessage(WsgRechtDialog.class, "WsgRechtDialog.labFl.text", new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labFl, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labAnteil,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labAnteil.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(labAnteil, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labWsg,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labWsg.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(labWsg, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labDdr,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labDdr.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labDdr, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labBrd,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labBrd.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(labBrd, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labFoot,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labFoot.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(25, 5, 5, 5);
        getContentPane().add(labFoot, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labFoot1,
            org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labFoot1.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(labFoot1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            butOk,
            org.openide.util.NbBundle.getMessage(WsgRechtDialog.class, "WsgRechtDialog.butOk.text", new Object[] {})); // NOI18N
        butOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    butOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 0, 0);
        getContentPane().add(butOk, gridBagConstraints);

        labWsgA.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labWsgA.text",
                new Object[] {})); // NOI18N
        labWsgA.setMaximumSize(new java.awt.Dimension(100, 17));
        labWsgA.setPreferredSize(new java.awt.Dimension(75, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labWsgA, gridBagConstraints);

        labDdrA.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labDdrA.text",
                new Object[] {})); // NOI18N
        labDdrA.setMaximumSize(new java.awt.Dimension(100, 17));
        labDdrA.setPreferredSize(new java.awt.Dimension(75, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labDdrA, gridBagConstraints);

        labBrdA.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labBrdA.text",
                new Object[] {})); // NOI18N
        labBrdA.setMaximumSize(new java.awt.Dimension(100, 17));
        labBrdA.setPreferredSize(new java.awt.Dimension(75, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labBrdA, gridBagConstraints);

        labWsgFl.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labWsgFl.text",
                new Object[] {})); // NOI18N
        labWsgFl.setMaximumSize(new java.awt.Dimension(100, 17));
        labWsgFl.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labWsgFl, gridBagConstraints);

        labDdrFl.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labDdrFl.text",
                new Object[] {})); // NOI18N
        labDdrFl.setMaximumSize(new java.awt.Dimension(100, 17));
        labDdrFl.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labDdrFl, gridBagConstraints);

        labBrdFl.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labBrdFl.text",
                new Object[] {})); // NOI18N
        labBrdFl.setMaximumSize(new java.awt.Dimension(100, 17));
        labBrdFl.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        getContentPane().add(labBrdFl, gridBagConstraints);

        labDdrAn.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labDdrAn.text",
                new Object[] {})); // NOI18N
        labDdrAn.setMaximumSize(new java.awt.Dimension(100, 17));
        labDdrAn.setPreferredSize(new java.awt.Dimension(75, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(labDdrAn, gridBagConstraints);

        labBrdAn.setText(org.openide.util.NbBundle.getMessage(
                WsgRechtDialog.class,
                "WsgRechtDialog.labBrdAn.text",
                new Object[] {})); // NOI18N
        labBrdAn.setMaximumSize(new java.awt.Dimension(100, 17));
        labBrdAn.setPreferredSize(new java.awt.Dimension(75, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(labBrdAn, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void butOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_butOkActionPerformed
        setVisible(false);
    }                                                                         //GEN-LAST:event_butOkActionPerformed
}
