/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DrawingFeature;
import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.cismap.io.converters.GeomFromWktConverter;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.listener.DrawingCountChangedEvent;
import de.cismet.watergis.broker.listener.DrawingsListener;
import de.cismet.watergis.gui.dialog.VisualizingDialog;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.h2gis.utilities.wrapper.StatementWrapper;

public class DrawingManager
implements FeatureCollectionListener {
    private static final Logger LOG = Logger.getLogger(DrawingManager.class);
    public static final String DRAWING_TABLE_NAME = "Zeichnungen";
    public static final String CHECK_TABLE = "select sld from \"Zeichnungen\"";
    private static final String INIT_DB_TABLE = "CREATE TABLE IF NOT EXISTS \"Zeichnungen\" (id identity primary key not null, geom Geometry, type varchar, text varchar, autoscale boolean, background boolean, fontsize integer, sld text)";
    private static final String ADD_FEATURE = "INSERT INTO \"Zeichnungen\" (geom, type, text, autoscale, background, fontsize, sld) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_FEATURE = "DELETE FROM \"Zeichnungen\" WHERE ID = %1$s";
    private static final String DELETE_ALL_FEATURE = "DELETE FROM \"Zeichnungen\"";
    private static final String SELECT_ALL_FEATURES = "SELECT id, geom, type, text, autoscale, background, fontsize, sld FROM \"Zeichnungen\"";
    private static final String FEATURES_EXISTS = "SELECT 1 FROM \"Zeichnungen\" limit 1";
    private static final String CHANGE_FEATURE = "UPDATE \"Zeichnungen\" SET geom = ?, type = ?, text = ?, sld = ?  WHERE ID = ?";
    private static final String CREATE_TABLE_FROM_CSV = "CREATE TABLE \"%s\" as select * from CSVREAD('%s');";
    private static final String TEMP_TABLE = "temp_drawing";
    private final Executor executor = CismetExecutors.newSingleThreadExecutor();
    private final List<DrawingsListener> listener = new ArrayList<DrawingsListener>();

    private DrawingManager() {
        AppBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
        this.initDB();
        this.loadFeatures();
    }

    public static DrawingManager getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public void loadFeatures() {
        ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
        List oldFeatures = AppBroker.getInstance().getMappingComponent().getFeatureCollection().getAllFeatures();
        for (Feature f : oldFeatures) {
            if (!(f instanceof DrawingSLDStyledFeature)) continue;
            featuresToRemove.add(f);
        }
        AppBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeatures(featuresToRemove);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<DrawingSLDStyledFeature> features = DrawingManager.this.getAllFeatures();
                AppBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatures(features);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDB() {
        ConnectionWrapper conn = null;
        StatementWrapper st = null;
        try {
            conn = H2FeatureServiceFactory.getDBConnection(null);
            H2FeatureServiceFactory.initDatabase((ConnectionWrapper)conn);
            st = H2FeatureServiceFactory.createStatement((ConnectionWrapper)conn);
            try {
                st.execute(CHECK_TABLE);
            }
            catch (Exception e) {
                try {
                    st.execute("drop table \"Zeichnungen\"");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            st.execute(INIT_DB_TABLE);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error while initialising the internal database", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing a db statement", (Throwable)ex);
                }
            }
        }
    }

    public void featuresAdded(final FeatureCollectionEvent fce) {
        this.orderFeatures(fce);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList features = new ArrayList(fce.getEventFeatures());
                for (Feature feature : features) {
                    if (!(feature instanceof DrawingFeature) || ((DrawingFeature)feature).getId() != -1) continue;
                    DrawingManager.this.addFeatureToDb((DrawingFeature)feature);
                    DrawingSLDStyledFeature styledFeature = new DrawingSLDStyledFeature((DrawingFeature)feature);
                    if (AppBroker.getInstance().getDrawingStyleLayer() != null) {
                        styledFeature.setSLDStyles((List)AppBroker.getInstance().getDrawingStyles(feature.getGeometry().getGeometryType()).get("default"));
                    }
                    AppBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature(feature);
                    AppBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)styledFeature);
                }
                DrawingManager.this.fireDrawingCountChanged();
            }
        });
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DrawingManager.this.removeAllFeatures();
            }
        });
    }

    public void featuresRemoved(final FeatureCollectionEvent fce) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Collection features = fce.getEventFeatures();
                for (Feature feature : features) {
                    if (!(feature instanceof DrawingSLDStyledFeature)) continue;
                    DrawingManager.this.removeFeature((DrawingSLDStyledFeature)feature);
                }
                DrawingManager.this.fireDrawingCountChanged();
            }
        });
    }

    public void featuresChanged(final FeatureCollectionEvent fce) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Collection features = fce.getEventFeatures();
                for (Feature feature : features) {
                    if (!(feature instanceof DrawingSLDStyledFeature) || ((DrawingSLDStyledFeature)feature).getId() == -1) continue;
                    DrawingManager.this.changeFeature((DrawingSLDStyledFeature)feature);
                }
            }
        });
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        this.orderFeatures(fce);
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    public void featureCollectionChanged() {
    }

    private void orderFeatures(FeatureCollectionEvent fce) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrawingManager.this.orderAllFeatures();
            }
        });
    }

    public void addDrawingsListener(DrawingsListener l) {
        this.listener.add(l);
    }

    public void removeDrawingsListener(DrawingsListener l) {
        this.listener.remove(l);
    }

    public void fireDrawingCountChanged() {
        DrawingCountChangedEvent e = new DrawingCountChangedEvent(this);
        for (DrawingsListener l : this.listener) {
            l.drawingsCountChanged(e);
        }
    }

    private void orderAllFeatures() {
        HashMap orderMap = new HashMap();
        MappingComponent map = AppBroker.getInstance().getMappingComponent();
        FeatureCollection fc = map.getFeatureCollection();
        ArrayList features = new ArrayList(fc.getAllFeatures());
        PNode parentNode = null;
        for (Feature feature : features) {
            PFeature pfeature;
            if (!(feature instanceof DrawingSLDStyledFeature)) continue;
            DrawingSLDStyledFeature dFeature = (DrawingSLDStyledFeature)feature;
            Integer order = dFeature.getTypeOrder();
            ArrayList<PFeature> featureListForPosition = (ArrayList<PFeature>)orderMap.get(order);
            if (featureListForPosition == null) {
                featureListForPosition = new ArrayList<PFeature>();
                orderMap.put(order, featureListForPosition);
            }
            if ((pfeature = (PFeature)map.getPFeatureHM().get(dFeature)) != null) {
                featureListForPosition.add(pfeature);
            }
            if (parentNode == null) {
                parentNode = pfeature.getParent();
            }
            if (parentNode == null || parentNode.getChildrenCount() <= 0) continue;
            parentNode.removeChild((PNode)pfeature);
        }
        if (parentNode != null) {
            for (int i = DrawingFeature.getTypeOrderCount() - 1; i >= 0; --i) {
                List featureListForPosition = (List)orderMap.get(i);
                if (featureListForPosition == null) continue;
                for (PFeature feature : featureListForPosition) {
                    parentNode.addChild((PNode)feature);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addFeatureToDb(DrawingFeature feature) {
        ConnectionWrapper cw = null;
        Statement ps = null;
        try {
            cw = H2FeatureServiceFactory.getDBConnection(null);
            feature.setGeometry(CrsTransformer.transformToDefaultCrs((Geometry)feature.getGeometry()));
            String sld = feature.getSld();
            if (sld == null) {
                sld = VisualizingDialog.exportSLD(VisualizingDialog.getInstance().getStyleLayer(), feature.getGeometry().getGeometryType());
                feature.setSld(sld);
            }
            ps = cw.prepareStatement(ADD_FEATURE);
            ps.setString(1, feature.getGeometry().toText());
            String type = feature.getGeometryType().name();
            if (type.equalsIgnoreCase("TEXT") && feature.getPrimaryAnnotationFont() != null) {
                type = type + "(" + this.fontToString(feature.getPrimaryAnnotationFont()) + ")";
            }
            ps.setString(2, type);
            ps.setString(3, feature.getGeometryType().equals((Object)AbstractNewFeature.geomTypes.TEXT) ? feature.getName() : null);
            ps.setString(4, String.valueOf(feature.isAutoscale()));
            ps.setBoolean(5, feature.getPrimaryAnnotationHalo() != null);
            ps.setObject(6, feature.getPrimaryAnnotationFont() != null ? Integer.valueOf(feature.getPrimaryAnnotationFont().getSize()) : null);
            ps.setString(7, sld);
            ps.execute();
            LOG.error((Object)ADD_FEATURE);
            ResultSet rs = ps.getGeneratedKeys();
            if (rs.next()) {
                feature.setId(rs.getInt(1));
            } else {
                LOG.error((Object)"Error: ID for drawing feature was not generated.");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while inserting new feature into the internal db.", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing statement", (Throwable)ex);
                }
            }
            this.fireDrawingCountChanged();
        }
    }

    private String fontToString(Font font) {
        String style = "PLAIN";
        switch (font.getStyle()) {
            case 1: {
                style = "BOLD";
                break;
            }
            case 2: {
                style = "ITALIC";
                break;
            }
            case 3: {
                style = "BOLDITALIC";
            }
        }
        return font.getName() + "-" + style + "-" + font.getSize();
    }

    private void removeFeature(DrawingSLDStyledFeature feature) {
        String delete = String.format(DELETE_FEATURE, feature.getId());
        this.executeUpdate(delete);
        this.fireDrawingCountChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeFeature(DrawingSLDStyledFeature feature) {
        ConnectionWrapper cw = null;
        PreparedStatement ps = null;
        try {
            cw = H2FeatureServiceFactory.getDBConnection(null);
            ps = cw.prepareStatement(CHANGE_FEATURE);
            ps.setString(1, feature.getGeometry().toString());
            String type = feature.getGeometryType().name();
            if (type.equalsIgnoreCase("TEXT") && feature.getPrimaryAnnotationFont() != null) {
                type = type + "(" + this.fontToString(feature.getPrimaryAnnotationFont()) + ")";
            }
            ps.setString(2, type);
            ps.setString(3, feature.getGeometryType().equals((Object)AbstractNewFeature.geomTypes.TEXT) ? feature.getText() : null);
            ps.setString(4, (String)feature.getProperty("sld"));
            ps.setInt(5, feature.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing the following statement: UPDATE \"Zeichnungen\" SET geom = ?, type = ?, text = ?, sld = ?  WHERE ID = ?", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing statement", (Throwable)ex);
                }
            }
        }
    }

    private void removeAllFeatures() {
        this.executeUpdate(DELETE_ALL_FEATURE);
        this.fireDrawingCountChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFeatures(File drawingFile) {
        String readCvsQuery = String.format(CREATE_TABLE_FROM_CSV, TEMP_TABLE, drawingFile.getAbsolutePath());
        ConnectionWrapper cw = null;
        StatementWrapper st = null;
        GeomFromWktConverter converter = new GeomFromWktConverter();
        try {
            cw = H2FeatureServiceFactory.getDBConnection(null);
            st = H2FeatureServiceFactory.createStatement((ConnectionWrapper)cw);
            st.executeUpdate(String.format("DROP TABLE  IF EXISTS \"%1$s\"", TEMP_TABLE));
            st.executeUpdate(readCvsQuery);
            ResultSet rs = st.executeQuery(String.format("SELECT id, geom, type, text, autoscale, background, fontsize, sld FROM \"%1$s\"", TEMP_TABLE));
            Base64 base64 = new Base64();
            while (rs.next()) {
                int id = rs.getInt(1);
                String geomAsTExt = rs.getString(2);
                String type = rs.getString(3);
                String text = rs.getString(4);
                boolean autoscale = Boolean.parseBoolean(rs.getString(5));
                boolean halo = Boolean.parseBoolean(rs.getString(6));
                String sld = new String(base64.decode(rs.getString(8)));
                Geometry geom = converter.convertForward(geomAsTExt, new String[]{CismapBroker.getInstance().getDefaultCrs()});
                geom.setSRID(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs()));
                DrawingFeature feature = new DrawingFeature(geom);
                if (AbstractNewFeature.geomTypes.valueOf((String)type).equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
                    feature.setName(text);
                }
                feature.setGeometryType(AbstractNewFeature.geomTypes.valueOf((String)type));
                feature.setEditable(true);
                feature.setSld(sld);
                if (AbstractNewFeature.geomTypes.valueOf((String)type).equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
                    int fontsize = Integer.parseInt(rs.getString(7));
                    feature.setAutoScale(autoscale);
                    if (halo) {
                        feature.setPrimaryAnnotationHalo(Color.WHITE);
                    }
                    feature.setPrimaryAnnotationFont(new Font("sansserif", 0, fontsize));
                }
                this.addFeatureToDb(feature);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retreiving all features from the database: ", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing statement", (Throwable)ex);
                }
            }
            this.executeUpdate("drop table \"temp_drawing\"");
            this.fireDrawingCountChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeUpdate(String statement) {
        ConnectionWrapper cw = null;
        StatementWrapper st = null;
        try {
            cw = H2FeatureServiceFactory.getDBConnection(null);
            st = H2FeatureServiceFactory.createStatement((ConnectionWrapper)cw);
            LOG.error((Object)statement, (Throwable)new Exception());
            st.executeUpdate(statement);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while executing the following statement: " + statement), (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing statement", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<DrawingSLDStyledFeature> getAllFeatures() {
        ArrayList<DrawingSLDStyledFeature> features = new ArrayList<DrawingSLDStyledFeature>();
        ConnectionWrapper cw = null;
        StatementWrapper st = null;
        try {
            cw = H2FeatureServiceFactory.getDBConnection(null);
            st = H2FeatureServiceFactory.createStatement((ConnectionWrapper)cw);
            ResultSet rs = st.executeQuery(SELECT_ALL_FEATURES);
            while (rs.next()) {
                int id = rs.getInt(1);
                Geometry geom = (Geometry)rs.getObject(2);
                String type = rs.getString(3);
                String text = rs.getString(4);
                boolean autoscale = rs.getBoolean(5);
                boolean halo = rs.getBoolean(6);
                int fontsize = rs.getInt(7);
                String sld = rs.getString(8);
                geom.setSRID(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs()));
                DrawingSLDStyledFeature feature = new DrawingSLDStyledFeature();
                feature.setGeometry(geom);
                String font = null;
                if (type.contains("(")) {
                    font = type.substring(type.indexOf("(") + 1, type.length() - 1);
                    type = type.substring(0, type.indexOf("("));
                }
                feature.setId(id);
                if (AbstractNewFeature.geomTypes.valueOf((String)type).equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
                    feature.setText(text);
                }
                feature.setGeometryType(AbstractNewFeature.geomTypes.valueOf((String)type));
                feature.setEditable(true);
                if (AbstractNewFeature.geomTypes.valueOf((String)type).equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
                    feature.setAutoScale(autoscale);
                    if (halo) {
                        feature.setPrimaryAnnotationHalo(Color.WHITE);
                    }
                    if (font != null) {
                        Font f = Font.decode(font);
                        feature.setPrimaryAnnotationFont(f);
                    } else {
                        feature.setPrimaryAnnotationFont(new Font("sansserif", 0, fontsize));
                    }
                }
                feature.setSLDStyles((List)AppBroker.getInstance().getDrawingStylesBySld(sld).get("default"));
                feature.setProperty("sld", (Object)sld);
                features.add(feature);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retreiving all features from the database: ", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing statement", (Throwable)ex);
                }
            }
        }
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean featuresExists() {
        ConnectionWrapper cw = null;
        StatementWrapper st = null;
        try {
            cw = H2FeatureServiceFactory.getDBConnection(null);
            st = H2FeatureServiceFactory.createStatement((ConnectionWrapper)cw);
            ResultSet rs = st.executeQuery(FEATURES_EXISTS);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking, whether features exists in the database: ", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing statement", (Throwable)ex);
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        int i;
        Thread[] threads = new Thread[10];
        for (i = 1; i < 10; ++i) {
            threads[i] = new Thread(new Tester());
            threads[i].setDaemon(false);
        }
        threads[0] = new Thread(new TesterDelete());
        threads[0].setDaemon(false);
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
    }

    private static final class LazyInitialiser {
        static final DrawingManager INSTANCE = new DrawingManager();

        private LazyInitialiser() {
        }
    }

    private static final class TesterDelete
    implements Runnable {
        private TesterDelete() {
        }

        @Override
        public void run() {
            DrawingManager.getInstance().executeUpdate("delete from \"Zeichnungen\"");
        }
    }

    private static final class Tester
    implements Runnable {
        private Tester() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionWrapper cw = null;
            StatementWrapper st = null;
            GeomFromWktConverter converter = new GeomFromWktConverter();
            try {
                cw = H2FeatureServiceFactory.getDBConnection(null);
                st = H2FeatureServiceFactory.createStatement((ConnectionWrapper)cw);
                for (int i = 0; i < 500; ++i) {
                    String geomAsTExt = "POLYGON((33554.2324 500943.2343, 33584.2324 500943.2343, 33584.2324 500953.2343, 33554.2324 500943.2343))";
                    String type = "POLYGON";
                    String text = null;
                    boolean autoscale = false;
                    boolean halo = false;
                    Geometry geom = converter.convertForward("POLYGON((33554.2324 500943.2343, 33584.2324 500943.2343, 33584.2324 500953.2343, 33554.2324 500943.2343))", new String[]{CismapBroker.getInstance().getDefaultCrs()});
                    geom.setSRID(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs()));
                    DrawingFeature feature = new DrawingFeature(geom);
                    if (AbstractNewFeature.geomTypes.valueOf((String)"POLYGON").equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
                        feature.setName(text);
                    }
                    feature.setGeometryType(AbstractNewFeature.geomTypes.valueOf((String)"POLYGON"));
                    feature.setEditable(true);
                    if (AbstractNewFeature.geomTypes.valueOf((String)"POLYGON").equals((Object)AbstractNewFeature.geomTypes.TEXT)) {
                        int fontsize = 12;
                        feature.setAutoScale(false);
                        feature.setPrimaryAnnotationFont(new Font("sansserif", 0, 12));
                    }
                    DrawingManager.getInstance().addFeatureToDb(feature);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while inserting features into the db: ", (Throwable)e);
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"Error while closing statement", (Throwable)ex);
                    }
                }
            }
        }
    }
}

