/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LinearReferencingInfo;
import de.cismet.cismap.commons.gui.attributetable.DefaultAttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.H2AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.WithoutGeometryCreator;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.TableLinearReferencedLineEditor;
import de.cismet.cismap.linearreferencing.TableStationEditor;
import de.cismet.cismap.linearreferencing.tools.StationEditorInterface;
import de.cismet.cismap.linearreferencing.tools.StationTableCellEditorInterface;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class DefaultWatergisH2AttributeTableRuleSet
extends DefaultAttributeTableRuleSet
implements H2AttributeTableRuleSet {
    private static final Logger LOG = Logger.getLogger(DefaultWatergisH2AttributeTableRuleSet.class);
    protected final Map<String, WatergisDefaultRuleSet.DataType> typeMap = new HashMap<String, WatergisDefaultRuleSet.DataType>();
    private List<LinearReferencingInfo> refInfos = null;
    private Map<String, LinearReferencingInfo> refInfoMap = null;
    private String geometryType = null;
    private Map<String, FeatureServiceAttribute> attributesMap = new HashMap<String, FeatureServiceAttribute>();
    private boolean isCheckTable = false;

    public DefaultWatergisH2AttributeTableRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("bak_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("bak_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br_dm_li", new WatergisDefaultRuleSet.Numeric(7, 3, false, true));
        this.typeMap.put("ho_li", new WatergisDefaultRuleSet.Numeric(7, 3, false, true));
        this.typeMap.put("br_tr_o_li", new WatergisDefaultRuleSet.Numeric(5, 3, false, true));
        this.typeMap.put("ho_e", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_a", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("gefaelle", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_d_e", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_a", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_m", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_gn", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("km_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("km_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("nr", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("name", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("berme_w", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("berme_b", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("br_f", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("br_k", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_k_f", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_k_pn", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_bhw_pn", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_mw_pn", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bv_w", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bv_b", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_d_o", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_u", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_ea", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_d_ea", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ho_so", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_d_so_ok", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("sz", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("az", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ezg_fl", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("v_fl", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("pu", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("pu_foel", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("br_li", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(WatergisDefaultRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("bv_re", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bh_re", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bl_re", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bv_li", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bh_li", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bl_li", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("mw", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, true, false));
        this.typeMap.put("la_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("lak_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("lak_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_cd_k", new WatergisDefaultRuleSet.Numeric(20, 0, true, false));
        this.typeMap.put("la_gn", new WatergisDefaultRuleSet.Varchar(75, true, false));
        this.typeMap.put("la_gn_t", new WatergisDefaultRuleSet.Numeric(1, 0, true, false));
        this.typeMap.put("la_lage", new WatergisDefaultRuleSet.Varchar(1, true, false));
        this.typeMap.put("la_ordn", new WatergisDefaultRuleSet.Numeric(2, 0, true, false));
        this.typeMap.put("la_wrrl", new WatergisDefaultRuleSet.Numeric(1, 0, true, false));
        this.typeMap.put("gbk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, true, true));
        this.typeMap.put("gbk_lawa_k", new WatergisDefaultRuleSet.Numeric(4, 0, true, true));
        this.typeMap.put("ezg", new WatergisDefaultRuleSet.Numeric(15, 0, true, true));
    }

    public void init(List<LinearReferencingInfo> refInfos, String geometryType, List<FeatureServiceAttribute> attributes, String tableName) {
        this.refInfos = refInfos;
        this.geometryType = geometryType;
        boolean bl = this.isCheckTable = tableName.startsWith("Pr\u00fcfungen->") || tableName.startsWith("TechProf");
        if (attributes != null) {
            for (FeatureServiceAttribute attribute : attributes) {
                this.attributesMap.put(attribute.getName(), attribute);
            }
        }
        if (refInfos != null) {
            this.refInfoMap = new HashMap<String, LinearReferencingInfo>();
            for (LinearReferencingInfo info : refInfos) {
                this.refInfoMap.put(info.getFromField(), info);
                if (info.getTillField() == null) continue;
                this.refInfoMap.put(info.getTillField(), info);
            }
        }
    }

    public TableCellEditor getCellEditor(String columnName) {
        StationTableCellEditorInterface editor;
        StationTableCellEditorInterface editorCopy;
        Collection cellEditor;
        LinearReferencingInfo refInfo = this.getInfoForColumn(columnName);
        if (refInfo != null && (cellEditor = Lookup.getDefault().lookupAll(StationTableCellEditorInterface.class)) != null && cellEditor.size() > 0 && (editorCopy = this.createNewInstance(editor = cellEditor.toArray(new StationTableCellEditorInterface[1])[0])) != null) {
            editorCopy.setLinRefInfos(this.refInfos);
            editorCopy.setColumnName(columnName);
            return editorCopy;
        }
        return super.getCellEditor(columnName);
    }

    public FeatureCreator getFeatureCreator() {
        if (this.refInfos == null || this.refInfos.isEmpty()) {
            if (this.geometryType.equalsIgnoreCase("Point")) {
                return new PrimitiveGeometryCreator("POINT", false);
            }
            if (this.geometryType.equalsIgnoreCase("MultiPoint")) {
                return new PrimitiveGeometryCreator("POINT", true);
            }
            if (this.geometryType.equalsIgnoreCase("LineString")) {
                PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("LINESTRING", false);
                creator.setMinLength(0.01);
                return creator;
            }
            if (this.geometryType.equalsIgnoreCase("MultiLineString")) {
                PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("LINESTRING", true);
                creator.setMinLength(0.01);
                return creator;
            }
            if (this.geometryType.equalsIgnoreCase("Polygon")) {
                PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", false);
                c.setMinArea(1.0E-4);
                return c;
            }
            if (this.geometryType.equalsIgnoreCase("MultiPolygon")) {
                PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
                c.setMinArea(1.0E-4);
                return c;
            }
            if (this.geometryType.equalsIgnoreCase("none")) {
                return new WithoutGeometryCreator();
            }
        }
        return super.getFeatureCreator();
    }

    private StationTableCellEditorInterface createNewInstance(StationTableCellEditorInterface editor) {
        try {
            Constructor<?> c = editor.getClass().getConstructor(new Class[0]);
            return (StationTableCellEditorInterface)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot create a new instance of class " + editor.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    public TableCellRenderer getCellRenderer(String columnName) {
        if (this.isCheckTable) {
            return this.getSpecialRenderer(columnName);
        }
        LinearReferencingInfo refInfo = this.getInfoForColumn(columnName);
        if (refInfo != null) {
            return new DefaultTableCellRenderer(){
                DecimalFormat format = new DecimalFormat();
                {
                    this.format.setGroupingUsed(false);
                    this.format.setMaximumFractionDigits(2);
                    this.format.setMinimumFractionDigits(2);
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Object val = value;
                    if (value instanceof Number) {
                        val = this.format.format(value);
                    } else if (value instanceof String) {
                        try {
                            val = Double.parseDouble((String)value);
                            val = this.format.format(val);
                        }
                        catch (NumberFormatException e) {
                            LOG.error((Object)"Numeric field does not contain a numeric value", (Throwable)e);
                        }
                    }
                    Component c = super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setHorizontalAlignment(4);
                        ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                    }
                    return c;
                }
            };
        }
        FeatureServiceAttribute attr = this.attributesMap.get(columnName);
        if (attr != null && (FeatureTools.getH2DataType((FeatureServiceAttribute)attr).equalsIgnoreCase("double") || FeatureTools.getH2DataType((FeatureServiceAttribute)attr).equalsIgnoreCase("integer") || FeatureTools.getH2DataType((FeatureServiceAttribute)attr).equalsIgnoreCase("bigint") || FeatureTools.getH2DataType((FeatureServiceAttribute)attr).equalsIgnoreCase("numeric"))) {
            if (columnName.equals("ba_st_von") || columnName.equals("ba_st_bis") || columnName.equals("laenge") || columnName.equals("bak_st_von") || columnName.equals("bak_st_bis") || columnName.equals("lak_st_von") || columnName.equals("lak_st_bis") || columnName.equals("la_st_von") || columnName.equals("la_st_bis")) {
                return new DefaultTableCellRenderer(){
                    DecimalFormat format = new DecimalFormat();
                    {
                        this.format.setGroupingUsed(false);
                        this.format.setMaximumFractionDigits(2);
                        this.format.setMinimumFractionDigits(2);
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = value != null ? super.getTableCellRendererComponent(table, this.format.format(value).replace('.', ','), isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (c instanceof JLabel) {
                            ((JLabel)c).setHorizontalAlignment(4);
                            ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                        }
                        return c;
                    }
                };
            }
            return new DefaultTableCellRenderer(){
                DecimalFormat format = new DecimalFormat();
                {
                    this.format.setGroupingUsed(false);
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = value != null && value instanceof Number ? super.getTableCellRendererComponent(table, this.format.format(value).replace('.', ','), isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setHorizontalAlignment(4);
                        ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                    }
                    return c;
                }
            };
        }
        return null;
    }

    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            WatergisDefaultRuleSet.downloadDocumentFromWebDav(WatergisDefaultRuleSet.getWbblPath(), WatergisDefaultRuleSet.addExtension(value.toString(), "pdf"));
        }
    }

    private TableCellRenderer getSpecialRenderer(String columnName) {
        final WatergisDefaultRuleSet.DataType type = this.typeMap.get(columnName);
        if (columnName.equals("id") || columnName.equals("ww_gr")) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setHorizontalAlignment(4);
                        ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                    }
                    return c;
                }
            };
        }
        if (type != null) {
            if (type instanceof WatergisDefaultRuleSet.Numeric) {
                return new DefaultTableCellRenderer(){
                    DecimalFormat format = new DecimalFormat();
                    DecimalFormat formatWithOutdecimals = new DecimalFormat();
                    {
                        this.format.setGroupingUsed(false);
                        this.format.setMaximumFractionDigits(((WatergisDefaultRuleSet.Numeric)type).getScale());
                        this.format.setMinimumFractionDigits(((WatergisDefaultRuleSet.Numeric)type).getScale());
                        this.formatWithOutdecimals.setGroupingUsed(false);
                        this.formatWithOutdecimals.setMaximumFractionDigits(0);
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c;
                        Object val = value;
                        if (value instanceof Number) {
                            val = this.format.format(value);
                        } else if (value instanceof String) {
                            try {
                                val = Double.parseDouble((String)value);
                                val = this.format.format(val);
                            }
                            catch (NumberFormatException e) {
                                LOG.error((Object)"Numeric field does not contain a numeric value", (Throwable)e);
                            }
                        }
                        if (val != null && ((WatergisDefaultRuleSet.Numeric)type).isShowDecimalsOnlyIfExists()) {
                            try {
                                double doubleVal = this.format.parse(val.toString()).doubleValue();
                                long longVal = (long)doubleVal;
                                if (doubleVal == (double)longVal) {
                                    val = this.formatWithOutdecimals.format(longVal);
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Numeric field does not contain a numeric value", (Throwable)e);
                            }
                        }
                        if ((c = super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column)) instanceof JLabel) {
                            ((JLabel)c).setHorizontalAlignment(4);
                            ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                        }
                        return c;
                    }
                };
            }
            if (type instanceof WatergisDefaultRuleSet.BooleanAsInteger || type instanceof WatergisDefaultRuleSet.Catalogue && ((WatergisDefaultRuleSet.Catalogue)type).isRightAlignment()) {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (c instanceof JLabel) {
                            ((JLabel)c).setHorizontalAlignment(4);
                            ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                        }
                        return c;
                    }
                };
            }
            if (type instanceof WatergisDefaultRuleSet.Link && ((WatergisDefaultRuleSet.Link)type).isRightAlignment()) {
                return new LinkTableCellRenderer(4);
            }
        }
        return null;
    }

    public LinearReferencingInfo getInfoForColumn(String columnName) {
        if (this.refInfoMap == null) {
            return null;
        }
        return this.refInfoMap.get(columnName);
    }

    public List<LinearReferencingInfo> getAllLinRefInfos() {
        return this.refInfos;
    }

    public H2AttributeTableRuleSet clone() {
        DefaultWatergisH2AttributeTableRuleSet ruleSet = new DefaultWatergisH2AttributeTableRuleSet();
        ruleSet.refInfos = this.refInfos;
        ruleSet.refInfoMap = this.refInfoMap;
        ruleSet.attributesMap = this.attributesMap;
        ruleSet.geometryType = this.geometryType;
        ruleSet.isCheckTable = this.isCheckTable;
        return ruleSet;
    }

    public void startEditMode(JDBCFeature feature) {
        this.createEditor(feature);
    }

    private void createEditor(JDBCFeature feature) {
        if (this.refInfoMap == null || this.refInfos == null || this.refInfos.isEmpty()) {
            return;
        }
        LinearReferencingHelper linHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();
        LinearReferencingInfo info = this.refInfos.get(0);
        MetaClass metaClass = ClassCacheMultiple.getMetaClass((String)info.getDomain(), (String)info.getLinRefReferenceName());
        if (metaClass != null) {
            try {
                String query = "SELECT %s, %s FROM %s WHERE %s = '%s';";
                String routeQuery = String.format("SELECT %s, %s FROM %s WHERE %s = '%s';", metaClass.getID(), metaClass.getPrimaryKey(), metaClass.getTableName(), info.getTrgLinRefJoinField(), feature.getProperty(info.getSrcLinRefJoinField()));
                MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), routeQuery);
                if (mos != null && mos.length == 1) {
                    MetaObject routeObject = mos[0];
                    if (info.getTillField() == null || info.getTillField().isEmpty()) {
                        CidsBean stationBean = linHelper.createStationBeanFromRouteBean(routeObject.getBean(), ((Double)feature.getProperty(info.getFromField())).doubleValue());
                        TableStationEditor editor = new TableStationEditor(info.getLinRefReferenceName(), (FeatureServiceFeature)feature, info.getSrcLinRefJoinField());
                        editor.setCidsBean(stationBean);
                        editor.addPropertyChangeListener(feature.getPropertyChangeListener());
                        feature.setStationEditor(info.getFromField(), (StationEditorInterface)editor);
                    } else {
                        CidsBean lineBean = linHelper.createLineBeanFromRouteBean(routeObject.getBean());
                        linHelper.setGeometryToLineBean(feature.getGeometry(), lineBean);
                        CidsBean fromStation = linHelper.getStationBeanFromLineBean(lineBean, true);
                        linHelper.setLinearValueToStationBean((Double)feature.getProperty(info.getFromField()), fromStation);
                        CidsBean toStation = linHelper.getStationBeanFromLineBean(lineBean, false);
                        linHelper.setLinearValueToStationBean((Double)feature.getProperty(info.getTillField()), toStation);
                        TableLinearReferencedLineEditor st = new TableLinearReferencedLineEditor(info.getLinRefReferenceName(), (FeatureServiceFeature)feature, info.getSrcLinRefJoinField());
                        st.setCidsBean(lineBean);
                        TableStationEditor fromEditor = st.getFromStation();
                        TableStationEditor toEditor = st.getToStation();
                        st.addPropertyChangeListener(feature.getPropertyChangeListener());
                        feature.setBackgroundColor(st.getLineColor());
                        feature.setStationEditor(info.getGeomField(), (StationEditorInterface)st);
                        feature.setStationEditor(info.getFromField(), (StationEditorInterface)fromEditor);
                        feature.setStationEditor(info.getTillField(), (StationEditorInterface)toEditor);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while creating station bean", (Throwable)ex);
            }
        }
    }
}

