/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DeichRuleSet
extends WatergisDefaultRuleSet {
    public DeichRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("zuordnung", new WatergisDefaultRuleSet.Varchar(100, false, false));
        this.typeMap.put("bez", new WatergisDefaultRuleSet.Varchar(100, false, false));
        this.typeMap.put("anlagekat", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("baujahr", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("berme", new WatergisDefaultRuleSet.Varchar(50, true, true));
        this.typeMap.put("bewuchs", new WatergisDefaultRuleSet.Varchar(50, true, true));
        this.typeMap.put("deichnr", new WatergisDefaultRuleSet.Varchar(50, true, true));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("geom");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return super.getCellEditor(columnName);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -2;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("LINESTRING", true);
        return c;
    }
}

