/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EzgKumSgDiffRuleSet
extends WatergisDefaultRuleSet {
    public EzgKumSgDiffRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("see_lawa", new WatergisDefaultRuleSet.Varchar(20, true, true));
        this.typeMap.put("see_sp", new WatergisDefaultRuleSet.Varchar(8, true, true));
        this.typeMap.put("flaeche_diff", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("anteil", new WatergisDefaultRuleSet.Numeric(6, 2, false, false));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("flaeche") && !columnName.equals("geom") && !columnName.equals("id") & !columnName.equals("anteil");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche", "anteil"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        if (name.equals("anteil")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            if (propertyName.equals("flaeche")) {
                return Math.round(geom.getArea());
            }
            if (propertyName.equals("anteil")) {
                Double diff = (Double)feature.getProperty("flaeche_diff");
                return (double)Math.round(geom.getArea() * 100.0 / (diff + geom.getArea()) * 100.0) / 100.0;
            }
        }
        return null;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        switch (propertyName) {
            case "flaeche": {
                return "round(st_area(geom))";
            }
            case "anteil": {
                return "round( (st_area(geom) * 100 / (flaeche_diff + anteil) ) * 100) / 100.0";
            }
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        if (index == 4) {
            return Double.class;
        }
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

