/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FgBaDRuleSet
extends WatergisDefaultRuleSet {
    public FgBaDRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("profil", new WatergisDefaultRuleSet.Catalogue("k_profil", true, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("material", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaDRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br_dm_li", new WatergisDefaultRuleSet.Numeric(8, 3, false, true));
        this.typeMap.put("ho_li", new WatergisDefaultRuleSet.Numeric(8, 3, false, true));
        this.typeMap.put("br_tr_o_li", new WatergisDefaultRuleSet.Numeric(5, 3, false, true));
        this.typeMap.put("ho_e", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_a", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("gefaelle", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_d_e", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_a", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_m", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.minBaLength = 0.5;
        this.maxConfirmationlessLength = 100.0;
        this.maxBaLength = 250.0;
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("laenge") && !columnName.equals("ww_gr") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr") && !columnName.equals("id");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaDRuleSet.isValueEmpty(newValue) && column.equals("profil")) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaDRuleSet.getCurrentYear(), 1800, FgBaDRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("ho_e") && !this.checkRangeBetweenOrEqual(column, newValue, -6, 179, true)) {
            return oldValue;
        }
        if (column.equals("ho_a") && !this.checkRangeBetweenOrEqual(column, newValue, -6, 179, true)) {
            return oldValue;
        }
        if (column.equals("gefaelle") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 50.0, -10.0, 100.0, true)) {
            return oldValue;
        }
        if (column.equals("ho_d_e") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 5.0, 0.0, 10.0, true)) {
            return oldValue;
        }
        if (column.equals("ho_d_a") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 5.0, 0.0, 10.0, true)) {
            return oldValue;
        }
        if (column.equals("ho_d_m") && !this.checkRange(column, newValue, 0, 10, 0, 30, true, false, true)) {
            return oldValue;
        }
        if (column.equals("br_tr_o_li") && !this.checkRangeBetweenOrEqual(column, newValue, 0.05, 5.0, 0.025, 10.0, true)) {
            return oldValue;
        }
        if (column.equals("br_dm_li") && feature.getProperty("profil") != null) {
            if (feature.getProperty("profil").equals("kr") || feature.getProperty("profil").equals("ei")) {
                if (this.isNoIntegerTempMessage(column, newValue, true) && newValue instanceof Number) {
                    newValue = Math.round(((Number)newValue).doubleValue());
                }
                if (!this.checkRangeBetweenOrEqual("br_dm_li", newValue, 50.0, 5000.0, 25.0, 10000.0, true)) {
                    return oldValue;
                }
            }
            if ((feature.getProperty("profil").equals("re") || feature.getProperty("profil").equals("tr")) && !this.checkRangeBetweenOrEqual("br_dm_li", newValue, 0.05, 5.0, 0.025, 10.0, true)) {
                return oldValue;
            }
        }
        if (column.equals("ho_li") && feature.getProperty("profil") != null) {
            if (feature.getProperty("profil").equals("ei")) {
                if (this.isNoIntegerTempMessage(column, newValue, true) && newValue instanceof Number) {
                    newValue = Math.round(((Number)newValue).doubleValue());
                }
                if (!this.checkRangeBetweenOrEqual("ho_li", newValue, 50.0, 5000.0, 25.0, 10000.0, true)) {
                    return oldValue;
                }
            }
            if ((feature.getProperty("profil").equals("re") || feature.getProperty("profil").equals("tr")) && !this.checkRangeBetweenOrEqual("ho_li", newValue, 0.05, 5.0, 0.025, 10.0, true)) {
                return oldValue;
            }
        }
        if ((column.equals("ho_li") || column.equals("br_tr_o_li")) && !FgBaDRuleSet.isValueEmpty(newValue) && feature.getProperty("profil") != null && feature.getProperty("profil").equals("kr")) {
            this.showMessage("Bei Profil = kr ist kein Wert f\u00fcr " + column + " zul\u00e4ssig", column);
            return null;
        }
        if (column.equals("br_tr_o_li") && !FgBaDRuleSet.isValueEmpty(newValue) && feature.getProperty("profil") != null && FgBaDRuleSet.isValueIn(feature.getProperty("profil"), new String[]{"ei", "kr", "re"}, false)) {
            this.showMessage("Bei Profil = " + feature.getProperty("profil") + " ist kein Wert f\u00fcr " + column + " zul\u00e4ssig", column);
            return null;
        }
        if (column.equals("br_dm") && !FgBaDRuleSet.isValueEmpty(newValue) && feature.getProperty("profil") != null && feature.getProperty("profil").equals("tr") && newValue != null && feature.getProperty("br_tr_o_li") != null && newValue.equals(feature.getProperty("br_tr_o_li"))) {
            this.showMessage("Bei Profil = tr d\u00fcrfen br_dm und br_tr_o_li nicht gleich sein.", column);
            return oldValue;
        }
        if (column.equals("br_tr_o_li") && !FgBaDRuleSet.isValueEmpty(newValue) && feature.getProperty("profil") != null && feature.getProperty("profil").equals("tr") && newValue != null && feature.getProperty("br_dm") != null && newValue.equals(feature.getProperty("br_dm"))) {
            this.showMessage("Bei Profil = tr d\u00fcrfen br_dm und br_tr_o_li nicht gleich sein.", column);
            return oldValue;
        }
        if (column.equals("ho_a") || column.equals("ho_e")) {
            if (column.equals("ho_a") && feature.getProperty("ho_e") != null) {
                double hoa;
                double hoe = FgBaDRuleSet.toNumber(feature.getProperty("ho_e")).doubleValue();
                if (hoe < (hoa = FgBaDRuleSet.toNumber(newValue).doubleValue()) && !this.showSecurityQuestion("ho_e >= ho_a nicht eingehalten. Fortsetzen?", column, newValue)) {
                    return oldValue;
                }
            } else if (column.equals("ho_e") && feature.getProperty("ho_a") != null) {
                double hoa = FgBaDRuleSet.toNumber(feature.getProperty("ho_a")).doubleValue();
                double hoe = FgBaDRuleSet.toNumber(newValue).doubleValue();
                if (hoe < hoa && !this.showSecurityQuestion("ho_e >= ho_a nicht eingehalten. Fortsetzen?", column, newValue)) {
                    return oldValue;
                }
            }
        }
        if (column.equals("ho_a") || column.equals("ho_e") || column.equals("ba_st_bis") || column.equals("ba_st_von")) {
            Object bis;
            Object hoA = column.equals("ho_a") ? newValue : feature.getProperty("ho_a");
            Object hoE = column.equals("ho_e") ? newValue : feature.getProperty("ho_e");
            Object von = column.equals("ba_st_von") ? newValue : feature.getProperty("ba_st_von");
            Object object = bis = column.equals("ba_st_bis") ? newValue : feature.getProperty("ba_st_bis");
            if (hoA != null && FgBaDRuleSet.isNumberOrNull(hoA) && hoE != null && FgBaDRuleSet.isNumberOrNull(hoE) && von != null && FgBaDRuleSet.isNumberOrNull(von) && bis != null && FgBaDRuleSet.isNumberOrNull(bis)) {
                double laenge = FgBaDRuleSet.toNumber(bis).doubleValue() - FgBaDRuleSet.toNumber(von).doubleValue();
                double gefaelle = (FgBaDRuleSet.toNumber(hoE).doubleValue() - FgBaDRuleSet.toNumber(hoA).doubleValue()) / Math.abs(laenge) * 1000.0;
                feature.setProperty("gefaelle", (Object)gefaelle);
                if (!this.checkRangeBetweenOrEqual("gefaelle", feature.getProperty("gefaelle"), 0.0, 50.0, -10.0, 100.0, true)) {
                    return oldValue;
                }
            } else if (feature.getProperty("gefaelle") != null) {
                feature.setProperty("gefaelle", null);
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("material")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("dl");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("profil")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("d");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("profil") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            int answ;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaDRuleSet.isValueEmpty(feature.getProperty("profil"))) {
                this.showMessage("Das Attribut Profil darf nicht leer sein", "profil");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "profil");
            }
            if (!this.checkRangeBetweenOrEqual("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaDRuleSet.getCurrentYear() + 2, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (!this.checkRangeBetweenOrEqual("ho_e", feature.getProperty("ho_e"), -6, 179, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_e");
            }
            if (!this.checkRangeBetweenOrEqual("ho_a", feature.getProperty("ho_a"), -6, 179, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_a");
            }
            if (!this.checkRangeBetweenOrEqual("gefaelle", feature.getProperty("gefaelle"), 0, 50, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gefaelle");
            }
            if (!this.checkRangeBetweenOrEqual("ho_d_e", feature.getProperty("ho_d_e"), 0, 10, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_e");
            }
            if (!this.checkRangeBetweenOrEqual("ho_d_a", feature.getProperty("ho_d_a"), 0, 10, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_a");
            }
            if (!this.checkRange("ho_d_m", feature.getProperty("ho_d_m"), 0, 30, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_m");
            }
            if (!this.checkRangeBetweenOrEqual("br_tr_o_li", feature.getProperty("br_tr_o_li"), 0.025, 6.0, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_tr_o_li");
            }
            if (FgBaDRuleSet.isValueIn(feature.getProperty("profil"), new Object[]{"kr", "ei"}, false)) {
                if (!this.checkRangeBetweenOrEqual("br_dm_li", feature.getProperty("br_dm_li"), 25, 6000, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_dm_li");
                }
                if (this.isNoInteger("br_dm_li", feature.getProperty("br_dm_li"), false)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_dm_li");
                }
                if (this.isNoInteger("ho_li", feature.getProperty("ho_li"), false)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_li");
                }
            }
            if (FgBaDRuleSet.isValueIn(feature.getProperty("profil"), new Object[]{"re", "tr"}, false)) {
                if (!this.checkRangeBetweenOrEqual("br_dm_li", feature.getProperty("br_dm_li"), 0.025, 6.0, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_dm_li");
                }
                if (!this.checkRangeBetweenOrEqual("ho_li", feature.getProperty("ho_li"), 0.025, 6.0, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_li");
                }
            }
            if (feature.getProperty("profil").equals("ei") && !this.checkRangeBetweenOrEqual("ho_li", feature.getProperty("ho_li"), 25, 6000, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_li");
            }
            if (feature.getProperty("profil").equals("kr") && (feature.getProperty("ho_li") != null || feature.getProperty("br_tr_o_li") != null)) {
                this.showMessage("Die Attribute ho_li und br_tr_o_li d\u00fcrfen nicht belegt sein, wenn profil = kr.", "ho_li / br_tr_o_li");
                if (feature.getProperty("ho_li") != null) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_li");
                }
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_tr_o_li");
            }
            if ((feature.getProperty("profil").equals("ei") || feature.getProperty("profil").equals("re")) && feature.getProperty("br_tr_o_li") != null) {
                this.showMessage("Das Attribute br_tr_o_li darf nicht belegt sein, wenn profil = ei oder re.", "br_tr_o_li");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_tr_o_li");
            }
            if (feature.getProperty("profil").equals("tr") && feature.getProperty("br_dm_li") != null && feature.getProperty("br_tr_o_li") != null && feature.getProperty("br_dm_li") == feature.getProperty("br_tr_o_li")) {
                this.showMessage("Die Attribute br_dm_li und br_tr_o_li d\u00fcrfen nicht gleich sein, wenn profil = tr.", "br_dm_li");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_dm_li");
            }
            if (feature.getProperty("ho_e") == null || feature.getProperty("ho_a") == null || !(((Number)feature.getProperty("ho_e")).doubleValue() < ((Number)feature.getProperty("ho_a")).doubleValue()) || (answ = JOptionPane.showConfirmDialog(AppBroker.getInstance().getWatergisApp(), "Sind Sie sicher, dass das Attribut ho_e (" + feature.getProperty("ho_e") + ") kleiner als das Attribut ho_a(" + feature.getProperty("ho_a") + ") sein soll?", "Best\u00e4tigung ID: " + this.idOfCurrentlyCheckedFeature + " Feld: ho_e", 0)) == 0) continue;
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_e");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
        if (feature.getProperty("ho_a") != null && FgBaDRuleSet.isNumberOrNull(feature.getProperty("ho_a")) && feature.getProperty("ho_e") != null && FgBaDRuleSet.isNumberOrNull(feature.getProperty("ho_e"))) {
            double laenge = FgBaDRuleSet.toNumber(feature.getProperty("ba_st_bis")).doubleValue() - FgBaDRuleSet.toNumber(feature.getProperty("ba_st_von")).doubleValue();
            double gefaelle = (FgBaDRuleSet.toNumber(feature.getProperty("ho_e")).doubleValue() - FgBaDRuleSet.toNumber(feature.getProperty("ho_a")).doubleValue()) / laenge * 1000.0;
            feature.setProperty("gefaelle", (Object)gefaelle);
        }
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 0.5f, 250.0f);
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaDRuleSet.downloadDocumentFromWebDav(FgBaDRuleSet.getWbblPath(), FgBaDRuleSet.addExtension(value.toString(), "pdf"));
        }
    }
}

