/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.LineAndStationCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.RouteTableCellEditor;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FgBaDeichRuleSet
extends WatergisDefaultRuleSet {
    private static Logger LOG = Logger.getLogger(FgBaDeichRuleSet.class);

    public FgBaDeichRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("km_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("km_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("l_rl", new WatergisDefaultRuleSet.Catalogue("k_l_rl", false, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("name", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("deich", new WatergisDefaultRuleSet.Catalogue("k_deich", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("ord", new WatergisDefaultRuleSet.Catalogue("k_deich_ord", true, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("l_fk", new WatergisDefaultRuleSet.Catalogue("k_deich_l_fk", true, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("schgr", new WatergisDefaultRuleSet.Catalogue("k_deich_schgr", false, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("material_f", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material_w", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material_k", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material_i", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material_b", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("berme_w", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("berme_b", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaDeichRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br_f", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("br_k", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_k_f", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_k_pn", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_bhw_pn", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_mw_pn", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bv_w", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bv_b", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.minBaLength = 10.0;
    }

    public boolean isColumnEditable(String columnName) {
        if (columnName.equals("ww_gr")) {
            return AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren");
        }
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("laenge") && !columnName.equals("obj_nr") && !columnName.equals("id");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaDeichRuleSet.isValueEmpty(newValue) && (column.equalsIgnoreCase("deich") || column.equalsIgnoreCase("ord") || column.equalsIgnoreCase("l_fk"))) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaDeichRuleSet.getCurrentYear(), 1800, FgBaDeichRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("bv_w") && !this.checkRangeBetweenOrEqual(column, newValue, 3.0, 6.0, 1.0, 15.0, true)) {
            return oldValue;
        }
        if (column.equals("bv_b") && !this.checkRangeBetweenOrEqual(column, newValue, 3.0, 6.0, 1.0, 15.0, true)) {
            return oldValue;
        }
        if (column.equals("l_fk") && newValue != null) {
            if (FgBaDeichRuleSet.isValueIn(newValue, new Object[]{"fd"}, false)) {
                if (!this.checkRangeBetweenOrEqual("br_f", feature.getProperty("br_f"), 2.0, 20.0, 2.0, 50.0, true)) {
                    return oldValue;
                }
                if (!this.checkRangeBetweenOrEqual("br_k", feature.getProperty("br_k"), 1.0, 5.0, 0.5, 10.0, true)) {
                    return oldValue;
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_f", feature.getProperty("ho_k_f"), 0.5, 10.0, 0.5, 15.0, true)) {
                    return oldValue;
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_pn", feature.getProperty("ho_k_pn"), 2.0, 20.0, 2.0, 25.0, true)) {
                    return oldValue;
                }
                if (!this.checkRangeBetweenOrEqual("ho_bhw_pn", feature.getProperty("ho_bhw_pn"), 2.0, 20.0, 2.0, 25.0, true)) {
                    return oldValue;
                }
                if (!FgBaDeichRuleSet.isValueIn(feature.getProperty("l_rl"), new Object[]{"re", "li", "nb"}, false)) {
                    this.showMessage("Wenn l_fk = fd, dann muss l_rl = re, li oder nb", "l_rl");
                    return oldValue;
                }
            } else if (FgBaDeichRuleSet.isValueIn(newValue, new Object[]{"bd", "kd"}, false)) {
                if (!this.checkRangeBetweenOrEqual("br_f", feature.getProperty("br_f"), 2.0, 50.0, 2.0, 100.0, true)) {
                    return oldValue;
                }
                if (!this.checkRangeBetweenOrEqual("br_k", feature.getProperty("br_k"), 1.0, 10.0, 0.5, 20.0, true)) {
                    return oldValue;
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_f", feature.getProperty("ho_k_f"), 1.0, 10.0, 1.0, 15.0, true)) {
                    return oldValue;
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_pn", feature.getProperty("ho_k_pn"), 1.0, 15.0, 1.0, 20.0, true)) {
                    return oldValue;
                }
                if (!this.checkRange("ho_bhw_pn", feature.getProperty("ho_bhw_pn"), 0, 15, 0, 20, true, false, true)) {
                    return oldValue;
                }
                this.removeStationLine((CidsLayerFeature)feature);
                feature.setProperty("l_rl", null);
            }
        }
        if (column.equals("br_f") && newValue != null && (FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"fd"}, false) ? !this.checkRangeBetweenOrEqual("br_f", newValue, 2.0, 20.0, 2.0, 50.0, true) : FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"bd", "kd"}, false) && !this.checkRangeBetweenOrEqual("br_f", newValue, 2.0, 50.0, 2.0, 100.0, true))) {
            return oldValue;
        }
        if (column.equals("br_k") && newValue != null && (FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"fd"}, false) ? !this.checkRangeBetweenOrEqual("br_k", newValue, 1.0, 5.0, 0.5, 10.0, true) : FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"bd", "kd"}, false) && !this.checkRangeBetweenOrEqual("br_k", newValue, 1.0, 10.0, 0.5, 20.0, true))) {
            return oldValue;
        }
        if (column.equals("ho_k_f") && newValue != null && (FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"fd"}, false) ? !this.checkRangeBetweenOrEqual("ho_k_f", newValue, 0.5, 10.0, 0.5, 15.0, true) : FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"bd", "kd"}, false) && !this.checkRangeBetweenOrEqual("ho_k_f", newValue, 1.0, 10.0, 1.0, 15.0, true))) {
            return oldValue;
        }
        if (column.equals("ho_k_pn") && newValue != null && (FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"fd"}, false) ? !this.checkRangeBetweenOrEqual("ho_k_pn", newValue, 2.0, 20.0, 2.0, 25.0, true) : FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"bd", "kd"}, false) && !this.checkRangeBetweenOrEqual("ho_k_pn", newValue, 1.0, 15.0, 1.0, 20.0, true))) {
            return oldValue;
        }
        if (column.equals("ho_bhw_pn") && newValue != null && (FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"fd"}, false) ? !this.checkRangeBetweenOrEqual("ho_bhw_pn", newValue, 2.0, 20.0, 2.0, 25.0, true) : FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"bd", "kd"}, false) && !this.checkRange("ho_bhw_pn", newValue, 0, 15, 0, 20, true, false, true))) {
            return oldValue;
        }
        if ((column.equals("ba_cd") || column.equals("ba_st_von") || column.equals("ba_st_bis")) && newValue != null && FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"bd", "kd"}, false)) {
            this.showMessage("Es darf keine Stationierung angegeben sein, wenn l_fk = bd oder kd", "ba_cd");
            this.removeStationLine((CidsLayerFeature)feature);
            return oldValue;
        }
        if (column.equals("br_f") && newValue != null && feature.getProperty("br_k") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("br_k")).doubleValue()) {
            this.showMessage("Das Attribute br_f muss gr\u00f6\u00dfer br_k sein.", "br_f");
            return oldValue;
        }
        if (column.equals("br_k") && feature.getProperty("br_f") != null && newValue != null && ((Number)feature.getProperty("br_f")).doubleValue() <= ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribute br_f muss gr\u00f6\u00dfer br_k sein.", "br_k");
            return oldValue;
        }
        if (column.equals("ho_k_f") && newValue != null && feature.getProperty("ho_k_pn") != null && ((Number)feature.getProperty("ho_k_pn")).doubleValue() <= ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_k_f sein.", column);
            return oldValue;
        }
        if (column.equals("ho_k_pn")) {
            if (feature.getProperty("ho_k_f") != null && newValue != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("ho_k_f")).doubleValue()) {
                this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_k_f sein.", column);
                return oldValue;
            }
            if (feature.getProperty("ho_bhw_pn") != null && newValue != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("ho_bhw_pn")).doubleValue()) {
                this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_bhw_pn sein.", column);
                return oldValue;
            }
        }
        if (column.equals("ho_bhw_pn")) {
            if (newValue != null && feature.getProperty("ho_k_pn") != null && ((Number)feature.getProperty("ho_k_pn")).doubleValue() <= ((Number)newValue).doubleValue()) {
                this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_bhw_pn sein.", column);
                return oldValue;
            }
            if (newValue != null && feature.getProperty("ho_mw_pn") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("ho_mw_pn")).doubleValue()) {
                this.showMessage("Das Attribute ho_bhw_pn muss gr\u00f6\u00dfer ho_mw_pn sein.", column);
                return oldValue;
            }
        }
        if (column.equals("ho_mw_pn")) {
            if (feature.getProperty("ho_bhw_pn") != null && newValue != null && ((Number)feature.getProperty("ho_bhw_pn")).doubleValue() <= ((Number)newValue).doubleValue()) {
                this.showMessage("Das Attribute ho_bhw_pn muss gr\u00f6\u00dfer ho_mw_pn sein.", column);
                return oldValue;
            }
            if (feature.getProperty("ho_k_pn") != null && newValue != null && ((Number)feature.getProperty("ho_k_pn")).doubleValue() <= ((Number)newValue).doubleValue()) {
                this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_mw_pn sein.", column);
                return oldValue;
            }
        }
        if (column.equals("ho_k_pn") && newValue != null && feature.getProperty("ho_mw_pn") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("ho_mw_pn")).doubleValue()) {
            this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_mw_pn sein.", column);
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    private void removeStationLine(CidsLayerFeature cidsFeature) {
        try {
            cidsFeature.removeStations();
            cidsFeature.setProperty("ba_cd", null);
            cidsFeature.getBean().setProperty("ba_cd", null);
            CidsLayerInfo info = cidsFeature.getLayerInfo();
            for (String colName : info.getColumnNames()) {
                if (!info.isStation(colName) || !info.getStationInfo(colName).getRouteTable().equals("dlm25w.fg_ba")) continue;
                cidsFeature.setProperty(colName, null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while removing station", (Throwable)e);
        }
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_cd")) {
            RouteTableCellEditor editor = new RouteTableCellEditor("dlm25w.fg_ba", "ba_st", true);
            String filterString = this.getRouteFilter();
            if (filterString != null) {
                editor.setRouteQuery(filterString);
            }
            return editor;
        }
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_rl")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("deich");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_rl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("deich")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("deich") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("ord")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("ord") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_fk")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_fk") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("schgr")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("schgr") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.startsWith("material")) {
            CidsLayerFeatureFilter filter;
            AbstractCidsLayerListCellRenderer renderer = new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            };
            if (columnName.equals("material_f")) {
                filter = this.createCidsLayerFeatureFilter("deich_f");
            } else if (columnName.equals("material_w")) {
                filter = this.createCidsLayerFeatureFilter("deich_w");
            } else if (columnName.equals("material_k")) {
                filter = this.createCidsLayerFeatureFilter("deich_k");
            } else if (columnName.equals("material_i")) {
                filter = this.createCidsLayerFeatureFilter("deich_i");
            } else if (columnName.equals("material_b")) {
                filter = this.createCidsLayerFeatureFilter("deich_b");
            } else {
                return null;
            }
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)renderer);
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaDeichRuleSet.isValueEmpty(feature.getProperty("deich"))) {
                this.showMessage("Das Attribut deich darf nicht leer sein", "deich");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "deich");
            }
            if (FgBaDeichRuleSet.isValueEmpty(feature.getProperty("ord"))) {
                this.showMessage("Das Attribut ord darf nicht leer sein", "ord");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ord");
            }
            if (FgBaDeichRuleSet.isValueEmpty(feature.getProperty("l_fk"))) {
                this.showMessage("Das Attribut l_fk darf nicht leer sein", "l_fk");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_fk");
            }
            if (!this.checkRangeBetweenOrEqual("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaDeichRuleSet.getCurrentYear() + 2, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (!this.checkRangeBetweenOrEqual("bv_w", feature.getProperty("bv_w"), 1, 15, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bv_w");
            }
            if (!this.checkRangeBetweenOrEqual("bv_b", feature.getProperty("bv_b"), 1, 15, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bv_b");
            }
            if (FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"fd"}, false)) {
                if (!this.checkRangeBetweenOrEqual("br_f", feature.getProperty("br_f"), 2, 50, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_f");
                }
                if (!this.checkRangeBetweenOrEqual("br_k", feature.getProperty("br_k"), 0.5, 10.0, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_k");
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_f", feature.getProperty("ho_k_f"), 0.5, 15.0, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_k_f");
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_pn", feature.getProperty("ho_k_pn"), 2, 25, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_k_pn");
                }
                if (!this.checkRangeBetweenOrEqual("ho_bhw_pn", feature.getProperty("ho_bhw_pn"), 2, 25, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_bhw_pn");
                }
                if (!FgBaDeichRuleSet.isValueIn(feature.getProperty("l_rl"), new Object[]{"re", "li", "nb"}, false)) {
                    this.showMessage("Wenn l_fk = fd, dann muss l_rl = re, li oder nb", "l_rl");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_rl");
                }
            } else if (FgBaDeichRuleSet.isValueIn(feature.getProperty("l_fk"), new Object[]{"bd", "kd"}, false)) {
                if (!this.checkRangeBetweenOrEqual("br_f", feature.getProperty("br_f"), 2, 100, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_f");
                }
                if (!this.checkRangeBetweenOrEqual("br_k", feature.getProperty("br_k"), 0.5, 20.0, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_k");
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_f", feature.getProperty("ho_k_f"), 1, 15, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_k_f");
                }
                if (!this.checkRangeBetweenOrEqual("ho_k_pn", feature.getProperty("ho_k_pn"), 1, 20, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_k_pn");
                }
                if (!this.checkRange("ho_bhw_pn", feature.getProperty("ho_bhw_pn"), 0, 20, true, false, true)) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_bhw_pn");
                }
                if (!FgBaDeichRuleSet.isValueEmpty(feature.getProperty("l_rl"))) {
                    this.showMessage("Das Attribut l_rl muss leer sein, wenn l_fk = bd oder kd", "l_rl");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_rl");
                }
                if (feature.getProperty("ba_st") != null) {
                    this.showMessage("Es darf keine Stationierung angegeben sein, wenn l_fk = bd oder kd", "ba_st");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st");
                }
            }
            if (feature.getProperty("br_f") != null && feature.getProperty("br_k") != null && ((Number)feature.getProperty("br_f")).doubleValue() <= ((Number)feature.getProperty("br_k")).doubleValue()) {
                this.showMessage("Das Attribute br_f muss gr\u00f6\u00dfer br_k sein.", "br_f");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_f");
            }
            if (feature.getProperty("ho_k_f") != null && feature.getProperty("ho_k_pn") != null && ((Number)feature.getProperty("ho_k_pn")).doubleValue() <= ((Number)feature.getProperty("ho_k_f")).doubleValue()) {
                this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_k_f sein.", "ho_k_pn");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_k_pn");
            }
            if (feature.getProperty("ho_bhw_pn") != null && feature.getProperty("ho_k_pn") != null && ((Number)feature.getProperty("ho_k_pn")).doubleValue() <= ((Number)feature.getProperty("ho_bhw_pn")).doubleValue()) {
                this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_bhw_pn sein.", "ho_k_pn");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_k_pn");
            }
            if (feature.getProperty("ho_bhw_pn") != null && feature.getProperty("ho_mw_pn") != null && ((Number)feature.getProperty("ho_bhw_pn")).doubleValue() <= ((Number)feature.getProperty("ho_mw_pn")).doubleValue()) {
                this.showMessage("Das Attribute ho_bhw_pn muss gr\u00f6\u00dfer ho_mw_pn sein.", "ho_bhw_pn");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_bhw_pn");
            }
            if (feature.getProperty("ho_k_pn") == null || feature.getProperty("ho_mw_pn") == null || !(((Number)feature.getProperty("ho_k_pn")).doubleValue() <= ((Number)feature.getProperty("ho_mw_pn")).doubleValue())) continue;
            this.showMessage("Das Attribute ho_k_pn muss gr\u00f6\u00dfer ho_mw_pn sein.", "ho_k_pn");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_k_pn");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        return new LineAndStationCreator("ba_st", this.getDefaultValues(), routeMc, (LinearReferencingHelper)new LinearReferencingWatergisHelper());
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        return properties;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaDeichRuleSet.downloadDocumentFromWebDav(FgBaDeichRuleSet.getWbblPath(), FgBaDeichRuleSet.addExtension(value.toString(), "pdf"));
        }
    }

    public boolean isCatThree() {
        return true;
    }
}

