/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.HashMap;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FgBaSbefRuleSet
extends WatergisDefaultRuleSet {
    private static final HashMap<String, String[]> allowedMaterial = new HashMap();

    public FgBaSbefRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("sbef", new WatergisDefaultRuleSet.Catalogue("k_sbef", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaSbefRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_e", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_a", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("gefaelle", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_d_e", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_a", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.minBaLength = 0.5;
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("laenge") && !columnName.equals("ww_gr") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        String[] allowedMaterialVArray;
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaSbefRuleSet.isValueEmpty(newValue) && column.equals("sbef")) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", "sbef");
            return oldValue;
        }
        if (column.equals("br") && !this.checkRange(column, newValue, 0, 10, 0, 100, true, false, true)) {
            return oldValue;
        }
        if (column.equals("ho_e") && !this.checkRangeBetweenOrEqual(column, newValue, -6, 179, true)) {
            return oldValue;
        }
        if (column.equals("ho_a") && !this.checkRangeBetweenOrEqual(column, newValue, -6, 179, true)) {
            return oldValue;
        }
        if (column.equals("ho_d_e") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 1.0, 0.0, 5.0, true)) {
            return oldValue;
        }
        if (column.equals("ho_d_a") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 1.0, 0.0, 5.0, true)) {
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaSbefRuleSet.getCurrentYear(), 1800, FgBaSbefRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("ho_a") || column.equals("ho_e")) {
            if (column.equals("ho_a") && feature.getProperty("ho_e") != null) {
                double hoa;
                double hoe = FgBaSbefRuleSet.toNumber(feature.getProperty("ho_e")).doubleValue();
                if (hoe < (hoa = FgBaSbefRuleSet.toNumber(newValue).doubleValue())) {
                    this.showMessage("Wert nicht zul\u00e4ssig, weil ho_e >= ho_a nicht eingehalten", "ho_e");
                    return oldValue;
                }
            } else if (column.equals("ho_e") && feature.getProperty("ho_a") != null) {
                double hoa = FgBaSbefRuleSet.toNumber(feature.getProperty("ho_a")).doubleValue();
                double hoe = FgBaSbefRuleSet.toNumber(newValue).doubleValue();
                if (hoe < hoa) {
                    this.showMessage("Wert nicht zul\u00e4ssig, weil ho_e >= ho_a nicht eingehalten", "ho_e");
                    return oldValue;
                }
            }
        }
        if (column.equals("ho_a") || column.equals("ho_e") || column.equals("ba_st_bis") || column.equals("ba_st_von")) {
            Object bis;
            Object hoA = column.equals("ho_a") ? newValue : feature.getProperty("ho_a");
            Object hoE = column.equals("ho_e") ? newValue : feature.getProperty("ho_e");
            Object von = column.equals("ba_st_von") ? newValue : feature.getProperty("ba_st_von");
            Object object = bis = column.equals("ba_st_bis") ? newValue : feature.getProperty("ba_st_bis");
            if (hoA != null && FgBaSbefRuleSet.isNumberOrNull(hoA) && hoE != null && FgBaSbefRuleSet.isNumberOrNull(hoE) && von != null && FgBaSbefRuleSet.isNumberOrNull(von) && bis != null && FgBaSbefRuleSet.isNumberOrNull(bis)) {
                double laenge = FgBaSbefRuleSet.toNumber(bis).doubleValue() - FgBaSbefRuleSet.toNumber(von).doubleValue();
                double gefaelle = (FgBaSbefRuleSet.toNumber(hoE).doubleValue() - FgBaSbefRuleSet.toNumber(hoA).doubleValue()) / Math.abs(laenge) * 1000.0;
                feature.setProperty("gefaelle", (Object)gefaelle);
                if (!this.checkRangeBetweenOrEqual("gefaelle", feature.getProperty("gefaelle"), 0.0, 50.0, -10.0, 100.0, true)) {
                    return oldValue;
                }
            } else if (feature.getProperty("gefaelle") != null) {
                feature.setProperty("gefaelle", null);
            }
        }
        if (column.equals("gefaelle") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 50.0, -10.0, 100.0, true)) {
            return oldValue;
        }
        if (column.equals("material") && !FgBaSbefRuleSet.isValueEmpty(newValue) && (allowedMaterialVArray = allowedMaterial.get(feature.getProperty("sbef").toString())) != null && !FgBaSbefRuleSet.arrayContains(allowedMaterialVArray, newValue.toString())) {
            this.showMessage("Wenn das Attribut sbef = " + feature.getProperty("sbef").toString() + ", dann muss das Attribut material " + FgBaSbefRuleSet.arrayToString(allowedMaterialVArray) + " sein.", "material");
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("sbef")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), this.createCidsLayerFeatureFilter("fg_ba_sbef"));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("sbef") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("material")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), this.createCidsLayerFeatureFilter("sbef"));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            String[] allowedMaterialVArray;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaSbefRuleSet.isValueEmpty(feature.getProperty("sbef"))) {
                this.showMessage("Das Attribut sbef darf nicht leer sein", "sbef");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "sbef");
            }
            if (!this.checkRange("br", feature.getProperty("br"), 0, 100, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
            }
            if (!this.checkRangeBetweenOrEqual("ho_e", feature.getProperty("ho_e"), -6, 179, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_e");
            }
            if (!this.checkRangeBetweenOrEqual("ho_a", feature.getProperty("ho_a"), -6, 179, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_a");
            }
            if (!this.checkRangeBetweenOrEqual("ho_d_e", feature.getProperty("ho_d_e"), 0, 5, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_e");
            }
            if (!this.checkRangeBetweenOrEqual("ho_d_a", feature.getProperty("ho_d_a"), 0, 5, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_a");
            }
            if (!this.checkRangeBetweenOrEqual("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaSbefRuleSet.getCurrentYear() + 2, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (feature.getProperty("ho_e") != null && feature.getProperty("ho_a") != null && ((Number)feature.getProperty("ho_e")).doubleValue() < ((Number)feature.getProperty("ho_a")).doubleValue()) {
                this.showMessage("Das Attribute ho_e muss gr\u00f6\u00dfer oder gleich dem Attribut ho_a sein.", "ho_a");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_e");
            }
            if (feature.getProperty("sbef") != null && (allowedMaterialVArray = allowedMaterial.get(feature.getProperty("sbef").toString())) != null && !FgBaSbefRuleSet.isValueEmpty(feature.getProperty("material")) && !FgBaSbefRuleSet.arrayContains(allowedMaterialVArray, feature.getProperty("material").toString())) {
                this.showMessage("Wenn das Attribut sbef = " + feature.getProperty("sbef").toString() + ", dann muss das Attribut material " + FgBaSbefRuleSet.arrayToString(allowedMaterialVArray) + " sein.", "material");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "material");
            }
            this.refillGefaelle(feature);
            if (this.checkRangeBetweenOrEqual("gefaelle", feature.getProperty("gefaelle"), -10, 100, true)) continue;
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gefaelle");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    private void refillGefaelle(FeatureServiceFeature feature) {
        if (feature.getProperty("ho_a") != null && FgBaSbefRuleSet.isNumberOrNull(feature.getProperty("ho_a")) && feature.getProperty("ho_e") != null && FgBaSbefRuleSet.isNumberOrNull(feature.getProperty("ho_e"))) {
            double laenge = FgBaSbefRuleSet.toNumber(feature.getProperty("ba_st_bis")).doubleValue() - FgBaSbefRuleSet.toNumber(feature.getProperty("ba_st_von")).doubleValue();
            double gefaelle = (FgBaSbefRuleSet.toNumber(feature.getProperty("ho_e")).doubleValue() - FgBaSbefRuleSet.toNumber(feature.getProperty("ho_a")).doubleValue()) / laenge * 1000.0;
            feature.setProperty("gefaelle", (Object)gefaelle);
        } else if (feature.getProperty("gefaelle") != null) {
            feature.setProperty("gefaelle", null);
        }
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 0.5f, 100.0f);
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaSbefRuleSet.downloadDocumentFromWebDav(FgBaSbefRuleSet.getWbblPath(), FgBaSbefRuleSet.addExtension(value.toString(), "pdf"));
        }
    }

    static {
        allowedMaterial.put("Buh", new String[]{"H", "K", "Ste", "Ste-Fs", "Ste-Gab", "Ste-Wab"});
        allowedMaterial.put("Gtr", new String[]{"B", "K", "Ste-Fs"});
        allowedMaterial.put("Pf", new String[]{"B", "H", "K"});
        allowedMaterial.put("Pfl", new String[]{"B", "Ste", "Ste-Fs", "Ste-Gab", "Ste-Wb"});
        allowedMaterial.put("Pfr", new String[]{"B", "H", "K"});
        allowedMaterial.put("Pl", new String[]{"B"});
        allowedMaterial.put("Rgl", new String[]{"Ste", "Ste-Fs", "Ste-Gab", "Ste-Wb"});
        allowedMaterial.put("So-Ab", new String[]{"B"});
        allowedMaterial.put("So-Abt", new String[]{"B"});
        allowedMaterial.put("So-Gl", new String[]{"B"});
        allowedMaterial.put("So-Ra", new String[]{"B"});
        allowedMaterial.put("SP", new String[]{"Ste", "Ste-Fs", "Ste-Gab", "Ste-Wb"});
        allowedMaterial.put("St\u00f6ste", new String[]{"Ste", "Ste-Fs", "Ste-Wb"});
        allowedMaterial.put("Sw-Gru", new String[]{"B"});
        allowedMaterial.put("Sw-So", new String[]{"B"});
        allowedMaterial.put("Sw-St\u00fc", new String[]{"B"});
        allowedMaterial.put("Wu", new String[]{"H"});
    }
}

