/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FgBaSchwRuleSet
extends WatergisDefaultRuleSet {
    public FgBaSchwRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("name", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("schw", new WatergisDefaultRuleSet.Catalogue("k_schw", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaSchwRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("sz", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("az", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ezg_fl", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("v_fl", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("pu_anz1", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("pu_typ1", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("pu_motl1", new WatergisDefaultRuleSet.Numeric(5, 1, false, true));
        this.typeMap.put("pu_foel1", new WatergisDefaultRuleSet.Numeric(7, 1, false, true));
        this.typeMap.put("pu_anz2", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("pu_typ2", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("pu_motl2", new WatergisDefaultRuleSet.Numeric(5, 1, false, true));
        this.typeMap.put("pu_foel2", new WatergisDefaultRuleSet.Numeric(7, 1, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("ww_gr") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaSchwRuleSet.isValueEmpty(newValue) && column.equals("schw")) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaSchwRuleSet.getCurrentYear(), 1800, FgBaSchwRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("br") && !this.checkRange(column, newValue, 0, 10, 0, 30, true, false, true)) {
            return oldValue;
        }
        if (column.equals("sz") && !this.checkRange(column, newValue, -6, 179, true, true, true)) {
            return oldValue;
        }
        if (column.equals("az") && !this.checkRange(column, newValue, -6, 179, true, true, true)) {
            return oldValue;
        }
        if (column.equals("ezg_fl") && !this.checkRange(column, newValue, 0, 50, 0, 100, true, false, true)) {
            return oldValue;
        }
        if (column.equals("v_fl") && !this.checkRange(column, newValue, 0, 50, 0, 100, true, false, true)) {
            return oldValue;
        }
        if (column.equals("pu_anz1") && !this.checkRange(column, newValue, 1, 4, 1, 9, true, true, true)) {
            return oldValue;
        }
        if (column.equals("pu_motl1") && !this.checkRange(column, newValue, 0, 250, 0, 500, true, false, true)) {
            return oldValue;
        }
        if (column.equals("pu_foel1") && !this.checkRange(column, newValue, 0, 50, 0, 100, true, false, true)) {
            return oldValue;
        }
        if (column.equals("pu_anz2") && !this.checkRange(column, newValue, 1, 4, 1, 9, true, true, true)) {
            return oldValue;
        }
        if (column.equals("pu_motl2") && !this.checkRange(column, newValue, 0, 250, 0, 500, true, false, true)) {
            return oldValue;
        }
        if (column.equals("pu_foel2") && !this.checkRange(column, newValue, 0, 50, 0, 100, true, false, true)) {
            return oldValue;
        }
        if (column.equals("sz") && newValue != null && feature.getProperty("az") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("az")).doubleValue()) {
            this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut az sein.", column);
            return oldValue;
        }
        if (column.equals("az") && feature.getProperty("sz") != null && newValue != null && ((Number)feature.getProperty("sz")).doubleValue() <= ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut az sein.", column);
            return oldValue;
        }
        if (column.equals("ezg_fl") && newValue != null && feature.getProperty("v_fl") != null && ((Number)newValue).doubleValue() < ((Number)feature.getProperty("v_fl")).doubleValue()) {
            this.showMessage("Das Attribut ezg_fl darf nicht kleiner als das Attribut v_fl sein.", column);
            return oldValue;
        }
        if (column.equals("v_fl") && feature.getProperty("ezg_fl") != null && newValue != null && ((Number)feature.getProperty("ezg_fl")).doubleValue() < ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribut ezg_fl darf nicht kleiner als das Attribut v_fl sein.", column);
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("schw")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("schw") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaSchwRuleSet.isValueEmpty(feature.getProperty("schw"))) {
                this.showMessage("Das Attribut schw darf nicht leer sein", "schw");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "schw");
            }
            if (!this.checkRange("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaSchwRuleSet.getCurrentYear() + 2, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (!this.checkRange("br", feature.getProperty("br"), 0, 30, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
            }
            if (!this.checkRange("ezg_fl", feature.getProperty("ezg_fl"), 0, 100, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ezg_fl");
            }
            if (!this.checkRange("v_fl", feature.getProperty("v_fl"), 0, 100, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "v_fl");
            }
            if (!this.checkRange("pu_anz1", feature.getProperty("pu_anz1"), 1, 9, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "pu_anz1");
            }
            if (!this.checkRange("pu_motl1", feature.getProperty("pu_motl1"), 0, 500, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "pu_motl1");
            }
            if (!this.checkRange("pu_foel1", feature.getProperty("pu_foel1"), 0, 100, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "pu_foel1");
            }
            if (!this.checkRange("pu_anz2", feature.getProperty("pu_anz2"), 1, 9, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "pu_anz2");
            }
            if (!this.checkRange("pu_motl2", feature.getProperty("pu_motl2"), 0, 500, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "pu_motl2");
            }
            if (!this.checkRange("pu_foel2", feature.getProperty("pu_foel2"), 0, 100, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "pu_foel2");
            }
            if (feature.getProperty("sz") != null && feature.getProperty("az") != null && ((Number)feature.getProperty("sz")).doubleValue() <= ((Number)feature.getProperty("az")).doubleValue()) {
                this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut az sein.", "sz");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "sz");
            }
            if (feature.getProperty("ezg_fl") == null || feature.getProperty("v_fl") == null || !(((Number)feature.getProperty("ezg_fl")).doubleValue() < ((Number)feature.getProperty("v_fl")).doubleValue())) continue;
            this.showMessage("Das Attribut ezg_fl darf nicht kleiner als das Attribut v_fl sein.", "ezg_fl");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ezg_fl");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationCreator creator = new StationCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper());
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaSchwRuleSet.downloadDocumentFromWebDav(FgBaSchwRuleSet.getWbblPath(), FgBaSchwRuleSet.addExtension(value.toString(), "pdf"));
        }
    }
}

