/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class FgBaTechRuleSet
extends WatergisDefaultRuleSet {
    public FgBaTechRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("tech", new WatergisDefaultRuleSet.Catalogue("k_tech", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("na_gu", new WatergisDefaultRuleSet.Catalogue("k_na_gu", false, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("mahd_gu", new WatergisDefaultRuleSet.Catalogue("k_mahd_gu", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("gu_gu", new WatergisDefaultRuleSet.Catalogue("k_tech", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.minBaLength = 0.5;
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("laenge") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr") && !columnName.equals("id") && !columnName.equals("ww_gr");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        if (FgBaTechRuleSet.isValueEmpty(newValue)) {
            if (column.equals("tech") && FgBaTechRuleSet.isValueEmpty(feature.getProperty("na_gu")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("mahd_gu")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("gu_gu"))) {
                this.showMessage("Die Attribute tech, na_gu, mahd_gu und gu_gu d\u00fcrfen nicht alle leer sein", column);
                return oldValue;
            }
            if (column.equals("na_gu") && FgBaTechRuleSet.isValueEmpty(feature.getProperty("tech")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("mahd_gu")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("gu_gu"))) {
                this.showMessage("Die Attribute tech, na_gu, mahd_gu und gu_gu d\u00fcrfen nicht alle leer sein", column);
                return oldValue;
            }
            if (column.equals("mahd_gu") && FgBaTechRuleSet.isValueEmpty(feature.getProperty("tech")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("na_gu")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("gu_gu"))) {
                this.showMessage("Die Attribute tech, na_gu, mahd_gu und gu_gu d\u00fcrfen nicht alle leer sein", column);
                return oldValue;
            }
            if (column.equals("gu_gu") && FgBaTechRuleSet.isValueEmpty(feature.getProperty("tech")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("na_gu")) && FgBaTechRuleSet.isValueEmpty(feature.getProperty("mahd_gu"))) {
                this.showMessage("Die Attribute tech, na_gu, mahd_gu und gu_gu d\u00fcrfen nicht alle leer sein", column);
                return oldValue;
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("tech")) {
            String wbvPraefix = (String)AppBroker.getInstance().getOwnWwGr().getProperty("praefix");
            try {
                Integer.parseInt(wbvPraefix);
            }
            catch (NumberFormatException w) {
                wbvPraefix = null;
            }
            CidsLayerFeatureFilter filter = wbvPraefix != null ? this.createCidsLayerFeatureFilter("wbv", wbvPraefix) : null;
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("tech") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("gu_gu")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("gu_gu") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("mahd_gu")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("mahd_gu") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("na_gu")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("na_gu") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (!FgBaTechRuleSet.isValueEmpty(feature.getProperty("tech")) || !FgBaTechRuleSet.isValueEmpty(feature.getProperty("na_gu")) || !FgBaTechRuleSet.isValueEmpty(feature.getProperty("mahd_gu")) || !FgBaTechRuleSet.isValueEmpty(feature.getProperty("gu_gu"))) continue;
            this.showMessage("Die Attribute tech, na_gu, mahd_gu und gu_gu d\u00fcrfen nicht alle leer sein", "tech / na_gu / mahd_gu / gu_gu");
            if (FgBaTechRuleSet.isValueEmpty(feature.getProperty("tech"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "tech");
            }
            if (FgBaTechRuleSet.isValueEmpty(feature.getProperty("na_gu"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "na_gu");
            }
            if (FgBaTechRuleSet.isValueEmpty(feature.getProperty("mahd_gu"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "mahd_gu");
            }
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gu_gu");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 0.5f);
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }
}

