/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FgBaWehrRuleSet
extends WatergisDefaultRuleSet {
    private static final Map<String, String[]> ALLOWED_WEHR_WEHR_V = new HashMap<String, String[]>();
    private static final Map<String, String[]> ALLOWED_WEHR_WEHR_AV = new HashMap<String, String[]>();
    private static final Map<String, String[]> WEHR_V_MATERIAL = new HashMap<String, String[]>();
    private static final Map<String, String[]> WEHR_A_MATERIAL_A = new HashMap<String, String[]>();

    public FgBaWehrRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("wehr", new WatergisDefaultRuleSet.Catalogue("k_wehr", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("wehr_v", new WatergisDefaultRuleSet.Catalogue("k_wehr_v", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material_v", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("wehr_av", new WatergisDefaultRuleSet.Catalogue("k_wehr_av", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("wehr_a", new WatergisDefaultRuleSet.Catalogue("k_sbef", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material_a", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaWehrRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("br_li", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_so", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("sz", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("az", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("ww_gr") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        String[] allowedMaterialAArray;
        String[] allowedMaterialVArray;
        String[] allowedWehrAVArray;
        String[] allowedWehrVArray;
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaWehrRuleSet.isValueEmpty(newValue) && (column.equals("wehr") || column.equals("wehr_v") || column.equals("wehr_av"))) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaWehrRuleSet.getCurrentYear(), 1800, FgBaWehrRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("br") && !this.checkRange(column, newValue, 0, 10, 0, 30, true, false, true)) {
            return oldValue;
        }
        if (column.equals("br_li") && !this.checkRange(column, newValue, 0, 30, 0, 100, true, false, true)) {
            return oldValue;
        }
        if (column.equals("ho_so") && !this.checkRange(column, newValue, -6, 179, true, true, true)) {
            return oldValue;
        }
        if (column.equals("sz") && !this.checkRange(column, newValue, -6, 179, true, true, true)) {
            return oldValue;
        }
        if (column.equals("az") && !this.checkRange(column, newValue, -6, 179, true, true, true)) {
            return oldValue;
        }
        if (column.equals("sz") && newValue != null && feature.getProperty("az") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("az")).doubleValue()) {
            this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut az sein.", column);
            return oldValue;
        }
        if (column.equals("az") && feature.getProperty("sz") != null && newValue != null && ((Number)feature.getProperty("sz")).doubleValue() <= ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut az sein.", column);
            return oldValue;
        }
        if (column.equals("sz") && newValue != null && feature.getProperty("ho_so") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("ho_so")).doubleValue()) {
            this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut ho_so sein.", column);
            return oldValue;
        }
        if (column.equals("ho_so") && feature.getProperty("sz") != null && newValue != null && ((Number)feature.getProperty("sz")).doubleValue() <= ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut ho_so sein.", column);
            return oldValue;
        }
        if (column.equals("az") && newValue != null && feature.getProperty("ho_so") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("ho_so")).doubleValue()) {
            this.showMessage("Das Attribut az muss gr\u00f6\u00dfer als das Attribut ho_so sein.", column);
            return oldValue;
        }
        if (column.equals("ho_so") && feature.getProperty("az") != null && newValue != null && ((Number)feature.getProperty("az")).doubleValue() <= ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribut az muss gr\u00f6\u00dfer als das Attribut ho_so sein.", column);
            return oldValue;
        }
        if (column.equals("wehr_v") && newValue != null && feature.getProperty("wehr") != null && (allowedWehrVArray = ALLOWED_WEHR_WEHR_V.get(feature.getProperty("wehr").toString().toLowerCase())) != null && (FgBaWehrRuleSet.isValueEmpty(newValue) || !FgBaWehrRuleSet.arrayContains(allowedWehrVArray, newValue.toString().toLowerCase()))) {
            this.showMessage("Wenn das Attribut wehr = " + feature.getProperty("wehr").toString() + ", dann muss das Attribut wehr_v " + FgBaWehrRuleSet.arrayToString(allowedWehrVArray) + " sein.", column);
            return oldValue;
        }
        if (column.equals("wehr_av") && newValue != null && feature.getProperty("wehr") != null && (allowedWehrAVArray = ALLOWED_WEHR_WEHR_AV.get(feature.getProperty("wehr").toString().toLowerCase())) != null && (FgBaWehrRuleSet.isValueEmpty(newValue) || !FgBaWehrRuleSet.arrayContains(allowedWehrAVArray, newValue.toString().toLowerCase()))) {
            this.showMessage("Wenn das Attribut wehr = " + newValue.toString() + ", dann muss das Attribut wehr_av " + FgBaWehrRuleSet.arrayToString(allowedWehrAVArray) + " sein.", column);
            return oldValue;
        }
        if (column.equals("wehr_v") && newValue != null && feature.getProperty("material_v") != null) {
            allowedMaterialVArray = WEHR_V_MATERIAL.get(newValue.toString().toLowerCase());
            if (allowedMaterialVArray != null) {
                if (feature.getProperty("material_v") == null || !FgBaWehrRuleSet.arrayContains(allowedMaterialVArray, feature.getProperty("material_v").toString().toLowerCase())) {
                    this.showMessage("Wenn das Attribut wehr_v = " + newValue.toString() + ", dann muss das Attribut material_v " + FgBaWehrRuleSet.arrayToString(allowedMaterialVArray) + " sein.", column);
                    return oldValue;
                }
            } else if (feature.getProperty("material_v") != null) {
                this.showMessage("Wenn das Attribut wehr_v = " + newValue.toString() + ", dann muss das Attribut material_v null sein", column);
            }
        }
        if (column.equals("material_v") && newValue != null && !newValue.equals("") && feature.getProperty("material_v") != null) {
            allowedMaterialVArray = WEHR_V_MATERIAL.get(feature.getProperty("wehr_v").toString().toLowerCase());
            if (allowedMaterialVArray != null) {
                if (newValue == null || !FgBaWehrRuleSet.arrayContains(allowedMaterialVArray, newValue.toString().toLowerCase())) {
                    this.showMessage("Wenn das Attribut wehr_v = " + feature.getProperty("wehr_v").toString() + ", dann muss das Attribut material_v " + FgBaWehrRuleSet.arrayToString(allowedMaterialVArray) + " sein.", column);
                    return oldValue;
                }
            } else if (newValue != null) {
                this.showMessage("Wenn das Attribut wehr_v = " + feature.getProperty("wehr_v").toString() + ", dann muss das Attribut material_v null sein", column);
            }
        }
        if (column.equals("wehr_a") && newValue != null && feature.getProperty("material_a") != null) {
            allowedMaterialAArray = WEHR_A_MATERIAL_A.get(newValue.toString().toLowerCase());
            if (allowedMaterialAArray != null) {
                if (feature.getProperty("material_a") == null || !FgBaWehrRuleSet.arrayContains(allowedMaterialAArray, feature.getProperty("material_a").toString().toLowerCase())) {
                    this.showMessage("Wenn das Attribut wehr_a = " + newValue.toString() + ", dann muss das Attribut material_a " + FgBaWehrRuleSet.arrayToString(allowedMaterialAArray) + " sein.", column);
                    return oldValue;
                }
            } else if (feature.getProperty("material_a") != null) {
                this.showMessage("Wenn das Attribut wehr_a = " + newValue.toString() + ", dann muss das Attribut material_a null sein", column);
            }
        }
        if (column.equals("material_a") && newValue != null && feature.getProperty("material_a") != null) {
            allowedMaterialAArray = WEHR_A_MATERIAL_A.get(feature.getProperty("wehr_a").toString().toLowerCase());
            if (allowedMaterialAArray != null) {
                if (newValue == null || !FgBaWehrRuleSet.arrayContains(allowedMaterialAArray, newValue.toString().toLowerCase())) {
                    this.showMessage("Wenn das Attribut wehr_a = " + feature.getProperty("wehr_a").toString() + ", dann muss das Attribut material_a " + FgBaWehrRuleSet.arrayToString(allowedMaterialAArray) + " sein.", column);
                    return oldValue;
                }
            } else if (newValue != null) {
                this.showMessage("Wenn das Attribut wehr_a = " + feature.getProperty("wehr_a").toString() + ", dann muss das Attribut material_a null sein", column);
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("wehr")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("wehr") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("wehr_v")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("wehr_v") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("wehr_av")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("wehr_av") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("material_v")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("wehr_v");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("material_a")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("wehr_a");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("wehr_a")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("fg_ba_wehr");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("sbef") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaWehrRuleSet.isValueEmpty(feature.getProperty("wehr"))) {
                this.showMessage("Das Attribut wehr darf nicht leer sein", "wehr");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "wehr");
            }
            if (FgBaWehrRuleSet.isValueEmpty(feature.getProperty("wehr_v"))) {
                this.showMessage("Das Attribut wehr_v darf nicht leer sein", "wehr_v");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "wehr_v");
            }
            if (FgBaWehrRuleSet.isValueEmpty(feature.getProperty("wehr_av"))) {
                this.showMessage("Das Attribut wehr_av darf nicht leer sein", "wehr_av");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "wehr_av");
            }
            if (!this.checkRange("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaWehrRuleSet.getCurrentYear() + 2, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (!this.checkRange("br", feature.getProperty("br"), 0, 30, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
            }
            if (!this.checkRange("br_li", feature.getProperty("br_li"), 0, 100, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br_li");
            }
            if (!this.checkRange("ho_so", feature.getProperty("ho_so"), -6, 179, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_so");
            }
            if (!this.checkRange("sz", feature.getProperty("sz"), -6, 179, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "sz");
            }
            if (!this.checkRange("az", feature.getProperty("az"), -6, 179, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "az");
            }
            if (feature.getProperty("sz") != null && feature.getProperty("az") != null && ((Number)feature.getProperty("sz")).doubleValue() <= ((Number)feature.getProperty("az")).doubleValue()) {
                this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut az sein.", "sz");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "sz");
            }
            if (feature.getProperty("sz") != null && feature.getProperty("ho_so") != null && ((Number)feature.getProperty("sz")).doubleValue() <= ((Number)feature.getProperty("ho_so")).doubleValue()) {
                this.showMessage("Das Attribut sz muss gr\u00f6\u00dfer als das Attribut ho_so sein.", "sz");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "sz");
            }
            if (feature.getProperty("az") != null && feature.getProperty("ho_so") != null && ((Number)feature.getProperty("az")).doubleValue() <= ((Number)feature.getProperty("ho_so")).doubleValue()) {
                this.showMessage("Das Attribut az muss gr\u00f6\u00dfer als das Attribut ho_so sein.", "az");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "az");
            }
            if (feature.getProperty("wehr") != null) {
                String[] allowedWehrVArray = ALLOWED_WEHR_WEHR_V.get(feature.getProperty("wehr").toString().toLowerCase());
                String[] allowedWehrAVArray = ALLOWED_WEHR_WEHR_AV.get(feature.getProperty("wehr").toString().toLowerCase());
                if (allowedWehrVArray != null && (FgBaWehrRuleSet.isValueEmpty(feature.getProperty("wehr_v")) || !FgBaWehrRuleSet.arrayContains(allowedWehrVArray, feature.getProperty("wehr_v").toString().toLowerCase()))) {
                    this.showMessage("Wenn das Attribut wehr = " + feature.getProperty("wehr").toString() + ", dann muss das Attribut wehr_v " + FgBaWehrRuleSet.arrayToString(allowedWehrVArray) + " sein.", "wehr_v");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "wehr_v");
                }
                if (allowedWehrAVArray != null && (FgBaWehrRuleSet.isValueEmpty(feature.getProperty("wehr_av")) || !FgBaWehrRuleSet.arrayContains(allowedWehrAVArray, feature.getProperty("wehr_av").toString().toLowerCase()))) {
                    this.showMessage("Wenn das Attribut wehr = " + feature.getProperty("wehr").toString() + ", dann muss das Attribut wehr_av " + FgBaWehrRuleSet.arrayToString(allowedWehrAVArray) + " sein.", "wehr_av");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "wehr_av");
                }
            }
            if (feature.getProperty("wehr_v") != null) {
                String[] allowedMaterialVArray = WEHR_V_MATERIAL.get(feature.getProperty("wehr_v").toString().toLowerCase());
                if (allowedMaterialVArray != null) {
                    if (feature.getProperty("material_v") == null || !FgBaWehrRuleSet.arrayContains(allowedMaterialVArray, feature.getProperty("material_v").toString().toLowerCase())) {
                        this.showMessage("Wenn das Attribut wehr_v = " + feature.getProperty("wehr_v").toString() + ", dann muss das Attribut material_v " + FgBaWehrRuleSet.arrayToString(allowedMaterialVArray) + " sein.", "material_v");
                        return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "material_v");
                    }
                } else if (feature.getProperty("material_v") != null) {
                    this.showMessage("Wenn das Attribut wehr_v = " + feature.getProperty("wehr_v").toString() + ", dann muss das Attribut material_v null sein", "material_v");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "material_v");
                }
            }
            if (feature.getProperty("wehr_a") == null) continue;
            String[] allowedMaterialAArray = WEHR_A_MATERIAL_A.get(feature.getProperty("wehr_a").toString().toLowerCase());
            if (allowedMaterialAArray != null) {
                if (feature.getProperty("material_a") != null && FgBaWehrRuleSet.arrayContains(allowedMaterialAArray, feature.getProperty("material_a").toString().toLowerCase())) continue;
                this.showMessage("Wenn das Attribut wehr_a = " + feature.getProperty("wehr_a").toString() + ", dann muss das Attribut material_a " + FgBaWehrRuleSet.arrayToString(allowedMaterialAArray) + " sein.", "material_a");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "material_a");
            }
            if (feature.getProperty("material_a") == null) continue;
            this.showMessage("Wenn das Attribut wehr_a = " + feature.getProperty("wehr_a").toString() + ", dann muss das Attribut material_a null sein", "material_a");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "material_a");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationCreator creator = new StationCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper());
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaWehrRuleSet.downloadDocumentFromWebDav(FgBaWehrRuleSet.getWbblPath(), FgBaWehrRuleSet.addExtension(value.toString(), "pdf"));
        }
    }

    static {
        ALLOWED_WEHR_WEHR_V.put("s-kbw", new String[]{"bo", "bo-j", "sch\u00fc"});
        ALLOWED_WEHR_WEHR_V.put("s-sbw", new String[]{"bo", "bo-j", "sch\u00fc"});
        ALLOWED_WEHR_WEHR_V.put("s-stw", new String[]{"bo", "bo-j", "sch\u00fc"});
        ALLOWED_WEHR_WEHR_V.put("s-moe", new String[]{"bo", "bo-j", "sch\u00fc"});
        ALLOWED_WEHR_WEHR_V.put("w-strei", new String[]{"schw"});
        ALLOWED_WEHR_WEHR_V.put("w-\u00fcfa", new String[]{"schw"});
        ALLOWED_WEHR_WEHR_V.put("kl", new String[]{"ki", "ki-fb", "ki-fb-sch\u00fc", "ki-sch\u00fc"});
        ALLOWED_WEHR_WEHR_V.put("na", new String[]{"na"});
        ALLOWED_WEHR_WEHR_V.put("seg", new String[]{"seg", "seg-fb"});
        ALLOWED_WEHR_WEHR_V.put("sek", new String[]{"sek"});
        ALLOWED_WEHR_WEHR_V.put("schl", new String[]{"schl"});
        ALLOWED_WEHR_WEHR_V.put("w-sch\u00fc", new String[]{"sch\u00fc", "sch\u00fc-dop", "sch\u00fc-dreh", "sch\u00fc-haken", "sch\u00fc-seg"});
        ALLOWED_WEHR_WEHR_V.put("tro", new String[]{"tro"});
        ALLOWED_WEHR_WEHR_V.put("wz", new String[]{"wz"});
        ALLOWED_WEHR_WEHR_AV.put("w-strei", new String[]{"ohne"});
        ALLOWED_WEHR_WEHR_AV.put("w-\u00fcfa", new String[]{"ohne"});
        WEHR_V_MATERIAL.put("bo", new String[]{"h", "k", "st", "nb"});
        WEHR_V_MATERIAL.put("bo-j", new String[]{"h", "k", "st", "nb"});
        WEHR_V_MATERIAL.put("schw", new String[]{"b", "k"});
        WEHR_A_MATERIAL_A.put("pl", new String[]{"b"});
        WEHR_A_MATERIAL_A.put("rl", new String[]{"b"});
        WEHR_A_MATERIAL_A.put("sp", new String[]{"ste"});
    }
}

