/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.watergis.server.search.FgBaCdCheck;
import de.cismet.cids.custom.watergis.server.search.RemoveUnnusedRoute;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.SimpleAttributeTableModel;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.RouteCombo;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.SplitAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FgBakRuleSet
extends WatergisDefaultRuleSet {
    private static final Random RANDOM = new Random(new Date().getTime());
    private final Logger LOG = Logger.getLogger(FgBakRuleSet.class);
    private TreeSet<FeatureServiceFeature> changedBaCdObjects;

    public FgBakRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("bak_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("bak_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ba_gn", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("laenge") && !columnName.equals("geom") && !columnName.equals("bak_st_von") && !columnName.equals("bak_st_bis");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("ba_cd")) {
            if (this.changedBaCdObjects == null) {
                this.changedBaCdObjects = new TreeSet();
            }
            this.changedBaCdObjects.add(feature);
            if (newValue != null && !newValue.equals("")) {
                String valString;
                String userGroup = SessionManager.getSession().getUser().getUserGroup().getName();
                if (!oldValue.equals(newValue) && !userGroup.equalsIgnoreCase("administratoren")) {
                    String prefix = (String)AppBroker.getInstance().getOwnWwGr().getProperty("praefix");
                    if (prefix != null) {
                        return prefix + ":" + newValue;
                    }
                } else if (!oldValue.equals(newValue) && (valString = String.valueOf(newValue)).contains(":") && userGroup.equalsIgnoreCase("administratoren")) {
                    String prefix = valString.substring(0, valString.indexOf(":"));
                    boolean listFound = false;
                    block2: while (!listFound) {
                        ComboBoxModel model = ((CidsLayerFeature)feature).getCatalogueCombo("ww_gr").getModel();
                        if (model.getSize() > 1) {
                            listFound = true;
                            for (int i = 0; i < model.getSize(); ++i) {
                                CidsLayerFeature wwGrFeature;
                                Object prefixTmp;
                                Object tmp = model.getElementAt(i);
                                if (!(tmp instanceof CidsLayerFeature) || (prefixTmp = (wwGrFeature = (CidsLayerFeature)tmp).getProperty("praefix")) == null || !prefixTmp.equals(prefix)) continue;
                                model.setSelectedItem(wwGrFeature);
                                feature.setProperty("ww_gr", (Object)wwGrFeature);
                                continue block2;
                            }
                            continue;
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        HashMap<Integer, String> baCdMap = new HashMap<Integer, String>();
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (this.changedBaCdObjects != null && this.changedBaCdObjects.contains(feature)) {
                String baCd = (String)feature.getProperty("ba_cd");
                if (feature.getProperty("ww_gr").equals(AppBroker.getInstance().getNiemandWwGr()) && baCd != null && !baCd.equals("")) {
                    feature.setProperty("ww_gr", (Object)AppBroker.getInstance().getOwnWwGr());
                }
            }
            if (feature.getProperty("ba_cd") == null || feature.getProperty("ba_cd").equals("")) {
                feature.setProperty("ww_gr", (Object)AppBroker.getInstance().getNiemandWwGr());
                feature.setProperty("ba_cd", (Object)String.valueOf(feature.hashCode()));
            }
            this.setBaCd(feature);
            baCdMap.put((Integer)feature.getProperty("id"), (String)feature.getProperty("ba_cd"));
        }
        if (!baCdMap.isEmpty()) {
            try {
                ArrayList list;
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new FgBaCdCheck(baCdMap));
                if (attributes != null && !attributes.isEmpty() && (list = (ArrayList)attributes.get(0)) != null && !list.isEmpty()) {
                    JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(FgBakRuleSet.class, (String)"FgBakRuleSet.prepareForSave().message", list.get(0)), NbBundle.getMessage(FgBakRuleSet.class, (String)"FgBakRuleSet.prepareForSave().title"), 0);
                    return new AttributeTableExtendedRuleSet.ErrorDetails(this.getFeatureByBaCd(features, String.valueOf(list.get(0))), "ba_cd");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(FgBakRuleSet.class, (String)"FgBakRuleSet.prepareForSave().error.message"), NbBundle.getMessage(FgBakRuleSet.class, (String)"FgBakRuleSet.prepareForSave().error.title"), 0);
                this.LOG.error((Object)"Error while checking the uniqueness of the ba_cd field.", (Throwable)e);
                return new AttributeTableExtendedRuleSet.ErrorDetails(null, "ba_cd");
            }
        }
        return super.prepareForSaveWithDetails(features);
    }

    private FeatureServiceFeature getFeatureByBaCd(List<FeatureServiceFeature> features, String baCd) {
        for (FeatureServiceFeature f : features) {
            if (!f.getProperty("ba_cd").equals(baCd)) continue;
            return f;
        }
        return null;
    }

    private void setBaCd(FeatureServiceFeature feature) {
        CidsLayerFeature cLayerFeature;
        Object o;
        if (feature instanceof CidsLayerFeature && (o = (cLayerFeature = (CidsLayerFeature)feature).getPropertyObject("ww_gr")) instanceof CidsLayerFeature) {
            CidsLayerFeature wwGr = (CidsLayerFeature)o;
            String baCd = (String)feature.getProperty("ba_cd");
            String praefix = (String)wwGr.getProperty("praefix");
            if (praefix != null && !baCd.startsWith(praefix + ":")) {
                feature.setProperty("ba_cd", (Object)(praefix + ":" + baCd));
            }
        }
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        List removedFeatures;
        AppBroker.getInstance().getWatergisApp().initRouteCombo();
        RouteCombo.clearRouteCache();
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak");
        CidsLayer layer = new CidsLayer(routeMc);
        SplitAction.commit((AbstractFeatureService)layer);
        if (model instanceof SimpleAttributeTableModel && (removedFeatures = ((SimpleAttributeTableModel)model).getRemovedFeature()) != null && !removedFeatures.isEmpty()) {
            ArrayList<Feature> selectedFeaturesToRemove = new ArrayList<Feature>();
            for (FeatureServiceFeature feature : removedFeatures) {
                try {
                    RemoveUnnusedRoute nodesSearch = new RemoveUnnusedRoute(feature.getId(), 3);
                    SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)nodesSearch);
                }
                catch (Exception e) {
                    this.LOG.error((Object)"Error while removing unused stations", (Throwable)e);
                }
                List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
                for (Feature f : selectedFeatures) {
                    String deletedFeatureBaCd;
                    String selectedFeatureBaCd;
                    CidsLayerFeature clf;
                    if (!(f instanceof CidsLayerFeature) || (clf = (CidsLayerFeature)f).getProperty("ba_cd") == null || feature.getProperty("ba_cd") == null || !(selectedFeatureBaCd = String.valueOf(clf.getProperty("ba_cd"))).equals(deletedFeatureBaCd = String.valueOf(feature.getProperty("ba_cd")))) continue;
                    selectedFeaturesToRemove.add(f);
                }
            }
            if (!selectedFeaturesToRemove.isEmpty()) {
                SelectionManager.getInstance().removeSelectedFeatures(selectedFeaturesToRemove);
            }
        }
        try {
            this.refreshTemplate("RefreshRwSegGeom");
            this.refreshTemplate("RefreshEzgKrl");
        }
        catch (ConnectionException ex) {
            this.LOG.error((Object)"Cannot refresh templates", (Throwable)ex);
        }
        super.afterSave(model);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"bak_st_von", "bak_st_bis", "laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        if (name.equals("bak_st_von")) {
            return 4;
        }
        if (name.equals("bak_st_bis")) {
            return 5;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        if (propertyName.equals("bak_st_von")) {
            return 0;
        }
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        if (propertyName.equals("bak_st_von")) {
            return "0";
        }
        if (propertyName.equals("bak_st_bis")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("LINESTRING", this.getDefaultValues());
        creator.setMinLength(0.01);
        return creator;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        String baCd = String.valueOf(AppBroker.getInstance().getOwnWwGr().getProperty("praefix")) + ":";
        Random r = new Random(new Date().getTime());
        baCd = baCd + r.nextInt();
        properties.put("ba_cd", baCd);
        return properties;
    }

    @Override
    public FeatureServiceFeature cloneFeature(FeatureServiceFeature feature) {
        boolean unique;
        FeatureServiceFeature newFeature = super.cloneFeature(feature);
        CidsBean wwGr = (CidsBean)feature.getProperty("original:ww_gr");
        String prefix = String.valueOf(wwGr.getProperty("praefix"));
        String baCd = (String)newFeature.getProperty("ba_cd");
        do {
            unique = true;
            try {
                HashMap<Integer, String> baCdMap = new HashMap<Integer, String>();
                baCd = prefix + ":" + String.valueOf(Math.abs(RANDOM.nextInt()));
                baCdMap.put(-1, baCd);
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new FgBaCdCheck(baCdMap));
                if (attributes == null || attributes.isEmpty()) continue;
                unique = false;
            }
            catch (Exception e) {
                this.LOG.error((Object)"Error checking baCd", (Throwable)e);
            }
        } while (!unique);
        newFeature.setProperty("ba_cd", (Object)baCd);
        return newFeature;
    }
}

