/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class KgWkRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(KgWkRuleSet.class);
    private static final String URL_TEMPLATE = "https://fis-wasser-mv.de/charts/steckbriefe/cw/cw_wk.php?schema=reporting_bp3&kg=%1s";

    public KgWkRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("wk_nr", new WatergisDefaultRuleSet.Catalogue("k_wk_kg", true, true, new WatergisDefaultRuleSet.Varchar(50, false, false)));
        this.typeMap.put("wk_fedfue", new WatergisDefaultRuleSet.Catalogue("k_wk_kg", false, false, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("kkm_ort", new WatergisDefaultRuleSet.Varchar(30, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("flaeche") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("wk_fedfue");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("wk_nr")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true));
        }
        if (columnName.equals("wk_nr")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("wk_nr");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "st_area(geom)::bigint";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wk_nr") && value instanceof String && clickCount == 1) {
            try {
                URL u = new URL(String.format(URL_TEMPLATE, value.toString()));
                try {
                    BrowserLauncher.openURL((String)u.toString());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

