/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MnFgChmRuleSet
extends WatergisDefaultRuleSet {
    public MnFgChmRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("stalu", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("wk_k", new WatergisDefaultRuleSet.Varchar(30, false, false));
        this.typeMap.put("messstelle", new WatergisDefaultRuleSet.Varchar(20, false, false));
        this.typeMap.put("wk_k", new WatergisDefaultRuleSet.Varchar(100, false, false));
        this.typeMap.put("lage", new WatergisDefaultRuleSet.Varchar(100, true, true));
        this.typeMap.put("lawa_typ", new WatergisDefaultRuleSet.Numeric(3, 0, true, true));
        this.typeMap.put("latest_y", new WatergisDefaultRuleSet.Numeric(4, 0, true, true));
        this.typeMap.put("rw", new WatergisDefaultRuleSet.Numeric(11, 2, true, true));
        this.typeMap.put("hw", new WatergisDefaultRuleSet.Numeric(10, 2, true, true));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("geom") && !columnName.equals("rw") && !columnName.equals("hw");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return super.getCellEditor(columnName);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"rw", "hw"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("rw")) {
            return -3;
        }
        if (name.equals("hw")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            if (propertyName.equals("rw")) {
                return geom.getCoordinates()[0].getOrdinate(0);
            }
            if (propertyName.equals("hw")) {
                return geom.getCoordinates()[0].getOrdinate(1);
            }
        }
        return null;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("rw")) {
            return "round(st_x(geom)::numeric, 2)";
        }
        if (propertyName.equals("hw")) {
            return "round(st_y(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POINT", false);
        return c;
    }
}

