/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.gui.actions.gaf.ReportAction;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class QpGafPRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(QpGafPRuleSet.class);

    public QpGafPRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, false, false));
        this.typeMap.put("la_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, false, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("re", new WatergisDefaultRuleSet.Numeric(11, 2, false, false));
        this.typeMap.put("ho", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("qp_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("upl_name", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("upl_datum", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("upl_zeit", new WatergisDefaultRuleSet.Varchar(8, false, false));
        this.typeMap.put("aufn_name", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("aufn_datum", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("aufn_zeit", new WatergisDefaultRuleSet.Time(false, false));
        this.typeMap.put("titel", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("beschreib", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("p_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("id_gaf", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("y", new WatergisDefaultRuleSet.Numeric(6, 2, false, false));
        this.typeMap.put("z", new WatergisDefaultRuleSet.Numeric(6, 2, false, false));
        this.typeMap.put("kz", new WatergisDefaultRuleSet.Catalogue("k_qp_gaf_kz", true, false, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("hw", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("rw", new WatergisDefaultRuleSet.Numeric(11, 2, false, false));
        this.typeMap.put("hyk", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("qp_nr")) {
            return new LinkTableCellRenderer(4);
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"re", "ho"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("re")) {
            return 8;
        }
        if (name.equals("ho")) {
            return 9;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = feature.getGeometry();
        if (geom instanceof Point) {
            if (propertyName.equals("re")) {
                value = ((Point)geom).getX();
            } else if (propertyName.equals("ho")) {
                value = ((Point)geom).getY();
            }
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("re")) {
            return "st_x(geom)";
        }
        if (propertyName.equals("ho")) {
            return "st_y(geom)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        return null;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("qp_nr") && value instanceof Integer && clickCount == 1 && feature instanceof CidsLayerFeature) {
            ReportAction action = new ReportAction();
            action.actionPerformed(null);
        }
    }
}

